﻿#coding:utf-8

import os
import stat
import time
import shutil
from java.io import File
import traceback
import sys 
reload(sys)
sys.setdefaultencoding('utf-8') 


#所有数据存放顶层目录名称
G_ALL_DATA_DIRNAME = "DataCollect"
OS_OPEN_FLAGS = os.O_WRONLY | os.O_CREAT | os.O_TRUNC  # 写 | 创建并打开 | 截断
OS_OPEN_MODES = stat.S_IWUSR | stat.S_IRUSR  # 拥有者具有读写权限


# 判断当前语言是否为中文
def isChinese(devObj):
    
    lang = devObj.get("lang")
    if "zh" == lang:
        return True
        
    return False

def creatPkginfo(rootPath, devObj):
    '''
    @summary: 创建与datacollect同级的目录pkginfo，用于表示该包是信息收集的包。
        pkginfo下有两个空文件
            type_collect: 信息收集的包
            domain_storage: 存储设备
    '''
    logger = devObj.get("logger")
    pkginfoPath = rootPath + os.sep + "pkginfo"
    typeFile = pkginfoPath + os.sep + "type_collect"
    domainFile = pkginfoPath + os.sep + "domain_storage"
    descFile = pkginfoPath + os.path.sep + "desc"
    try:
        #如果pkginfo已存在，则需要先删除
        if os.path.exists(pkginfoPath):
            shutil.rmtree(pkginfoPath, True)
            
        os.mkdir(pkginfoPath)
        #先创建type文件，然后拷贝type并重命名为domain文件
        fileObj = os.fdopen(os.open(typeFile, OS_OPEN_FLAGS, OS_OPEN_MODES), 'w')
        fileObj.close()
        shutil.copy(typeFile, domainFile)
        
        #获取设备SN，当前时间
        snStr = "deviceSN=${%s}\n"
        deviceSn = getDeviceSn(devObj)
        snStr = snStr % deviceSn
        dateStr = "fileCreateTime=%d"
        curtime = int(time.time() * 1000)
        dateStr = dateStr % curtime
        
        #创建desc文件，写入SN，时间
        fileObj = os.fdopen(os.open(descFile, OS_OPEN_FLAGS, OS_OPEN_MODES), 'w')
        fileObj.write(snStr)
        fileObj.write(dateStr)
        fileObj.close()
        
        logger.info("[creatPkginfo] Creat the pkginfo succeed!")
    
    except:
        if os.path.exists(pkginfoPath):
            shutil.rmtree(pkginfoPath, True)   
        logger.error("[creatPkginfo] Creat the pkginfo failed! except trace back: " + str(traceback.format_exc()))
   
   
def getDeviceSn(devObj):
    '''
            获取设备SN号
    '''
    devNode = devObj.get("devNode")   
    if None == devNode:
        return ""
        
    sn = devNode.getDeviceSerialNumber() 
    return sn

     
def execute(devObj):
    
    logger = devObj.get("logger")
    try:
        #获取本次数据收集根目录
        tmpDataCollectDir = devObj.get("tmpDataCollectDir")        
        if None==tmpDataCollectDir or ""==tmpDataCollectDir:
            if isChinese(devObj):
                devObj["py_detail"] = u"[错误] 临时数据收集目录为空。"
            else:
                devObj["py_detail"] = "[ERROR] The temporary data collect directory is empty."
            return  (False, devObj["py_detail"])
        
        dataRootDir = tmpDataCollectDir + os.sep + G_ALL_DATA_DIRNAME
        if not os.path.exists(dataRootDir):
            if isChinese(devObj):
                devObj["py_detail"] = u"[错误] 根数据目录" + dataRootDir + u"不存在。"
            else:
                devObj["py_detail"] = "[ERROR] The root data directory " + dataRootDir + " does not exist."
            return  (False, devObj["py_detail"])
            
        #压缩前创建pkginfo
        creatPkginfo(tmpDataCollectDir, devObj)
        pkginfoPath = tmpDataCollectDir + os.path.sep + 'pkginfo'
        
        #设置压缩包名称
        strCurTime = str(time.strftime('%Y%m%d%H%M%S',time.localtime(time.time())))
        new7zFileName = devObj.get("devIp") + "_" + strCurTime
        new7zFilePath = tmpDataCollectDir + os.sep + new7zFileName
        
        #压缩指定的根数据文件夹        
        collectManagement = devObj.get("collecManagementObj")
        new7zFileName = collectManagement.compressFile(new7zFilePath, True, dataRootDir, pkginfoPath)       
        if new7zFileName == "" :
            #若压缩失败，则清理资源并报错
            shutil.rmtree(tmpDataCollectDir, False)
            if isChinese(devObj):
                devObj["py_detail"] = u"[错误] 压缩根数据目录" + dataRootDir + u"失败。"
            else:
                devObj["py_detail"] = "[ERROR] Failed to compress the root data directory " + dataRootDir
            return  (False, devObj["py_detail"])
        
        #拷贝压缩文件到数据顶层数据目录，并清除临时数据目录
        new7zFilePath = tmpDataCollectDir + os.sep + new7zFileName
        shutil.move(new7zFilePath, devObj.get("collectRetDir"))
        shutil.rmtree(tmpDataCollectDir, False)
        
        #回传压缩文件名称
        retFileName = new7zFileName.decode('utf-8')
        devObj["collectRetFileName"]=retFileName
        return (True,"")
        
    except:
        logger.error("[compress] catch except of trace back:" + str(traceback.format_exc()))
        #清理资源
        tmpDataCollectDir = devObj.get("tmpDataCollectDir")
        if ""!=tmpDataCollectDir and os.path.exists(tmpDataCollectDir):
            shutil.rmtree(tmpDataCollectDir, False)
            
        #报错
        if isChinese(devObj):
            devObj["py_detail"] = u"[错误] 压缩数据收集结果文件异常。"
        else:
            devObj["py_detail"] = "[ERROR] An exception occurred during compressing the root data directory."
            
        return (False, devObj["py_detail"])