﻿#coding:utf-8

import os
import shutil
import time
import sys 
import re
import traceback
reload(sys)
sys.setdefaultencoding('utf-8') 


#所有数据存放顶层目录名称
G_ALL_DATA_DIRNAME = "DataCollect"

#判断当前语言是否为中文
def isChinese(devObj):
    
    lang = devObj.get("lang")
    if "zh" == lang:
        return True
        
    return False

# **************************************************************************** #
# 函数名称: createDataCltDirIfIPExist
# 功能说明: 如果IP开头的文件夹存在，则创建DataCollect文件夹，并将IP开头的文件夹移到DataCollect内
# 输入参数: 设备对象，解压目录路径
# 输出参数: 创建成功or创建失败
# **************************************************************************** # 
def createDataCltDirIfIPExist(devObj, unZipDirPath):
    try:
        logger = devObj.get("logger")
        if os.path.exists(unZipDirPath):
            fileList = os.listdir(unZipDirPath)
            logger.info("[decompress]The file list in unZipDirPath is " + str(fileList))
            #IP匹配正则
            pattern = "^((\d{1}|[1-9]\d{1}|1\d{2}|2[0-4]\d|25[0-5])\.){3}(\d{1}|[1-9]\d{1}|1\d{2}|2[0-4]\d|25[0-5])(_MAIN)?$"
            isIPDirExistent = False #IP目录是否存在
            for fileName in fileList:
                if re.match(pattern, fileName, re.IGNORECASE):
                    isIPDirExistent = True
                    break
            
            rootDataDir = unZipDirPath + os.sep + G_ALL_DATA_DIRNAME
            #如果IP目录存在，则创建DataCollect文件夹，否则直接返回失败
            if isIPDirExistent:
                os.mkdir(rootDataDir)
            else:
                return False
            #创建失败则直接返回
            if not os.path.exists(rootDataDir):
                return False
            
            #移动IP文件夹到DataCollect文件夹，这里将源目录下所有内容移到DataCollect文件夹，以防可能有除了IP文件夹外的其他内容
            logger.info("[decompress]Move IP directory to DataCollect directory.")
            for fileName in fileList:
                src = unZipDirPath + os.sep + fileName
                dst = rootDataDir + os.sep + fileName
                shutil.move(src, dst)
            return True
        else:
            return False
    except:
        logger.error("[decompress]Catch exception when execute createDataCltDirIfIPExist:" + str(traceback.format_exc()))
        return False

#解压入口
def execute(devObj):
    
    unZipDirPath = ""
    logger = devObj.get("logger")
    
    try:        
        zipFilePath = devObj.get("collectRetDir") + os.sep + devObj.get("collectRetFileName")        
        if not os.path.exists(zipFilePath):
            if isChinese(devObj):
                devObj["py_detail"] = u"[错误] 系统信息收集结果包" + zipFilePath + u"不存在。"
            else:
                devObj["py_detail"] = "[ERROR] The system information collect result package " + zipFilePath + " does not exist."
            return  (False, devObj["py_detail"])
        
        #解压原有信息收集包并删除该包
        collectManagement = devObj.get("collecManagementObj")
        unZipDirPath = str(collectManagement.deCompressFile(zipFilePath))
        if unZipDirPath == "" :
            if isChinese(devObj):
                devObj["py_detail"] = u"[错误] 解压系统信息收集结果包" + zipFilePath + u"失败。"
            else:            
                devObj["py_detail"] = "[ERROR] Failed to decompress the system information collect result package " + zipFilePath + "."
            return  (False, devObj["py_detail"])
        
        try:
            os.remove(zipFilePath)
        except:
            logger.error("[decompress] remove file catch except of trace back:" + str(traceback.format_exc()))
            
        #若解压后的文件夹中不存在DataCollect,则报错
        rootDataDir = unZipDirPath + os.sep + G_ALL_DATA_DIRNAME
        if not os.path.exists(rootDataDir):
            #如果解压后DataCollect文件夹不存在，则判断是否有IP开头的文件夹，若有则创建DataCollect文件夹，没有则返回错误
            #之所以加此逻辑是因为老26V1R5最老的版本下载的压缩包内并没有DataCollect文件夹，而是直接包含IP开头的文件夹
            isSucc = createDataCltDirIfIPExist(devObj, unZipDirPath)
            if not isSucc:
                if isChinese(devObj):
                    devObj["py_detail"] = u"[错误] 根数据目录" + rootDataDir + u"不存在。"
                else:
                    devObj["py_detail"] = "[ERROR] The root data directory " + rootDataDir + " does not exist."
                shutil.rmtree(unZipDirPath, True)  #清理资源，忽略异常
                return  (False, devObj["py_detail"])
        
        #将解压后目录改名为临时目录
        curTime = str(time.strftime('%Y%m%d%H%M%S',time.localtime(time.time())))
        tmpDataCollectDir = devObj.get("collectRetDir") + os.sep + "tmpdir@" + curTime
        os.rename(unZipDirPath, tmpDataCollectDir)
        if not os.path.exists(tmpDataCollectDir):
            if isChinese(devObj):
                devObj["py_detail"] = u"[错误] 重命名解压数据目录" + unZipDirPath + u"失败。"
            else:
                devObj["py_detail"] = "[ERROR] Renaming the unzipped data directory " + unZipDirPath + " failed."
            shutil.rmtree(unZipDirPath, True)  #清理资源，忽略异常
            return  (False, devObj["py_detail"])
        
        #将目录名称计入设备对象（供后续压缩时使用）
        devObj["tmpDataCollectDir"] = tmpDataCollectDir
        return (True, "")
        
    except:
        #清理资源并返回错误
        if ""!=unZipDirPath and os.path.exists(unZipDirPath):
            shutil.rmtree(unZipDirPath, True)
         
        logger.error("[decompress] catch except of trace back:" + str(traceback.format_exc()))
        if isChinese(devObj):
            devObj["py_detail"] = u"[错误] 解压系统信息收集结果包异常。"
        else:            
            devObj["py_detail"] = "[ERROR] An exception occurred during decompressing the system information collect result package."
        
        return (False, devObj["py_detail"])
        