﻿#coding: UTF-8

from java.io import File
import time
import traceback
import common
from common import TimeOutException
# modified 20140513 begin
#超时时间为5分钟，最多4次，即最大超时时间为20分钟
G_TIMEOUT = 5 * 60
#重试3次
G_RETRY_TIMES = 3

#判断当前语言是否为中文
def isChinese(devObj):
    
    lang = devObj.get("lang")
    if "zh" == lang:
        return True
        
    return False

# **************************************************************************** #
# 函数名称: downloadRemoteFile
# 功能说明: 下載远端文件
# 输入参数: 设备对象
# 输出参数: 无
# **************************************************************************** # 
def downloadRemoteFile(devObj):
    sftp = devObj.get("SFTP")
    localPath = devObj.get("collectRetDir") + File.separator + devObj.get("collectRetFileName")
    file = File(localPath)
    sftp.getFile(devObj.get("collecRemotePath"), file, None)
    #由于框架提供的sftp下载失败会抛出异常，所以下载成功就不会抛出异常，这里成功返回"true"
    return True

def execute(devObj):
    
    logger = devObj.get("logger")
    try:
        ssh = devObj.get("SSH")
        isDownloadFailed = False
        #如果命令超时，则等待5分钟再去设备下载
        if "true" == devObj.get("timeout"):
            logger.warn("Executing command timeout, try to download after 5 minutes later.")
            i = 0
            while i <= G_RETRY_TIMES:
                try:
                    time.sleep(G_TIMEOUT)
                    i += 1
                    
                    #保持SSH连接处于连接状态（cli会10分钟闲置超时）
                    common.execCmdNoLog(ssh,"showsys")
                    
                    isDownloadSuc = downloadRemoteFile(devObj)
                    if isDownloadSuc:
                        break
                except TimeOutException:
                    logger.error("[download] Execute command timeout:" + traceback.format_exc())
                    return (False, common.getCmdTimeOutErrMsg(devObj)) 
                except:
                    if i >= 4:
                        isDownloadFailed = True
                        break
                    logger.warn("Downloading remote file failed, try again after 5 minutes later")
                    continue
            #若下载失败，则直接返回
            if isDownloadFailed:
                if isChinese(devObj):
                    devObj["py_detail"] = u"[错误] 信息收集异常。"
                else:
                    devObj["py_detail"] = "[ERROR] An exception occurred during collecting information."
                return (False, devObj["py_detail"])
        else:
            downloadRemoteFile(devObj)
        return (True,"")
        # modified 20140513 end
    except:
        logger.error("[download] catch except of trace back:" + str(traceback.format_exc()))
        if isChinese(devObj):
            devObj["py_detail"] = u"[错误] 下载信息收集结果包异常。"
        else:
            devObj["py_detail"] = "[ERROR] An exception occurred during downloading data collecting information package."
        
        return (False, devObj["py_detail"])
