﻿#coding: UTF-8

import re
import common

##########################脚本要求##########################
#使用前请务必阅读下面的要求
#1、登录用户必须为admin
#2、debug登录密码中不能包含#
#3、CLI的命令提示符必须包含admin和>
#4、debug的命令提示符必须包含#
#5、MML的命令提示符必须包含>
############################################################



#判断当前语言是否为中文
def isChinese(devObj):
    
    lang = devObj.get("lang")
    if "zh" == lang:
        return True
        
    return False


# **************************************************************************** #
# 函数名称: getCurSysMode
# 功能说明: 获取当前系统模式（要求登录用户为admin）
# 输入参数: devObj
# 输出参数: 无
# 返 回 值: CLI, DEBUG or MML
# **************************************************************************** # 
def getCurSysMode(ssh):
    #通过showsys回显判断当前命令行模式
    temp = common.execCmdWithTimout(ssh,"showsys", 320)
    if re.search("admin", temp, re.IGNORECASE):
        return "CLI"
    elif re.search("command not found", temp, re.IGNORECASE):
        return "DEBUG"
    elif re.search("spu ui>|MML>", temp, re.IGNORECASE):
        return "MML"
    else:
        return ""


# **************************************************************************** #
# 函数名称: changeMode
# 功能说明: 切换当前系统模式到指定模式
# 输入参数: 设备对象，目标系统模式
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeMode(devObj, tgtSysMode, updateErrMsg=True):
    
    if "CLI" == tgtSysMode:
        return changeMode2CLI(devObj, updateErrMsg)
    elif "DEBUG" == tgtSysMode:
        return changeMode2Debug(devObj, updateErrMsg)
    elif "MML" == tgtSysMode:
        return changeMode2MML(devObj, updateErrMsg)
    
    return False
    

# **************************************************************************** #
# 函数名称: changeMode2CLI
# 功能说明: 从任意模式进入CLI模式（脚本限制请参阅文件头部）
# 输入参数: devObj
# 输出参数: 错误原因
# 返 回 值: True or False
# **************************************************************************** # 
def changeMode2CLI(devObj, updateErrMsg=True):

    #获取当前系统模式
    ssh = devObj.get("SSH")    
    sysMode = getCurSysMode(ssh);
    
    #依据具体的模式进行相应的模式切换操作
    if "CLI" == sysMode:
        return True
                
    elif "DEBUG" == sysMode:
        temp = common.execCmd(ssh,"exit")
        if re.search(">", temp, re.IGNORECASE):
            return True
    
    elif "MML" == sysMode:
        temp = common.execCmd(ssh,"exit")
        if re.search("#", temp, re.IGNORECASE):
            temp = common.execCmd(ssh,"exit")
            if re.search(">", temp, re.IGNORECASE):
                return True
    else:
        pass
    
    if updateErrMsg:
        #模式切换失败
        if isChinese(devObj):
            devObj["py_detail"] = u"[错误] 无法将系统模式切换到CLI。请确保设备工作状态正常。"
        else:
            devObj["py_detail"] = "[Error] Changing system mode to CLI failed. Please make sure the device works in normal status."
    return False


# **************************************************************************** #
# 函数名称: changeMode2Debug
# 功能说明: 从任意模式进入Debug模式（脚本限制请参阅文件头部）
# 输入参数: devObj
# 输出参数: 错误原因
# 返 回 值: True or False
# **************************************************************************** # 
def changeMode2Debug(devObj, updateErrMsg=True):
        
    ssh = devObj.get("SSH")   
    debugPwd = devObj.get("debug")
    
    #如果debug密码设置为空，则使用默认密码
    if None == debugPwd or "" == debugPwd:
        if isChinese(devObj):
            devObj["py_detail"] = u"[错误] 由于debug密码不存在，无法将系统模式切换到debug。"
        else:
            devObj["py_detail"] = "[Error] Changing system mode to debug failed since the debug password does not exist."
        return False
    
    #获取当前系统模式
    sysMode = getCurSysMode(ssh);
    
    #依据具体的模式进行相应的模式切换操作
    if "CLI" == sysMode:
        temp = common.execCmd(ssh,"debug")
        if re.search("Enter Password", temp, re.IGNORECASE):
            temp = common.execCmdNoLog(ssh,debugPwd)
            if re.search("#", temp, re.IGNORECASE):
                return True
            else:
                #提示debug密码存在问题
                if isChinese(devObj):
                    devObj["py_detail"] = u"[错误] 无法将系统模式切换到debug。请确保debug密码正确，且设备工作状态正常。"
                else:
                    devObj["py_detail"] = "[Error] Changing system mode to debug failed. Please make sure the debug password is correct and the device works in normal status."
                return False
                
    elif "MML" == sysMode:
        temp = common.execCmd(ssh,"exit")
        if re.search("#", temp, re.IGNORECASE):
            return True
            
    elif "DEBUG" == sysMode:
        return True
    else:
        pass
    
    if updateErrMsg:
        #模式切换失败
        if isChinese(devObj):
            devObj["py_detail"] = u"[错误] 无法将系统模式切换到debug。请确保设备工作状态正常。"
        else:
            devObj["py_detail"] = "[Error] Changing system mode to debug failed. Please make sure the device works in normal status."
    return False


# **************************************************************************** #
# 函数名称: changeMode2MML
# 功能说明: 从任意模式进入MML模式（脚本限制请参阅文件头部）
# 输入参数: devObj
# 输出参数: 错误原因
# 返 回 值: True or False
# **************************************************************************** # 
def changeMode2MML(devObj, updateErrMsg=True):

    #获取当前系统模式
    ssh = devObj.get("SSH")
    sysMode = getCurSysMode(ssh);
    
    #依据具体的模式进行相应的模式切换操作
    if "CLI" == sysMode:
        if not changeMode2Debug(devObj, updateErrMsg):
            return False
        temp = common.execCmd(ssh,"mml")
        if re.search(">", temp, re.IGNORECASE):
            return True
                
    elif "DEBUG" == sysMode:
        temp = common.execCmd(ssh,"mml")
        if re.search(">", temp, re.IGNORECASE):
            return True
    
    elif "MML" == sysMode:
        return True
    else:
        pass
    
    if updateErrMsg:
        #模式切换失败
        if isChinese(devObj):
            devObj["py_detail"] = u"[错误] 无法将系统模式切换到MML。请确保设备工作状态正常。"
        else:
            devObj["py_detail"] = "[Error] Changing system mode to MML failed. Please make sure the device works in normal status."
    return False
