﻿#coding: UTF-8

import os
import traceback
import common
from common import TimeOutException
strCmd = "datacollect"
remotePath = "/ServiceTool/DataCollect.zip"
fileName = "DataCollect.zip"


def isChinese(devObj):    
    lang = devObj.get("lang")
    if "zh" == lang:
        return True
        
    return False


def execute(devObj):
    
    strErr = ""
    logger = devObj.get("logger")
    try:
        ssh = devObj.get("SSH")
        
        #收集超时时重试3次
        retryNum = 3        
        
        #采用重试方式执行命令
        while retryNum > 0:
            #执行datacollect命令
            strRet = unicode(common.execCmd(ssh,strCmd)) #str用于规避返回结果为None时报错的情况，不能去除
            
            #如果执行成功，则返回成功
            #command operates successfully
            if strRet.find("successful") != -1:
                devObj["collectRetFileName"]=fileName
                devObj["collecRemotePath"]=remotePath
                return (True, "")
            #如果仅收集到部分日志，则返回成功，并设置部分成功标志
            #Logs of only one controller are collected during information collection.
            elif strRet.find("only one controller are collected") != -1:
                PY_LOGGER.info("Logs of only one controller are collected by the datacollect command!!!")
                if True == isChinese(devObj):
                    strErr = u"datacollect命令仅收集到一个控制器的信息，请稍后重试或联系技术支持工程师协助处理。"
                else:
                    strErr = "Logs of only one controller are collected by the datacollect command, please try again later or contact the technical support engineer for help."
                
                devObj["py_detail"] = strErr
                devObj["collectAllInfo"] = False  #对每个收集项，信息全收集成功字段默认为True，仅在部分成功时才设置为False
                
                devObj["collectRetFileName"]=fileName
                devObj["collecRemotePath"]=remotePath                
                return (True, strErr)
            #如果执行失败
            else:
                #如果是因为超时导致的失败，继续重试
                #Error: Message execution timed out.
                if strRet.find("timed out") != -1:
                    PY_LOGGER.info("The datacollect command timed out!!")
                    retryNum -= 1
                    continue
                #其他错误时提示出错，并返回失败。
                #Error: The device memory is not enough.
                #Error: Operation failed. Please try again later.
                elif strRet.find("not exist") != -1:
                    if True == isChinese(devObj):
                        strErr = u"当前版本不支持datacollect命令，收集日志失败。"
                    else:
                        strErr = "Current system version does not support datacollect command, collect logs failed."
                    devObj["py_detail"] = strErr
                    return (False, strErr)
                else:
                    PY_LOGGER.info("A error occurred during executing the datacollect command!!!")
                    # 收集失败时报错信息中增加原始信息  modified 20140916 Begin
                    if True == isChinese(devObj):
                        strErr = u"datacollect命令执行出错，请联系技术支持工程师协助处理。"
                        strErr += u"\n命令执行原始信息为：" + strRet
                    else:
                        strErr = "Failed to execute the datacollect command, please contact the technical support engineer for help."
                        strErr += "\nThe original information:" + strRet
                    # 收集失败时报错信息中增加原始信息  modified 20140916 End
                    
                    devObj["py_detail"] = strErr
                    return (False, strErr)
        
        #走到这里，就意味着命令重试了三次，且均以超时告终
        PY_LOGGER.info("The datacollect command timed out up to 3 time!!")
        # modified 20140513 begin
        #返回超时标识
        devObj["timeout"] = "true"
        devObj["collectRetFileName"]=fileName
        devObj["collecRemotePath"]=remotePath
        return (True, "")
        # modified 20140513 end
    except TimeOutException:
        logger.error("[module1] Execute command timeout:" + traceback.format_exc())
        return (False, common.getCmdTimeOutErrMsg(devObj)) 
    except:
        logger.error("[module1] catch except of trace back:" + str(traceback.format_exc()))
        #发生异常时，提示出现异常
        if True == isChinese(devObj):
            strErr = u"信息收集出现异常。请联系技术支持工程师协助处理。" 
        else:
            strErr = "An exception occurred during collecting the information, please contact the technical support engineer for help."
        
        devObj["py_detail"] = strErr
        return (False, strErr)