#coding:utf-8

import re

R2C00_SECURE_VERSION = 'V100R002C00SPC010'
R2C01_SECURE_VERSION = 'V100R002C01SPC007'

# **************************************************************************** #
# 函数名称: switchValidVersion
# 功能说明: 将版本号转化成有效的版本号（17位：V100R002C00SPC001 或者11位：V100R005C02）
# 输入参数: version
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def switchValidVersion(version):
    temp = ""
    
    startIndex = version.index("V100")
    if re.search("SPC", version, re.IGNORECASE):
        endIndex = startIndex + 17  #格式：V100R002C00SPC001
    else:
        endIndex = startIndex + 11  #格式：V100R002C00
    
    #提取有效的版本号信息
    temp = version[startIndex: endIndex]
    
    return temp

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 工具调用接口
# 输入参数: version
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
# admin:/>showupgradepkginfo -t 1   
# ========================================================
#              Upgrade Package Information
# --------------------------------------------------------
#  Controller ID    Package Version      Package Status  
# --------------------------------------------------------
#  A                V100R002C00SPC008    Running         
#  B                V100R002C00SPC008    Running         
# ========================================================
# ========================================================
#              System Version Information
# --------------------------------------------------------
#  Controller ID    Version    
# --------------------------------------------------------
#  A                V100R002C00SPC008          
#  B                V100R002C00SPC008          
# ========================================================
def execute(ssh):
    isSecure = False
    
    cliRet = ssh.execCmd('showupgradepkginfo -t 1')
    rowList = cliRet.splitlines()
    
    count = len(rowList)
    for i in range(count):
        if bool(re.search('Controller ID', rowList[i], re.IGNORECASE)):

            columnList = rowList[i + 2].split()
            devVersion = switchValidVersion(columnList[1])
            #根据设备版本号是否安全红线设备
            if bool(re.search('V100R001', devVersion, re.IGNORECASE)):
                isSecure = False
            elif bool(re.search('V100R002C00', devVersion, re.IGNORECASE)):
                if devVersion < R2C00_SECURE_VERSION:
                    isSecure = False
                else:
                    isSecure = True
            elif bool(re.search('V100R002C01', devVersion, re.IGNORECASE)):
                if devVersion < R2C01_SECURE_VERSION:
                    isSecure = False
                else:
                    isSecure = True
            elif bool(re.search('V100R005', devVersion, re.IGNORECASE)):
                isSecure = True
            else:
                isSecure = False
    #返回判断结果
    return isSecure
