# -*- coding: UTF-8 -*-

# **************************************************************************** #
# 函数名称: getError
# 功能说明: 获取错误码对应描述信息
# 输入参数: lang  语言环境
#        key 描述信息key值
#        
# 输出参数: 无
# 返 回 值: version
# **************************************************************************** # 
def getError(lang, key, params=[]):
    if lang not in ["zh", "en"]:
        return CODEMap.get("UnknownError").get("en") 
    if key not in CODEMap:
        return CODEMap.get("UnknownError").get(lang)
    if not params:
        return CODEMap.get(key).get(lang)
    errorDesc = CODEMap.get(key).get(lang)
    paramNum = len(params)
    for index in range(paramNum):
        paramRep = "###" + str(index) 
        paramDes = params[index]
        errorDesc = errorDesc.replace(paramRep, paramDes)
    return errorDesc

# **************************************************************************** #
# 设备错误码描述信息
# **************************************************************************** #
CODEMap = \
{   
    #版本限制报错信息
    "versionLimit": \
    {
       "zh":u"因存储设备版本限制，不支持通过工具进行系统日志收集。请选择任意一条操作建议进行处理：\n\
（1）请参考“操作指导书”进行手动收集；\n\
（2）若使用工具进行收集，请在收集前先升级存储设备至V100R005C30SPC700+SPH701及之后版本；",
       "en":"OceanStor Toolkit cannot be used to collect system logs due to version restrictions of storage devices. Collect logs by following any of the following suggestions: \n\
(1) Manually collect logs by referring to the operation guide. \n\
(2) If you collect logs using the Toolkit, upgrade the storage device to V100R005C30SPC700 or later with the SPH701 hot patch installed."              
    }
    ,
    
    #热补丁版本限制报错信息
    "hotPatchLimit": \
    {
       "zh":u"因存储设备版本限制，不支持通过工具进行系统日志收集。请选择任意一条操作建议进行处理：\n\
（1）当前存储设备版本未安装###0及之后版本热补丁，请参考“操作指导书”进行手动收集；\n\
（2）若使用工具进行收集，请在收集前先将存储设备安装###0及之后版本的热补丁或升级存储设备至V100R005C30SPC700+SPH701及之后版本；",
       "en":"OceanStor Toolkit cannot be used to collect system logs due to version restrictions of storage devices. Collect logs by following any of the following suggestions:\n\
(1) If hot patch ###0 or a later version is not installed on the current storage device, manually collect logs by referring to the operation guide. \n\
(2) If you collect logs using the Toolkit, install hot patch ###0 or a later version on the storage device, or upgrade the storage device to V100R005C30SPC700 or later with the SPH701 patch installed. "              
    }
    ,
    #V100R005C30SPC700特定版本热补丁版本限制报错信息
    "hotPatchLimit_SPC700": \
    {
       "zh":u"因存储设备版本限制，不支持通过工具进行系统日志收集。请选择任意一条操作建议进行处理：\n\
（1）当前存储设备版本未安装###0及之后版本热补丁，请参考“操作指导书”进行手动收集；\n\
（2）若使用工具进行收集，请在收集前先将存储设备安装###0及之后版本的热补丁；",
       "en":"OceanStor Toolkit cannot be used to collect system logs due to version restrictions of storage devices. Collect logs by following any of the following suggestions:\n\
(1) If hot patch ###0 or a later version is not installed on the current storage device, manually collect logs by referring to the operation guide. \n\
(2) If you collect logs using the Toolkit, install hot patch ###0 or a later version on the storage device before the collection."              
    }
    ,

    #查询信息失败
    "queryError": \
    {
     "zh": u"查询信息失败",
     "en": "Querying information failed"
     }
    ,

    #未知错误
    "UnknownError": \
    {
     "zh": u"未知错误",
     "en": "Unknown Error"
     }
}
