# -*- coding: UTF-8 -*-
'''
@summary: record data collect collection item result.
'''
import os
import dataConstants

class DataCollectResultRecorder():
    '''
    @summary: record data collect collection item result.
    '''
    def __init__(self, devObject):
        '''
        @summary: initializing parameters
        '''
        self.devObj = devObject
        self.logger = self.devObj.get("logger")
        self.logger.info("[ResultRecorder] initiating DataCollectResultRecorder...")

    def recordCrntModuleStatus(self, ctrlrDir, itemName, result, errMsgs):
        '''
        @summary: write into info.txt to record current item status
        @param ctrlrDir: location of record file
        @param result: enumeration in dataConstants
        '''
        if not ctrlrDir or not itemName:
            self.logger.info("wrong input parameter!")
            return
        if len(itemName) > 40:
            itemName = itemName[0:15] + "..." + itemName[-15:]

        try:
            recordFile = os.path.join(ctrlrDir, dataConstants.COLLECT_ITEMS_RECORD_DESTINATION)
            fileObj = open(recordFile, "a")
            if self.isFileVacent(recordFile):
                fileObj.write(" --------------------------------------------------------\n")
                fileObj.write("|            COLLECT ITEM NAME           |STATUS         |\n")
                fileObj.write(" -------------------------------------------------------\n")

            fileObj.write(self.constructRecordLine(itemName, result))
            fileObj.write(" --------------------------------------------------------\n")

        except Exception, excp:
            self.logger.info("try to record admin mode collection result but failed %s." % str(excp))
            errMsgs += ("failed to record Item %s's collection status\n" % str(itemName))
        finally:
            fileObj.close()
        try:
            recordFile = os.path.join(ctrlrDir, dataConstants.ERR_LOG_DESTINATION)
            fileObj = open(recordFile, "a")
            fileObj.write(errMsgs)
        except Exception, excp:
            self.logger.info("failed to append error messages %s." % str(excp))
        finally:
            fileObj.close()
        return

    def constructRecordLine(self, itemName, result):
        '''
        @summary: build record line to specified file
        @return: lineString
        '''
        self.logger.info("building record line...")
        itemLen = len(itemName)
        leftSpaceIndent = (40 - itemLen) / 2
        leftSpace = leftSpaceIndent * " "
        rightSpaceIndent = (40 - itemLen) - leftSpaceIndent
        rightSpace = rightSpaceIndent * " "
        line = "|" + leftSpace + itemName + rightSpace + "|"
        resultIndent = 15 - len(result)
        rightSpace = resultIndent * " "
        line += result + rightSpace + "|\n"
        return line

    def isFileVacent(self, recordFile):
        '''
        @summary: check whether file does not exist or file vacant
        '''
        self.logger.info("checking whether file is vacant.")
        if not os.path.exists(recordFile):
            return True

        fileSize = os.path.getsize(recordFile)
        if fileSize <= 0:
            return True
        return  False
