from com.huawei.ism.tool.obase.connection import SshConnection
from com.huawei.ism.tool.obase.connection import SftpTransporter
from com.huawei.ism.tool.obase.exception import ToolException
from com.huawei.ism.tool.obase.exception import PwdCLIOverrunException
import traceback


class SSHToolUtils():
    '''
    @summary:  building new SSH/SFTP connection independently
    '''
    
    def __init__(self, devObject, logger):
        
        self.devObj = devObject
        self.log = logger
        
    def newSshUsingCrntUsrCredential(self, destHost, sshPort=22):
        '''
        @summary: building new SSh  connection to destination 
        @warning:  only 4 connections at most  exists at the same time!
        @return:  status, sshCon(None if not exists!)
        '''
    
        username = self.devObj.get("username") if self.devObj.get("username") else ""
        password = self.devObj.get("password") if self.devObj.get("password") else ""
        context = self.devObj.get("context")  if self.devObj.get("context")  else ""
        try:
            self.log.info("building SSH connection to host: %s" % str(destHost))
            sshCon = SshConnection(destHost, username, password, sshPort)
            context.addProtocolForShellCreated(destHost, sshCon)
            sshCon.connect()
            self.log.info("SSH connection successfully built!")
            return True, sshCon
        except PwdCLIOverrunException:
            self.log.error("failed in building SSH connection, too much instance exists!")
            return False, None
        except ToolException, tExp:
            self.log.error("error occurred while building SSH connection " + unicode(tExp))
            return False, None
        except Exception, expn:
            self.log.error("exception occurred while building SSH connection " + unicode(expn))
            return False, None
    
    def deriveSftpTransporter(self, sshCon):
        '''
        @summary: derive SFTP connection using current set ssh connection 
        @return status,sftpConn(None if not exists!)
        '''
        if  None == sshCon or not isinstance(sshCon, SshConnection):
            self.log.error("current ssh connection is unable to derive!")
            return False, None
        try:
            self.log.info("building SFTP connection to host...")
            sftpConn = SftpTransporter(sshCon)
            return True, sftpConn
        except :
            self.log.error("error occured while deriving SFTP transporter " + unicode(traceback.print_exc()))
            return False, None
            
               
    def closeSshConnection(self, sshCon):
        '''
        @summary: close SSH connection 
        '''
        if sshCon is not None and  isinstance(sshCon, SshConnection):
            self.log.info("close SSH Connection...")
            try:
                sshCon.close()

            except:
                self.log.info("Exception occurred: " + unicode(traceback.print_exc()))
                return
        else:
            self.log.info("current SSH connection is not valid .")
            return 
            
                
        
    def closeSftpConnection(self, sftpTrans):
        '''
        @summary: close SFTP connection 
        '''
        if sftpTrans is not None and isinstance(sftpTrans, SftpTransporter):
            self.log.info("close SFTP Connection...")
            try:
                sftpTrans.close()

            except:
                self.log.info("Exception occurred: " + unicode(traceback.print_exc()))
                return
        else:
            self.log.info("current SFTP connection is not valid.")
            return 

        
