# -*- coding: UTF-8 -*-
from java.io import File
from java.lang import Exception as JavaException
import os
import shutil
import traceback
import time
import resource
import dataConstants
import os
import re
import resource
import shutil
import sys
try:
    reload(sys)
    sys.setdefaultencoding('utf-8')
except:
    pass
import time
import traceback

CLI_RET_END_FLAG = ":/>"

 
CLI_INFO_NORMAL_ROW_MIN = 7

def creatPkginfo(rootPath, devObj):
    '''
    @summary: 创建与datacollect同级的目录pkginfo，用于表示该包是信息收集的包。
        pkginfo下有两个空文件
            type_collect: 信息收集的包
            domain_storage: 存储设备
    '''
    logger = devObj.get("logger")
    pkginfoPath = rootPath + os.path.sep + "pkginfo"
    typeFile = pkginfoPath + os.path.sep + "type_collect"
    domainFile = pkginfoPath + os.path.sep + "domain_storage"
    descFile = pkginfoPath + os.path.sep + "desc"
    try:
        #如果pkginfo已存在，则需要先删除
        if os.path.exists(pkginfoPath):
            shutil.rmtree(pkginfoPath, True)
            
        os.mkdir(pkginfoPath)
        #先创建type文件，然后拷贝type并重命名为domain文件
        fileObj = open(typeFile, "w")  
        fileObj.close()
        shutil.copy(typeFile, domainFile)
        
        #获取设备SN，当前时间
        snStr = "deviceSN=${%s}\n"
        deviceSn = getDeviceSn(devObj)
        snStr = snStr % deviceSn
        dateStr = "fileCreateTime=%d"
        curtime = int(time.time() * 1000)
        dateStr = dateStr % curtime
        
        #创建desc文件，写入SN，时间
        fileObj = open(descFile, "w")
        fileObj.write(snStr)
        fileObj.write(dateStr)
        fileObj.close()
        logger.info("[creatPkginfo] Creat the pkginfo succeed!")
         
    except:
        if os.path.exists(pkginfoPath):
            shutil.rmtree(pkginfoPath, True)   
        logger.error("[creatPkginfo] Creat the pkginfo failed! except trace back: " +
                      str(traceback.format_exc()))
    
def getDeviceSn(devObj):
    '''
            获取设备SN号
    '''
    devNode = devObj.get("devNode")   
    if None == devNode:
        return ""
        
    serialNum = devNode.getDeviceSerialNumber()
    return serialNum

def executeCmdWithTimeout(devObj, cmd, timeOut=3 * 60):
    '''
    @summary: execute command with given time out 
    @return: isSuccess: boolean , is Command Executed Successfully
    @return: cmdEcho
    '''     
    ssh = devObj.get("SSH")
    sftp = devObj.get("SFTP")
    logger = devObj.get("logger")
    cmdEcho = ""
    isSuccess = False
    logger.info("executing command:%s..." % str(cmd))
    times = 1
    while times <= 3:
        try:
            cmdEcho = ssh.execCmdWithTimout(cmd, timeOut)
            times += 1
            if not cmdEcho:
                isSuccess = False
            else:
                isSuccess = True
            break
        except :
            times += 1
            logger.info("start to reconnect to remote device...")
            ssh.reConnect()
            sftp.reConnect()
            time.sleep(times * 2)

    return isSuccess, cmdEcho

def execCmdTmoutNoLog(devObj, cmd, timeOut=3 * 60):
    '''
    @summary: execute command with given time out ,without log echos
    @return: isSuccess: boolean , is Command Executed Successfully
    @return: cmdEcho
    '''     
    logger = devObj.get("logger")
    ssh = devObj.get("SSH")
    cmdEcho = ""
    isSuccess = False
    logger.info("executing command with no log" )
    try:
        cmdEcho = ssh.execCmdNoLogTimout(cmd, timeOut)
        isSuccess = True
    except:
        logger.info("executing command:[no log cmd]  but failed with exception...")
        isSuccess = False
    if not cmdEcho:
        isSuccess = False
        
    return isSuccess, cmdEcho
 
def isSystemNormal(devObj):
    '''
    @summary: check whether the system is normal
    @return:  if not return False, otherwise return True
    '''
    cmd = "showsys"
    
    isSuccess, cmdEcho = executeCmdWithTimeout(devObj, cmd, 5)
    if not isSuccess:
        return False
    if len(cmdEcho.splitlines()) < CLI_INFO_NORMAL_ROW_MIN:
        return False
    if not "system information" in cmdEcho.lower():
        return False
    #system is not ready, may the device is not initializing
    if "not ready" in cmdEcho.lower():
        return False
    
    return True

def addEchoMsg(devObj, msgKey, args = []):
    '''
    @summary: set message that is shown on UI
    '''
    lang = devObj.get("lang")
    logger = devObj.get("logger")
    if not devObj.get("py_detail", ""):
        devObj["py_detail"] = ""
    if not resource.MSG_DICT.has_key(msgKey):
        logger.info("failed in fetching execution status message...")
        return False
    message = resource.MSG_DICT[msgKey][lang]
    if len(args) < 1:
        devObj["py_detail"] += message
        logger.info("execution result msg:" + unicode(devObj["py_detail"]))
        return True
    else:
        args = tuple(args)
        message = message % args
        devObj["py_detail"] += message
        logger.info("execution result msg:" + unicode(devObj["py_detail"]))
        return True
    
def getLoginPasswd(devObj):
    '''
    @summary: get login password of current login user
    '''
    devNode = devObj.get("devNode")
    password = devNode.getLoginUser().getPassword()
    return password

def downloadFile2Local(devObj, sftpConn, remoteLocation, localLocation):
    '''
    @summary: download file to Local dir
    @param devObj, sftpConn: SFTP connection Object, remoteLocation: file location on device, localLocation: 
    @return: boolean
    '''
    logger = devObj.get("logger")
    logger.info("collect file from remote %s to local %s" % (str(remoteLocation), str(localLocation)))
    try:
        logger.info("download remote file to local:")
        sftpConn.getFile(remoteLocation, File(localLocation), None)
        logger.info("finished downloading file...")
        return True
    
    except JavaException, jxe:
        logger.info("downloading failed:" + unicode(jxe))
        return False
    except Exception, exp:
        logger.error('Caught Exception when downloading file:' + unicode(exp))
        return False

def downloadDir2Local(devObj, sftpConn, remoteLocation, localLocation):
    '''
    @summary:  download remote directory recursively to local 
    @param param:  
    '''
    logger = devObj.get("logger")
    try:
        logger.info("downloading remote dir to local:")
        sftpConn.getDirRecurse(remoteLocation, File(localLocation))
        logger.info("finished downloading files...")
        return True
    except JavaException, jxe:
        logger.info("downloading failed:" + unicode(jxe))
        return False
    except BaseException, exp:
        logger.error('Caught Exception when downloading dir:' + unicode(exp))
        return False

def removeRemoteFile(devObj, sftpConn, remoteFileLocation):
    '''
    @summary: remove remote file on device 
    @param remoteFileLocation: remote file's location
    '''
    logger = devObj.get("logger")
    try:
        logger.info("removing single file on device...")
        sftpConn.deleteFile(remoteFileLocation)
        logger.info("finished removing file...")
        return True
    except JavaException, jxe:
        logger.info("failed to remove remote file(s):" + unicode(jxe))
        return False
    except BaseException, exp:
        logger.error('Caught Exception when removing file on remote device:' + unicode(exp))
        return False
    
def sendCtrlPlusCCmd(devObj, timeout=3*60):
    '''
    @summary: if an interrupt operation is required to quit current command ,send control + c command.
    '''
    ssh = devObj.get("SSH")   
    logger = devObj.get("logger")
    logger.info("send control + C command to CLI...")
    try:
        ret = ssh.execCtrlPlusCCmd(timeout)
        return ret
    except:
        raise

def removeFileOnRemote(devObj, sftpConn, remoteFileLocation):
    '''
    @summary: remove file on remote 
    @param devObj, sftpConn: SFTP connection Object, remoteLocation: file location on device 
    @return: boolean
    '''
    logger = devObj.get("logger")
    logger.info("now try to remove file on remote :%s" % str(remoteFileLocation))
    try:
        logger.info("remove remote file to local:")
        sftpConn.deleteFile(remoteFileLocation)
        logger.info("finished removing file...")
        return True
    
    except JavaException, jxe:
        logger.info("removing file on remote failed:" + unicode(jxe))
        return False
    except Exception, exp:
        logger.error('Caught Exception when removing file:' + unicode(exp))
        return False

def getAllMappedIpInfo(devObj):
    '''
    @summary: get device's controllers Ip Mapping info
    '''
    logger = devObj.get("logger")
    cmd = "showcontroller"
    controllerIpInfoList = []
    controllerIpMap = {}
    isSuccess, cmdEcho = executeCmdWithTimeout(devObj, cmd)
    if not isSuccess or not cmdEcho:
        logger.info("failed to fetch controllers' IPs...")
        return controllerIpInfoList
    controllerCursor = ""
    for line in cmdEcho.splitlines():
        if "controller id" in line.lower() and "|" in line:
            controllerCursor = line.split("|")[1].strip()
            controllerIpMap["controller"] = controllerCursor
        if "primary/secondary status" in line.lower() and "|" in line and controllerCursor:
            ctrlrPriority = line.split("|")[1].strip().lower()
            controllerIpMap["priority"] = ctrlrPriority
        if "ipv6 address for management" in line.lower() and "|" in line and controllerCursor:
            ipv6Addr = line.split("|")[1].strip().lower()
            controllerIpMap["ipv6"] = ipv6Addr
        if "ip address for management" in line.lower() and "|" in line and controllerCursor:
            controllerIp = line.split("|")[1].strip()
            controllerIpMap["manageIp"] = controllerIp
            logger.info("controller %s 's management ip: %s" % (controllerCursor, controllerIp))
        if "---" in  line or "===" in line:
            if controllerIpMap :
                controllerIpInfoList.append(controllerIpMap)
                controllerCursor = ""
                controllerIpMap = {}
    if controllerIpMap:
        controllerIpInfoList.append(controllerIpMap)

    return controllerIpInfoList

def getCrntCtrlrInnerIp(devObj):
    '''
    @summary: get current controller's inner ip 
    '''
    controllerIpInfoList = getAllMappedIpInfo(devObj)
    curIp = devObj.get("devIp")
    curCtrlName = ""
    for controllerIpMap in controllerIpInfoList:
        if controllerIpMap.get("ipv6", "") == curIp or controllerIpMap.get("manageIp", "") == curIp:
            curCtrlName = controllerIpMap.get("controller", "")
            break

    return dataConstants.INNER_IP_MAP.get(curCtrlName, "")

def getOppstInnerIp(devObj):
    '''
    @summary: get opposite controller's inner Ip 
    '''
    crntCtrlrInnerIp = getCrntCtrlrInnerIp(devObj)
    for controllerKey in dataConstants.INNER_IP_MAP:
        if dataConstants.INNER_IP_MAP[controllerKey] != crntCtrlrInnerIp:
            return dataConstants.INNER_IP_MAP[controllerKey]
    return ""


def deletePath(devObj, pathName):
    toDeletRmtPthCmd = 'rm -rf ' + pathName
    isExeSucc, delRet = execCmdTmoutNoLog(devObj, toDeletRmtPthCmd, 60)
    while isExeSucc and 'y/n' in delRet:
        isExeSucc, delRet = execCmdTmoutNoLog(devObj, 'y', 60)


def isCmdExecuteSucess(echo_msg):
    if re.search("success", echo_msg, re.IGNORECASE):
        return True
    else:
        return False





