# -*- coding: UTF-8 -*-
from com.huawei.ism.tlv.lang import UnsignedInt32, UnsignedInt8, UnsignedInt16
from com.huawei.ism.tlv.bean import Param
from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.bean import Record
from com.huawei.ism.tlv import TLVUtils
from java.lang import Exception

INTEGRATIVE_QUERY = 8596492288

# 命令执行超时时间
CMD_DEFAULT_TIMEOUT = 60

def execute(devObj):
    flag = True
    msgParam0 = Param(0, ParamType.UNSIGN_INT, UnsignedInt32(1))
    ip = ""
    user = ""
    paswd = ""
    xmlCont = "\r\n" 
    try:
        tlvConn = devObj.get("TLV")
        recs = tlvConn.getBatch(INTEGRATIVE_QUERY, TLVUtils.paramList(), CMD_DEFAULT_TIMEOUT)
        itemNum = recs.size()

        for index in range(0, itemNum):
            rec = recs.get(index)
            if (4 == rec.getParamIntValue(5).intValue()):
                ip = rec.getParamStrValue(0)
                user = rec.getParamStrValue(2)
                paswd = rec.getParamStrValue(3)
                xmlCont += "<devices>\r\n" 
                xmlCont += "  <resultcode>0</resultcode>\r\n"
                xmlCont += "  <device>\r\n"
                xmlCont += "    <ip>" + ip + "</ip>\r\n" 
                xmlCont += "    <username>" + user + "</username>\r\n" 
                xmlCont += "    <password><![CDATA[" + paswd + "]]></password>\r\n"
                xmlCont += "  </device>\r\n"  
                xmlCont += "</devices>\r\n"
                # 在java端消除打印
                devObj["integrate_back"] = xmlCont
    except:
        xmlCont = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><devices><resultcode>1</resultcode></devices>"
        flag = False
    return (flag, "")
