# -*- coding: UTF-8 -*-
'''
@summary: datacollect module func:collect basic(CLI) information, executed in cli mode on current connection
'''
import os
from common import util
from common import dataConstants
from common.dataCollectResultRecorder import DataCollectResultRecorder
from common.sshTools import SSHToolUtils
import modelManager

class DeviceMmlCollector():
    '''
    @summary: collect Admin mode command echo, collect in one file named cliCmd_info.txt
    '''
    def __init__(self, devObject, opztMngIp, localCtrlrPriority):
        '''
        @summary: initializing parameters
        '''
        self.devObj = devObject
        self.logger = self.devObj.get("logger")
        self.logger.info("[MML Info] initiating MmlModeDeviceInfoCollector...")
        self.localMngIp = self.devObj.get("devIp")
        self.opztMngIp = opztMngIp
        self.localCtrlrPriority = localCtrlrPriority
        self.resultRecorder = DataCollectResultRecorder(self.devObj)
        self.collectItem = ""

    def doCollect(self):
        '''
        @summary: entrance
        '''
        self.closePaginationFunc()
        currentCtrlrDir, oppositeCtrlrDir = self.tryMkLocalDir()
        self.getMmlCmdEchoInCrntCtrlr(currentCtrlrDir)
        if self.opztMngIp :
            self.getMmlCmdEchoInOpztCtrlr(oppositeCtrlrDir)
        modelManager.changeAnyModel2Cli(self.devObj["SSH"], self.devObj["SFTP"])
        return

    def tryMkLocalDir(self):
        '''
        @summary: try to make 'other' directory, if it does not exist, create one.
        @return: local directory corresponding to  current controller(current controller may not be equivalent to main controller)
        @return: local directory corresponding to  opposite controller
        '''
        localBaseDir = self.devObj.get("collectRetDir", "")
        self.logger.info("current local base file Path is " + unicode(localBaseDir))
        localMainCtlrLocation = os.path.join(self.devObj["localMainCtlrLocation"],
             dataConstants.COLLECT_TYPE_OTHERS)
        localOpztCtlrLocation = ""

        if not os.path.exists(localMainCtlrLocation) and localMainCtlrLocation:
            os.makedirs(localMainCtlrLocation)

        if self.opztMngIp :
            localOpztCtlrLocation = os.path.join(self.devObj["localOpztCtlrLocation"],
                                                 dataConstants.COLLECT_TYPE_OTHERS)
            if not os.path.exists(localOpztCtlrLocation) and localOpztCtlrLocation:
                os.makedirs(localOpztCtlrLocation)

        return localMainCtlrLocation, localOpztCtlrLocation

    def closePaginationFunc(self):
        '''
        @summary: set 'chgpagination' switch to off , which brings '--more--' interaction disabled
        '''
        cmd = "chgpagination off"
        cmdEchoList = util.executeCmdWithTimeout(self.devObj, cmd)
        return cmdEchoList[0]

    def getMmlCmdEchoInCrntCtrlr(self, crntCtlrFileDir):
        '''
        @summary: execute command on MMl mode and collect command echo to specified file
        @note: in MMl mode, echo msg will be divided into several kinds and collected into different files.
        '''
        currentLogFileDir = self.devObj["localMainCtlrLocation"]
        errMsg = "/*******collect MML information *******/\n"
        if not modelManager.changeCli2Debug(self.devObj):
            errMsg += ("~failed to enter current controller's debug mode..\n")
            result = dataConstants.IS_COLLECT_ITEM_FAILED
            collectItem = "emp,raid,sic,pangea,mem info in MML"
            self.recordCrntModuleStatus(currentLogFileDir, result, errMsg, collectItem)
            return
        isSucc, echo = util.executeCmdWithTimeout(self.devObj, "mml")
        if not isSucc or "mml>" not in echo.lower():
            errMsg += ("~failed to enter current controller's MML mode..\n")
            result = dataConstants.IS_COLLECT_ITEM_FAILED
            collectItem = "emp,raid,sic,pangea,mem info in MML"
            self.recordCrntModuleStatus(currentLogFileDir, result, errMsg, collectItem)
            modelManager.changeAnyModel2Cli(self.devObj["SSH"], self.devObj["SFTP"])
            return

        self.runCmdAndCltEcho(crntCtlrFileDir, currentLogFileDir)
        modelManager.changeAnyModel2Cli(self.devObj["SSH"], self.devObj["SFTP"])
        return

    def getMmlCmdEchoInOpztCtrlr(self, opztCtlrFileDir):
        '''
        @summary: execute command on MMl mode and collect command echo on opposite controller
        @note: in MMl mode, echo msg will be divided into several kinds and collected into different files.
        '''
        currentLogFileDir = self.devObj["localOpztCtlrLocation"]
        errMsg = "/*******collect MML information *******/\n"
        sshUtil = SSHToolUtils(self.devObj, self.logger)
        isSucc, sshCon = sshUtil.newSshUsingCrntUsrCredential(self.opztMngIp)
        if not isSucc or sshCon == None:
            if not  modelManager.enterOpztDebugMode(self.devObj) :
                errMsg += ("~failed to enter opposite controller's debug mode..\n")
                result = dataConstants.IS_COLLECT_ITEM_FAILED
                collectItem = "emp,raid,sic,pangea,mem info in MML"
                self.recordCrntModuleStatus(currentLogFileDir, result, errMsg, collectItem)
                return
            isSucc, echo = util.executeCmdWithTimeout(self.devObj, "mml")
            if not isSucc or "mml>" not in echo.lower():
                errMsg += ("~failed to enter opposite controller's MML mode..\n")
                result = dataConstants.IS_COLLECT_ITEM_FAILED
                collectItem = "emp,raid,sic,pangea,mem info in MML"
                self.recordCrntModuleStatus(currentLogFileDir, result, errMsg, collectItem)
                modelManager.changeAnyModel2Cli(self.devObj["SSH"], self.devObj["SFTP"])
                return
            self.runCmdAndCltEcho(opztCtlrFileDir, currentLogFileDir)
            self.logger.info("done collection on MMl mode of the opposite controller...")
            modelManager.quit2MainCtrlrAdminMode(self.devObj)
            return
        else:
            oriSshCon = self.devObj["SSH"]
            self.devObj["SSH"] = sshCon
            if not modelManager.changeCli2Debug(self.devObj):
                errMsg += ("~failed to enter current controller's debug mode..\n")
                result = dataConstants.IS_COLLECT_ITEM_FAILED
                collectItem = "emp,raid,sic,pangea,mem info in MML"
                self.devObj["SSH"] = oriSshCon
                self.recordCrntModuleStatus(currentLogFileDir, result, errMsg, collectItem)
                return
            isSucc, echo = util.executeCmdWithTimeout(self.devObj, "mml")
            if not isSucc or "mml>" not in echo.lower():
                errMsg += ("~failed to enter current controller's MML mode..\n")
                result = dataConstants.IS_COLLECT_ITEM_FAILED
                collectItem = "emp,raid,sic,pangea,mem info in MML"
                self.recordCrntModuleStatus(currentLogFileDir, result, errMsg, collectItem)
                self.devObj["SSH"] = oriSshCon
                modelManager.changeAnyModel2Cli(self.devObj["SSH"], self.devObj["SFTP"])
                return
            self.runCmdAndCltEcho(opztCtlrFileDir, currentLogFileDir)
            self.logger.info("done collection on MMl mode of the opposite controller...")
            modelManager.changeAnyModel2Cli(sshCon)
            self.devObj["SSH"] = oriSshCon
            modelManager.changeAnyModel2Cli(self.devObj["SSH"])
            return

    def runCmdAndCltEcho(self, destFileDir, logDir):
        '''
        @summary: collect command echo
        @return: collect status, errLog, cmdEchos
        '''
        for collectType in [dataConstants.MML_EMP_MMLINFO, dataConstants.MML_RAID_MMLINFO,
                            dataConstants.MML_SIC_MMLINFO, dataConstants.MML_PANGEA_MMLINFO, dataConstants.MML_MEMINFO]:
            cmdEchos = " "
            errMsgs = "/*******%s*******/\n" % collectType.get("destination")
            hasFailed = False
            hasSucceeded = False
            try:
                for checkItem in collectType.get("cmdItem"):
                    isSucc, cmdEcho = util.executeCmdWithTimeout(self.devObj, checkItem)
                    if not isSucc:
                        cmdEchos += ("\n" + checkItem + " command executed failed \n")
                        hasFailed = True
                        errMsgs += ("~" + checkItem + " command executed failed \n" + cmdEcho + ".\n")
                    else:
                        cmdEchos += ("\n" + cmdEcho + "\n")
                        hasSucceeded = True

            except BaseException, expn:
                self.logger.info("[mmlInfo] try to fetch mml mode info but found exception:%s." % str(expn))
                errMsgs += ("~try to collect mml mode information but found exception: %s.\n" % expn)
                hasFailed = True
            resultStatus = self.parseCollectItemStatus(hasSucceeded, hasFailed)
            self.recordCrntModuleStatus(logDir, resultStatus, errMsgs, collectType.get("destination"))
            exportFile = os.path.join(destFileDir, collectType.get("destination"))
            self.logger.info("now try to export current ctrlr's system settings to %s..." % str(exportFile))
            try:
                appenderObj = open(exportFile, "a")
                appenderObj.write(cmdEchos)
            finally:
                self.logger.info("done appending command echo to file...")
                appenderObj.close()

        return

    def parseCollectItemStatus(self, hasSucceeded, hasFailed):
        '''
        @summary:  parse collect Item result status
        @return: enum
        '''
        result = ""
        if hasFailed and hasSucceeded:
            result = dataConstants.IS_COLLECT_ITEM_PARTLY_SUCCESS
        elif hasFailed:
            result = dataConstants.IS_COLLECT_ITEM_FAILED
        else:
            result = dataConstants.IS_COLLECT_ITEM_SUCCESS
        self.logger.info("parse current collection item's status %s" % result)
        return  result

    def recordCrntModuleStatus(self, recordDir, result, errLog, collectItem):
        '''
        @summary: write into info.txt to record current item status
        '''
        self.resultRecorder.recordCrntModuleStatus(recordDir, collectItem, result, errLog)
