﻿#coding: UTF-8
'''
mode switcher:
admin->debug
admin->debug
admin->minisystem
admin->remote
any(main ctrlr)  ->admin
'''
import java.lang.Exception as JException
from com.huawei.ism.tool.obase.connection import SftpTransporter
import re
import checkSecure
from common import util
#cli命令回文行数判断
G_CLI_INFO_NORMAL_ROW_MIN = 7


def changeCli2Developer(devObj):
    '''
    # **************************************************************************** #
    # 函数名称: changeCli2Developer
    # 功能说明: 从Cli模式进入developer模式
    # 输入参数: devObj
    # 输出参数: 无
    # 返 回 值: True or False
    # **************************************************************************** #
    '''
    ssh = devObj.get("SSH")
    developerPwd = ""

    # 调试密码从框架获取 modified 20131129 Begin
    try:
        developerPwd = devObj.get("developer")
    except:
        return False

    #如果密码设置为空，则返回False
    if developerPwd == None or developerPwd == "":
        return False

    #判断是否为安全红线设备
    secureFlag = checkSecure.execute(ssh)
    if secureFlag:
        temp = ssh.execCmd("developer")
        #安全红线后设备进入developer模式
        if re.search("Are you sure", temp, re.IGNORECASE):

            temp1 = ssh.execCmd("y")

            if re.search("Enter Password", temp1, re.IGNORECASE):
                temp2 = ssh.execCmdNoLog(developerPwd)
                if re.search("developer:", temp2, re.IGNORECASE):
                    return True
    else:
        calPwd = developerPwd
        temp = ssh.execCmd("developer")
        #安全红线前设备进入developer模式
        if re.search("Enter Password", temp, re.IGNORECASE):
            temp1 = ssh.execCmdNoLog(calPwd)
            if re.search("developer:", temp1, re.IGNORECASE):
                return True
    # 调试密码从框架获取 modified 20131129 End

    #进入developer模式失败，重新回到CLI模式
    changeAnyModel2Cli(ssh)
    return False


def changeAnyModel2Cli(ssh, sftp = None):
    '''
    # **************************************************************************** #
    # 函数名称: changeAnyModel2Cli
    # 功能说明: 从任意模式退出到cli命令模式（不适用于心跳连接到对端的情况）
    # 输入参数: ssh
    # 输出参数: 无
    # 返 回 值: True or False
    # **************************************************************************** # 
    @warning: Only capable for current main controller's mode switch!
    '''
    try:
        counter = 0
        while True:
            temp = ssh.execCmd("showsys")
            #非developer模式下，cli回文正确，则认为回到了cli
            if re.search("System Name", temp, re.IGNORECASE) \
                and not re.search("developer", temp, re.IGNORECASE):
                break
            #老版本在minisystem下直接exit会退出连接，需要重连
            elif re.search("minisystem>", temp, re.IGNORECASE):
                temp1 = ssh.execCmd("exit")
                if re.search("Are you sure", temp1, re.IGNORECASE):
                    try:
                        ssh.execCmd("y")
                    except:
                        ssh.reConnect()
                        if sftp != None and isinstance(sftp, SftpTransporter):
                            sftp.reConnect()
                    continue

            #其他情况下，直接exit
            else:
                temp1 = ssh.execCmd("exit")
                if re.search("Are you sure", temp1, re.IGNORECASE):
                    ssh.execCmd("y")

            #单控的命令模式最多4层
            counter += 1
            if counter >= 4:
                break
    except:
        ssh.reConnect()
        if sftp != None:
            sftp.reConnect()


def changeDeveloper2Minisystem(devObj):
    '''
    # **************************************************************************** #
    # 函数名称: changeDeveloper2Minisystem
    # 功能说明: 从developer模式进入minisystem模式
    # 输入参数: devObj
    # 输出参数: 无
    # 返 回 值: True or False
    # **************************************************************************** # 
    '''
    ssh = devObj.get("SSH")
    #进入minisystem
    temp = ssh.execCmd("minisystem")
    if re.search("Are you sure", temp, re.IGNORECASE):
        temp1 = ssh.execCmd("y")

        if re.search("minisystem>", temp1, re.IGNORECASE):
            return True

    return False


def changeCli2Debug(devObj):
    '''
    # **************************************************************************** #
    # 函数名称: changeCli2Debug
    # 功能说明: 从Cli模式进入debug模式
    # 输入参数: devObj
    # 输出参数: 无
    # 返 回 值: True or False
    # **************************************************************************** #
    '''
    ssh = devObj.get("SSH")

    # 调试密码从框架获取 added 20131129 Begin
    #先判断调试密码是否为空
    try:
        calPwd = devObj.get("developer")
    except:
        return False

    #如果密码设置为空，则返回False
    if calPwd == None or calPwd == "":
        return False
    # 调试密码从框架获取 added 20131129 End

    #判断是否为安全红线设备
    secureFlag = checkSecure.execute(ssh)
    if secureFlag:
        return False

    #安全红线前的设备：先进入developer
    changeFlag = changeCli2Developer(devObj)
    if not changeFlag:
        return False


    temp = ssh.execCmd("debug")
    #V1R2直接进入debug
    if re.search("Storage:", temp, re.IGNORECASE):
        return True
    #V1R1仍需要再多输入一次密码
    elif re.search("Enter Password", temp, re.IGNORECASE):
        temp1 = ssh.execCmdNoLog(calPwd)
        if re.search("Storage:", temp1, re.IGNORECASE):
            return True
    #其他情况，返回失败
    else:
        pass

    #进入debug模式失败，重新回到CLI模式
    changeAnyModel2Cli(ssh)

    return False

def isSecuredAndNoMinisystem(devObj):
    '''
    @summary: check whether the system is within red-line but failed to enter minisystem 
    '''
    ssh = devObj.get("SSH")
    sftp = devObj.get("SFTP")
    secureFlag = checkSecure.execute(ssh)
    if not secureFlag:
        return False
    try:
        if  changeCli2Developer(devObj):
            if not changeDeveloper2Minisystem(devObj):
                changeAnyModel2Cli(ssh, sftp)
                return True
        changeAnyModel2Cli(ssh, sftp)
        return False
    except BaseException , excp:
        devObj.get("logger").info("exception occurred when attempt to enter minisystem mode :%s" % str(excp))
        ssh.reConnect()
        sftp.reConnect()
        return True
    except JException , jexcp:
        devObj.get("logger").info("exception occurred when attempt to enter minisystem mode :%s" % str(jexcp))
        ssh.reConnect()
        sftp.reConnect()
        return True

def ssh2RemoteCtrlr(devObj):
    '''
    @summary: build connection to remote controller via debug mode's SSH interface
    '''
    ssh = devObj.get("SSH")
    logger = devObj.get("logger")
    isDeviceSecured = checkSecure.execute(ssh)
    logger.info("[mode manager]current device has %sly secured" % str(isDeviceSecured))
    oppstInnerIp = util.getOppstInnerIp(devObj)
    try:
        if not isDeviceSecured:
            return ssh2RemoteViaDebug(devObj, oppstInnerIp)
        else:
            return ssh2RemtoeViaMinisystem(devObj)
    except JException, jexcept:
        logger.info("Exception occurred while trying to connect to remote %s " % str(jexcept))
        if isConnected(devObj):
            changeAnyModel2Cli(ssh)
        else:
            reconnect(devObj)
        return False
    except BaseException, excp:
        logger.info("Exception(python) occurred  while trying to heart-beat to opposite %s" % str(excp))

def ssh2RemtoeViaMinisystem(devObj):
    '''
    @summary: ssh to remote controller via minisystem  mode's ssh2remote interface
    '''
    ssh = devObj.get("SSH")
    logger = devObj.get("logger")
    logger.info("current device is secured, try to enter minisystem mode...")
    try:
        if not changeCli2Developer(devObj):
            logger.info("failed to enter developer mode on device")
            return False
        #entered developer mode
        if not changeDeveloper2Minisystem(devObj):
            changeAnyModel2Cli(ssh)
            return False
        cmd = "sshtoremote"
        isSuccess, cmdEcho = util.executeCmdWithTimeout(devObj, cmd)
        if isSuccess and "password:" in cmdEcho.lower():
            isSuccess, cmdEcho = util.execCmdTmoutNoLog(devObj, util.getLoginPasswd(devObj))
            if "password:" in cmdEcho.lower():
                logger.info("[mode manager] WRONG Password!, quit")
                util.sendCtrlPlusCCmd(devObj)
                changeAnyModel2Cli(ssh)
        if isSuccess and "welcome" in cmdEcho.lower() and ":/>" in cmdEcho:
            return True
        else:
            changeAnyModel2Cli(ssh)
            return False
    except:
        raise

def ssh2RemoteViaDebug(devObj, oppstInnerIp):
    '''
    @summary:  ssh to remote controller via debug mode's ssh interface
    @raise exception: connection might be interrupted , ToolException shall be catched if called    
    '''
    try:
        ssh = devObj.get("SSH")
        logger = devObj.get("logger")
        isSuccess = changeCli2Debug(devObj)
        if not isSuccess:
            logger.info("[mode manager]failed to change to debug mode...")
            return isSuccess

        logger.info("[mode manager]opposite controller's inner ip is %s" % str(oppstInnerIp))
        name = devObj.get("username")
        if not oppstInnerIp or not name:
            logger.info("[mode manager] failed to qry opzt ctl ip or user name")
            return False
        cmd = "ssh " + name + "@" + oppstInnerIp
        isSuccess, cmdEcho = util.executeCmdWithTimeout(devObj, cmd)
        if not isSuccess:
            logger.info("[mode manager] failed to connect to peering ctrlr")
            changeAnyModel2Cli(ssh)
            return False
        if "password:" in cmdEcho.lower():
            isSuccess, cmdEcho = util.execCmdTmoutNoLog(devObj, util.getLoginPasswd(devObj))
            if "password:" in cmdEcho.lower():
                logger.info("[mode manager] WRONG Password!, quit")
                util.sendCtrlPlusCCmd(devObj)
                changeAnyModel2Cli(ssh)
        if "welcome" in cmdEcho.lower() and ":/>" in cmdEcho:
            return True
        else:
            changeAnyModel2Cli(ssh)
            return False
    except:
        raise

def isConnected(devObj):
    '''
    @summary: check whether the SSH connection (with Session) is connected
    '''
    ssh = devObj.get("SSH")
    logger = devObj.get("logger")
    if not ssh.isConnected():
        logger.info("current SSH Connection is interrupted!")
        return False
    else:
        logger.info("current SSH Connection is connected!")
        return True

def reconnect(devObj):
    '''
    @summary: reconnect to device ,rebuild ssh and sftp connection
    '''
    ssh = devObj.get("SSH")
    sftp = devObj.get("SFTP")
    logger = devObj.get("logger")
    logger.info("[mode manager]except occurred, reconnect to device")
    try:
        ssh.reConnect()
        sftp.reConnect()
        logger.info("[model manager]reconnected!")
        return True
    except JException, jex:
        logger.info("failed to reconnect! error msg: %s " % str(jex))
    except BaseException, excp:
        logger.info("failed to reconnect! error msg: %s " % str(excp))
    return False

def enterOpzDeveloperMode(devObj):
    '''
    @summary: try to enter opposite controller's developer mode
    @note: quit to current controller's admin mode if failed
    '''
    logger = devObj.get("logger")
    if not ssh2RemoteCtrlr(devObj):
        logger.info("[mode manager]failed to connect to opposite controller's admin mode, quit...")
        return False
    developerPasswd = devObj.get("developer")#this does exits here!
    cmd = "developer"
    cmdStatus, cmdEcho = util.executeCmdWithTimeout(devObj, cmd)
    if not cmdStatus :
        quit2MainCtrlrAdminMode(devObj)
        return False
    if cmdEcho and "are you sure" in cmdEcho.lower():
        cmdStatus, cmdEcho = util.executeCmdWithTimeout(devObj, "y")
    if cmdEcho and "enter password" in cmdEcho.lower():
        cmdStatus, cmdEcho = util.execCmdTmoutNoLog(devObj, developerPasswd)
    if not 'developer:' in cmdEcho.lower():
        logger.info("[mode manager]wrong mode fetched while trying to enter remote ctrl's developer mode")
        quit2MainCtrlrAdminMode(devObj)
        return False
    return True

def enterOpztDebugMode(devObj):
    '''
    @summary: enter into opposite controller's debug mode ,quit and roll-back to admin mode if failed
    '''
    ssh = devObj.get("SSH")
    logger = devObj.get("logger")
    developerPasswd = devObj.get("developer") #this does exits here!
    if not enterOpzDeveloperMode(devObj):
        return False
    isDeviceSecured = checkSecure.execute(ssh)
    logger.info("[mode manager]current device has %sly secured" % str(isDeviceSecured))
    if isDeviceSecured:
        logger.info("[mode manager]cannot enter debug mode due to device's secure strategy")
        return False
    cmd = "debug"
    cmdStatus, cmdEcho = util.executeCmdWithTimeout(devObj, cmd)
    if cmdStatus and  "enter password" in cmdEcho.lower():
        cmdStatus, cmdEcho = util.execCmdTmoutNoLog(devObj, developerPasswd)
    if "storage:" in cmdEcho.lower():
        logger.info("[mode manager]successfully entered opposite controller's storage mode.")
        return True
    logger.info("[mode manager]wrong mode fetched while trying to enter remote ctrl's debug mode")
    quit2MainCtrlrAdminMode(devObj)
    return False

def enterOpzMinisystemMode(devObj):
    '''
    @summary:  enter into opposite controller's Mini-system mode ,quit and roll-back to admin mode if failed
    '''
    logger = devObj.get("logger")
    if not enterOpzDeveloperMode(devObj):
        return False
    logger.info("[mode manager] now trying to enter opposite controller's minisytem mode...")
    cmd = "minisystem"
    cmdStatus, cmdEcho = util.executeCmdWithTimeout(devObj, cmd)
    if cmdStatus and "are you sure" in cmdEcho.lower():
        cmdStatus, cmdEcho = util.executeCmdWithTimeout(devObj, "y")
    if "minisystem>" in cmdEcho.lower():
        logger.info("[mode manager] successfully entered into opposite controller's minisytem mode")
        return True
    logger.info("[mode manager] failed to enter opposite controller's minisystrem mode, quit...")
    quit2MainCtrlrAdminMode(devObj)
    return False

def quit2MainCtrlrAdminMode(devObj):
    '''
    @summary:call this func if ssh had already heart-beat to opposite controller and back to main controller's admin mode is required
    @note: you must make sure that you are now successfully entered opposite controller's any mode
    '''
    logger = devObj.get("logger")
    ssh = devObj.get("SSH")
    timeOut = 3 * 60
    try:
        while True:
            logger.info("[mode manager] try exit cmd to quit to main ctrlr admin mode ...")
            cmd = "exit"
            cmdEcho = ssh.execCmdWithTimout(cmd, timeOut)

            if "are you sure" in cmdEcho.lower():
                ssh.execCmdWithTimout("y", timeOut)
    except:
        return reconnect(devObj)
