﻿#coding: UTF-8

import re
import modelManager
import os
import codecs
import shutil
from java.io import File
from java.lang import Exception
from cbb.frame.util.tar_util import decompress_tar_all_file
import string
import time

#单次收集硬盘最大个数
CollectDiskInfo_MAXCounter = 20

G_INFORMATION_SPLIT_STR = "\n********************\n"

# **************************************************************************** #
# 函数名称: decompressPKG
# 功能说明: 解压告警文件
# 输入参数: ssh
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def decompressPKG(filePath, depressPath):
    decompress_tar_all_file(filePath, depressPath)

# **************************************************************************** #
# 函数名称: getPath
# 功能说明: 获取告警文件路径
# 输入参数: ssh
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
#MML>alarm exportevent
def getPath(mmlInfo):
    lineList = mmlInfo.splitlines()    
    path = ""
    
    for line in lineList:
        if re.search("path", line, re.IGNORECASE):
            path = line[line.index(":/") + 1 : -2]
            break
        else:
            continue
            
    return path

# *************************************************************#
# 函数名称: commonFileWrite
# 功能说明: 文件写入操作（通用函数）
# 其 他   :  无
# *************************************************************#  
def commonFileWrite(fileName, writeInfoStr, ifAddFlag, logger):

    flag = True
    try:
        #判断是否为追加内容
        if True == ifAddFlag:
            localFile = codecs.open(fileName, "a", "utf-8")
        else:
            localFile = codecs.open(fileName, "w", "utf-8")
            
        localFile.write(writeInfoStr)
        localFile.close()
    except Exception,e:
        logger.error("Writing to file error:" + str(e))
        flag = False
    
    return flag

# **************************************************************************** #
# 函数名称: getEventInMmlModel
# 功能说明: 在mml模式下获取event信息文件
# 输入参数: 无
# 输出参数: 无
# **************************************************************************** # 
def getEventInMmlModel(devObj):
    
    """取得传入参数"""
    ssh = devObj.get("SSH")
    #Smart信息文件保存路径
    smartInfoSaveDir = devObj['SmartInfoDir']
    sftp = devObj.get("SFTP")
    logger = devObj.get("logger")

    #通过mml命令生成告警文件
    mmlRet = ssh.execCmd("alarm exportevent")
    lineList = mmlRet.splitlines()

    if not bool(re.search("path", mmlRet, re.IGNORECASE)):
        logger.error("[Smart Info] Running command to create event file Failed!")
        return False
    
    remoteFile = getPath(str(mmlRet))
    
    #创建临时文件夹
    tempDir = smartInfoSaveDir + os.sep + "temp"
    if not os.path.exists(tempDir):
        logger.info("[Smart Info] Create temp directory:" + tempDir)
        os.makedirs(tempDir)

    localFile = tempDir + os.sep + 'event_export.tar'
    file = File(localFile)
    try:
        sftp.getFile(remoteFile, file, None)  
    except Exception,e:
        logger.error("[Smart Info] Get file by SFTP Error:" + str(e))
        return False
    #解压到临时文件夹
    decompressPKG(localFile, tempDir)
    
    #提取local_alm_file.txt文件
    alarmFile = tempDir + os.sep + "local_alm_file.txt"
    if not os.path.exists(alarmFile):
        logger.error("[Smart Info] local_alm_file.txt is not exists!")
        return False
    
    shutil.copy(alarmFile, smartInfoSaveDir)
    #修改文件名
    oldFile = smartInfoSaveDir + os.sep + "local_alm_file.txt"
    newFile = smartInfoSaveDir + os.sep + "event.txt"
    os.rename(oldFile, newFile)
    
    #删除临时文件夹
    try:
        shutil.rmtree(tempDir, True)
    except:
        logger.error("[Smart Info] Delete temp directory Failed!")
    
    return True


# 框号变更导致Smart信息收集不到 added 20150108 Begin
# **************************************************************************** #
# 函数名称: getEnclosureIDMap
# 功能说明: 获取框外部ID与内部ID对应关系（调用者保证：调用此接口前，ssh在MML模式下）
# 输入参数: ssh
# 输出参数: 无
# **************************************************************************** # 
def getEnclosureIDMap(devObj):
    
    ssh = devObj.get("SSH")
    logger = devObj.get("logger")
    
    idListMap = {}    
    
    temp = ssh.execCmd("dev framerecord")
    
    for line in temp.splitlines():
        if "user, inner, mac" in line:
            field = line.split("[")
            if len(field) == 2:
                mapList = field[1].split(",")
                if len(mapList) == 3:
                    userId = mapList[0].strip()
                    innerId = mapList[1].strip()
                    
                    #内部框号为唯一值，作为key值保存
                    idListMap[innerId] = userId
    
    return idListMap
# 框号变更导致Smart信息收集不到 added 20150108 End

# 收集失败打印硬盘位置信息  modified 20131008 Begin
# **************************************************************************** #
# 函数名称: getCollectDiskList
# 功能说明: 获取需要获取Smart信息的硬盘列表（调用者保证：调用此接口前，ssh在debug模式下）
# 输入参数: ssh
# 输出参数: 无
# **************************************************************************** # 
def getCollectDiskList(devObj):
    
    ssh = devObj.get("SSH")
    logger = devObj.get("logger")
    diskInfoDict = {"location":"", "name":""}
    location = ""

    needCollectDiskList = []
    diskLocationList = devObj["diskLocationList"]
    
    #进入mml命令模式
    ssh.execCmd("mml")
    
    # Smart信息收集不到问题优化 modified 20150108 Begin
    #获取框ID对应关系
    enclosureIdMap = getEnclosureIDMap(devObj)
    logger.info("[Smart Information Collect] enclosureIdMap:" + str(enclosureIdMap))
    if not enclosureIdMap:
        logger.error("Getting enclosure IDs ERROR!")
        return needCollectDiskList
    
    innerIdList = enclosureIdMap.keys()
    #循环通过内部框号获取单个框硬盘信息
    allDiskInfoStr = ""
    for Id in innerIdList:
        queryCmd = "dev diskinfo " + Id
        temp = ssh.execCmd(queryCmd)
        if re.search("(\d+,\d+)", temp, re.IGNORECASE):
            allDiskInfoStr += temp
    
    #获取总体硬盘信息
    lineList = allDiskInfoStr.splitlines()
    for line in lineList:
        if line.find("wwn") >= 0:
            #查询硬盘的location
            field = line.split()
            if len(field) > 2:
                location = field[1]
                
                #硬盘Location中内部框号转换为外部框号
                enclosureId = location.split(",")[0].strip().replace("(", "").strip()
                slotId = location.split(",")[1].strip().replace(")", "").strip()
                if enclosureId in innerIdList:
                    newEnId = enclosureIdMap.get(enclosureId)
                    location = "(" + newEnId + "," + slotId + ")"
                else:
                    #内部框号根本不存在，则丢弃
                    location = ""

                #如果location不在硬盘的物理信息中，则认为是系统盘，不需要收集
                if location not in diskLocationList:
                    location = ""
            #继续查询下一行
            continue
        
        if location != "" and line.find("Name") >= 0:
            #查询盘符信息
            field = line.split(",")
            for temp in field:
                if temp.startswith("Name"):
                    #盘符可能为空，也需要记录
                    diskName = temp.replace("Name ", "")
                    #获取正常的硬盘盘符(注：sda为可能为系统盘的盘符，不需要收集)
                    if diskName != "sda":
                        diskInfoDict["location"] = location
                        diskInfoDict["name"] = diskName
                        
                        #记录硬盘信息，初始化变量
                        needCollectDiskList.append(diskInfoDict)
                        diskInfoDict = {"location":"", "name":""}
                        location = ""
                        diskName = ""      
        else:
            continue
    #退出mml命令模式
    ssh.execCmd("exit")
    logger.info("[Smart Information Collect] needCollectDiskList:" + str(needCollectDiskList))
    # Smart信息收集不到问题优化 modified 20150108 End
    
    return needCollectDiskList

# 收集失败打印硬盘位置信息  modified 20131008 End

# 收集失败打印硬盘位置信息  modified 20131008 Begin
# **************************************************************************** #
# 函数名称: debugModelCollect
# 功能说明: 查询当前控制器下的硬盘Smart信息（调用者保证：调用此接口前，ssh在debug模式下）
# 输入参数: ssh
# 输出参数: 无
# **************************************************************************** # 
def debugModelCollect(devObj):
    
    #获取全局信息
    ssh = devObj.get("SSH")
    lang = devObj.get("lang")
    logger = devObj.get("logger")
    smartInfoSaveDir = devObj['SmartInfoDir']
    diskLocationList = devObj["diskLocationList"]
    
    #收集成功的Smart信息
    diskSmartInfoStr = ""
    #收集失败的Smart信息
    collectFailSmartINfoStr = ""
    
    #收集成功的硬盘列表
    collectSuccessDiskList = []
    #收集失败的硬盘列表
    collectFailedDiskList = []
    
    #计数器清零
    saveCounter = 0
    tempCounter = 0
    successCounter = 0

    #通过showdiskinfo命令获取硬盘盘符列表
    needCollectDiskList = getCollectDiskList(devObj)
    logger.info("[Smart Info] Need to collect disk number:" + str(len(needCollectDiskList)))
    
    #summary.ini文件操作变量
    configFileName = smartInfoSaveDir + os.sep + "summary.ini"
    configDataStr = ""
    indexInfoStr = ""
    physicDiskCounter = devObj["TotalDiskNumber"]
    configDataStr += "total=" + str(physicDiskCounter) + "\n"

    diskName = ""
    diskLocation = ""
    #收集失败的硬盘列表
    collectFailDiskStr = ""

    #收集所有盘的Smart信息
    for diskInfoTmp in needCollectDiskList:
        #获取硬盘信息
        diskName = diskInfoTmp["name"]
        diskLocation = diskInfoTmp["location"]
        
        #盘符为空，则直接将此硬盘设定为收集失败
        if diskName == "":
            #收集失败，需要将location写入失败列表
            if collectFailDiskStr == "":
                collectFailDiskStr = diskLocation
            else:
                collectFailDiskStr += "," + diskLocation
            
            diskInfoStrTmp = "Disk " + diskLocation + " has no name, collecting smart information failed!"
            collectFailSmartINfoStr += diskInfoStrTmp + G_INFORMATION_SPLIT_STR
            #添加到收集失败硬盘列表中
            collectFailedDiskList.append(diskLocation)
            continue
        
        #盘符不为空，继续收集
        cmdEndFlagList = ['> ', '# ']
        diskInfoStrTmp = ssh.execCmdNoLog("disktool -f a /dev/" + diskName, cmdEndFlagList)
        #判断收集是否成功
        if re.search("Serial Number", diskInfoStrTmp, re.IGNORECASE):
            tempCounter += 1
            successCounter += 1
            diskSmartInfoStr += diskInfoStrTmp + G_INFORMATION_SPLIT_STR
            #添加到收集成功硬盘列表中
            collectSuccessDiskList.append(diskLocation)
        else:
            #收集失败，需要将location写入失败列表
            if collectFailDiskStr == "":
                collectFailDiskStr = diskLocation
            else:
                collectFailDiskStr += "," + diskLocation
            collectFailSmartINfoStr += diskInfoStrTmp + G_INFORMATION_SPLIT_STR
            #添加到收集失败硬盘列表中
            collectFailedDiskList.append(diskLocation)

        #每收集20块盘，保存一份文件
        if tempCounter >= CollectDiskInfo_MAXCounter:
            
            #新建文件，保存smart信息
            fileName = smartInfoSaveDir + os.sep + "smart" + str(saveCounter) + ".txt"
            flag = commonFileWrite(fileName, diskSmartInfoStr, False, logger)
            if not flag:
                return (False, collectFailDiskStr)
            
            logger.info("[Smart Info] Collect 20 disks and write the result to the new file:" + fileName)
            
            #增加index描述
            indexInfoStr += "smart" + str(saveCounter) + "=" + str(successCounter-tempCounter) + "-" + str(successCounter-1) + "\n"
            
            #计数加一，变量清空
            saveCounter += 1
            diskSmartInfoStr = ""
            tempCounter = 0
            
    #不满20块盘，则最终收集写入文件
    if tempCounter > 0:
        #新建文件，保存smart信息
        fileName = smartInfoSaveDir + os.sep + "smart" + str(saveCounter) + ".txt"
        flag = commonFileWrite(fileName, diskSmartInfoStr, False, logger)
        if not flag:
            return (False, collectFailDiskStr)
        
        logger.info("[Smart Info] Collect remaining disks and write the result to the new file:" + fileName)
        
        #增加index描述
        indexInfoStr += "smart" + str(saveCounter) + "=" + str(successCounter-tempCounter) + "-" + str(successCounter-1) + "\n"

    #是否收集失败
    if successCounter == 0:
        logger.error("The number of disks successfully collected is 0, Error!")
        return (False, collectFailDiskStr)

    #记录成功数到信息增加
    configDataStr += "success=" + str(successCounter) + "\n"

    #记录收集完成时间
    curTime = time.strftime('%Y-%m-%d %H:%M:%S',time.localtime(time.time()))
    configDataStr += "date=" + str(curTime) + "\n"
    
    #没有收集到的硬盘也要加入到收集失败列表中
    for diskLocation in diskLocationList:
        if diskLocation not in collectSuccessDiskList and diskLocation not in collectFailedDiskList:
            collectFailSmartINfoStr += "Disk " + diskLocation + " has no name, collecting smart information failed!" + G_INFORMATION_SPLIT_STR
            collectFailedDiskList.append(diskLocation)
            #收集失败，需要将location写入失败列表
            if collectFailDiskStr == "":
                collectFailDiskStr = diskLocation
            else:
                collectFailDiskStr += "," + diskLocation

    #打印调试信息
    logger.info("[Smart Info] All need collect disks List:" + str(diskLocationList))
    logger.info("[Smart Info] Collect succeed disks List:" + str(collectSuccessDiskList))
    logger.info("[Smart Info] Collect failed disks List:" + str(collectFailedDiskList))    

    #将所有的信息写入summary.ini
    configDataStr += indexInfoStr
    flag = commonFileWrite(configFileName, configDataStr, False, logger)
    if not flag:
        return (False, collectFailDiskStr)
    
    
    #如果存在收集失败的盘，写入failsmart.txt文件
    if collectFailSmartINfoStr != "":
        fileName = smartInfoSaveDir + os.sep + "failsmart.txt"
        flag = commonFileWrite(fileName, collectFailSmartINfoStr, False, logger)
        if not flag:
            return (False, collectFailDiskStr)

    #正确返回
    return (True, collectFailDiskStr)

# 收集失败打印硬盘位置信息  modified 20131008 End

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 脚本执行入口
# 输入参数: ssh
# 输出参数: 无
# **************************************************************************** # 
def execute(devObj):

    ssh = devObj.get("SSH")
    lang = devObj.get("lang")
    logger = devObj.get("logger")
    
    flag = True
    errMsg = ""

    # 调试密码从框架获取 modified 20131129 Begin
    #先尝试切换到debug模式
    flag = modelManager.changeCli2Debug(devObj)
    if False == flag:
        logger.error("[Smart Info] Login to debug model failed, can not collect disk smart information!")
        if lang == "zh":
            errMsg = u"进入debug模式失败，信息收集失败。失败的原因可能为：\n" \
                    + u"（1）添加设备时未输入调试密码。\n（2）添加设备时输入的调试密码无效。"
        else:
            errMsg = "Login to debug model failed, can not collect disk smart information.The reason of failure may be:\n" \
                    + "(1) Did not enter a debug password when adding the device.\n(2) The debug password entered is incorrect."
        return (False, errMsg)
    # 调试密码从框架获取 modified 20131129 Begin

    # 收集失败打印硬盘位置信息  modified 20131008 Begin
    #在debug模式下收集控制器smart信息
    devObj["collectAllInfo"] = True
    collectFailDiskStr = ""
    iRet = debugModelCollect(devObj)
    if False == iRet[0]:
        logger.error("[Smart Info] Collecting disk smart information failed by debugModel!")
        #设置返回信息
        if lang == "zh":
            errMsg = u"在debug模式下收集硬盘Smart信息失败。"
        else:
            errMsg = "Collecting disk smart information failed by debugModel!"  
        return (False, errMsg)
    else:
        collectFailDiskStr = iRet[1]
        #部分收集成功
        if collectFailDiskStr != "":
            #设置返回信息
            if lang == "zh":
                errMsg = u"硬盘" + collectFailDiskStr + u"收集Smart失败，请按照如下建议处理：\
                \n（1）收集失败的原因可能是：硬盘单链路、响应慢、故障或者休眠。请先按照标准处理方法修复，修复完成后重新收集一次；\
                \n（2）如果仍然收集失败，请尝试手动执行命令收集单块硬盘；\
                \n（3）如果有任何疑问，请联系技术支持工程师协助处理；"
            else:
                errMsg = "Collecting smart information of disks " + collectFailDiskStr + " failed, please handle them according to the suggestion:\
                \n(1)The reason of failure may be: the disk is single path, the response of disk is slow, the disk is fault or in spin down status. Please repair it according to the standard treatment, then collect again;\
                \n(2)If collecting failed again, please try to collect the smart information manually;\
                \n(3)If you have any questions, please contact technical support engineers for further handling."
            
            #设置部分收集成功
            devObj["collectAllInfo"] = False
            devObj["py_detail"] = errMsg
    # 收集失败打印硬盘位置信息  modified 20131008 End

    #收集event信息
    #进入mml命令模式
    ssh.execCmd("mml")
    iRet = getEventInMmlModel(devObj)
    #重新回到CLI模式
    ssh.execCmd("exit")
    modelManager.changeAnyModel2Cli(ssh)

    if False == iRet:
        logger.error("[Smart Info] Collecting disk smart information failed by debugModel!")
        #设置返回信息
        if lang == "zh":
            errMsg = u"在Mml模式下收集Event信息失败。"
        else:
            errMsg = "Collecting Event information failed by MmlModel!"
        return (False, errMsg)

    #处理成功
    return (True, "")
