# -*- coding: UTF-8 -*-
'''
@summary: datacollect module func:collect minisystem(minisystem: />) information
'''
import os
from common import util
from common import dataConstants
from time import sleep
import modelManager
import checkSecure
from common.sshTools import SSHToolUtils
from common.dataCollectResultRecorder import DataCollectResultRecorder
class DeviceInnerLogCollector():
    '''
    @summary: collect minisystem  or debug mode command echo, collect in one file named minisystemCmd_info.txt or debugCmdInfo.txt
    '''
    def __init__(self, devObject, opztMngIp, localCtrlrPriority):
        '''
        @summary: initializing parameters
        '''
        self.devObj = devObject
        self.logger = self.devObj.get("logger")
        self.logger.info("[minisystem or debug Info] initiating MiniSystemInfoCollector...")
        self.localMngIp = self.devObj.get("devIp")
        self.opztMngIp = opztMngIp
        self.localCtrlrPriority = localCtrlrPriority
        self.resultRecorder = DataCollectResultRecorder(self.devObj)
        self.collectItem = ""

    def doCollect(self, isMinisystem):
        '''
        @summary: entrance
        '''
        self.closePaginationFunc()
        if isMinisystem and not self.minisysCanCollect():
            self.collectItem = dataConstants.MINISYSTEM_CMD_ECHO_DESTINATION
            self.logger.info("current system is secured and without minisystem mode , quit collection...")
            errLog = "/********minisystem information error********/\n~ current device has no minisystem mode\n"
            self.resultRecorder.recordCrntModuleStatus(self.devObj["localMainCtlrLocation"], \
                                self.collectItem, dataConstants.IS_COLLECT_ITEM_NOT_INVOLVED, errLog)
            if self.opztMngIp:
                self.resultRecorder.recordCrntModuleStatus(self.devObj["localOpztCtlrLocation"], \
                                self.collectItem, dataConstants.IS_COLLECT_ITEM_NOT_INVOLVED, errLog)
            return
        currentCtrlrDir, oppositeCtrlrDir = self.tryMkLocalDir()
        if  isMinisystem:
            self.collectItem = dataConstants.MINISYSTEM_CMD_ECHO_DESTINATION
            self.clctCurCtrlrMinisysCmdEcho(currentCtrlrDir)
            if self.opztMngIp:
                self.clctOpztCtrlrMinisysCmdEcho(oppositeCtrlrDir)
        else:
            self.collectItem = dataConstants.DEBUG_CMD_ECHO_DESTINATION
            self.clctCurCtrlrDebugCmdEcho(currentCtrlrDir)
            if self.opztMngIp:
                self.clctOpztCtrlrDebugCmdEcho(oppositeCtrlrDir)
        modelManager.changeAnyModel2Cli(self.devObj["SSH"], self.devObj["SFTP"])
        return

    def minisysCanCollect(self):
        '''
        @summary: checking whether the device is ready for minisystem info Collection
        '''
        ssh = self.devObj.get("SSH", "")
        if not checkSecure.execute(ssh):
            self.logger.info("current system is not red-line secured , there's no minisystem mode")
            return False
        elif modelManager.isSecuredAndNoMinisystem(self.devObj):
            self.logger.info("current system is secured but failed to enter minisystem.")
            return False
        else:
            return True

    def tryMkLocalDir(self):
        '''
        @summary: try to make 'other' directory, if it does not exist, create one.
        @return: local directory corresponding to  current controller
        @return: local directory corresponding to  opposite controller
        '''
        localMainCtlrLocation = os.path.join(self.devObj["localMainCtlrLocation"],
             dataConstants.COLLECT_TYPE_OTHERS)
        localOpztCtlrLocation = ""

        if not os.path.exists(localMainCtlrLocation) and localMainCtlrLocation:
            os.makedirs(localMainCtlrLocation)

        if self.opztMngIp :
            localOpztCtlrLocation = os.path.join(self.devObj["localOpztCtlrLocation"],
                                                 dataConstants.COLLECT_TYPE_OTHERS)
            if not os.path.exists(localOpztCtlrLocation) and localOpztCtlrLocation:
                os.makedirs(localOpztCtlrLocation)

        return localMainCtlrLocation, localOpztCtlrLocation

    def closePaginationFunc(self):
        '''
        @summary: set 'chgpagination' switch to off , which brings '--more--' interaction disabled
        '''
        cmd = "chgpagination off"
        cmdEchoList = util.executeCmdWithTimeout(self.devObj, cmd)
        return cmdEchoList[0]

    def writeCmdEchos2File(self, currentCtrlrDir, fileName, cmdEchos):
        '''
        @summary: execute command on minisystem mode and collect command echo to specified file
        @note: minisystemCmdInfo.txt
        '''
        exportFile = os.path.join(currentCtrlrDir, fileName)
        self.logger.info("now try to export current ctrlr's system settings to %s..." % str(exportFile))
        try:
            appenderObj = open(exportFile, "a")
            appenderObj.write(cmdEchos)
        finally:
            self.logger.info("done appending command echo to file...")
            appenderObj.close()

    def clctCurCtrlrDebugCmdEcho(self, currentCtrlrDir):
        '''
        @summary: 
        '''
        errLog = "/********debug information error********/\n"
        destFileName = dataConstants.DEBUG_CMD_ECHO_DESTINATION
        if not modelManager.changeCli2Debug(self.devObj):
            errLog += ("~failed to enter system's debug mode, quit collection.\n")
            self.recordCrntModuleStatus(self.devObj["localMainCtlrLocation"], False, False, errLog)
            self.writeCmdEchos2File(currentCtrlrDir, destFileName, " ")
            return
        hasFail, hasSuc, echoMsg, errMsg = self.runCommonCmdAndCltEcho()
        errLog += errMsg
        hasFailed, hasSucc, echoMsgs, errMsg = self.runDebugCmdandCltEcho()
        hasFail = hasFail or hasFailed
        hasSuc = hasSuc or hasSucc
        echoMsg += echoMsgs
        errLog += errMsg
        self.recordCrntModuleStatus(self.devObj["localMainCtlrLocation"], hasSuc, hasFail, errLog)
        self.writeCmdEchos2File(currentCtrlrDir, destFileName, echoMsg)
        modelManager.changeAnyModel2Cli(self.devObj["SSH"])
        return

    def clctOpztCtrlrDebugCmdEcho(self, oppositeCtrlrDir):
        '''
        @summary: 
        '''
        errLog = "/********debug information error********/\n"
        destFileName = dataConstants.DEBUG_CMD_ECHO_DESTINATION
        sshUtil = SSHToolUtils(self.devObj, self.logger)
        isOk, sshCon = sshUtil.newSshUsingCrntUsrCredential(self.opztMngIp)
        if not isOk or sshCon == None:
            self.logger.info("failed to build connection to remote opposite controller.")
            if not modelManager.enterOpztDebugMode(self.devObj):
                errLog += ("~failed to enter opposite controller's debug mode.\n")
                self.recordCrntModuleStatus(self.devObj["localOpztCtlrLocation"], False, False, errLog)
                self.writeCmdEchos2File(oppositeCtrlrDir, destFileName, errLog)
                return
            self.logger.info("collecting opposite controller's minisystem mode command info...")
            hasFail, hasSuc, echoMsg, errMsg = self.runCommonCmdAndCltEcho()
            errLog += errMsg
            hasFailed, hasSucc, echoMsgs, errMsg = self.runDebugCmdandCltEcho()
            hasFail = hasFail or hasFailed
            hasSuc = hasSuc or hasSucc
            echoMsg += echoMsgs
            errLog += errMsg
            self.recordCrntModuleStatus(self.devObj["localOpztCtlrLocation"], hasSuc, hasFail, errLog)
            self.writeCmdEchos2File(oppositeCtrlrDir, destFileName, echoMsg)
            modelManager.quit2MainCtrlrAdminMode(self.devObj)
        else:
            originSsh = self.devObj["SSH"]
            self.devObj["SSH"] = sshCon
            if not modelManager.changeCli2Debug(self.devObj):
                errLog += ("~failed to enter system's debug mode, quit collection.\n")
                self.recordCrntModuleStatus(self.devObj["localOpztCtlrLocation"], False, False, errLog)
                self.writeCmdEchos2File(oppositeCtrlrDir, destFileName, errLog)
                sshUtil.closeSshConnection(sshCon)
                self.devObj["SSH"] = originSsh
                return
            hasFail, hasSuc, echoMsg, errMsg = self.runCommonCmdAndCltEcho()
            errLog += errMsg
            hasFailed, hasSucc, echoMsgs, errMsg = self.runDebugCmdandCltEcho()
            hasFail = hasFail or hasFailed
            hasSuc = hasSuc or hasSucc
            echoMsg += echoMsgs
            errLog += errMsg
            self.recordCrntModuleStatus(self.devObj["localOpztCtlrLocation"], hasSuc, hasFail, errLog)
            self.writeCmdEchos2File(oppositeCtrlrDir, destFileName, echoMsg)
            modelManager.changeAnyModel2Cli(sshCon)
            sshUtil.closeSshConnection(sshCon)
            self.devObj["SSH"] = originSsh
            return

    def clctCurCtrlrMinisysCmdEcho(self, currentCtrlrDir):
        '''
        @summary: 
        '''
        errLog = "/********minisystem information error********/\n"
        destFileName = dataConstants.MINISYSTEM_CMD_ECHO_DESTINATION
        errorOccurred = False
        if not modelManager.changeCli2Developer(self.devObj):
            errLog += ("~failed to enter system's developer mode, quit collection.\n")
            errorOccurred = True
        if not errorOccurred and not modelManager.changeDeveloper2Minisystem(self.devObj):
            errLog += ("~failed to enter system's minisystem mode, quit collection.\n")
        if errorOccurred:
            modelManager.changeAnyModel2Cli(self.devObj["SSH"], self.devObj["SFTP"])
            self.recordCrntModuleStatus(self.devObj["localMainCtlrLocation"], False, False, errLog)
            self.writeCmdEchos2File(currentCtrlrDir, destFileName, " ")
            return
        self.doMinisystemCmdEchoCollect(currentCtrlrDir, True)
        self.logger.info("done collection minisystem mode command echo...")
        modelManager.changeAnyModel2Cli(self.devObj["SSH"], self.devObj["SFTP"])
        return

    def clctOpztCtrlrMinisysCmdEcho(self, oppositeCtrlrDir):
        '''
        @summary: 
        '''
        if not self.opztMngIp:
            return
        errLog = "/********mini-system information error********/\n"
        destFileName = dataConstants.MINISYSTEM_CMD_ECHO_DESTINATION
        sshUtil = SSHToolUtils(self.devObj, self.logger)
        isOk, sshCon = sshUtil.newSshUsingCrntUsrCredential(self.opztMngIp)
        if not isOk or sshCon == None:
            self.logger.info("failed to build connection to remote opposite controller.")
            if not modelManager.enterOpzMinisystemMode(self.devObj):
                errLog += ("~failed to enter oppsite controller's minisystem mode.\n")
                self.recordCrntModuleStatus(self.devObj["localOpztCtlrLocation"], False, False, errLog)
                self.writeCmdEchos2File(oppositeCtrlrDir, destFileName, " ")
                return
            self.logger.info("collecting opposite controller's minisystem mode command info...")
            self.doMinisystemCmdEchoCollect(oppositeCtrlrDir, False)
            modelManager.quit2MainCtrlrAdminMode(self.devObj)
            return
        else:
            originSsh = self.devObj["SSH"]
            self.devObj["SSH"] = sshCon
            errorOccurred = False
            if not modelManager.changeCli2Developer(self.devObj):
                errLog += ("~failed to enter system's developer mode, quit collection.\n")
                errorOccurred = True
            if not errorOccurred and not modelManager.changeDeveloper2Minisystem(self.devObj):
                errLog += ("~failed to enter system's minisystem mode, quit collection.\n")
            if errorOccurred:
                modelManager.changeAnyModel2Cli(self.devObj["SSH"], self.devObj["SFTP"])
                self.recordCrntModuleStatus(self.devObj["localOpztCtlrLocation"], False, False, errLog)
                self.writeCmdEchos2File(oppositeCtrlrDir, destFileName, " ")
                sshUtil.closeSshConnection(sshCon)
                self.devObj["SSH"] = originSsh
                return
            self.doMinisystemCmdEchoCollect(oppositeCtrlrDir, False)
            modelManager.changeAnyModel2Cli(sshCon)
            sshUtil.closeSshConnection(sshCon)
            self.devObj["SSH"] = originSsh
            return

    def doMinisystemCmdEchoCollect(self, fileLocation, isCrntctrlr):
        '''
        @summary: collect current controller's minisystem information
        @param fileLocation:location where current destination file locates in
        '''
        hasFailed = False
        hasSucceeded = False
        echoMsgs = " "
        errLog = "/********minisystem information error********/\n"
        ctrlrBaseDir = self.devObj["localMainCtlrLocation"] if isCrntctrlr else self.devObj["localOpztCtlrLocation"]
        destFileName = dataConstants.MINISYSTEM_CMD_ECHO_DESTINATION

        #common file do not need to collect on both controller:
        hasFail, hasSuc, echoMsg, errMsg = self.runMinisystemCmdAndCltEcho()
        hasFailed = hasFailed or hasFail
        hasSucceeded = hasSucceeded or hasSuc
        echoMsgs += echoMsg
        errLog += errMsg
        hasFail, hasSuc, echoMsg, errMsg = self.runCommonCmdAndCltEcho(True)
        hasFailed = hasFailed or hasFail
        hasSucceeded = hasSucceeded or hasSuc
        echoMsgs += echoMsg
        errLog += errMsg
        self.writeCmdEchos2File(fileLocation, destFileName, echoMsgs)
        self.recordCrntModuleStatus(ctrlrBaseDir, hasSucceeded, hasFailed, errLog)



    def runMinisystemCmdAndCltEcho(self):
        '''
        @summary: collect minisystem mode command 
        @return: hasFailed, hasSucceeded, echoMsgs, errLog
        '''
        echoMsgs = " "
        errLog = ""
        hasFailed = False
        hasSucceeded = False
        try:
            for collectItem in dataConstants.COMMON_MINISYSTEM_CMD_LIST:
                isSuccess, cmdEcho = util.executeCmdWithTimeout(self.devObj, collectItem)
                if not isSuccess:
                    hasFailed = True
                    errLog += ("~failed to execute command %s : %s\n" % (collectItem, str(cmdEcho)))
                else:
                    hasSucceeded = True
                echoMsgs += ("\nRunning command:>%s\n" % str(cmdEcho))
        except BaseException, excp:
            self.logger.info("exception occurred while processing command on minisystem specified commands; %s." \
                             % str(excp))

        return hasFailed, hasSucceeded, echoMsgs, errLog

    def runCommonCmdAndCltEcho(self, isMinisys = False):
        '''
        @summary: collect command echo
        @return: string 
        '''
        echoMsgs = " "
        errLog = ""
        hasFailed = False
        hasSucceeded = False
        try:
            for cmd in [dataConstants.DEBUG_CMD_MOUNT, dataConstants.DEBUG_CMD_IFCONFIG]:
                isSuccess, cmdEcho = util.executeCmdWithTimeout(self.devObj, cmd)
                if not isSuccess:
                    errLog += ("~failed to execute command %s : %s\n" % (cmd, str(cmdEcho)))
                    hasFailed = True
                else:
                    hasSucceeded = True
                echoMsgs += ("\nRunning command:>%s\n" % str(cmdEcho))
            needLoopCmds = [dataConstants.DEBUG_CMD_CPU, dataConstants.DEBUG_CMD_MEM_INFO[0]]
            for cmd in needLoopCmds:
                for times in ["first", "second", "third", "fourth", "fifth"]:
                    isSuccess, cmdEcho = util.executeCmdWithTimeout(self.devObj, cmd)
                    sleep(1)
                    if not isSuccess:
                        errLog += ("~failed to execute command %s for the %s time:%s.\n" % (cmd, times, cmdEcho))
                        hasFailed = True
                    echoMsgs += ("\nRunning command for the %s time:>%s\n" % (times, str(cmdEcho)))

            cmd = dataConstants.DEBUG_CMD_MEM_INFO[1]
            isSuccess, cmdEcho = util.executeCmdWithTimeout(self.devObj, cmd)
            if not isSuccess or "error:" in cmdEcho.lower():
                errLog += ("~failed to execute command %s -M: %s\n" % (cmd, str(cmdEcho)))
                hasFailed = True
            else:
                hasSucceeded = True
            echoMsgs += ("\nRunning command with M parameter:> %s \n" % str(cmdEcho))
            if not isMinisys:
                memRetParams = self.runDirInfoAndCltEcho(dataConstants.DEBUG_CMD_MEM_DIR)
                lftpRetParams = self.runDirInfoAndCltEcho(dataConstants.DEBUG_CMD_LFTP_INFO)
                hasSucceeded = hasSucceeded or memRetParams[0] or lftpRetParams[0]
                hasFailed = hasFailed or memRetParams[1] or lftpRetParams[1]
                echoMsgs += (memRetParams[2] + lftpRetParams[2])
                errLog += (memRetParams[3] + lftpRetParams[3])
        except BaseException, excp:
            self.logger.info("try to collect information in minisystem but failed to execute: %s" % str(excp))

        return hasFailed, hasSucceeded, echoMsgs, errLog

    def runDirInfoAndCltEcho(self, cmds):
        '''
        @summary: enter directory and collect directory information
        @param cmds: command list
        @return:  hasSucceeded, hasFailed, echoMsgs, errLog
        '''
        echoMsgs = " "
        errLog = ""
        hasFailed = False
        hasSucceeded = False
        cmd = cmds[0]
        isSuccess, cmdEcho = util.executeCmdWithTimeout(self.devObj, cmd)
        if not isSuccess or "error:" in cmdEcho.lower() or "permission denied" in cmdEcho.lower():
            errLog += ("~failed to execute command %s: %s\n" % (cmd, str(cmdEcho)))
            hasFailed = True
            echoMsgs += ("\nRunning command:> %s \n" % str(cmdEcho))
        else:
            echoMsgs += ("\nRunning command:> %s \n" % str(cmdEcho))
            hasSucceeded = True
            cmd = cmds[1]
            isSuccess, cmdEcho = util.executeCmdWithTimeout(self.devObj, cmd)
            if isSuccess:
                hasSucceeded = True
            else:
                errLog += ("~failed to execute command %s: %s\n" % (cmd, str(cmdEcho)))
                hasFailed = True
            echoMsgs += ("\nRunning command:> %s \n" % str(cmdEcho))
        return hasSucceeded, hasFailed, echoMsgs, errLog

    def runDebugCmdandCltEcho(self):
        '''
        @summary: specified debug mode collection command
        '''
        echoMsgs = " "
        errLog = ""
        hasFailed = False
        hasSucceeded = False
        for cmd in [dataConstants.DEBUG_CMD_OS_CLI, dataConstants.DEBUG_CMD_OS_EXPORT]:
            isSuccess, cmdEcho = util.executeCmdWithTimeout(self.devObj, cmd)
            if not isSuccess:
                errLog += ("~failed to execute command %s : %s\n" % (cmd, str(cmdEcho)))
                hasFailed = True
            else:
                hasSucceeded = True
            echoMsgs += ("\nRunning command:> %s\n" % str(cmdEcho))

        return hasFailed, hasSucceeded, echoMsgs, errLog

    def recordCrntModuleStatus(self, recordDir, hasSucceeded, hasFailed, errLog):
        '''
        @summary: write into info.txt to record current item status
        '''
        result = ""
        if hasFailed and hasSucceeded:
            result = dataConstants.IS_COLLECT_ITEM_PARTLY_SUCCESS
        elif hasFailed:
            result = dataConstants.IS_COLLECT_ITEM_FAILED
        else:
            result = dataConstants.IS_COLLECT_ITEM_SUCCESS

        self.resultRecorder.recordCrntModuleStatus(recordDir, self.collectItem, result, errLog)
