# -*- coding: UTF-8 -*-

import re

UNSUPPORT_VERSION_LIST = ["V200R001C00SPC100",\
                        "V200R001C00SPC200",\
                        "V200R001C00SPC300",\
                        "V200R001C00SPC400",\
                        "V200R001C00SPC500",\
                        "V200R001C00SPC600",\
                        "V200R001C00SPC700"]

# **************************************************************************** #
# 函数名称: switchValidVersion
# 功能说明: 将版本号转化成有效的版本号（17位：V200R001C00SPC100 或者11位：V200R001C00）
# 输入参数: version
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def switchValidVersion(version):
    temp = ""
    
    startIndex = version.index("V200")
    if re.search("SPC", version, re.IGNORECASE):
        endIndex = startIndex + 17  #格式：V200R001C00SPC100
    else:
        endIndex = startIndex + 11  #格式：V200R001C00
    
    #提取有效的版本号信息
    temp = version[startIndex: endIndex]
    
    return temp

# *************************************************************#
# 函数名称: execute
# 功能说明: 查询工具是否支持此版本
# 其 他   :  无
# *************************************************************#
def execute(dataDict):

    dev = dataDict.get("dev")
    deviceType = dev.getDeviceType()
    systemVersion = dev.getProductVersion()
    
    #规范系统SPC版本号
    systemVersion = switchValidVersion(systemVersion)
    #获取SPC版本号字段
    spcVersion = systemVersion[-6:]

    #版本号长度不足，返回错误
    if len(systemVersion) != 17:
        return False    
    #查看是否在不支持版本列表中
    elif systemVersion in UNSUPPORT_VERSION_LIST:
        return False
    else:
        return True