﻿# -*- coding: UTF-8 -*-

from java.io import File
import time
import traceback
import modelManager
import shutil
import os
from com.huawei.ism.tool.infocollect.service import DealFileInCopressPackage
from cbb.frame.util import public_ip_address_utils

G_RETRY_TIMES = 5

def get_product_pro(devObj,type):
    try:
        ssh = devObj.get("SSH")
        strCmd = "show system general"
        product_model="S5000T"
        product_sn = " 210235G"
        cliRet = ssh.execCmd(strCmd)
        list = cliRet.splitlines()
        for field in list:
            if type == "product_model":
                field = field.replace(" ", "")
                if field.find("ProductModel") != -1:
                    field = field.replace("ProductModel:", "")
                    product_model = field
                    return product_model
            if type == "product_sn":
                if field.find("SN") != -1:
                    field = field.replace(" ","")
                    field = field.replace("SN:", "")
                    product_sn = field
                    return product_sn
        return "default"
    except Exception, e:
        PY_LOGGER.error("[compress] get_product_pro catch except:"+str(e))
        result = "default"
        return result


# **************************************************************************** #
# 函数名称: getDevIpList
# 功能说明: 获取阵列IP地址列表
# 输入参数: devObj
# 输出参数: 阵列IP地址列表
# **************************************************************************** #
def getDevIpList(devObj):
    ipList = []
    ssh = devObj.get("SSH")
    
    masterIp = modelManager.getMasterIp(ssh)
    PY_LOGGER.info("[compress] [compress] Get master ip address is:"+masterIp)
    if "--" !=masterIp:
        ipList.append(masterIp+"_MAIN")
        
        devIpList = modelManager.getIpList(ssh)
        for ipInfo in devIpList:
            if masterIp != ipInfo:
                PY_LOGGER.info("[compress] [compress] Insert ip address is:"+ipInfo)
                ipList.append(ipInfo)
                
    # ，IP地址因异常获取失败，则强制设置默认IP地址，防止压缩文件内容为空，2013/12/14，Modified Begin
    if 0 == len(ipList):
        PY_LOGGER.info("[compress] [compress] Get null ip address")
        ipList.append(
            public_ip_address_utils.get_default_ip_by_126_100() + "_MAIN")
        ipList.append(public_ip_address_utils.get_default_ip_by_127_101())
    # ，IP地址因异常获取失败，则强制设置默认IP地址，防止压缩文件内容为空，2013/12/14，Modified End
    return ipList

def get_product_date():
    try:
        result = str(time.strftime('%Y%m%d%H%M%S',time.localtime(time.time())))
        return result
    except Exception, e:
        PY_LOGGER.error("[compress] catch except when get current time.~~~over!"+str(e))
        result = "20120512150000"
        return result

def write_version_file(devObj, strCmd):
    try:
        flag = True
        localDir = devObj.get("collectRetDir")+os.path.sep +"temp"+os.path.sep
        if True != os.path.exists(localDir):
            os.mkdir(localDir)
        f = open(localDir+os.path.sep+"DataCollect"+os.path.sep+"version", "w")
        
        f.write(strCmd)
        f.close()
        return flag
    except:
        flag = False
        PY_LOGGER.info("[compress] catch except when write elable info to file.")
        return flag

def adjustSingleExportFile(devObj):
    try:
        localDir = devObj.get("collectRetDir")+os.path.sep+"temp"+os.path.sep
        curCtrlId = "default"
        masterCtrlId = "default"
        list_file = os.listdir(localDir)
        list_controller = getDevIpList(devObj)
        
        for field in list_controller:
            if os.path.exists(localDir+os.path.sep+"DataCollect") == False:
                os.mkdir(localDir+os.path.sep+"DataCollect")
            if os.path.exists(localDir+os.path.sep+"DataCollect"+os.path.sep+field) == False:
                os.mkdir(localDir+os.path.sep+"DataCollect"+os.path.sep+field)
            if os.path.exists(localDir+os.path.sep+"DataCollect"+os.path.sep+field+os.path.sep+"Event") == False:
                os.mkdir(localDir+os.path.sep+"DataCollect"+os.path.sep+field+os.path.sep+"Event")
            if os.path.exists(localDir+os.path.sep+"DataCollect"+os.path.sep+field+os.path.sep+"Config") == False:
                os.mkdir(localDir+os.path.sep+"DataCollect"+os.path.sep+field+os.path.sep+"Config")
            if os.path.exists(localDir+os.path.sep+"DataCollect"+os.path.sep+field+os.path.sep+"Other") == False:
                os.mkdir(localDir+os.path.sep+"DataCollect"+os.path.sep+field+os.path.sep+"Other")
            for field_file in list_file:
                if field_file == "event_export.tar":
                    shutil.copy(localDir+field_file, localDir+os.path.sep+"DataCollect"+os.path.sep+field+os.path.sep+"Event"+os.path.sep)
                    continue
                if field_file == "Config.txt":
                    shutil.copy(localDir+field_file, localDir+os.path.sep+"DataCollect"+os.path.sep+field+os.path.sep+"Config"+os.path.sep)
                    continue
                if field_file == "disksmartinfo":
                    shutil.move(localDir+field_file, localDir+os.path.sep+"DataCollect"+os.path.sep+"disksmartinfo")
                    continue
                if field_file == "poolCkInfo":
                    shutil.move(localDir+field_file, localDir+os.path.sep+"DataCollect"+os.path.sep+"poolCkInfo")
                    continue
                try:
                    shutil.copy(localDir+field_file, localDir+os.path.sep+"DataCollect"+os.path.sep+field+os.path.sep+"Other"+os.path.sep)
                except Exception,exception:
                    PY_LOGGER.error("[compress] catch except when copy file:"+str(exception))
                    continue

        flag = write_version_file(devObj, "S5000TV200R001")
        if flag == False:
            PY_LOGGER.info("[compress] write version file in single mode failed.")

        for field_file in list_file:
            os.remove(localDir+field_file)
            
        return True
    except Exception, exception:
        PY_LOGGER.error("[compress] catch except when adjust single export file")
        PY_LOGGER.error("[compress] except arguement:"+str(exception.args)+"~~~over!")
        PY_LOGGER.error("[compress] except messages:"+str(exception))
        PY_LOGGER.error("[compress] except trace back:"+str(traceback.print_exc()))
        return False


def creatPkginfo(rootPath,devObj):
    '''
    @summary: 创建与datacollect同级的目录pkginfo，用于表示该包是信息收集的包。
        pkginfo下有两个空文件
            type_collect: 信息收集的包
            domain_storage: 存储设备
    '''
    pkginfoPath = rootPath + os.sep + "pkginfo"
    typeFile = pkginfoPath + os.sep + "type_collect"
    domainFile = pkginfoPath + os.sep + "domain_storage"
    descFile = pkginfoPath + os.sep + "desc"
    snFmt = "deviceSN=${%s}\n"
    timeFmt = "fileCreateTime=%s"
    try:
        #如果pkginfo已存在，则需要先删除
        if os.path.exists(pkginfoPath):
            shutil.rmtree(pkginfoPath, True)
            
        os.mkdir(pkginfoPath)
        #先创建type文件，然后拷贝type并重命名为domain文件
        fileObj = open(typeFile, "w")  
        fileObj.close()
        shutil.copy(typeFile, domainFile)
        #创建Desc文件并写入SN号和时间（UTC）
        #获取SN号和时间毫秒数
        snInfo = snFmt % str(getDeviceSn(devObj))
        timeInfo = timeFmt % str(long(time.time()*1000))
        desc_file = open(descFile, "w")
        seq = [snInfo,timeInfo]
        desc_file.writelines(seq)
        desc_file.close()
        PY_LOGGER.info("[creatPkginfo] Creat the pkginfo succeed!")
    
    except:
        if os.path.exists(pkginfoPath):
            shutil.rmtree(pkginfoPath, True)   
        PY_LOGGER.error("[creatPkginfo] Creat the pkginfo failed! except trace back: " + str(traceback.format_exc()))

def getDeviceSn(devObj):
        '''
                    获取设备SN号
        '''
        devNode = devObj.get("devNode")
        
        if None == devNode:
            return ""
        
        sn = devNode.getDeviceSerialNumber()
        
        return sn

def execute(devObj):
    try:
        #初始化清空
        flag_logexist = False
        devObj["py_detail"] = ""
        
        localDir = devObj.get("collectRetDir")+os.path.sep+"temp"+os.path.sep
        localFile_final = os.path.sep+"Datacollect_S5000T_21035000000.tgz"
        tar_class = devObj.get("PYENGINE.PY_ZIP")
        list = os.listdir(localDir)
        
        PY_LOGGER.info("[compress] Local dir is:" + localDir)
        for field in list:
            PY_LOGGER.info("[compress] file name is:"+field)
            if field.find("Datacollect") != -1:
                PY_LOGGER.info("[compress] name is:"+field)
                flag_logexist = True
                if field.find(".tgz") != -1:
                    localFile_final = field.replace(".tgz", ".7z")
                else:
                    localFile_final = field+".7z"   

                    resultRename = False
                    for index in range(0, G_RETRY_TIMES):
                        if resultRename:
                            break
                        else:
                            time.sleep(2)
                        try:
                            resultRename = os.renames(localDir+field, localDir+"DataCollect")
                        except Exception,exception:
                           PY_LOGGER.error("[compress]Rename catch except:"+str(exception))
                           continue

                PY_LOGGER.info("[compress] Final path is:"+localFile_final)
                break
            
        PY_LOGGER.info("[compress] Starting moving file")
        if not flag_logexist:
            adjustSingleExportFile(devObj)
            product_model = get_product_pro(devObj, "product_model")
            product_sn = get_product_pro(devObj, "product_sn")
            product_time = get_product_date()
            localFile_final = "Datacollect_"+product_model+"_"+product_sn+"_"+product_time+".7z"
        else:
            list_file_tempDir = os.listdir(localDir)
            list_file_DatacollectDir = os.listdir(localDir+"DataCollect")
            PY_LOGGER.info("[compress] Data path is:"+localDir+"DataCollect")
            
            for field in list_file_tempDir:
                if field.find("DataCollect") != -1:
                    continue
                if field.find("disksmartinfo") != -1:
                    shutil.move(localDir+field, localDir+os.path.sep+"DataCollect"+os.path.sep+"disksmartinfo")
                    continue
                if field.find("poolCkInfo") != -1:
                    shutil.move(localDir+field, localDir+os.path.sep+"DataCollect"+os.path.sep+"poolCkInfo")
                    continue
                
                for field_temp in list_file_DatacollectDir:
                    if field == "event_export.tar":
                        if os.path.exists(localDir+os.path.sep+"DataCollect"+os.path.sep+field_temp+os.path.sep+"Event"+os.path.sep+field) == False:
                            shutil.copy(localDir+field, localDir+os.path.sep+"DataCollect"+os.path.sep+field_temp+os.path.sep+"Event"+os.path.sep)
                            continue
                    if field == "Config.txt":
                        if os.path.exists(localDir+os.path.sep+"DataCollect"+os.path.sep+field_temp+os.path.sep+"Config"+os.path.sep+field) == False:
                            shutil.copy(localDir+field, localDir+os.path.sep+"DataCollect"+os.path.sep+field_temp+os.path.sep+"Config"+os.path.sep)
                            continue
                    if os.path.exists(localDir+os.path.sep+"DataCollect"+os.path.sep+field_temp+os.path.sep+"Other"+os.path.sep+field) == False:
                        try:
                            shutil.copy(localDir+field, localDir+os.path.sep+"DataCollect"+os.path.sep+field_temp+os.path.sep+"Other"+os.path.sep)
                        except Exception,exception:
                            PY_LOGGER.error("[compress] catch except when copy file:"+str(exception))
                            continue
                
                if os.path.exists(localDir+field):
                    os.remove(localDir+field)
                    
            flag = write_version_file(devObj, "S5000TV200R001")
            if flag == False:
                PY_LOGGER.info("[compress] write version file in regular mode failed.")
        
        #创建pkginfo
        creatPkginfo(localDir,devObj)
        
        #压缩结果文件
        PY_LOGGER.info("[compress] Starting compress file, localFile_final is:"+localFile_final)
        for index in range(0, G_RETRY_TIMES):
            result = True
            PY_LOGGER.info("[compress] start to compress collect info.TIMES:"+str(index))
            try:
                DealFileInCopressPackage.anonymizeTV2(localDir)
                result = tar_class.compressFile(devObj.get("collectRetDir") + os.path.sep + localFile_final, localDir)
            except Exception,exception:
                PY_LOGGER.error("[compress] Compress file catch except:"+str(exception))
                continue
            PY_LOGGER.info("[compress] End to compress collect info. result:"+str(result))
            if result:
                break
            else:
                os.remove(devObj.get("collectRetDir") + os.path.sep + localFile_final)
                time.sleep(2)
                continue
        
        if not result:
            os.remove(devObj.get("collectRetDir") + os.path.sep + localFile_final)
            result (False, "")
            
        CleanDir(localDir)
        devObj["collectRetFileName"] = localFile_final
        return (True, "")
    
    except Exception, exception:
        PY_LOGGER.error("[compress] catch except when compress file.~~~over!")
        PY_LOGGER.error("[compress] except arguement:"+str(exception.args)+"~~~over!")
        PY_LOGGER.error("[compress] except messages:"+str(exception))
        PY_LOGGER.error("[compress] except trace back:"+str(traceback.print_exc()))
        return (False, "")
