﻿# -*- coding: UTF-8 -*-

from java.io import File
import socket
import os
import shutil
import zipfile
import traceback
import tarfile
import time
import re
import threading
import collectSmartInfo
import collectCkInfo
import modelManager
from cbb.frame.util import public_ip_address_utils


G_STRCMD = "export "
G_ITEM_ALM = str("ALM")
G_ITEM_LOG = str("LOG")
G_ITEM_SYS = str("SYSCONFIG")
G_ITEM_DB = str("DB")
G_ITEM_ELABLE = str("ELABLE")
G_ITEM_CLICMD = str("CLICMD")
G_ITEM_SMART = str("SMART")
G_LOG_TIMO = 20*60
G_RETRY_TIMES = 3

PRODUCT_VERSION = "V200R001C00"
CLI_RET_END_FLAG = ":/>"

CLI_EXPORT_CMD_IS_OLD = True

#管理员用户CLI命令没开放的SPC版本号
NOT_SUPPORT_VERSION = ["V200R001C00SPC100","V200R001C00SPC200","V200R001C00SPC300","V200R001C00SPC400",\
                       "V200R001C00SPC500","V200R001C00SPC600","V200R001C00SPC700","V200R001C00SPC800"]

#全局变量，带回出错的详细信息
ERR_MSG = ""

#超级用户权限相对于admin列表可增加的CLI回显收集命令
super_admin_add = ["show security_rule"]

#一般admin用户权限相对于Base列表可增加的CLI回显收集命令
admin_add = [
              "show bond_port",
              "show iscsi target",
              "show isns server_ip",
              "show license",
              "show notification sms",
              "show schedule",
              "show system media_scan"]

#基本CLI命令收集项，适合所有权限的用户
cli_cmd_list_guest = [
               "show bbu general",
               "show clone general",
               "show clone available_lun primary",
               "show consistency_group general",
               "show controller general",
               "show disk general",
               "show disk bad_sector_record",
               "show disk precopy",
               "show disk system",
               "show enclosure",
               "show fan",
               "show host",
               "show initiator",
               "show interface_module",
               "show expansion_module",
               "show iscsi initiator_name",
               "show lun",
               "show lun_copy general",
               "show mapping_view general",
               "show notification trap",
               "show notification syslog",
               "show port general",
               "show power_supply",
               "show remote_device general",
               "show remote_replication general",
               "show smartqos_policy",
               "show snapshot general",
               "show storage_pool general",
               "show storage_pool task",
               "show system general",
               "show system ntp",
               "show system timezone",
               "show upgrade package",
               "show user",
               "show version all",
               "show worm enable",
               "show storage_pool tier",
               "show disk in_pool"]


list_multi_cli_cmd = [
               "show bbu general",
        	   "show clone general",
        	   "show consistency_group general",
        	   "show disk general",
        	   "show enclosure",
               "show fan",
               "show host",
               "show interface_module",
               "show expansion_module",
               "show lun_copy general",
               "show mapping_view general",
               "show power_supply",
               "show remote_replication general",
               "show storage_pool tier|show storage_pool general",
               "show disk in_pool|show storage_pool general"]


list_elable_cmd = ["show controller general",
                   "show bbu general",
                   "show fan",
                   "show interface_module",
                   "show expansion_module"]
list_elable_property = ["Devive",
                        "BBU",
                        "FAN",
                        "INTERFACE_MODULE",
                        "EXPANSION_MODULE"]
list_multi_elable_cmd = ["show bbu general",
                  "show fan",
                  "show interface_module",
                  "show expansion_module"]

CLI_EXEC_FAILED ="Error:"

# 错误码没有详细的提示信息，增加处理函数设置各种已知错误的可能发生场景，2013/11/08 modified Begin
#CLI收集成功时的标志
CLI_EXEC_SUCCESS_TAG =[ 
    "Error: Ftp put file failed",
    "Error: sftp put file failed",
    "Error: Collection succeeded but the ftp put file failed",
    "Error: Collection succeeded but the sftp put file failed",
    "Command executed successfully.",
    "Collection succeeded and the command was successfully executed",
    "Error: Part of information was successfully collected but the ftp put file failed",
    "Error: Part of information was successfully collected but the sftp put file failed",
    "Part of infomration was successfully collected and the command was successfully executed",
    "File Path"
]

#针对捕捉到回显信息，判断当前回显是否正常
dictMsg = [
{"key_word":"The system is busy. Please try again later",
 "msg_zh":u"\n失败可能原因及处理：\
        \n（1）系统繁忙，可能正在运行其它收集命令；\
        \n（2）两次信息收集间隔时间太短（小于5分钟）；\
        \n（3）具体原因及处理请联系技术支持工程师。",
 "msg_en":u"\nThe reason of failure and how to handle:\
        \n（1）System is busy, may be run the same collect command;\
        \n（2）It is too short time (less than 5 minutes) between two operation to collect;\
        \n（3）Please contact technical support engineers for further handling."},   
{"key_word":"The device memory is not enough",
 "msg_zh":u"\n失败可能原因及处理：\
        \n（1）设备内存不足；\
        \n（2）具体原因及处理请联系技术支持工程师。",
 "msg_en":u"\nThe reason of failure and how to handle:\
        \n（1）The device memory is not enough;\
        \n（2）Please contact technical support engineers for further handling."},   
{"key_word":"Socket connect failed",
 "msg_zh":u"\n失败可能原因及处理：\
        \n（1）Socket连接失败；\
        \n（2）具体原因及处理请联系技术支持工程师。",
 "msg_en":u"\nThe reason of failure and how to handle:\
        \n（1）Socket connect failed;\
        \n（2）Please contact technical support engineers for further handling."},      
{"key_word":"Receive message time out",
 "msg_zh":u"\n失败可能原因及处理：\
        \n（1）信息查询超时；\
        \n（2）具体原因及处理请联系技术支持工程师。",
 "msg_en":u"\nThe reason of failure and how to handle:\
        \n（1）Receive message time out;\
        \n（2）Please contact technical support engineers for further handling."},
{"key_word":"-bash:",
 "msg_zh":u"\n失败可能原因及处理：\
        \n（1）系统模式错误；\
        \n（2）具体原因及处理请联系技术支持工程师。",
 "msg_en":u"\nThe reason of failure and how to handle:\
        \n（1）System is not in the right Model;\
        \n（2）Please contact technical support engineers for further handling."},      
{"key_word":"Storage:",
 "msg_zh":u"\n失败可能原因及处理：\
        \n（1）系统模式错误；\
        \n（2）具体原因及处理请联系技术支持工程师。",
 "msg_en":u"\nThe reason of failure and how to handle:\
        \n（1）System is not in the right Model;\
        \n（2）Please contact technical support engineers for further handling."},            
{"key_word":"minisystem",
 "msg_zh":u"\n失败可能原因及处理：\
        \n（1）系统模式错误；\
        \n（2）具体原因及处理请联系技术支持工程师。",
 "msg_en":u"\nThe reason of failure and how to handle:\
        \n（1）System is not in the right Model;\
        \n（2）Please contact technical support engineers for further handling."},                 
{"key_word":"upgrade",
 "msg_zh":u"\n失败可能原因及处理：\
        \n（1）系统模式错误，处于升级模式；\
        \n（2）具体原因及处理请联系技术支持工程师。",
 "msg_en":u"\nThe reason of failure and how to handle:\
        \n（1）System is not in the right Model, it is in upgrade Mode;\
        \n（2）Please contact technical support engineers for further handling."},           
{"key_word":"The system is powering off",
 "msg_zh":u"\n失败可能原因及处理：\
        \n（1）系统不正常，处于下电模式；\
        \n（2）具体原因及处理请联系技术支持工程师。",
 "msg_en":u"\nThe reason of failure and how to handle:\
        \n（1）System is abnormal, it is in powering off Mode;\
        \n（2）Please contact technical support engineers for further handling."},
{"key_word":"Unknown error 6",
 "msg_zh":u"\n失败可能原因及处理：\
        \n（1）本地硬盘空间不足导致FTP传输失败；\
        \n（2）链路闪断导致FTP传输失败；\
        \n（3）远程设备文件不存在导致FTP传输失败；\
        \n（4）具体原因及处理请联系技术支持工程师。",
 "msg_en":u"\nThe reason of failure and how to handle:\
        \n（1）Disk have not enough space leading FTP transfer failed;\
        \n（2）Connect unstable leading FTP transfer failed;\
        \n（3）Storage device file did not exist leading FTP transfer failed;\
        \n（4）Please contact technical support engineers for further handling."},
{"key_word":"The user does not have the permission",
 "msg_zh":u"\n失败可能原因及处理：\
        \n（1）用户权限不够，无法执行此收集命令；\
        \n（2）具体原因及处理请联系技术支持工程师。",
 "msg_en":u"\nThe reason of failure and how to handle:\
        \n（1）The login user had low-privileged, it can't collect this information;\
        \n（2）Please contact technical support engineers for further handling."} ,
{"key_word":"The user account has been locked",
 "msg_zh":u"\n失败可能原因及处理：\
        \n（1）用户账号被锁定；\
        \n（2）具体原因及处理请联系技术支持工程师。",
 "msg_en":u"\nThe reason of failure and how to handle:\
        \n（1）The user account has been locked;\
        \n（2）Please contact technical support engineers for further handling."},
{"key_word":"Receive message failed",
 "msg_zh":u"\n失败可能原因及处理：\
        \n（1） 收集信息失败；\
        \n（2）具体原因及处理请联系技术支持工程师。",
 "msg_en":u"\nThe reason of failure and how to handle:\
        \n（1）Receive message failed;\
        \n（2）Please contact technical support engineers for further handling."},
{"key_word":"Unknown error",
 "msg_zh":u"\n失败可能原因及处理：\
        \n（1）未知错误，导出日志信息报错；\
        \n（2）具体原因及处理请联系技术支持工程师。",
 "msg_en":u"\nThe reason of failure and how to handle:\
        \n（1）Unknown error, export information failed;\
        \n（2）Please contact technical support engineers for further handling."},
{"key_word":"\^",
 "msg_zh":u"\n失败可能原因及处理：\
        \n（1）用户权限不够，无法执行此收集命令；\
        \n（2）当前系统不支持此命令；\
        \n（3）具体原因及处理请联系技术支持工程师。",
 "msg_en":u"\nThe reason of failure and how to handle:\
        \n（1）The login user had low-privileged, it can't collect this information;\
        \n（2）Current version can't support this cli command;\
        \n（3）Please contact technical support engineers for further handling."}]
# 错误码没有详细的提示信息，增加处理函数设置各种已知错误的可能发生场景，2013/11/08 modified End

# 阵列收集的日志压缩文件有损坏的压缩包，导致CloudService进行信息收集失败，工具跳过规避处理，2013/11/19  modified Begin
ERR_MSG_TAIL_ZH = u"\n失败可能原因及处理：\
    \n（1）阵列日志分区已满，导致有些日志包压缩失败，请及时清理阵列日志空间；\
    \n（2）具体原因及处理请联系技术支持工程师。"
ERR_MSG_TAIL_EN = u"\nThe reason of failure and how to handle:\
    \n(1) Some log was compressed failed because of the log partition of storage is full, please release enough space;\
    \n(2) Please contact technical support engineers for further handling."
# 阵列收集的日志压缩文件有损坏的压缩包，导致CloudService进行信息收集失败，工具跳过规避处理，2013/11/19  modified End

myaddr = public_ip_address_utils.get_export_config_used_ip()


class AsynProgressExecuteCmd(threading.Thread):
    """
    异步执行命令的线程
    目的用于异步执行命令，保持长连接
    """
    def __init__(self, devObj, LOGGER, cmd="show system general"):
        threading.Thread.__init__(self)
        self.stopFlg = False
        self.LOGGER = LOGGER
        self.cmd = cmd
        self.ssh = devObj.get("SSH")
        self.devObj = devObj
        self.timeout = 60*60*2

    def run(self):
        try:
            self.LOGGER.info("start execute AsynProgressExecuteCmd cmd[%s]." % self.cmd)
            while not self.stopFlg and self.timeout > 0:
                ret = self.ssh.execCmdWithTimout(self.cmd, 10)
                time.sleep(30)
                self.timeout -= 30
                self.LOGGER.info("execute timeout[%s], cmd[%s], ret:[%s]." % (self.timeout, self.cmd, str(ret)))
        except:
            self.LOGGER.error(str(traceback.format_exc()))

    def setStopFlag(self, stopFlag):
        self.stopFlg = stopFlag
        self.LOGGER.info("setStopFlag execute cmd[%s], timeout[%s], stopFlag:%s" % (self.timeout, self.cmd, stopFlag))


def func_fail_after_download(devObj, step):
    try:
        tar_class = devObj.get("PYENGINE.PY_ZIP")
        PY_LOGGER.info("[module] handle failed. error code is "+step)
        if step == "step11":
            os.renames(devObj.get("collectRetDir") + os.path.sep + "temp" + os.path.sep + devObj["collectRetFileName"].replace(".tgz", ""), devObj.get("collectRetDir") + os.path.sep + "temp" + os.path.sep +"DataCollect")
            write_version_file(devObj, "S5000TV200R001")
            tar_class.compressFile(devObj.get("collectRetDir") + os.path.sep + devObj["collectRetFileName"].replace(".tgz", ".7z"), devObj.get("collectRetDir") + os.path.sep + "temp")
            CleanDir(devObj.get("collectRetDir") + os.path.sep + "temp")
        return False
    except:
        return False

def write_version_file(devObj, strCmd):
    try:
        flag = True
        localDir = devObj.get("collectRetDir")+ os.path.sep + "temp" + os.path.sep
        if True != os.path.exists(localDir):
            os.mkdir(localDir)
        f = open(localDir+ os.path.sep + "DataCollect" + os.path.sep + "version", "w")
        
        f.write(strCmd)
        f.close()
        return flag
    except:
        flag = False
        PY_LOGGER.info("[module] catch except when write elable info to file.")
        return flag

def adjust_log_messages(devObj, localDir_fourth_message):
    lang = devObj.get("lang")
    global ERR_MSG
    try:
        if os.path.exists(localDir_fourth_message) == False:
            PY_LOGGER.info("[module] has no "+localDir_fourth_message)
            return False

        sufix = ""
        tar_class = devObj.get("PYENGINE.PY_ZIP")
        result = False
        newName_log = ""

        list1 = os.listdir(localDir_fourth_message)
        for field in list1:
            if field.find("cur_debug_mem") != -1:
                sufix = ""
            if field.find("his_tar") != -1:
                sufix = field.replace(".tgz", "").replace("his_tar_","")
            if field.find("message") != -1:
                sufix = "message"
            if field.find("tgz") == -1 and field.find("tar.gz") == -1 and field.find("tar.bz2") == -1 and field.find("zip") == -1:
                if os.path.isfile(localDir_fourth_message+os.path.sep+field):
                    continue
                list4 = os.listdir(localDir_fourth_message+os.path.sep+field)
                for field_file in list4:
                    try:
                        shutil.copy(localDir_fourth_message+os.path.sep+field+os.path.sep+field_file, localDir_fourth_message)
                    except Exception,exception:
                        PY_LOGGER.error("[module] except reason when copy file:"+str(exception))
                        continue
                    os.remove(localDir_fourth_message+os.path.sep+field+os.path.sep+field_file)
                continue

            localDir_fourth_message_temp = localDir_fourth_message + os.path.sep + "temp" + os.path.sep
            if os.path.exists(localDir_fourth_message_temp) == False:
                os.mkdir(localDir_fourth_message_temp)
                
            # ，阵列收集的日志压缩文件有损坏的压缩包，导致CloudService进行信息收集失败，工具跳过规避处理，2013/10/26  modified Begin
            result = True
            for index in range(0, G_RETRY_TIMES):
                PY_LOGGER.info("[module] start to decompress tar.gz file.time:"+str(index))
                try:
                    result = tar_class.decompressTarGzFile(localDir_fourth_message+os.path.sep+field, localDir_fourth_message_temp)
                    PY_LOGGER.info("[module] end to decompress tar.gz file.result is:"+str(result))
                except Exception,exception:
                    PY_LOGGER.error("[module] except reason when decompress file, exception:"+str(exception))
                    continue
                if result == True:
                    break
                else:
                    time.sleep(2)
                    continue
            if not result:
                devObj["collectAllInfo"] = False
                splitWord = "\\"
                fileName = localDir_fourth_message+os.path.sep+field.split(splitWord)[-1]
                if "zh"==lang:
                    ERR_MSG += u"解压["+fileName+u"]失败\n"
                    ERR_MSG = ERR_MSG.replace(ERR_MSG_TAIL_ZH,"")
                    ERR_MSG += ERR_MSG_TAIL_ZH
                else:
                    ERR_MSG += "Decompress ["+fileName+"] failed\n"
                    ERR_MSG = ERR_MSG.replace(ERR_MSG_TAIL_EN,"")
                    ERR_MSG += ERR_MSG_TAIL_EN
                devObj["py_detail"] = ERR_MSG
                failDecompressLogDir = localDir_fourth_message+os.path.sep+"failDecompressLog"
                if not os.path.exists(failDecompressLogDir):
                    PY_LOGGER.info("[module] Make dir:" +failDecompressLogDir)
                    os.mkdir(failDecompressLogDir)
                shutil.copy(localDir_fourth_message+os.path.sep+field,failDecompressLogDir+os.path.sep+field)
                PY_LOGGER.info("[module] Decompress failed file:" + failDecompressLogDir+os.path.sep+field)       
            # ，阵列收集的日志压缩文件有损坏的压缩包，导致CloudService进行信息收集失败，工具跳过规避处理，2013/10/26  modified End

            list2 = os.listdir(localDir_fourth_message_temp)
            for field_imp in list2:
                if os.path.isfile(localDir_fourth_message_temp+field_imp):
                    try:
                        shutil.copy(localDir_fourth_message_temp+field_imp, localDir_fourth_message)
                    except Exception,exception:
                        PY_LOGGER.error("[module] except reason when copy file:"+str(exception))
                        continue
                    os.remove(localDir_fourth_message_temp+field_imp)
                    continue
                list3 = os.listdir(localDir_fourth_message_temp+field_imp)
                for field_temp in list3:
                    if field_temp.find(".log") != -1:
                        newName_log = field_temp.replace(".log", sufix+".log")
                    elif field_temp.find(".txt") != -1:
                        newName_log = field_temp.replace(".txt", sufix+".txt")
                    else:
                        newName_log = field_temp+sufix

                    try:
                        os.renames(localDir_fourth_message_temp+os.path.sep+field_imp+os.path.sep+field_temp, localDir_fourth_message_temp+os.path.sep+field_imp+os.path.sep+newName_log)
                        shutil.copy(localDir_fourth_message_temp+os.path.sep+field_imp+os.path.sep+newName_log, localDir_fourth_message)
                    except Exception,exception:
                        PY_LOGGER.error("[module] except reason when copy file:"+str(exception))
                        continue
                    os.remove(localDir_fourth_message_temp+os.path.sep+field_imp+os.path.sep+newName_log)
            CleanDir(localDir_fourth_message_temp)
            os.remove(localDir_fourth_message+os.path.sep+field)
        return True
    except Exception,exception:
        PY_LOGGER.error("[module] catch except when adjust log file over!")
        PY_LOGGER.error("[module] except arguement:"+str(exception.args)+"~~~over!")
        PY_LOGGER.error("[module] except messages:"+str(exception))
        PY_LOGGER.error("[module] except trace back:"+str(traceback.print_exc()))
        return False
        

def adjust_log_other(devObj, localDir_fourth_other):
    try:
        return True
    except:
        PY_LOGGER.info("[module] catch except when adjust log file over!")
        return False

def adjust_log_file(devObj, localDir_third):
    try:
        passwd = devObj.get("decomp_pwd_new")	
        PY_LOGGER.info("[module] start to adjust log file:"+localDir_third)
        if os.path.exists(localDir_third+os.path.sep+"msg_other.zip") != True:
            PY_LOGGER.info("[module] have no log zip file, exit it.")
            return True
        localDir_fourth_message = localDir_third + os.path.sep + "Messages"
        localDir_fourth_other = localDir_third + os.path.sep + "Other"
        tar_class = devObj.get("PYENGINE.PY_ZIP")

        for index in range(0, G_RETRY_TIMES):
            PY_LOGGER.info("[module] decompress with password start~~.time:"+str(index))
            result = True
            try:
                result = tar_class.decompressZipFile(localDir_third+os.path.sep+"msg_other.zip", localDir_third, str(passwd))
            except Exception,exception:
                PY_LOGGER.error("[module] except reason:"+str(exception))
                continue
            PY_LOGGER.info("[module] decompress with password end~~, result is:"+str(result))
            if result == True:
                break
            else:
                if os.path.exists(localDir_third+os.path.sep+"msg_other.tar.bz2") == True:
                    os.remove(localDir_third+os.path.sep+"msg_other.tar.bz2")
                time.sleep(2)
                continue

        if result == False:
            return False
        if os.path.exists(localDir_third+"msg_other.tar.bz2") != True:
            step = "step5"
            func_fail_after_download(devObj, step)
            return False

        for index in range(0, G_RETRY_TIMES):
            PY_LOGGER.info("[module] decompress with msg other.bz2 start~~.time:"+str(index))
            result = True
            try:
                result = tar_class.decompressTarBz2File(localDir_third+os.path.sep+"msg_other.tar.bz2", localDir_third)
            except Exception,exception:
                PY_LOGGER.error("[module] except reason:"+str(exception))
                continue
            PY_LOGGER.info("[module] decompress with msg other.bz2 end~~, result is:"+str(result))
            if result == True:
                break
            else:
                time.sleep(2)
                continue
        if result == False:
            return False
        
        if os.path.exists(localDir_fourth_message) != True:
            step = "step7"
            func_fail_after_download(devObj, step)
            return False
        if os.path.exists(localDir_fourth_other) != True:
            step = "step8"
            func_fail_after_download(devObj, step)
            return False
        PY_LOGGER.info("[module] Adjust log messages [" + localDir_fourth_message +"] starting")
        result = adjust_log_messages(devObj, localDir_fourth_message)
        PY_LOGGER.info("[module] Adjust log messages ["+ localDir_fourth_message + "] end")
        if result == False:
            step = "step9"
            func_fail_after_download(devObj, step)
            return False
        result = adjust_log_other(devObj, localDir_fourth_other)
        if result == False:
            step = "step9"
            func_fail_after_download(devObj, step)
            return False
        PY_LOGGER.info("[module] del msg_other.zip start~~")
        os.remove(localDir_third+os.path.sep+"msg_other.tar.bz2")
        os.remove(localDir_third+os.path.sep+"msg_other.zip")
        PY_LOGGER.info("[module] del msg_other.zip end~~")
        
        return True
    except Exception,exception:
        PY_LOGGER.error("[module] catch except when adjust log file over!")
        PY_LOGGER.error("[module] except arguement:"+str(exception.args)+"~~~over!")
        PY_LOGGER.error("[module] except messages:"+str(exception))
        PY_LOGGER.error("[module] except trace back:"+str(traceback.print_exc()))
        return False
    
def CleanDir(Dir):
    try:
        PY_LOGGER.info("[module] start to clean dir")
        if os.path.isdir(Dir):
            paths = os.listdir( Dir )
            for path in paths:
                filePath = os.path.join( Dir, path )
                if os.path.isfile( filePath ):
                    try:
                        os.remove( filePath )
                    except os.error:
                        PY_LOGGER.info( "remove "+filePath+" error." )
                        return False
                elif os.path.isdir( filePath ):
                    if filePath[-4:].lower() == ".svn".lower():
                        continue
                    shutil.rmtree(filePath,True)
            os.rmdir(Dir)
        else:
            return False
        return True
    except:
        
        return False


def download_XVE(devObj, type):
    try:
        sftp = devObj.get("SFTP")
        ssh = devObj.get("SSH")
        localDir = devObj.get("collectRetDir")+os.path.sep+"temp"+os.path.sep
        
        #create "\temp" dir for adjust file directory
        if os.path.exists(localDir) != True:
            os.mkdir(localDir)
        localPath = localDir+devObj.get("collectRetFileName")
        file = File(localPath)
        sftp.getFile(devObj.get("collecRemotePath"),file,None)
        
        if type == "SYSCONFIG":
            os.renames(localPath, localDir+"Config.txt")
            del_type = "running_data"
        elif type == "ALM":
            del_type = "event"
        elif type == "DB":
            del_type = "configuration_data"
        elif type == "LOG":
            del_type = "log"
        #delete export file in memory of device
        strCmd = "delete file "+del_type
        PY_LOGGER.info("[module] delete command is:"+strCmd)
        cliRet = ssh.execCmd(strCmd)
        if cliRet.find("Command executed successfully") == -1:
            PY_LOGGER.info("[module] delete file in memory of device error. go on executing next step")
        return True
    except Exception,exception:
        PY_LOGGER.error("[module] catch except when download "+devObj.get("collecRemotePath")+"~~~over!")
        PY_LOGGER.error("[module] except arguement:"+str(exception.args)+"~~~over!")
        PY_LOGGER.error("[module] except messages:"+str(exception))
        PY_LOGGER.error("[module] except trace back:"+str(traceback.print_exc()))
        return False

def func_after_download(devObj, type):
    keepAliveThread = AsynProgressExecuteCmd(devObj, PY_LOGGER)
    try:
        if str(type) == str("ALM") or str(type) == str("ELABLE") or str(type) == str("DB") or str(type) == str("CLICMD"):
            PY_LOGGER.info("[module] no need handle log collect.")
            return (True, "")
        flag_logexist = False
        flag_logdir_exist = False
        result = False
        third_dir_name_list = []
        localDir_third_list = []
        step = "default"
        tar_class = devObj.get("PYENGINE.PY_ZIP")
        localPath = "default"
        localFile_final = "default"
        #search tgz file in the temp dir to decompress it
        localDir = devObj.get("collectRetDir")+os.path.sep+"temp"+os.path.sep

        PY_LOGGER.info("[module] local path of towar is:"+localDir)
        list = os.listdir(localDir)
        for field in list:
            if field.find(".tgz") != -1:
                flag_logexist = True
                localPath = localDir + field
                localFile_final = devObj.get("collectRetDir") + os.path.sep + field
                PY_LOGGER.info("[module] path is:"+localFile_final)
                second_dir_name = field.replace(".tgz", "")
                break
            if field.find("Datacollect") != -1:
                if os.path.isdir(localDir + field) == True:
                    flag_logdir_exist = True
                    break

        if flag_logdir_exist == True:
            localDir_third_list_get = devObj.get("localDir_third")
            if len(localDir_third_list_get) != 0:
                for dir_name_get in localDir_third_list_get:
                    if type == "SYSCONFIG":
                        shutil.copy(localDir+"Config.txt", dir_name_get+"Config"+os.path.sep)
            return True
            
        #if exist log dir, need to copy txt or dat file to correspond dir("\temp\second")
        if flag_logexist != True:
            PY_LOGGER.info("[module] log zip file is not exist, may be user do not collect system log.")
            result = True
            return result
        
        localDir_second = localDir + second_dir_name+os.path.sep
        if os.path.exists(localDir_second) != True:
            os.mkdir(localDir_second)
                
        #decompress tgz file to "\temp\second" dir
        keepAliveThread.start()
        PY_LOGGER.info("AsynProgressExecuteCmd keepAliveThread is start.")
        for index in range(0, G_RETRY_TIMES):
            result = True
            PY_LOGGER.info("[module] start to decompress localDir_second.time:"+str(index))
            PY_LOGGER.info("[module] start to decompress localPath is:"+localPath)
            PY_LOGGER.info("[module] start to decompress localDir_second is:"+localDir_second)
            try:
                result = tar_class.decompressZipFile(localPath, localDir_second)
            except Exception,exception:
                PY_LOGGER.error("[module] except reason:"+str(exception))
                continue
            PY_LOGGER.info("[module] end to decompress localDir_second.result:"+str(result))
            if result == True:
                break
            else:
                CleanDir(localDir_second)
                mkdir(localDir_second)
                time.sleep(2)
                continue
        if result == False:
            keepAliveThread.setStopFlag(True)
            return False
        os.remove(localPath)
        
        #search  "\temp\second" dir to find bz2 file and decompress it
        list2 = os.listdir(localDir_second)
        for field_second in list2:
            if field_second.find(".bz2") != -1:
                flag_bz2_exist = True
                third_dir_name_list.append(field_second.replace(".tar.bz2",""))
                PY_LOGGER.info("[module] list in tar is:"+str(field_second.replace(".tar.bz2","")))
                
        if flag_bz2_exist != True:
            step = "step2"
            func_fail_after_download(devObj, step)

        for third_dir_name in third_dir_name_list:

            #if find bz2 file, start to decompress to "\temp\second\third" dir
            localDir_third = localDir_second + third_dir_name+os.path.sep
            localDir_third_list.append(localDir_third)
            if os.path.exists(localDir_third) != True:
                os.mkdir(localDir_third)
            result = tar_class.decompressTarBz2File(localDir_second+third_dir_name+".tar.bz2", localDir_third)

            if result == False:
                step = "step3"
                func_fail_after_download(devObj, step)
                keepAliveThread.setStopFlag(True)
                return False
            #delete tar file
            os.remove(localDir_second+third_dir_name+".tar.bz2")
            if type == "SYSCONFIG":
                shutil.copy(localDir+"Config.txt", localDir_third+"Config"+os.path.sep)
                PY_LOGGER.info("[module] copy "+localDir+"Config.txt to "+localDir_third+"Config"+os.path.sep)
            #adjust log file to messages dictionary
            result = adjust_log_file(devObj, localDir_third)
            if result == False:
                keepAliveThread.setStopFlag(True)
                return False
        keepAliveThread.setStopFlag(True)
        devObj["localDir_third"]=localDir_third_list
        return True
    except Exception,exception:
        if not keepAliveThread.stopFlg:
            keepAliveThread.setStopFlag(True)
        PY_LOGGER.error("[module] catch except when handle after download~~~!")
        PY_LOGGER.error("[module] except arguement:"+str(exception.args)+"~~~over!")
        PY_LOGGER.error("[module] except messages:"+str(exception))
        PY_LOGGER.error("[module] except trace back:"+str(traceback.print_exc()))
        return False

# 任意一个CLI命令写入成功，则收集成功，2013/12/12，Modfidy Begin
# **************************************************************************** #
# 函数名称: isCliRetOk
# 功能说明: 粗略判断收集的CLI信息是否正常
# 输入参数: cliRet
# 输出参数: True or False
# **************************************************************************** # 
def isCliRetOk(cliRet):
    if None == cliRet or ""==cliRet:
        return False
    
    #异常，命令执行成功的关键字存在于前几行，防止全部判断时误判
    lineList = cliRet.splitlines()
    
    #行数大于12行，说明回显执行一定有结果，返回正常
    if len(lineList)>12:
        return True
    
    #判断是否是在CLI模式下执行的命令
    if -1 == lineList[-1].find(":/>"):
        return False
    
    if re.search(CLI_EXEC_FAILED, cliRet, re.IGNORECASE):
        #有license file报错视为正常
        if re.search("license file is unavailable", cliRet, re.IGNORECASE):
            return True
        return False
    return True
# 任意一个CLI命令写入成功，则收集成功，2013/12/12，Modfidy End

def is_multi_cmd(strCmd, type):
    try:
        flag = False
        list_cmd = None
        if type == str("ELABLE"):
            list_cmd = list_multi_elable_cmd
        elif type == str("CLICMD"):
            list_cmd = list_multi_cli_cmd
            
        for field in list_cmd:
            if field == strCmd or field.find(strCmd+"|") != -1:
                flag = True
                PY_LOGGER.info("[module] multi cmd")
                return flag
        PY_LOGGER.info("[module] single cmd")    
        return flag
    except:
        flag = False
        PY_LOGGER.info("[module] catch except when check if multi command~~~over!")
        return flag

# **************************************************************************** #
# 函数名称: getCmdIdList
# 功能说明: 获取CLI命令执行后的参数ID列表，便于查询具体的器件ID信息
# 输入参数: devObj，strCmd（CLI命令），type（导出类型）
# 输出参数: baseCliRet（父CLI命令执行结果），idInfoList（ID列表）
# **************************************************************************** # 
def getCmdIdList(devObj, strCmd, type):
    try:
        baseCliRet = ""
        idInfoList = []
        list_cmd = None
        ssh = devObj.get("SSH")
        if type == str("ELABLE"):
            list_cmd = list_multi_elable_cmd
        elif type == str("CLICMD"):
            list_cmd = list_multi_cli_cmd

        for element in list_cmd:
            if element.find(strCmd) != -1:
                if element.find("|") != -1:
                    list_tmp = element.split("|")
                    strCmd = list_tmp[1]
                    PY_LOGGER.info("[module] Execute ["+str(type)+"] cmd, cmd right element is: "+strCmd)
                    break

        baseCliRet = ssh.execCmd(strCmd)
        if baseCliRet == None:
            return (baseCliRet,idInfoList)
        
        list_cliRet = baseCliRet.splitlines()
        i = 0
        for field in list_cliRet:
            i = i+1
            if i < 5:
                continue
            if field.find(":/>") != -1 or field.find("developer:/>") != -1:
                continue
            list_field = field.split()
            idInfoList.append(list_field[0])
        return (baseCliRet,idInfoList)
    except:
        PY_LOGGER.info("[module] catch except when get multi command~~~over!")
        return (baseCliRet,idInfoList)

# **************************************************************************** #
# 函数名称: getCliExcuteRet
# 功能说明: 获取CLI命令的执行结果
# 输入参数: devObj，strCmd，type
# 输出参数: retFlag（CLI回显是否有效），result（CLI回显结果）
# **************************************************************************** # 
def getCliExcuteRet(devObj, strCmd, type):
    try:
        retFlag = True
        result = "default"
        cmdIdList = []
        if strCmd == None or "" == strCmd:
            retFlag = False
            PY_LOGGER.info("[module] Input cli cmd is null")
            return (retFlag, result)
        
        ssh = devObj.get("SSH")
        
        #单个CLI命令
        if not is_multi_cmd(strCmd, type):
            PY_LOGGER.info("[module] Execute ["+str(type)+"] cmd, cmd item is: "+strCmd)
            result = ssh.execCmd(strCmd)
            if not isCliRetOk(result):
                retFlag = False
                return (retFlag, result)
        
        #多个CLI命令        
        else:
            result = ""
            PY_LOGGER.info("[module] Execute ["+str(type)+"] cmd, cmd items is: "+strCmd)
         
            #获取父CLI执行结果，若是父CLI回显无效，子命令获取
            baseCliRet, cmdIdList = getCmdIdList(devObj, strCmd, type)
            result = baseCliRet
            if not isCliRetOk(result):
                retFlag = False
                return (retFlag, result)
            
            for idInfo in cmdIdList:
                if idInfo.startswith("SVP"):
                    continue
                result = result+ssh.execCmd(strCmd + " " + idInfo)
            
        return (retFlag, result)
    
    except Exception,exception:
        retFlag = False
        result = "default"
        PY_LOGGER.error("[module] catch except when collect ["+str(type)+"] failed, cli cmd is: "+strCmd)
        PY_LOGGER.error("[module] catch except when execute cli cmd, arguement:"+str(exception.args))
        PY_LOGGER.error("[module] catch except when execute cli cmd, messages:"+str(exception))
        PY_LOGGER.error("[module] catch except when execute cli cmd, trace back:"+str(traceback.print_exc()))
        return (retFlag, result)

def write_elable_file(devObj, strCmd):
    try:
        flag = True
        localDir = devObj.get("collectRetDir")+os.path.sep+"temp"+os.path.sep
        if True != os.path.exists(localDir):
            os.mkdir(localDir)
        f = open(localDir+"elable_info.txt", "a")
        
        f.write(strCmd)
        f.close()
        if not os.path.exists(localDir+"elable_info.txt"):
            flag = False
            PY_LOGGER.info("[module] lable info not exsit!!!")
            devObj["py_detail"] = u"\nThe file named elable_info.txt is not exist"
        return flag
    except Exception,exception:
        PY_LOGGER.error("[module] catch except when write elable, arguement:"+str(exception.args))
        PY_LOGGER.error("[module] catch except when write elable, messages:"+str(exception))
        PY_LOGGER.error("[module] catch except when write elable, trace back:"+str(traceback.print_exc()))
        return False

def write_clicmd_file(devObj, strCmd):
    try:
        flag = True
        localDir = devObj.get("collectRetDir")+os.path.sep+"temp"+os.path.sep
        if True != os.path.exists(localDir):
            os.mkdir(localDir)
        f = open(localDir+"clicmd.txt", "a")
        if not os.path.exists(localDir+"clicmd.txt"):
            flag = False
            devObj["py_detail"] = u"\nThe file named clicmd.txt is not exist"
        
        f.write(strCmd)
        f.close()
        return flag
    
    except Exception,exception:
        PY_LOGGER.error("[module] catch except when write cli, arguement:"+str(exception.args))
        PY_LOGGER.error("[module] catch except when write cli, messages:"+str(exception))
        PY_LOGGER.error("[module] catch except when write cli, trace back:"+str(traceback.print_exc()))
        return False

def find_in_list(list_src, strInfo):
    try:
        i = 0
        for field in list_src:
            if field == strInfo:
                return i
            i = i + 1
        return -1
    except:
        PY_LOGGER.info("[module] catch except when find info in list~~~over!")
        return -1

def get_field_type(atrribute_name):
    try:
        field_type = "string"
        return field_type
    except:
        PY_LOGGER.info("[module] catch except when get field type~~~over!")
        return field_type

def parse_elable_info(strInfo, strProperty):
    try:
        result = "    <TABLE>\n    </TABLE>\n"
        result = "    <TABLE attribute=\""+strProperty+"\">\n"
        result = result + "        <METADATA>\n"
        result = result + "        <FIELDS>\n"
        flag_start = False
        list_elable_key = []
        list_elable_value = []
        list = strInfo.splitlines()
        list_elable_value_num = 0
        for field in list:
            if field.find("Electronic Label") != -1:
                list_elable_value_num = list_elable_value_num + 1
                flag_start = True
            if flag_start == True:
                if field.find("=") != -1:
                    list_temp = field.split("=")
                    if -1 == find_in_list(list_elable_key, list_temp[0].replace(" ", "")):
                        list_elable_key.append(list_temp[0].replace(" ", ""))
                    list_elable_value.append(list_temp[1])
        if len(list_elable_key) == 0:
            result = result + "        </FIELDS>\n        </METADATA>\n    </TABLE>\n"
            return result
        i = 0
        j = 0
        value_max = 0
        for field in list_elable_key:
            result = result + "            <FIELD attribute = \""+field
            for j in range(list_elable_value_num):
                if len(list_elable_value[i]) > value_max:
                    value_max = len(list_elable_value[i])
            result = result + "\" fieldtype = \""+get_field_type(field)+"\" width = \""+str(value_max)+"\" required=\"true\" />\n"
            i = i + 1
            value_max = 0
        result = result+"        </FIELDS>\n        </METADATA>\n        <ROWDATA>\n"
        i = 0
        for i in range(list_elable_value_num):
            result = result + "            <ROW "
            j = 0
            for field in list_elable_key:
                result = result + field + "=\""
                if list_elable_value[j + i * len(list_elable_key)] == None:
                    result = result + "\""
                    j = j + 1
                    continue
                result = result +list_elable_value[j + i * len(list_elable_key)]+"\" "
                j = j + 1
            result = result + " />\n"
        result = result + "        </ROWDATA>\n    </TABLE>\n"
        return result
    except Exception,exception:
        PY_LOGGER.info("[module] catch except when parse info, arguement:"+str(exception.args))
        PY_LOGGER.info("[module] catch except when parse info, messages:"+str(exception))
        PY_LOGGER.info("[module] catch except when parse info, trace back:"+str(traceback.print_exc()))
        return result

# 任意一个CLI命令写入成功，则收集成功，2013/12/13，Modfidy Begin
# **************************************************************************** #
# 函数名称: export_elable
# 功能说明: 导出电子标签信息，创建头部文件失败时电子标签导出失败，所有电子标签信息只要          
#          中间有一项收集成功即收集成功
# 输入参数: devObj，type
# 输出参数: True or False
# **************************************************************************** # 
def export_elable(devObj, type):
    try: 
        result = "default"
        retFlag = True
        #电子标签回显成功记数
        elableRetOkNum =0 
        #电子标签回显写入成功记数
        elableWriteNum =0
        
        #电子标签表头信息
        list_header = ["<?xml version=\"1.0\" encoding=\"iso-8859-1\" standalone=\"yes\" ?> ",
                 "<DATAPACKET Version=\"2.0\">",
                 "<FILELABEL>",
                 "<VERDESC Ver=\"1.4\" />",
                 "</FILELABEL>",
                 "<TABLES>"]

        for field_header in list_header:
            retFlag = write_elable_file(devObj, field_header+"\n")
            if not retFlag:
                PY_LOGGER.info("[module] Create the head of file named elable_info failed")
                devObj["py_detail"] = u"\nCreate the head of file named elable_info.txt is failed"
                return (retFlag, elableWriteNum)   

        i = 0
        for field in list_elable_cmd:
            cliRetIsOk, result = getCliExcuteRet(devObj, field, type)
            
            #没有获取到CLI信息，直接跳出不写入文件
            if "default"==result or ""==result:
                PY_LOGGER.info("[module] Collect elable default, cmd is: "+field)
                continue
            
            #CLI回显成功记数
            if cliRetIsOk:
                elableRetOkNum +=1
            else:
                PY_LOGGER.info("[module] Collect elable failed, cmd is: "+field)

            i = i + 1
            if len(list_elable_property) >= i:
                result = parse_elable_info(result, list_elable_property[i-1])
            else:
                result = parse_elable_info(result, "default")
       
            #回显写入文件
            flag = write_elable_file(devObj, result)
            if not flag:
                PY_LOGGER.info("[module] Write elable info to file failed, cmd is: "+field)
            #写入成功的前提而且要求CLI回显必须为正常的才记数
            elif cliRetIsOk:
                elableWriteNum +=1
        
        PY_LOGGER.info("[module] Collect elable info success number: "+str(elableRetOkNum))       
        PY_LOGGER.info("[module] Write elable info to file success number: "+str(elableWriteNum))
        write_elable_file(devObj, "</TABLES>\n</DATAPACKET>")
        return (retFlag, elableWriteNum)
    
    except Exception,exception:
        retFlag = False
        devObj["py_detail"] = u"\nExport elable catch exception"
        PY_LOGGER.info("[module] catch except when export elable, arguement:"+str(exception.args))
        PY_LOGGER.info("[module] catch except when export elable, messages:"+str(exception))
        PY_LOGGER.info("[module] catch except when export elable, trace back:"+str(traceback.print_exc()))
        return (retFlag, elableWriteNum)

# **************************************************************************** #
# 函数名称: export_clicmd
# 功能说明: 导出CLI回显信息，创建头部文件失败时CLI导出失败，所有CLI信息只要中间有一项
#          收集成功即收集成功
# 输入参数: devObj，type
# 输出参数: True or False
# **************************************************************************** # 
def export_clicmd(devObj, type):
    try:
        retFlag = True
        #基础CLI命令记数
        cliCmdNum = 0
        #基础CLI命令回显成功记数
        cliRetOkNum =0 
        #CLI命令电子标签回显写入成功记数
        cliWriteNum =0
        ssh = devObj.get("SSH")
        
        #要执行的CLI命令集合
        cliCmd = []
        
        #收集CI信息抬头写入用户名，权限信息
        userName = devObj.get("username")
        if None == userName or "" == userName: 
            userName = getUserNameCli(ssh)
            
        userLevel = getUserPrivilege(devObj)  
        result = userName+":/>\n" + userLevel+"\n"
        
        result +="\n--------------------------------------START--------------------------------------\n"
        
        #写入CLI回显抬头信息
    	retFlag = write_clicmd_file(devObj, result)
    	if not retFlag:
            PY_LOGGER.info("[module] Create the head of file named clicmd.txt is failed")
            devObj["py_detail"] = u"\nCreate the head of file named clicmd.txt failed"
            return (retFlag,cliWriteNum)
        
        #不同权限级别收集的命令有差异 
        PY_LOGGER.info("[module] userName="+str(userName)+", userLevel="+str(userLevel))
        if "super_admin" == userLevel: 
            cliCmd.extend(cli_cmd_list_guest)
            cliCmd.extend(admin_add)
            cliCmd.extend(super_admin_add)
        elif "admin" == userLevel:
            cliCmd.extend(cli_cmd_list_guest)
            cliCmd.extend(admin_add)
        else:
            cliCmd = cli_cmd_list_guest
        
        cliCmdNum = len(cliCmd)
        PY_LOGGER.info("[module] Totall collect cli cmd num: "+str(cliCmdNum))
        for field in cliCmd:
            
            #导出CLI回显
            cliRetIsOk, result = getCliExcuteRet(devObj, field, type)
            
            #没有获取到CLI信息，直接跳出不写入文件
            if "default"==result or ""==result:
                PY_LOGGER.info("[module] Collect cli default, cmd is: "+field)
                continue
        
            #CLI回显成功记数
            if cliRetIsOk:
                cliRetOkNum +=1
            else:
                PY_LOGGER.info("[module] Collect cli failed, cmd is: "+field)
            
            #写入CLI回显信息      
            flag = write_clicmd_file(devObj, result)
            if not flag:
                PY_LOGGER.info("[module] Write cli info to file failed, cmd item is: "+field)
            elif cliRetIsOk:
                cliWriteNum +=1
        
        PY_LOGGER.info("[module] Collect cli info to success number: "+str(cliRetOkNum))
        PY_LOGGER.info("[module] Write cli info to file success number: "+str(cliWriteNum))
        
        #写入结束信息
        result = ""
        result += "\nTotall Number: "+str(cliCmdNum)
        result += "\nSuccess Number: "+str(cliRetOkNum)
        result += "\nWrite Success Number: "+str(cliWriteNum)+"\n"
        result +="\n--------------------------------------END--------------------------------------"
        write_clicmd_file(devObj, result)
            
        return (retFlag, cliWriteNum)
        
    except Exception,exception:
        retFlag = False
        devObj["py_detail"] = u"\nExport cli command catch exception"
        PY_LOGGER.info("[module] catch except when export cli cmd, arguement:"+str(exception.args))
        PY_LOGGER.info("[module] catch except when export cli cmd, messages:"+str(exception))
        PY_LOGGER.info("[module] catch except when export cli cmd, trace back:"+str(traceback.print_exc()))
        return (retFlag, cliWriteNum)
# 任意一个CLI命令写入成功，则收集成功，2013/12/13，Modfidy End

# 错误码没有详细的提示信息，增加处理函数设置各种已知错误的可能发生场景，2013/11/08 modified Begin
# **************************************************************************** #
# 函数名称: isCliExecSuccess
# 功能说明: 判断收集信息的CLI命令是否执行成功
# 输入参数: cliRet
# 输出参数: True or False
# **************************************************************************** # 
def isCliExecSuccess(cliRet):
    if None == cliRet or ""==cliRet:
        return False
    
    for successItem in CLI_EXEC_SUCCESS_TAG:
        if re.search(successItem, cliRet, re.IGNORECASE):
            return True
    return False

# **************************************************************************** #
# 函数名称: setFailedReason
# 功能说明: 根据回显结果设置失败的原因
# 输入参数: cliRet
# 输出参数: True or False
# **************************************************************************** # 
def setFailedReason(cliRet,devObj):
    lang = devObj.get("lang")
    username = devObj.get("username")
    errMsg = ""
    for dictItems in dictMsg:
        if re.search(dictItems.get("key_word"), cliRet, re.IGNORECASE):
            if "zh" == lang:
                errMsg = dictItems.get("msg_zh")             
            else:
                errMsg = dictItems.get("msg_en")  
            break     
    devObj["py_detail"] = cliRet.replace(username,"").replace(":/>","")+errMsg
# 错误码没有详细的提示信息，增加处理函数设置各种已知错误的可能发生场景，2013/11/08 modified End

# SPC900发布开放信息收集，脚本兼容处理，2013/11/12，modified Begin
# **************************************************************************** #
# 函数名称: getUserNameCli
# 功能说明: 根据CLI回显获取用户名
# 输入参数: cli
# 输出参数: userName
# **************************************************************************** # 
def getUserNameCli(cli):
    userName = ""

    #执行命令获取当前登录的用户名      
    cliRet = cli.execCmdNoLog("show system general")
    
    #输入CLI回显是否有效
    if None == cliRet or "" == cliRet: 
        return userName
    
    #执行命令获取当前登录的用户名      
    lineList = cliRet.splitlines()
    
    #用户名一定包含在最后一行中
    if lineList[-1].find(CLI_RET_END_FLAG):
        userName = lineList[-1].replace(" ","").replace(CLI_RET_END_FLAG,"")
    return userName

# **************************************************************************** #
# 函数名称: getUserName
# 功能说明: 获取登录用户名的权限级别
# 输入参数: devObj
# 输出参数: super_admin,guest或admin
# **************************************************************************** # 
def getUserPrivilege(devObj):
    
    userLevel = ""
    ssh = devObj.get("SSH")
    userName = devObj.get("username")
    if None == userName or "" == userName: 
        userName = getUserNameCli(ssh)
        
    PY_LOGGER.info("[module] Get login name is:"+str(userName))
    
    if "admin"==userName:
        userLevel = "super_admin"
        return userLevel
     
    #获取权限级别
    cliRet = ssh.execCmdNoLog("show user "+userName)
    lineList = cliRet.splitlines()
    
    #用户名一定包含在最后几行中
    for line in lineList[4:-1]:
        columnList = line.split()
        if len(columnList)>2:
            if userName == columnList[0]:
                userLevel = columnList[1]
                return userLevel
    return userLevel

# **************************************************************************** #
# 函数名称: getCurrentVesion
# 功能说明: 获取当前系统运行的版本号，精确到SPC，为了加快获取速率，
#           一次获取成功后保存到框架提供的全局变量中
# 输入参数: cli
# 输出参数: currentVesion
# **************************************************************************** # 
def getCurrentVesion(cli):  
    currentVesion = ""
      
    cliRet = cli.execCmdNoLog("show upgrade package")
    lineList = cliRet.splitlines()
    
    #直接从包含版本号的行开始
    for line in lineList[5:-1]:
        columnList = line.split()
        #找到关键字，直接返回当前版本号
        for column in columnList[2:-1]:
            if -1 != column.find(PRODUCT_VERSION):
                currentVesion = column[0:17]
                #在框架提供的全局变量里设置当前的版本号,精确到SPC
                return currentVesion           
    return currentVesion

# ，从SPC900开始，导出系统日志，告警信息，配置信息，DB信息采用新的CLI命令，2014/1/9 modified Begin
# **************************************************************************** #
# 函数名称: getRemotePath(cliExeRet) 
# 功能说明: 根据CLI回显获取阵列导出信息的目录
# 输入参数: cliExeRet
# 输出参数: collecRemotePath
# **************************************************************************** # 
def getRemotePath(cliExeRet):
    collecRemotePath = ""
    indexFst = -1
     
    if None == cliExeRet or "" == cliExeRet:
        return collecRemotePath
    
    lineList = cliExeRet.splitlines()
    for line in lineList:
        if line.strip().startswith("File Path"):
            indexFst = line.find("/")
            if -1 == indexFst:
                break
            collecRemotePath = line[indexFst:]
    return collecRemotePath
# ，从SPC900开始，导出系统日志，告警信息，配置信息，DB信息采用新的CLI命令，2014/1/9 modified End

# **************************************************************************** #
# 函数名称: isSupportVesion
# 功能说明: 判断当前版本是否支持
# 输入参数: cli
# 输出参数: True or False
# **************************************************************************** # 
def isSupportVersion(cli):
    currentVesion =  getCurrentVesion(cli)
    if ""==currentVesion:
        return False
    
    if currentVesion not in NOT_SUPPORT_VERSION: 
        return True
    return False
# ，SPC500发布开放信息收集，脚本兼容处理，2013/11/12，modified End


def execute(devObj,type):
    try:
        ssh = devObj.get("SSH")
        sftp = devObj.get("SFTP")
        lang = devObj.get("lang")
        flag = False
        collecRemotePath = ""
        ipAddr = public_ip_address_utils.get_export_config_used_ip()
        ipList = []
        
        global CLI_EXPORT_CMD_IS_OLD
          
        #初始化清空
        devObj["py_detail"] = ""
        devObj["collectAllInfo"] = True
         #导出电子标签
        if type == "ELABLE":
            
            if "V200R001C00SPC800" == getCurrentVesion(ssh):
                PY_LOGGER.error("[module] collect CK info begin")
                ckFlag = collectCkInfo.execute(devObj)
                if not ckFlag:
                    PY_LOGGER.error("[module] collect CK info failed")
            
            PY_LOGGER.info("[module] collect elable info start")
            retFlag, writeOkNum = export_elable(devObj, type)
            if not retFlag:
                flag = False
                PY_LOGGER.info("[module] collect elable info failed")
            elif 0 == writeOkNum:
                flag = False  
                devObj["py_detail"] = u"\nCollectting elable information failed." 
            else:
                flag = True
                PY_LOGGER.info("[module] collect elable info successful")
            return (flag, "")

        #导出CLI回显
        if type == "CLICMD":
            PY_LOGGER.info("[module] collect cli cmd info start")
            retFlag, writeOkNum = export_clicmd(devObj, type)
            if not retFlag:
                flag = False
                PY_LOGGER.info("[module] collect cli cmd info failed")
            elif 0 == writeOkNum:
                flag = False  
                devObj["py_detail"] = u"\nCollectting cli information failed." 
            else:
                flag = True
                PY_LOGGER.info("[module] collect cli cmd info successful")
            return (flag, "")
        
        #导出smart信息
        if type == "SMART":
            PY_LOGGER.info("[module] collect smart info start")
            strRet = collectSmartInfo.execute(devObj)
            if strRet == False:
                PY_LOGGER.info("[module] collect smart info failed")
                return (False, "")
            else:
                PY_LOGGER.info("[module] collect smart info successful")
                return (True, "")
        
        # 从SPC900开始，导出系统日志，告警信息，配置信息，DB信息采用新的CLI命令，2014/1/9 modified Begin
        if getCurrentVesion(ssh) in ["V200R001C00SPC100","V200R001C00SPC200","V200R001C00SPC300","V200R001C00SPC400",\
                       "V200R001C00SPC500","V200R001C00SPC600","V200R001C00SPC700","V200R001C00SPC800","V200R001C00SPC900"]:
            CLI_EXPORT_CMD_IS_OLD = True
        else:
            CLI_EXPORT_CMD_IS_OLD = False
        
        if CLI_EXPORT_CMD_IS_OLD:
            #确保传入的IP不为本地及阵列IP地址
            ipList = modelManager.getIpList(ssh)
            if ipAddr in ipList:
                ipAddr = public_ip_address_utils.get_export_event_used_ip()
                
            if type == "ALM":
                strCmd = G_STRCMD + "event event " + ipAddr + " admin ****** /collect_alm.tgz clean_device_file=no"
            if type == "LOG":
                strCmd = G_STRCMD + "event log " + ipAddr + " admin ****** /collect_log.tgz clean_device_file=no"
            if type == "SYSCONFIG":
                strCmd = G_STRCMD + "running_data " + ipAddr + " admin ****** /collect_sysconfig.txt clean_device_file=no"
            if type == "DB":
                strCmd = G_STRCMD + "configuration_data " + ipAddr + " admin ****** /collect_db.dat clean_device_file=no"
        else:
            if type == "ALM":
                strCmd = "show file export_path event"
            if type == "LOG":
                strCmd = "show file export_path log"
            if type == "SYSCONFIG":
                strCmd = "show file export_path running_data"
            if type == "DB":
                strCmd = "show file export_path configuration_data"
        # 从SPC900开始，导出系统日志，告警信息，配置信息，DB信息采用新的CLI命令，2014/1/9 modified End
            
        # 错误码没有详细的提示信息，增加处理函数设置各种已知错误的可能发生场景，2013/11/08 modified Begin
        PY_LOGGER.info("[module] Collect Start, exec cli: "+strCmd)
        userLevel = getUserPrivilege(devObj)
        PY_LOGGER.info("[module] Login user level is: "+userLevel)
        
        # SPC800发布开放信息收集，脚本兼容处理，2013/11/12，modified Begin
        #只读用户提示权限不够
        if "guest" == userLevel:
            if "zh" == lang:
               devObj["py_detail"] = u"（1）用户权限不够，无法执行此收集命令；\
                                   \n（2）具体处理请联系技术支持工程师。"
            else:
               devObj["py_detail"] = u"（1）The login user had low-privileged, it can't collect this information;\
                                   \n（2）Please contact technical support engineers for further handling."
            return (False,"")
        
        #DB信息老版本管理员用户无法导出
        if type == "DB":
            if not isSupportVersion(ssh) and "super_admin" != userLevel:   
                if "zh" == lang:
                   devObj["py_detail"] = u"（1）用户权限不够，无法执行此收集命令；\
                                       \n（2）具体处理请联系技术支持工程师。"
                else:
                   devObj["py_detail"] = u"（1）The login user had low-privileged, it can't collect this information;\
                                       \n（2）Please contact technical support engineers for further handling."
                return (False,"")
        # SPC800发布开放信息收集，脚本兼容处理，2013/11/12，modified End
            
        if type == "LOG":   
            PY_LOGGER.info("[module] collect log")
            cliExeRet = str(ssh.execCmdNoLogTimout(strCmd, G_LOG_TIMO))
        else:
            cliExeRet = str(ssh.execCmdNoLog(strCmd))
        PY_LOGGER.info("[module] Collect End, cli result: "+cliExeRet)

        #收集失败的场景，分别提示
        if not isCliExecSuccess(cliExeRet):
            setFailedReason(cliExeRet, devObj)      
            return (False,"")
        
        # 从SPC900开始，导出系统日志，告警信息，配置信息，DB信息采用新的CLI命令，2014/1/9 modified Begin
        if not CLI_EXPORT_CMD_IS_OLD:
            collecRemotePath = getRemotePath(cliExeRet)
            
        PY_LOGGER.info("[module] collect ok ,get the remote path is:"+collecRemotePath) 
         
        if type == "ALM":
            if "" == collecRemotePath:
                devObj["collecRemotePath"]="/OSM/export_import/event_export.tar"
            else:
                devObj["collecRemotePath"]=collecRemotePath	
            devObj["collectRetFileName"]="event_export.tar"
        if type == "LOG":
            if "" == collecRemotePath:
                list = sftp.listFiles("/OSM/export_import")
                for field in list:
                    PY_LOGGER.info("[module] file name in export_import is:"+field)
                    if field.find("Datacollect") != -1:
                        devObj["collecRemotePath"]="/OSM/export_import/"+field		
                        devObj["collectRetFileName"]=field
            else:
               devObj["collecRemotePath"]=collecRemotePath 
               devObj["collectRetFileName"]=collecRemotePath.split("/")[-1]
                    
        if type == "SYSCONFIG":
            if "" == collecRemotePath:
                devObj["collecRemotePath"]="/OSM/export_import/OSM_sysconfig.txt"
            else:
                devObj["collecRemotePath"]=collecRemotePath
            devObj["collectRetFileName"]="OSM_sysconfig.txt"
            
        if type == "DB":
            if "" == collecRemotePath:
                devObj["collecRemotePath"]="/OSM/export_import/db.dat"
            else:
                devObj["collecRemotePath"]=collecRemotePath
            devObj["collectRetFileName"]="db.dat"
        # 从SPC900开始，导出系统日志，告警信息，配置信息，DB信息采用新的CLI命令，2014/1/9 modified End
        
        strRet = download_XVE(devObj, type)
        if strRet == False:
            return (False, "")

        strRet = func_after_download(devObj, type)
        if strRet == False:
            return (False, "")

        if type == "LOG":
            index_1 = cliExeRet.find("Error: Part of information was successfully collected but the ftp put file failed")
            index_2 = cliExeRet.find("Part of infomration was successfully collected and the command was successfully executed")
            if ((index_1 != -1) or (index_2 != -1)):
                devObj["collectAllInfo"] = False
                devObj["py_detail"] = cliExeRet
        # 错误码没有详细的提示信息，增加处理函数设置各种已知错误的可能发生场景，2013/11/08 modified End
        return (True,"")
    except Exception,exception:
        PY_LOGGER.info("[module] catch except when execute module1~~~over~")
        PY_LOGGER.info("[module] except arguement:"+str(exception.args)+"~~~over!")
        PY_LOGGER.info("[module] except messages:"+str(exception))
        PY_LOGGER.info("[module] except trace back:"+str(traceback.print_exc()))
        return (False,"")
        
def execute_alm(devObj):
    return execute(devObj,G_ITEM_ALM)
    
def execute_log(devObj):
    return execute(devObj,G_ITEM_LOG)

def execute_sysconfig(devObj):
    return execute(devObj,G_ITEM_SYS)

def execute_db(devObj):
    return execute(devObj,G_ITEM_DB)

def execute_elable(devObj):
    return execute(devObj,G_ITEM_ELABLE)

def execute_clicmd(devObj):
    return execute(devObj,G_ITEM_CLICMD)

def execute_smart(devObj):
    return execute(devObj,G_ITEM_SMART)

