﻿# -*- coding: UTF-8 -*-
import re
from time import sleep
from toolutilities import sshutils
import modelManager
import os
import time
import zipfile
import codecs
import stat
import shutil
import traceback
from com.huawei.ism.tool.obase.entity import DevNode
from common.cliFactory import cli

#单次收集硬盘最大个数
CollectDiskInfo_MAXCounter = 20

#获取信息分隔符
G_INFORMATION_SPLIT_STR = "\n********************\r\n"

#系统支持的硬盘最小个数
G_SYS_DISK_NUMBER_MIN   = 2 

#cli命令回文行数判断
G_CLI_INFO_NORMAL_ROW_MIN = 5

#端口号
PORT_NUM = 22
    
G_SAVE_NUM = 0
G_TEMP_NUM = 0
G_SUCC_NUM = 0

#所有节点统计的收集成功列表
G_COLLECT_SUC_LIST = []
#所有节点统计的收集失败功列表
G_COLLECT_FAIL_LIST = []
#单个节点不足20块盘，遗留未写入文件信息
G_TAIL_COLLECT_INFO = ""

# **************************************************************************** #
# 函数名称: createSshConected
# 功能说明: 脚本自行创建SSH连接
# 输入参数: devObj，ipAddr
# 输出参数: 返回同阵列创建的SSH连接，使用后需要注销
# **************************************************************************** # 
def createSSHConnection(devObj, ipAddr):
     
    cliCon = None
    lang = devObj.get("lang")
    
    username = devObj.get("username")
    password = devObj.get("password")
    logger = devObj.get("logger")
    context = devObj.get("context")
     
    #限定必须为admin用户才能收集smart信息
    if not isSuperUser(devObj, username):
        return None
    
    try:
        devNodeTmp = copyDevNode(devObj.get("devNode"))
        devNodeTmp.setIp(ipAddr)
        cliCon = sshutils.createSSHConnectionByDevNode(devNodeTmp)
        logger.info("[Smart Info] Begin to connecting!")
        cliCon.connect()
    except:
        logger.error("[Smart Info] Collecting failed, the reason is: Create ssh ["+ipAddr+"] connection catch except!")
        if lang == "zh":
            devObj["py_detail"] = u"创建SSH["+ipAddr+u"]连接失败"
        else:
            devObj["py_detail"] = "Create ssh ["+ipAddr+"] connection failed"  
        return None
    
    #系统是否正常
    logger.info("[Smart Info] Begin to checking system status!")
    iRet = isSysNormal(devObj, cliCon)
    sysStats = iRet[0]
    sysInfoStr = iRet[1]
    if not sysStats:
        cliCon.close()
        return None

    logger.info("[Smart Info] Create ssh ["+ipAddr+"] connection success!")        
    return cliCon
       
# **************************************************************************** #
# 函数名称: isSysNormal
# 功能说明: 判断系统是否正常
# 输入参数: devObj,ssh
# 输出参数: True:系统正常，False:异常；show system general回显信息
# **************************************************************************** # 
def isSysNormal(devObj, ssh):
    Health = ""
    Running = ""

    lang = devObj.get("lang")
    logger = devObj.get("logger")
    
    #查看系统状态是否正常(设置5秒超时：系统未正常开工时CLI命令也能快速返回)
    cliRet = ssh.execCmdWithTimout("show system general", 5)
    
    if None != cliRet and "" != cliRet:
        list = cliRet.splitlines()
        for field in list:
            field = field.replace(" ","")
            if field.startswith("HealthStatus:"):
                Health = field.replace("HealthStatus:","")
                continue
            if  field.startswith("RunningStatus:"):
                Running = field.replace("RunningStatus:","")
                break
        if "Normal" == Health and "Normal" == Running:
            return (True,cliRet)
    
    
    logger.error("[Smart Info] Collecting failed, the reason is: system abnormal!")
    if lang == "zh":
        devObj["py_detail"] = u"系统状态不正常，不能收集Smart信息。"
    else:
        devObj["py_detail"] = "The status of system is abnormal, and collecting smart information failed."
    
    return (False,cliRet)

# **************************************************************************** #
# 函数名称: isAdminUser
# 功能说明: 判断用户名是否为超级管理员用户
# 输入参数: devObj,userName
# 输出参数: True:超级用户，False:非超级用户
# **************************************************************************** # 
def isSuperUser(devObj, userName):
    
    lang = devObj.get("lang")
    logger = devObj.get("logger")
    if userName != "admin":
        logger.error("[Smart Info] Collecting failed, the reason is: login name ["+userName+"] is low-privileged!")    
        #设置错误信息
        if lang == "zh":
            devObj["py_detail"] = u"当前用户权限过低，不能够收集硬盘Smart信息。请使用admin用户收集。"
        else:
            devObj["py_detail"] = "The user logged in with is low-privileged and can not support to collect disk's smart information. " \
                    + "Please login with admin, then collect the disk's smart information."
        return False
    return True

# **************************************************************************** #
# 函数名称: diskSatisfyMinNum
# 功能说明: 判断盘数是否满足最小盘数要求
# 输入参数: devObj,diskCounter
# 输出参数: True:满足，False:不满足
# **************************************************************************** # 
def diskSatisfyMinNum(devObj, diskCounter, fileBaseDir):
    
    lang = devObj.get("lang")
    logger = devObj.get("logger")
    
    if diskCounter < G_SYS_DISK_NUMBER_MIN:
        logger.error("[Smart Info] Collecting failed, the reason is: disk num "+str(diskCounter)+" is less than "+str(G_SYS_DISK_NUMBER_MIN)) 
        if lang == "zh":
            devObj["py_detail"] = u"通过硬盘物理信息获取硬盘个数失败。"
        else:
            devObj["py_detail"] = "Getting disk number by disk physic information failed." 
        
        #删除总收集文件夹
        try:
            shutil.rmtree(fileBaseDir, True)
        except:
            pass
        finally:
            return False
   
    #设置返回信息
    return True  
    
# **************************************************************************** #
# 函数名称: getLogicInfo
# 功能说明: 获取POOL对应的硬盘列表等信息
# 输入参数: ssh
# 输出参数: CLI命令回显信息
# **************************************************************************** # 
def getLogicInfo(ssh):
    i = 0
    cliRet1 = ssh.execCmd("show storage_pool general")
    cliRet = cliRet1
    list = cliRet1.splitlines()
    for field1 in list:
        i = i+1
        if i > 4:
            list1 = field1.split()
            if len(list1)<1:
                continue
            
            #Find to the end
            if("admin:/>" == list1[0]):
                break
            
            if("ID" == list1[0]) or ("--" == list1[0]):
                continue

            #Find right lines and show each POOL_ID
            if(len(list1)>=6):
                cliRet2 = ssh.execCmd("show storage_pool tier pool_id=" + str(list1[0]))
                cliRet = cliRet + cliRet2
    return cliRet

# **************************************************************************** #
# 函数名称: createBasicFile
# 功能说明: 创建子文件夹并保存信息
# 输入参数: devObj，sysInfoStr
# 输出参数: fileBaseDir（创建文件路径），diskPhysicInfo（硬盘物理信息回文）
# **************************************************************************** # 
def createBasicFile(devObj, sysInfoStr):
    
    ssh = devObj.get("SSH")
    lang = devObj.get("lang")
    logger = devObj.get("logger")
    ipAddr = devObj.get("devIp")
    
    fileBaseDir = devObj.get("collectRetDir")+os.path.sep+"temp"+os.path.sep
    subFileDir = fileBaseDir + "disksmartinfo"

    logger.info("[Smart Info] Create fileBaseDir is :" + fileBaseDir)
    if not os.path.exists(subFileDir):
        try:
            os.makedirs(subFileDir)
        except:
            logger.error("[Smart Info] Failed to create directory")
            if lang == "zh":
                devObj["py_detail"] = u"创建disksmartinfo文件夹失败。"
            else:
                devObj["py_detail"] = "Failed to create disksmartinfo directory." 
            return (None, None)
    devObj['SmartInfoDir'] = subFileDir

    #保存系统基本信息
    basicInfoStr = ""
    basicInfoStr += "smart analyzelog device ip:" + ipAddr + G_INFORMATION_SPLIT_STR
    basicInfoStr += sysInfoStr + G_INFORMATION_SPLIT_STR
    basicInfoStr += getLogicInfo(ssh) + G_INFORMATION_SPLIT_STR
    diskPhysicInfo = ssh.execCmd("show disk general |filterColumn include columnList=ID,Health\sStatus,Running\sStatus,Type,Capacity,Role,Disk\sDomain\sID,Speed(RPM),Health\sMark,Manufacturer,Serial\sNumber")
    cmdValid = modelManager.hasCliExecPrivilege(diskPhysicInfo)
    #部分版本CLI命令columnList存在拼写问题，需要适配
    if not cmdValid:
        diskPhysicInfo = ssh.execCmd("show disk general |filterColumn include colunmList=ID,Health\sStatus,Running\sStatus,Type,Capacity,Role,Disk\sDomain\sID,Speed(RPM),Health\sMark,Manufacturer,Serial\sNumber")
    basicInfoStr += diskPhysicInfo + G_INFORMATION_SPLIT_STR
    try:
        #获取硬盘DHA信息
        diskSnDhaInfo = {}
        dictList = cli.getCliTable2DictList(diskPhysicInfo)
        for info in dictList:
            SN = info.get("Serial Number")
            healthMark = info.get("Health Mark","N\A")
            dha = "\r\nStart Health Mark\r\nHealth Mark For DHA : %s\r" % str(healthMark)
            if SN:
                diskSnDhaInfo.setdefault(SN,dha)
        devObj["diskSnDhaInfo"] = diskSnDhaInfo
    except:
        diskSnDhaInfo = {}
        devObj["diskSnDhaInfo"] = diskSnDhaInfo
        logger.error("get DHA info filed !")
    
    sysBasicInfoFile = subFileDir + os.sep + "basicinfo.txt"
    flag = commonFileWrite(sysBasicInfoFile, basicInfoStr, False, logger)
    if not flag:    
        #删除总收集文件夹
        try:
            shutil.rmtree(fileBaseDir, True)
        except:
            logger.error("remove file filed !")
        finally:
            logger.error("[Smart Info] Collecting failed, the reason is: Create basic file failed!") 
            if lang == "zh":
                devObj["py_detail"] = u"创建basicinfo.txt文件失败。"
            else:
                devObj["py_detail"] = "Creating basicinfo.txt file failed." 
            return (None, None)
    
    diskIdList = getDiskIdList(diskPhysicInfo)
    isWritenSuc = writeDiskDetail2BasicInfo(devObj, sysBasicInfoFile, diskIdList)
    if not isWritenSuc:#只要有硬盘详细信息写入basicinfo.txt文件失败就视为失败
        if lang == "zh":
            devObj["py_detail"] = u"硬盘详细信息写入basicinfo.txt文件失败。"
        else:
            devObj["py_detail"] = "Failed to write the detail of disk information to basicinfo.txt file." 
        return (None, None)
    
    return (fileBaseDir, diskPhysicInfo)


# **************************************************************************** #
# 函数名称: writeDiskDetail2BasicInfo
# 功能说明: 根据硬盘ID获取硬盘详细信息，然后将其写入basicinfo.txt文件
# 输入参数: 设备对象，basicinfo.txt文件路径，硬盘ID列表
# 输出参数: diskIdList硬盘ID列表
# **************************************************************************** # 
def writeDiskDetail2BasicInfo(devObj, sysBasicInfoFile, diskIdList):
    ssh = devObj.get("SSH")
    logger = devObj.get("logger")
    lang = devObj.get("lang")
    
    #对每20个硬盘ID写入文件
    counter = 20
    diskDetailInfo = ""
    isWritenSuc = False
    for diskId in diskIdList:
        diskDetailInfo += ssh.execCmdNoLog("show disk general disk_id=" + diskId) + G_INFORMATION_SPLIT_STR
        --counter
        if 0 == counter:
            isWritenSuc = commonFileWrite(sysBasicInfoFile, diskDetailInfo, True, logger)
            #只要有文件写入失败就返回
            if not isWritenSuc:
                return isWritenSuc
            #重新初始化变量
            counter = 20
            diskDetailInfo = ""
            
    #将剩余内容（如果有的话）写入文件
    if "" != diskDetailInfo:
        isWritenSuc = commonFileWrite(sysBasicInfoFile, diskDetailInfo, True, logger)
        
    return isWritenSuc


# **************************************************************************** #
# 函数名称: getDiskIdList
# 功能说明: 获取硬盘ID列表
# 输入参数: diskPhysicInfo(硬盘物理信息CLI回显)
# 输出参数: diskIdList硬盘ID列表
# **************************************************************************** # 
def getDiskIdList(diskPhysicInfo):
    diskIdList = []
    lineList = diskPhysicInfo.splitlines()
    #回显信息template
    """
    show disk general
    
      ID         Health Status  Running Status  Type          Capacity    Role       Disk Domain ID  Speed(RPM)  Health Mark  
      ---------  -------------  --------------  ------------  ----------  ---------  --------------  ----------  -----------  
      DAE000.0   Normal         Online          SAS            273.833GB  Free Disk  --              10000       98           
      DAE100.23  Normal         Online          SSD            185.747GB  Free Disk  --              --          --           
    admin:/>
    """
    isSwithOn = False
    for line in lineList:
        line = line.strip()
        if line.startswith("---"):
            isSwithOn = True
            continue
        elif -1 != line.find(":/>"):
            isSwithOn = False
        if isSwithOn:
            diskIdList.append(line.split()[0])
    return diskIdList


# **************************************************************************** #
# 函数名称: getDiskCounter
# 功能说明: 通过硬盘物理信息计算硬盘个数和Location的列表
# 输入参数: diskPhysicInfo(硬盘物理信息CLI回显)
# 输出参数: diskCounter（硬盘个数），diskLocationList（硬盘对应位置列表）
# **************************************************************************** # 
def getDiskCounterAndList(diskPhysicInfo):
    
    diskCounter = 0
    diskLocationList = []
    global G_DISK_PREFIX
    lineList = diskPhysicInfo.splitlines()
    i = 0
    for line in lineList: 
        i = i+1
        field = line.split()
        if -1!=line.find("successfully"):
            diskCounter=0
            break
        
        if i > 4:     
            if len(field) < 6:
                continue
        
            if -1!=line.find("show disk general") or -1!=line.find("ID") or -1!=line.find("----") or -1!=line.find("admin:"):
                continue
            
            diskCounter+=1
            location = field[0]
            diskLocationList.append(location) 
            
    return (diskCounter, diskLocationList)

# *************************************************************#
# 函数名称: commonFileWrite
# 功能说明: 文件写入操作（通用函数）
# 其 他   :  无
# *************************************************************#  
def commonFileWrite(fileName, writeInfoStr, ifAddFlag, logger):

    flag = True
    try:
        #判断是否为追加内容
        if True == ifAddFlag:
            localFile = codecs.open(fileName, "a", "utf-8")
        else:
            localFile = codecs.open(fileName, "w", "utf-8")
            
        localFile.write(writeInfoStr)
        localFile.flush()
        localFile.close()
    except Exception,e:
        logger.error("[Smart Info] Collecting failed, the reason is: Writing to file error:" + str(e))
        flag = False
    
    return flag

# **************************************************************************** #
# 函数名称: getCollectDiskList_Debug
# 功能说明: 获取需要获取Smart信息的硬盘列表（调用者保证：调用此接口前，ssh在minisystem模式下）
# 输入参数: devObj，ssh
# 输出参数: 无
# **************************************************************************** # 
def getCollectDiskList_Debug(devObj, ssh):
    
    diskInfoDict = {"location":"", "name":""}
    diskName = ""
    location = ""    
    needCollectDiskList = []
    diskLocationList = devObj["diskLocationList"]
    logger = devObj.get("logger")
    
    #查询所有硬盘信息，获取所有SAS和SATA盘的盘符列表
    temp = ssh.execCmd("sddebug show disk")
    #mark 补全合法判断
    lines = temp.splitlines()
    if len(lines) > 3:
        for line in lines[3:]:    
            lineData = line.split()
            if len(lineData) > 6:
                location = lineData[0]
                diskName = lineData[-1] 
                #过滤掉不在物理硬盘信息里面
                if location not in diskLocationList:
                    location = ""
                    
            if location != "" and diskName != "":
                if location != "sda":
                    diskInfoDict["location"] = location
                    diskInfoDict["name"] = diskName
                    #记录硬盘信息，初始化变量
                    needCollectDiskList.append(diskInfoDict)
                    diskInfoDict = {"location":"", "name":""}
                    location = ""
    
    return needCollectDiskList

# **************************************************************************** #
# 函数名称: setUiDisplayMsg
# 功能说明: 设置部分收集成功的相关状态
# 输入参数: devObj，collectFailDiskStr
# 输出参数: 无
# **************************************************************************** # 
def setUiDisplayMsg(devObj):
    
    lang = devObj.get("lang")
    logger = devObj.get("logger")
    allDiskLocationList = devObj["diskLocationList"]
    smartInfoSaveDir = devObj['SmartInfoDir']
    
    #获取全局信息
    global G_SAVE_NUM, G_TEMP_NUM, G_SUCC_NUM
    global G_COLLECT_SUC_LIST, G_COLLECT_FAIL_LIST, G_TAIL_COLLECT_INFO
    
    #没有收集成功的显示错误信息
    collectFailDiskStr = ""
    #没有执行过收集的硬盘错误信息
    noCollectDiskInfoStr = "" 

    for location in allDiskLocationList:
        #没有收集成功的硬盘
        if location not in G_COLLECT_SUC_LIST:
            collectFailDiskStr += location + "," 
            #没有执行过收集的硬盘
            if location not in G_COLLECT_FAIL_LIST:
                noCollectDiskInfoStr += "Disk " + location + " has not been collected, collecting smart information failed!" + G_INFORMATION_SPLIT_STR

    #部分收集成功
    if collectFailDiskStr != "":
        #去除字符串最后的分隔符
        collectFailDiskStr = collectFailDiskStr[0:-1]
        
        logger.error("[Smart Info] Collecting partly successful, end!")
        #设置返回信息
        if lang == "zh":
            errMsg = u"硬盘（" + collectFailDiskStr + u"）收集Smart失败，请按照如下建议处理：\
            \n（1）收集失败的原因可能是：硬盘单链路、响应慢、故障或者休眠。请先按照标准处理方法修复，修复完成后重新收集一次；\
            \n（2）如果仍然收集失败，请尝试手动执行命令收集单块硬盘；\
            \n（3）如果有任何疑问，请联系技术支持工程师协助处理。"
        else:
            errMsg = "Collecting smart information of disks (" + collectFailDiskStr + " ) failed, please handle them according to the suggestion:\
            \n(1)The reason of failure may be: the disk is single path, the response of disk is slow, the disk is fault or in spin down status. Please repair it according to the standard treatment, then collect again;\
            \n(2)If collecting failed again, please try to collect the smart information manually;\
            \n(3)If you have any questions, please contact technical support engineers for further handling."
            
        #设置部分收集成功
        devObj["collectAllInfo"] = False
        devObj["py_detail"] = errMsg
    else:
        logger.info("[Smart Info] Collecting successful, end!")
        devObj["collectAllInfo"] = True
        
    #如果存在收集失败的盘，写入failsmart.txt文件
    if noCollectDiskInfoStr:
        fileName = smartInfoSaveDir + os.sep + "failsmart.txt"
        flag = commonFileWrite(fileName, noCollectDiskInfoStr, False, logger)
        if not flag:
            return False
    
    return True
        

# **************************************************************************** #
# 函数名称: minisystemModelCollect(devObj, ssh, nodeName)
# 功能说明: 查询当前控制器下的硬盘Smart信息（minisystem模式下）
# 输入参数: devObj, ssh, nodeName
# 输出参数: 无
# **************************************************************************** # 
def minisystemModelCollect(devObj, ssh, nodeName):
    
    #获取脚本中指定的全局变量
    global G_SAVE_NUM, G_TEMP_NUM, G_SUCC_NUM
    global G_COLLECT_SUC_LIST, G_COLLECT_FAIL_LIST, G_TAIL_COLLECT_INFO
    
    #获取全局信息
    lang = devObj.get("lang")
    logger = devObj.get("logger")
    smartInfoSaveDir = devObj['SmartInfoDir']
    
    #收集成功的Smart信息
    diskSmartInfoStr = ""
    #收集失败的Smart信息
    collectFailSmartINfoStr = ""
     
    needCollectDiskList = getCollectDiskList_Debug(devObj,ssh)
    
    if not needCollectDiskList:
        return False
    
    #切换回developer模式
    modelManager.changeDebug2Developer(ssh)
        
    modelManager.changeDeveloper2Minisystem(ssh)

    diskName = ""
    diskLocation = ""
    
    for diskInfoTmp in needCollectDiskList:
#       #获取硬盘信息
        diskName = diskInfoTmp["name"]
        diskLocation = diskInfoTmp["location"]

        #盘符为空，则直接将此硬盘设定为收集失败
        if not diskName:
            #收集失败，需要将location写入失败列表
            G_COLLECT_FAIL_LIST.append(diskLocation)
            
            diskInfoStrTmp = "Disk " + diskLocation + " has no name, collecting smart information failed!"
            collectFailSmartINfoStr += diskInfoStrTmp + G_INFORMATION_SPLIT_STR
            continue

        #盘符不为空，继续收集
        diskInfoStrTmp = ssh.execCmdNoLog("disktool -f a /dev/" + diskName)
        #判断收集是否成功。因硬盘健康分析需使用Device Model做分隔，所以必须判断此字段存在，否则可能导致分析数据错位。
        if re.search("Serial Number", diskInfoStrTmp, re.IGNORECASE) and "Device Model" in diskInfoStrTmp:
            G_TEMP_NUM += 1
            G_SUCC_NUM += 1
            #收集成功
            G_COLLECT_SUC_LIST.append(diskLocation)
            #根据SN号获取DHA信息
            lineList = diskInfoStrTmp.splitlines()
            for line in lineList:
                if "Serial Number:" in line:
                    SN = line.split(":")[1].strip()
                    break
            diskSnDhaInfo = devObj["diskSnDhaInfo"]
            dha = diskSnDhaInfo.get(SN,"\r\nStart Health Mark\r\nHealth Mark For DHA : N\A")
            G_TAIL_COLLECT_INFO += diskInfoStrTmp + dha + G_INFORMATION_SPLIT_STR
        else:
            #收集失败，需要将location写入失败列表
            G_COLLECT_FAIL_LIST.append(diskLocation)
            
            collectFailSmartINfoStr += diskInfoStrTmp + G_INFORMATION_SPLIT_STR

        #每收集20块盘，保存一份文件
        if G_TEMP_NUM >= CollectDiskInfo_MAXCounter:
            
            #新建文件，保存smart信息
            fileName = smartInfoSaveDir + os.sep + "smart" + str(G_SAVE_NUM) + ".txt"
            flag = commonFileWrite(fileName, G_TAIL_COLLECT_INFO, False, logger)
            #重置信息
            G_TAIL_COLLECT_INFO = ""
            if not flag:
                return False
            
            logger.info("[Smart Info] Collect 20 disks and write the result to the new file:" + fileName)
        
            #计数加一，变量清空
            G_SAVE_NUM += 1
            G_TEMP_NUM = 0

    #如果存在收集失败的盘，写入failsmart.txt文件
    if collectFailSmartINfoStr != "":
        fileName = smartInfoSaveDir + os.sep + "failsmart.txt"
        flag = commonFileWrite(fileName, collectFailSmartINfoStr, False, logger)
        if not flag:
            return False

    #正确返回
    return True

# **************************************************************************** #
# 函数名称: collectSmartByIp(devObj, ssh, nodeName)
# 功能说明: 工具登录为阵列Ip时收集，SSH连接可以直接从devObj中获取
# 输入参数: devObj：框架原始的连接信息；ssh：具体针对结点nodeName创建的某一个IP连接
#           用完后需要释放
# 输出参数: 无
# **************************************************************************** #
def collectSmartByIp(devObj, ssh, nodeName):
    logger = devObj.get("logger")
    lang = devObj.get("lang")
    
    #切换到developer模式下
    logger.info("[Smart Info] Begin to changing to developer model!")
    flag = modelManager.changeCli2Developer(devObj, ssh)
    #切换到developer模式失败，直接返回
    if not flag:
        logger.error("[Smart Info] Collecting failed, the reason is: Login to developer model failed!")
        if lang == "zh":
            devObj["py_detail"] = u"进入developer模式失败，smart信息收集失败。失败的原因可能为：\n" \
                    + u"（1）添加设备时未输入developer密码。\n（2）添加设备时输入的developer密码无效。"
        else:
            devObj["py_detail"] = "Login to developer model failed, can not collect disk smart information.The reason of failure may be:\n" \
                    + "(1) Did not enter a developer password when adding the device.\n(2) The developer password entered is incorrect."
        return False
    
    #通过showdiskinfo命令获取硬盘盘符列表
    logger.info("[Smart Info] Begin to getting disk info in debug mode!")
    #进debug查询信息
    ret = modelManager.changeDeveloper2Debug(ssh)
    if not ret:
        logger.info("[Smart Info] Begin to debug failed!")
        if lang == "zh":
            devObj["py_detail"] = u"进入debug模式失败。"
        else:
            devObj["py_detail"] = "Login to debug model failed."
        return False
    
    #Minisystem下开始收集
    logger.info("[Smart Info] Begin to collecting smart info!")
    if not minisystemModelCollect(devObj, ssh, nodeName):
        logger.error("[Smart Info] Collecting failed, the reason is: execute collecting failed!")
        #设置返回信息
        if lang == "zh":
            devObj["py_detail"] = u"在minisystem模式下收集硬盘Smart信息失败。"
        else:
            devObj["py_detail"] = "Collecting disk smart information failed by minisystem model!"  
            
        # added 20140605 begin
        modelManager.changeAnyModel2Cli(ssh)
        # added 20140605 end
        return False
    
    #切回CLI模式
    logger.info("[Smart Info] Collecting smart info (storage) finished, back to cli model!")
    modelManager.changeAnyModel2Cli(ssh)
    return True

# **************************************************************************** #
# 函数名称: execute(devObj)
# 功能说明: 脚本执行入口
# 输入参数: devObj为原始连接
# 输出参数: 无
# **************************************************************************** # 
def execute(devObj):
    
    try: 
        suffix2 = "V200R002C00B020"
        suffix3 = "V200R002C00SPC100" 
        flag =True
        
        global G_SAVE_NUM, G_TEMP_NUM, G_SUCC_NUM
        global G_COLLECT_SUC_LIST, G_COLLECT_FAIL_LIST, G_TAIL_COLLECT_INFO
        
        G_SAVE_NUM = 0
        G_TEMP_NUM = 0
        G_SUCC_NUM =0
        
        ssh = devObj.get("SSH")
        lang = devObj.get("lang")
        logger = devObj.get("logger")
        userName = devObj.get("username")
        loginIp = devObj.get("devIp")
            
        #初始化smart收集状态标志，在execute函数返回值为True的前提下，设置为True为成功，False为部分收集成功
        devObj["collectAllInfo"] = True
                
        #系统是否正常
        logger.info("[Smart Info] Begin to checking system status!")
        iRet = isSysNormal(devObj, ssh)
        sysStats = iRet[0]
        sysInfoStr = iRet[1]
        if not sysStats:
            return False
        
        devsion = getVersion(ssh)
        logger.info("device version:" + devsion)
        #版本判断
        if devsion.endswith(suffix2) or devsion.endswith(suffix3) or devsion == "":
            if lang == "zh":
               devObj["py_detail"] = u"设备版本不支持Smart收集。"
            else:
               devObj["py_detail"] = "The device version does not support smart information collection."  
            return False
        
        #判断用户是否为admin用户
        logger.info("[Smart Info] Begin to checking login name!")
        if not isSuperUser(devObj, userName):
            return False

        #创建子文件夹并保存信息
        logger.info("[Smart Info] Begin to creating system basic information file!")
        iRet = createBasicFile(devObj,sysInfoStr)
        fileBaseDir = iRet[0]
        diskPhysicInfo = iRet[1]
        if None == fileBaseDir:
            return False
        
        #通过硬盘物理信息计算硬盘数
        logger.info("[Smart Info] Begin to getting disk list info!")
        iRet = getDiskCounterAndList(diskPhysicInfo)
        diskCounter = iRet[0]
        #保存供后续使用
        devObj["diskLocationList"] = iRet[1]

        logger.info("[Smart Info] Getting disk number by disk physic information:" + str(diskCounter))
        if not diskSatisfyMinNum(devObj, diskCounter, fileBaseDir):
            return False
        
        #记录硬盘总个数
        devObj["TotalDiskNumber"] = diskCounter
        
        logger.info("[Smart Info] Begin to collecting smart information (Storage)!")

        #调用获取IP接口
        ipInfoList = modelManager.getIpList(ssh) 
        if not ipInfoList:
            logger.error("[Smart Info] get Ip List failed!")
            #设置返回信息
            if lang == "zh":
                devObj["py_detail"] = u"获取设备IP失败。"
            else:
                devObj["py_detail"] = "Failed to get the controller IP."  
            return False
        
        nodeCreateSshSuc = False
        for nodeIpDir in ipInfoList:
            nodeCreateSshSuc = False
            nodeName = nodeIpDir["node"]
            #循环一个结点所有的IP地址，任意一个创建成功即在该结点上面收集
            for ipAddr in nodeIpDir["ipList"]:
                
                if loginIp in nodeIpDir["ipList"]:
                    nodeCreateSshSuc = True
                    collectSmartByIp(devObj, ssh, nodeName)
                    break
                else:
                    sshTmp = createSSHConnection(devObj, ipAddr)
                
                    #创建不成功，继续连接下一个IP
                    if not sshTmp:
                        continue
    
                    #创建成功，开始收集本节点数据
                    nodeCreateSshSuc = True
                    collectSmartByIp(devObj, sshTmp, nodeName)
                    break
                    #收集成功，关闭临时连接
                    sshTmp.close()
                    break
            
            #本节点所有ip全部连接失败
            if not nodeCreateSshSuc:
                #此结点无法连接，请检查网线是否插好等，此结点收集失败
                pass
        
        #是否收集失败
        if G_SUCC_NUM == 0:
            logger.error("The number of disks successfully collected is 0, Error!")
            return False  
        
        #处理遗留信息
        flag = writeTailSmartInfo(devObj)
        if not flag:
            logger.error("Write tail smart info failed, Error!")
            return False  
        
        #处理summary文件
        flag = writeSummaryFile(devObj)
        if not flag:
            logger.error("Write summary info failed, Error!")
            return False
        
        #设置最终界面显示结果
        if not setUiDisplayMsg(devObj):
            logger.error("Set UI display information failed, Error!")
            return False        
        
        #正常返回
        return True
        
    except:
        if lang == "zh":
            devObj["py_detail"] = u"收集硬盘Smart信息失败。"
        else:
            devObj["py_detail"] = "Failed to collect hard disk smart information."
        logger.error("[Smart info] catch except:" + traceback.format_exc())
        return False

# **************************************************************************** #
# 函数名称: writeSummaryFile
# 功能说明: 收集流程结束，保存summary文件
# 输入参数: devObj
# 输出参数: 无
# **************************************************************************** # 
def writeSummaryFile(devObj):

    smartInfoSaveDir = devObj['SmartInfoDir']
    logger = devObj.get("logger")
    
    #获取脚本中指定的全局变量
    global G_SAVE_NUM, G_TEMP_NUM, G_SUCC_NUM
    global G_COLLECT_SUC_LIST, G_COLLECT_FAIL_LIST, G_TAIL_COLLECT_INFO
    
    #summary.ini文件操作变量
    configFileName = smartInfoSaveDir + os.sep + "summary.ini"
    configDataStr = ""
    physicDiskCounter = devObj["TotalDiskNumber"]        
          
    configDataStr += "total=" + str(physicDiskCounter) + "\n"

    #记录成功数到信息增加
    configDataStr += "success=" + str(G_SUCC_NUM) + "\n"
    
    #记录收集完成时间
    curTime = time.strftime('%Y-%m-%d %H:%M:%S',time.localtime(time.time()))
    configDataStr += "date=" + str(curTime) + "\n"

    #设置过程信息
    indexInfoStr = ""
    for index in range(G_SAVE_NUM):
        
        #获取开始index和结束index
        startIndex = index * CollectDiskInfo_MAXCounter
        if index + 1 == G_SAVE_NUM:
            endIndex = G_SUCC_NUM - 1           
        else:
            endIndex = startIndex + CollectDiskInfo_MAXCounter - 1
        #设置index描述信息
        indexInfoStr += "smart" + str(index) + "=" + str(startIndex) + "-" + str(endIndex) + "\n"

    #将所有的信息写入summary.ini
    configDataStr += indexInfoStr
    flag = commonFileWrite(configFileName, configDataStr, False, logger)
    if not flag:
        return False
    
    return True

# **************************************************************************** #
# 函数名称: writeTailSmartInfo
# 功能说明: 将遗留未写入文件的最终写入smart文件中
# 输入参数: devObj
# 输出参数: 无
# **************************************************************************** # 
def writeTailSmartInfo(devObj):

    smartInfoSaveDir = devObj['SmartInfoDir']
    logger = devObj.get("logger")
    
    #获取脚本中指定的全局变量
    global G_SAVE_NUM, G_TEMP_NUM, G_SUCC_NUM
    global G_COLLECT_SUC_LIST, G_COLLECT_FAIL_LIST, G_TAIL_COLLECT_INFO
    
    #summary.ini文件操作变量
    configFileName = smartInfoSaveDir + os.sep + "summary.ini"

    #不满20块盘，则最终收集写入文件
    if G_TAIL_COLLECT_INFO:
        #新建文件，保存smart信息
        fileName = smartInfoSaveDir + os.sep + "smart" + str(G_SAVE_NUM) + ".txt"
        flag = commonFileWrite(fileName, G_TAIL_COLLECT_INFO, False, logger)
        if not flag:
            return False
        
        #保存num加一
        G_SAVE_NUM += 1
        logger.info("[Smart Info] Collect remaining disks and write the result to the new file:" + fileName)

    return True
            
# **************************************************************************** #
# 函数名称: getVersion
# 功能说明: 脚本执行入口
# 输入参数: ssh
# 输出参数: devVersion
# **************************************************************************** # 
def getVersion(ssh):
    
    # IPV6无法收集问题 Begin
    devVersion = ""
    ret = ssh.execCmd("show upgrade package")
    retlines = ret.splitlines()
    if len(retlines) < 8:
        return devVersion
    
    #查询系统软件版本
    for line in retlines[5:]:
        if re.search("HotPatch Version|:/>", line, re.IGNORECASE):
            break
        devVersion = line.split()[3].strip()
        return devVersion
    # IPV6无法收集问题 End
    return devVersion

def copyDevNode(devNode):
    '''
            函数名称: copyDevNode
            功能说明: 复制DevNode对象的部分参数，创建新的DevNode对象，除IP外请不要修改其它成员变量，否则可能影响原DevNode对象的值
            输入参数: devNode
            输出参数: 无
            返 回 值: devNode    
    '''
    devTmp = DevNode()
    devTmp.setSocks5Proxy(devNode.getSocks5Proxy());
    devTmp.setIp(devNode.getIp())   
    devTmp.setPort(devNode.getPort())
    devTmp.setTlvPort(devNode.getTlvPort())
    devTmp.setLoginUser(devNode.getLoginUser())
    devTmp.setSshForwardList(devNode.getSshForwardList())
    devTmp.setDeveloperPwd(devNode.getDeveloperPwd())
    return devTmp   