# -*- coding: UTF-8 -*-
from util import log
import os
import time
SETTING_FILE_NAME = 'collect.conf'
DEFAULT_DISKLOG_INTERVAL = '60'
DISKLOG_INTERVAL_KEY = 'DiskLogCollectionInterval'

class GlobalConfigureSeekor(object):
    '''
    @summary: fetch global settings
    '''
    def __init__(self, devObj):
        '''
        :private
        @summary: entrance
        '''
        self.devObj = devObj
        self.__configure = {}
        self.__getSettingConfig()

    def __getSettingConfig(self):
        '''
        @summary: get global settings configurations file
        '''
        log.info(self.devObj, str(dir(self.devObj)))
        settingsPath = os.path.join(self.devObj.get('currentScriptPath'), '..', '..', '..', '..', '..')
        settingslocation = os.path.join(settingsPath, SETTING_FILE_NAME)
        log.info(self.devObj, "global file path: %s" % str(settingslocation))
        try:
            configFile = open(settingslocation, 'r')
            for line in configFile:
                if line and  '=' in line and line.find('#') != 0 \
                        and len(line.split('=')) == 2:
                    params = line.split('=')
                    self.__configure[params[0].strip()] = params[1].strip()
        except BaseException, excp:
            log.error(self.devObj, 'failed to parse confuration file : %s' % str(excp))

    def getConfigures(self):
        '''
        @summary getters for private attribute: __configure
        '''
        return self.__configure

    @classmethod
    def getSettingValue(cls, devObj, settingName, default = ''):
        '''
        @summary:  get disk log collection function setting: collection interval
        '''
        settingName = settingName.strip()
        settingValue = default
        log.info(devObj, "default setting of %s is %s." % (settingName, settingValue))
        seekor = GlobalConfigureSeekor(devObj)
        settings = seekor.getConfigures()
        log.info(devObj, "settings %s." % str(settings))
        if settings.get(settingName, ''):
            log.info(devObj, "found  settings on configuration file, override...")
            settingValue = settings.get(settingName)
        return settingValue

class ConfigureUtil(object):
    '''
    @summary: utils for info-collect function settings
    '''

    def __init__(self):
        '''
        @summary:  constructor
        '''

    @classmethod
    def diskLogCltSleep(cls, devObj):
        '''
        @summary:  disklog collection interval , sleep for several minutes(default 60 seconds) 
        '''

        interval = GlobalConfigureSeekor.getSettingValue(devObj, DISKLOG_INTERVAL_KEY, DEFAULT_DISKLOG_INTERVAL)
        if interval.isdigit():
            interval = int(interval)
        else:
            interval = DEFAULT_DISKLOG_INTERVAL
        log.info(devObj, "now start to sleep for %s seconds during disk log collection interval" % str(interval))
        time.sleep(int(interval))
