#coding:utf-8

from java.io import File
import time
import traceback
import modelManager
import shutil
import os
from com.huawei.ism.tool.infocollect.service import DealFileInCopressPackage
from module1 import CleanDir

G_RETRY_TIMES = 5
def get_product_pro(devObj,type):
    try:
        ssh = devObj.get("SSH")
        strCmd = "show system general"
        product_model="S5000T"
        product_sn = " 210235G"
        cliRet = ssh.execCmd(strCmd)
        list = cliRet.splitlines()
        for field in list:
            if type == "product_model":
                field = field.replace(" ", "")
                if field.find("ProductModel") != -1:
                    field = field.replace("ProductModel:", "")
                    product_model = field
                    return product_model
            if type == "product_sn":
                if field.find("SN") != -1:
                    field = field.replace(" ","")
                    field = field.replace("SN:", "")
                    product_sn = field
                    return product_sn
        return "default"
    except Exception, e:
        PY_LOGGER.error("[compress] get_product_pro catch except:"+str(e))
        result = "default"
        return result

def get_product_date():
    try:
        result = str(time.strftime('%Y%m%d%H%M%S',time.localtime(time.time())))
        return result
    except Exception, e:
        PY_LOGGER.error("[compress] catch except when get current time.~~~over!"+str(e))
        result = "20120512150000"
        return result

def write_version_file(devObj, verInfo):
    try:
        localDir = devObj.get("collectRetDir") + os.sep + "temp" + os.sep
        if not os.path.exists(localDir):
            os.mkdir(localDir)
        f = open(localDir + "DataCollect" + os.sep + "version", "w")
        
        f.write(verInfo)
        f.flush()
        f.close()
        return True
    except:
        lang = devObj.get("lang")
        if lang == "zh":
            devObj["py_detail"] = u"写版本文件失败。"
        else:
            devObj["py_detail"] = "Failed to write version to file."
        PY_LOGGER.error("[compress] catch except when write version info to file.")
        return False

def adjustSingleExportFile(devObj):
    try:
        localDir = devObj.get("collectRetDir")+os.path.sep+"temp"+os.path.sep
        curCtrlId = "default"
        masterCtrlId = "default"
        list_file = os.listdir(localDir)
        
        ssh = devObj.get("SSH")
        strCmd = "show controller general"
        cliRet = str(ssh.execCmd(strCmd))
        list_cliRet = cliRet.splitlines()
        for field in list_cliRet:
            if len(field) < 1:
                continue
            if field.find(" ") != -1:
                field = field.replace(" ", "")
            if field.startswith("Controller"):
                list_ctrl = field.split(":")
                PY_LOGGER.info("1 is:"+list_ctrl[0])
                curCtrlId = list_ctrl[1]
            if field.startswith("Role"):
                list_role = field.split(":")
                if list_role[1] in ["Primary", "Master"]:
                    masterCtrlId = curCtrlId
                    PY_LOGGER.info("master id is:"+masterCtrlId)
                    
        strCmd = "show controller ip"
        list_controller = []
        cliRet = str(ssh.execCmd(strCmd))
        list_cliRet = cliRet.splitlines()
        for field in list_cliRet:
            if len(field) < 1:
                continue
            if field.find(" ") != -1:
                field = field.replace(" ", "")
            if field.startswith("Controller"):
                list_ctrl = field.split(":")
                curCtrlId = list_ctrl[1]
            if field.startswith("IPv4Address"):
                list_ip = field.split(":")
                ctrlIp = list_ip[1]
                if curCtrlId == masterCtrlId:
                    ctrlIp = ctrlIp+"_MAIN"
                    PY_LOGGER.info("find a controller~~~"+ctrlIp)
                list_controller.append(ctrlIp)
        if 0 == len(list_controller):
            errMsg = "Failed to get controller ip, details as follows:\n" + cliRet
            PY_LOGGER.info("[compress] " + errMsg)
            devObj["py_detail"] = errMsg
            return False
        PY_LOGGER.info("all export file listed: "+str(list_controller))
        for field in list_controller:
            if os.path.exists(localDir+os.path.sep+"DataCollect") == False:
                os.mkdir(localDir+os.path.sep+"DataCollect")
            if os.path.exists(localDir+os.path.sep+"DataCollect"+os.path.sep+field) == False:
                os.mkdir(localDir+os.path.sep+"DataCollect"+os.path.sep+field)
            if os.path.exists(localDir+os.path.sep+"DataCollect"+os.path.sep+field+os.path.sep+"Event") == False:
                os.mkdir(localDir+os.path.sep+"DataCollect"+os.path.sep+field+os.path.sep+"Event")
            if os.path.exists(localDir+os.path.sep+"DataCollect"+os.path.sep+field+os.path.sep+"Config") == False:
                os.mkdir(localDir+os.path.sep+"DataCollect"+os.path.sep+field+os.path.sep+"Config")
            if os.path.exists(localDir+os.path.sep+"DataCollect"+os.path.sep+field+os.path.sep+"Other") == False:
                os.mkdir(localDir+os.path.sep+"DataCollect"+os.path.sep+field+os.path.sep+"Other")
            list_file = os.listdir(localDir)            
            for field_file in list_file:
                if field_file == "event_export.tar":
                    shutil.copy(localDir+field_file, localDir+os.path.sep+"DataCollect"+os.path.sep+field+os.path.sep+"Event"+os.path.sep)
                    continue
                if field_file == "Config.txt":
                    shutil.copy(localDir+field_file, localDir+os.path.sep+"DataCollect"+os.path.sep+field+os.path.sep+"Config"+os.path.sep)
                    continue
                if field_file == "disksmartinfo":
                    shutil.move(localDir+field_file, localDir+os.path.sep+"DataCollect"+os.path.sep+"disksmartinfo")
                    continue
                 
                try:
                    shutil.copy(localDir+field_file, localDir+os.path.sep+"DataCollect"+os.path.sep+field+os.path.sep+"Other"+os.path.sep)
                except Exception,exception:
                    PY_LOGGER.error("[compress] catch except when copy file:"+str(exception))
                    continue
                
        list_files = os.listdir(localDir)
        PY_LOGGER.info("all export file list_files: "+str(list_files))
        for list_file in list_files :
            if list_file.find("Disklog") != -1:
                shutil.move(localDir+list_file, localDir+os.path.sep+"DataCollect"+os.path.sep+"Disklog")
                continue  
        flag = write_version_file(devObj, "S5000T V200R002C00")
        if flag == False:
            PY_LOGGER.info("[compress] write version file in single mode failed.")
        list_file = os.listdir(localDir)
        for field_file in list_file:
            #删除除了DataCollect外其他所有文件
            if field_file.find("DataCollect") != -1:
                continue
            os.remove(localDir+field_file)
            
        return flag
    except:
        PY_LOGGER.error("catch except when adjust single export file")
        PY_LOGGER.error("except trace back:" + traceback.format_exc())
        lang = devObj.get("lang")
        if lang == "zh":
            devObj["py_detail"] = u"拷贝文件失败。"
        else:
            devObj["py_detail"] = "Failed to copy file."
        return False

def execute(devObj):
    lang = devObj.get("lang")
    try:
        #初始化清空
        flag_logexist = False
        devObj["py_detail"] = ""
        localDir = devObj.get("collectRetDir")+os.path.sep+"temp"+os.path.sep
        localFile_final = os.path.sep+"Data_S5000T_21035000000.tgz"
        tar_class = devObj.get("PYENGINE.PY_ZIP")
        list = os.listdir(localDir)
        PY_LOGGER.info("[compress] Local dir is:" + localDir)
        #获取设备型号和当前时间戳
        product_model = get_product_pro(devObj, "product_model")
        product_time = get_product_date()
        PY_LOGGER.info("[compress] list dir is:"+str(list))
        for field in list:
            PY_LOGGER.info("[compress] file name is:"+field)
            if field.find("Datacollect") != -1:
                PY_LOGGER.info("[compress] found log collecting outpus:"+field)
                flag_logexist = True
                if field.find(".tgz") != -1:
                    localFile_final = field.replace(".tgz", ".7z")
                    PY_LOGGER.info("[compress] final file name:"+localFile_final)
                else:
                    localFile_final = field+".7z"
                    resultRename = False
                    for index in range(0, G_RETRY_TIMES):
                        if resultRename:
                            break
                        else:
                            time.sleep(2)
                        try:
                            os.renames(localDir+field, localDir+"DataCollect")
                            resultRename = True
                            PY_LOGGER.info("[compress] finished  file rename:"+resultRename)
                        except Exception,exception:
                            PY_LOGGER.error("[compress]Rename catch except:"+str(exception))
                            continue
                localFile_final = "Data_%s_%s_%s" % (product_model.replace(" ", ""), product_time,
                                                     get_product_pro(devObj, "product_sn")) + ".7z"
                PY_LOGGER.info("[compress] Final path is:"+localFile_final)
                break
        PY_LOGGER.info("[compress] Starting moving file")
        if not flag_logexist:
            isOptSuc = adjustSingleExportFile(devObj)
            if not isOptSuc:
                return (False, "")
            localFile_final = "Data_%s_%s_%s" % (product_model.replace(" ", ""), product_time,
                                                 get_product_pro(devObj, "product_sn")) + ".7z"
        else:
            list_file_tempDir = os.listdir(localDir)
            list_file_DatacollectDir = os.listdir(localDir+"DataCollect")
            PY_LOGGER.info("[compress] Data path is:"+localDir+"DataCollect")
            for field in list_file_tempDir:
                if field.find("DataCollect") != -1:
                    continue
                if field.find("disksmartinfo") != -1:
                    shutil.move(localDir+field, localDir+os.path.sep+"DataCollect"+os.path.sep+"disksmartinfo")
                    continue
                if field.find("Disklog") != -1:
                    shutil.move(localDir+field, localDir+os.path.sep+"DataCollect"+os.path.sep+"Disklog")
                    continue        
                for field_temp in list_file_DatacollectDir:
                    
                    # 压缩文件失败 modified 20131221 Begin
                    #如果为文件，则跳过
                    if os.path.isfile(localDir + "DataCollect" + os.sep + field_temp):
                        continue
                    # 压缩文件失败 modified 20131221 End
                    if field == "event_export.tar":
                        #文件保存路径
                        saveDir = localDir+os.path.sep+"DataCollect"+os.path.sep+field_temp+os.path.sep+"Event"+os.path.sep
                        if os.path.exists(saveDir + field) == False:
                            #如果目标文件夹不存在，需要创建
                            if not os.path.exists(saveDir):
                                os.mkdir(saveDir)
                            
                            shutil.copy(localDir+field, saveDir + field)
                        continue
                    if field == "Config.txt":
                        #文件保存路径
                        saveDir = localDir+os.path.sep+"DataCollect"+os.path.sep+field_temp+os.path.sep+"Config"+os.path.sep
                        if os.path.exists(saveDir) == False:
                            #如果目标文件夹不存在，需要创建
                            if not os.path.exists(saveDir):
                                os.mkdir(saveDir)
                            
                            shutil.copy(localDir+field, saveDir + field)
                        continue
                    if os.path.exists(localDir+os.path.sep+"DataCollect"+os.path.sep+field_temp+os.path.sep+"Other"+os.path.sep+field) == False:
                        try:
                            #文件保存路径
                            saveDir = localDir+os.path.sep+"DataCollect"+os.path.sep+field_temp+os.path.sep+"Other"+os.path.sep
                            PY_LOGGER.info("[compress] saveDir:" + saveDir)
                            PY_LOGGER.info("[compress] field:"+str(field))
                            if os.path.exists(saveDir + field) == False:
                                #如果目标文件夹不存在，需要创建
                                if not os.path.exists(saveDir):
                                    os.mkdir(saveDir)
                                
                                shutil.copy(localDir+field, saveDir + field)
                        except Exception,exception:
                            PY_LOGGER.error("[compress] catch except when copy file:"+str(exception))
                            continue
                if os.path.exists(localDir+field):
                    os.remove(localDir+field)

            flag = write_version_file(devObj, "S5000T V200R002C00")
            if flag == False:
                PY_LOGGER.info("[compress] write version file in regular mode failed.")
        PY_LOGGER.info("[compress] Starting compress file, localFile_final is:"+localFile_final)
        
        #增加pkginfo文件夹
        creatPkginfo(localDir,devObj)
        
        #压缩结果文件
        finalFilePath = devObj.get("collectRetDir") + os.path.sep + localFile_final
        DealFileInCopressPackage.anonymizeTV2(localDir)
        result = tar_class.compressFile(finalFilePath, localDir)
        if not result:
            PY_LOGGER.error("[compress] Failed to compress file.")
            if 'zh' == lang:
                devObj['py_detail'] = u'压缩文件失败。'
            else:
                devObj['py_detail'] = 'Failed to compress file.'
            return (False, "")
            
        CleanDir(devObj, localDir)
        devObj["collectRetFileName"] = localFile_final
        
        return (True, "")
    except:
        PY_LOGGER.error("[compress] catch except when compress file.~~~over!")
        PY_LOGGER.error("[compress] except trace back:" + traceback.format_exc())
        if 'zh' == lang:
            devObj['py_detail'] = u'压缩文件失败。'
        else:
            devObj['py_detail'] = 'Failed to compress file.'
        return (False, "")


def creatPkginfo(rootPath,devObj):
    '''
    @summary: 创建与datacollect同级的目录pkginfo，用于表示该包是信息收集的包。
        pkginfo下有两个空文件
            type_collect: 信息收集的包
            domain_storage: 存储设备
    '''
    pkginfoPath = rootPath + os.sep + "pkginfo"
    typeFile = pkginfoPath + os.sep + "type_collect"
    domainFile = pkginfoPath + os.sep + "domain_storage"
    descFile = pkginfoPath + os.sep + "desc"
    snFmt = "deviceSN=${%s}\n"
    timeFmt = "fileCreateTime=%s"
    try:
        #如果pkginfo已存在，则需要先删除
        if os.path.exists(pkginfoPath):
            shutil.rmtree(pkginfoPath, True)
            
        os.mkdir(pkginfoPath)
        #先创建type文件，然后拷贝type并重命名为domain文件
        fileObj = open(typeFile, "w")  
        fileObj.close()
        shutil.copy(typeFile, domainFile)
        #创建Desc文件并写入SN号和时间（UTC）
        #获取SN号和时间毫秒数
        snInfo = snFmt % str(getDeviceSn(devObj))
        timeInfo = timeFmt % str(long(time.time()*1000))
        desc_file = open(descFile, "w")
        seq = [snInfo,timeInfo]
        desc_file.writelines(seq)
        desc_file.close()
        PY_LOGGER.info("[creatPkginfo] Creat the pkginfo succeed!")
    
    except:
        if os.path.exists(pkginfoPath):
            shutil.rmtree(pkginfoPath, True)   
        PY_LOGGER.error("[creatPkginfo] Creat the pkginfo failed! except trace back: " + str(traceback.format_exc()))
        
def getDeviceSn(devObj):
        '''
                    获取设备SN号
        '''
        devNode = devObj.get("devNode")
        
        if None == devNode:
            return ""
        
        sn = devNode.getDeviceSerialNumber()
        
        return sn
    