# -*- coding: UTF-8 -*-
from common.util import log
from defusedxml import ElementTree as ET
  
def parseConf(devObj, confPth):
    try: 
        tree = ET.parse(confPth)     #打开xml文档 
        root = tree.getroot()
    except Exception, e:
        log.error(devObj, "Parse disk log collect configure file exception:" + unicode(e))
        return {}
    
    confMap = {}
    for vendorTree in root.findall("vendor"): 
        vendor = vendorTree.attrib["diskVendor"]
            
        typeTree = vendorTree.findall('diskType')
        for typeNode in typeTree:
            key = (vendor.upper(), typeNode.attrib['type'].upper())
            val = []
            for confNode in typeNode.findall("conf"):
                val.append((confNode.attrib['collectCmd'], confNode.attrib['resultPth']))
            confMap[key] = val
    
    return confMap
