# -*- coding: UTF-8 -*-
import com.huawei.ism.tool.infocollect.util.DataCollectConstants as DCC
from common.cliFactory import cli
from common.util import systemMode
from common.util import util
from common.util import log
from common.util import device
from common.config import config
from common.disklogConf import disklogConf
import re

def execute(devObj):
    diskInfoCollector = DiskInfoCollector(devObj)
    return diskInfoCollector.collectDiskInfo()

    
class DiskInfoCollector():
    
    def __init__(self, devObject):
        '''
        @summary: collect disk info , including disk id| type| vendor| SN| model number| disk symbol  
        '''
        self.devObj = devObject
        log.info(self.devObj, "initiating disk query job ...")
        
    def collectDiskInfo(self):
        '''
        @summary: fetch system disk information
        @return: sysDiskNum, diskMap
        @return:  integer  , {diskId:(diskInfo, tuple)}
        '''
        try:
            util.initPyDetailMsg(self.devObj)
            isCmdSuccess = util.checkSystemNormal(self.devObj)
            if not isCmdSuccess:
                log.error(self.devObj, "qry disk info but found current system is not normal!")
                return (0, {})

            sysDiskNum, diskMap = self.getAllDiskInfo()
            log.info(self.devObj, "current device available disk counts:%s" % str(sysDiskNum))
            log.info(self.devObj, "current device info lists:%s" % str(diskMap))
            
            if not diskMap:
                diskMap = {}
                log.error(self.devObj, 'Query all disk info failed.')
                return (sysDiskNum, {})
            else:
                return sysDiskNum, diskMap
        except Exception, e:
            e = str(e)
            log.error(self.devObj, "exception occurred while processing collectDiskInfo -> DiskInfoCollector %s" % e)
            if re.match("([a-z|A-Z]+[.]+)+[a-z|A-Z]+(\|\|)(\S)+", e):
                log.info(self.devObj, "error type is known with params, sealing return message...")
                errMsg = e.split("||")[0]
                msgParam = e.split("||")[1]
                util.addPyDetailMsg(self.devObj, errMsg, msgParam)
                
            elif re.match("([a-z|A-Z]+[.]+)+[a-z|A-Z]+", e):
                log.info(self.devObj, "error type is known, sealing return message...")
                util.addPyDetailMsg(self.devObj, e)

            else:
                log.info(self.devObj, "unknown exception, using unified err message:%s" % str(e))
                util.addPyDetailMsg(self.devObj, "qry.disk.info.failed")
                
            return (0, {})
            

    def getAllDiskInfo(self):
        '''
        @summary: 
        @return: 
        '''
        cmd = "show disk general |filterColumn include columnList=Model,ID,Serial\sNumber,Manufacturer,Type,Firmware\sVersion"
        cmdCompatible = "show disk general |filterColumn include colunmList=Model,ID,Serial\sNumber,Manufacturer,Type,Firmware\sVersion"
        diskMap = {}
        diskCounts = 0
        hasSensitiveDisks = False
        try:
            log.info(self.devObj, "processing command: %s" % cmdCompatible)
            isCmdSuccess, cmdEcho = cli.executeCmdWithTimout(self.devObj, cmdCompatible, 3 * 60)
            if not isCmdSuccess or "^" in cmdEcho:
                log.info(self.devObj, "this version doesnot support this cmd: %s"%cmdCompatible)
                log.info(self.devObj, "processing command: %s"%cmd)
                isCmdSuccess, cmdEcho = cli.executeCmdWithTimout(self.devObj, cmd, 3*60)
                if not isCmdSuccess or not cmdEcho:
                    raise Exception, "qry.all.disk.ID.failed"
                
            filteredList = util.getHorizontalCliRet(self.devObj, cmdEcho)
            if not filteredList:
                raise Exception, "qry.all.disk.ID.failed"

            for diskInfo in filteredList:
                if not diskInfo.get("Firmware Version") or not diskInfo.get("ID") or not diskInfo.get("Manufacturer") or\
                 not diskInfo.get("Serial Number") or not diskInfo.get("Model") or not diskInfo.get("Type"):
                    log.info(self.devObj, "found un-handled disk info:%s" + str(diskInfo))
                    continue
                diskCounts += 1
                diskModel = diskInfo.get("Model")
                diskVendor = diskInfo.get("Manufacturer")
                firmwareVersion = diskInfo.get("Firmware Version")
                #exclude disks that log collection will influent the performance

                diskId = diskInfo.get("ID")
                diskSN = diskInfo.get("Serial Number")
                
                diskType = diskInfo.get("Type").replace(" ", "").upper()
                diskType = "NL_SAS" if diskType.upper() == 'NEARLINESAS' else diskType
                if "toshiba" == diskVendor.lower() and diskModel in disklogConf.TOSHIBA_EXCLUDE_DISK_MODEL_LIST:
                    hasSensitiveDisks = True
                    continue

                diskMap[diskId] = [diskId, diskSN, diskVendor, diskModel, "", diskType]
                log.info(self.devObj, "disk %s has info listed:%s" % (diskMap[diskId], "".join(diskMap[diskId])))
                        
            
            log.info(self.devObj, "entering into mini-system mode...")
            ret = systemMode.enterDeveloperMode(self.devObj)
            if ret == False:
                return 0, {}
            elif ret == DCC.NEED_DBG_PWD:
                return DCC.NEED_DBG_PWD, {}
                

            if not systemMode.enterDiagnoseMode(self.devObj):
                log.error(self.devObj, "failed enter into diagnose mode using debug cmd")
                return 0, {}
                
            cmd = "sddebug show disk"
            isCmdSuccess, cmdEcho = cli.executeCmdWithTimout(self.devObj, cmd, 3 * 60)
            
            if not isCmdSuccess :
                log.error(self.devObj, "running cmd sddebug but failed in parsing params")
                raise Exception, "query.disk.blkdev.failed"
            
            diskSymbolMap = {}
            cmdEchoSplitlines = cmdEcho.splitlines()
            if ("Frame" in cmdEchoSplitlines[1]) and ("Slot" in cmdEchoSplitlines[1]) and ("ID" in cmdEchoSplitlines[1]):
                #   V200R002C00SPC100
                #   Frame Slot    ID Serial Number            Size     Type Capacity Sector
                #   ----- ----    -- -------------------      ----     ---- -------- ------
                #       0   32    32 STM000183724              2.5      SSD      93G    512 
                for lines in cmdEchoSplitlines[3:]:
                    
                    lineParams = re.split("[ ]+", lines.strip())
                    if len(lineParams) < 8 :
                        continue
                    if 'NEARLINE' in lines and len(lineParams) < 9 :
                        continue
                    diskSymbolMap[lineParams[3]] = 'sd-' + str(lineParams[2]) + 'a'
            else:
                #   V200R002C00SPC200 and others version
                #    ID      SDID Serial Number             Size     Type   Capacity   Sector   BlkDev
                #---------  ---- ------------------        ----     ----   --------   ------   ------
                #    ENG0.0    64 LXYTNELN                  3.5      SAS     558G      512     sd-64a
                for lines in cmdEchoSplitlines[3:]:
                    
                    lineParams = re.split("[ ]+", lines.strip())
                    if len(lineParams) < 8 :
                        continue
                    
                    if 'NEARLINE' in lines and len(lineParams) < 9 :
                        continue
                    
                    if "sd-" in lineParams[-1].lower():
                        diskSymbolMap[lineParams[2]] = lineParams[-1]
                    
            faultDiskInfos = []
            for diskInfo in diskMap:
                if not diskSymbolMap.get(diskMap[diskInfo][1]):
                    log.warn(self.devObj, "cannot figure the symbol of the disk:" + str(diskMap[diskInfo]))
                    faultDiskInfos.append(diskInfo)
                    continue
                diskMap[diskInfo][4] = diskSymbolMap.get(diskMap[diskInfo][1])
                if diskMap[diskInfo][4] == "" :
                    log.error(self.devObj, "error occurred while fetching disk %s symbol" % str(diskMap[diskInfo][0]))
                    raise Exception, "query.disk.blkdev.failed"
                
                diskMap[diskInfo] = tuple(diskMap[diskInfo])
                
            if  len(faultDiskInfos) > 0:
                for diskInfo in faultDiskInfos:
                    del diskMap[diskInfo]
            

            log.info(self.devObj, "disk total Counts %s" % str(diskCounts))
            if hasSensitiveDisks and diskCounts == 0:
                # -2 means this zero disk fetched scenario might due to performance sensitive disk exclusion 
                diskCounts = DCC.TOO_MUCH_PERFORMANCE_SENSITIVE_DISKS

            if not diskMap:
                diskMap = {}
                diskCounts = DCC.TOO_MUCH_PERFORMANCE_SENSITIVE_DISKS if hasSensitiveDisks else 0
                log.error(self.devObj, 'Query all disk info failed.')
            systemMode.exitDiagnoseOrMinisystem(self.devObj)
            return diskCounts, diskMap
        
        except Exception, e:
            log.error(self.devObj, "Exception occurred while qrying disk info:%s" % str(e))
            raise Exception, e
        
        finally:
            if  systemMode.isInDeveloperMode(self.devObj):
                systemMode.developerMode2CliMode(self.devObj)
                   
