﻿#coding:utf-8

from java.io import File
import time
import traceback
from com.huawei.ism.tool.infocollect.service import DealFileInCopressPackage

def get_product_pro(devObj,type):
    try:
        ssh = devObj.get("SSH")
        strCmd = "show system general"
        product_model="S5000T"
        product_sn = " 210235G"
        cliRet = str(ssh.execCmd(strCmd))
        list = cliRet.splitlines()
        for field in list:
            if type == "product_model":
                field = field.replace(" ", "")
                if field.find("ProductModel") != -1:
                    field = field.replace("ProductModel:", "")
                    product_model = field
                    return product_model
            if type == "product_sn":
                if field.find("SN") != -1:
                    field = field.replace(" ","")
                    field = field.replace("SN:", "")
                    product_sn = field
                    return product_sn
        return "default"
    except:
        result = "default"
        return result

def get_product_date():
    try:
        result = str(time.strftime('%Y%m%d%H%M%S',time.localtime(time.time())))
        return result
    except:
        PY_LOGGER.info("catch except when get current time.~~~over!")
        result = "20120512150000"
        return result

def write_version_file(devObj, strCmd):
    try:
        flag = True
        localDir = devObj.get("collectRetDir")+"\\temp\\"
        if True != os.path.exists(localDir):
            os.mkdir(localDir)
        f = open(localDir+"\\DataCollect\\version", "w")
        
        f.write(strCmd)
        f.close()
        return flag
    except:
        flag = False
        PY_LOGGER.info("catch except when write elable info to file.")
        return flag

def adjustSingleExportFile(devObj):
    try:
        localDir = devObj.get("collectRetDir")+"\\temp\\"
        curCtrlId = "default"
        masterCtrlId = "default"
        list_file = os.listdir(localDir)
        
        ssh = devObj.get("SSH")
        strCmd = "show controller general"
        cliRet = str(ssh.execCmd(strCmd))
        list_cliRet = cliRet.splitlines()
        for field in list_cliRet:
            if len(field) < 1:
                continue
            if field.find(" ") != -1:
                field = field.replace(" ", "")
            if field.startswith("Controller"):
                list_ctrl = field.split(":")
                PY_LOGGER.info("1 is:"+list_ctrl[0])
                curCtrlId = list_ctrl[1]
            if field.startswith("Role"):
                list_role = field.split(":")
                if(list_role[1] == "Primary"):
                    masterCtrlId = curCtrlId
                    PY_LOGGER.info("master id is:"+masterCtrlId)
                    
        strCmd = "show controller ip"
        list_controller = []
        cliRet = str(ssh.execCmd(strCmd))
        list_cliRet = cliRet.splitlines()
        for field in list_cliRet:
            if len(field) < 1:
                continue
            if field.find(" ") != -1:
                field = field.replace(" ", "")
            if field.startswith("Controller"):
                list_ctrl = field.split(":")
                curCtrlId = list_ctrl[1]
            if field.startswith("IPv4Address"):
                list_ip = field.split(":")
                ctrlIp = list_ip[1]
                if curCtrlId == masterCtrlId:
                    ctrlIp = ctrlIp+"_MAIN"
                    PY_LOGGER.info("find a controller~~~"+ctrlIp)
                list_controller.append(ctrlIp)
        for field in list_controller:
            if os.path.exists(localDir+"\\DataCollect") == False:
                os.mkdir(localDir+"\\DataCollect")
            if os.path.exists(localDir+"\\DataCollect\\"+field) == False:
                os.mkdir(localDir+"\\DataCollect\\"+field)
            if os.path.exists(localDir+"\\DataCollect\\"+field+"\\Event") == False:
                os.mkdir(localDir+"\\DataCollect\\"+field+"\\Event")
            if os.path.exists(localDir+"\\DataCollect\\"+field+"\\Config") == False:
                os.mkdir(localDir+"\\DataCollect\\"+field+"\\Config")
            if os.path.exists(localDir+"\\DataCollect\\"+field+"\\Other") == False:
                os.mkdir(localDir+"\\DataCollect\\"+field+"\\Other")
            for field_file in list_file:
                if field_file == "event_export.tar":
                    shutil.copy(localDir+field_file, localDir+"\\DataCollect\\"+field+"\\Event\\")
                    continue
                if field_file == "Config.txt":
                    shutil.copy(localDir+field_file, localDir+"\\DataCollect\\"+field+"\\Config\\")
                    continue
                shutil.copy(localDir+field_file, localDir+"\\DataCollect\\"+field+"\\Other\\")

        vers = str(devObj.get("devNode").getDeviceType()) + " " + str(devObj.get("devNode").getProductVersion())
        flag = write_version_file(devObj, vers)
        if flag == False:
            PY_LOGGER.info("write version file in single mode failed.")

        for field_file in list_file:
            os.remove(localDir+field_file)
            
        return True
    except Exception, exception:
        PY_LOGGER.info("catch except when adjust single export file")
        PY_LOGGER.info("except arguement:"+str(exception.args)+"~~~over!")
        PY_LOGGER.info("except messages:"+str(exception))
        PY_LOGGER.info("except trace back:"+str(traceback.print_exc()))
        devObj["py_detail"] = "catch except when adjust single export file"
        return False

def execute(devObj):
    try:
        localDir = devObj.get("collectRetDir")+"\\temp\\"
        flag_logexist = False
        localFile_final = "\\Datacollect_S5000T_21035000000.tgz"
        tar_class = devObj.get("PYENGINE.PY_ZIP")
        list = os.listdir(localDir)
        for field in list:
            PY_LOGGER.info("file name is:"+field)
            if field.find("Datacollect") != -1:
                PY_LOGGER.info("name is:"+field)
                flag_logexist = True
                if field.find(".tgz") != -1:
                    localFile_final = field.replace(".tgz", ".7z")
                else:
                    localFile_final = field+".7z"
                    os.renames(localDir+field, localDir+"DataCollect")
                PY_LOGGER.info("path is:"+localFile_final)
                break
        if flag_logexist == False:
            adjustSingleExportFile(devObj)
            product_model = get_product_pro(devObj, "product_model")
            product_sn = get_product_pro(devObj, "product_sn")
            product_time = get_product_date()
            localFile_final = "Datacollect_"+product_model+"_"+product_sn+"_"+product_time+".7z"
            PY_LOGGER.info("tar file is:"+localFile_final)
        else:
            list_file_tempDir = os.listdir(localDir)
            list_file_DatacollectDir = os.listdir(localDir+"DataCollect")
            for field in list_file_tempDir:
                if field.find("DataCollect") != -1:
                    continue
                for field_temp in list_file_DatacollectDir:
                    
                    
                    #如果为文件，则跳过
                    if os.path.isfile(localDir + "DataCollect" + os.sep + field_temp):
                        continue
                    
                        
                    if field == "event_export.tar":
                        if os.path.exists(localDir+"\\DataCollect\\"+field_temp+"\\Event\\"+field) == False:
                            shutil.copy(localDir+field, localDir+"\\DataCollect\\"+field_temp+"\\Event\\")
                            continue
                    if field == "Config.txt":
                        if os.path.exists(localDir+"\\DataCollect\\"+field_temp+"\\Config\\"+field) == False:
                            shutil.copy(localDir+field, localDir+"\\DataCollect\\"+field_temp+"\\Config\\")
                            continue
                    if os.path.exists(localDir+"\\DataCollect\\"+field_temp+"\\Other\\"+field) == False:
                        shutil.copy(localDir+field, localDir+"\\DataCollect\\"+field_temp+"\\Other\\")
                os.remove(localDir+field)

            vers = str(devObj.get("devNode").getDeviceType()) + " " + str(devObj.get("devNode").getProductVersion())
            flag = write_version_file(devObj, vers)
            if flag == False:
                PY_LOGGER.info("write version file in regular mode failed.")
            
            #添加svp日志到日志收集包中
            if (os.path.exists("c:\\Huawei\\ISM\\bin\\collectLog\\svplog.zip")):
                shutil.move("c:\\Huawei\\ISM\\bin\\collectLog\\svplog.zip",localDir+os.path.sep+"DataCollect"+os.path.sep+"svplog.zip")    
        
        DealFileInCopressPackage.anonymizeTV2(localDir)
        result = tar_class.compressFile(devObj.get("collectRetDir") + "\\" + localFile_final, localDir)
        CleanDir(devObj, localDir)
        devObj["collectRetFileName"] = localFile_final

        return (True, "")
    except Exception, exception:
        PY_LOGGER.info("catch except when compress file.~~~over!")
        PY_LOGGER.info("except arguement:"+str(exception.args)+"~~~over!")
        PY_LOGGER.info("except messages:"+str(exception))
        PY_LOGGER.info("except trace back:"+str(traceback.print_exc()))
        devObj["py_detail"] = "catch except when compress file.~~~over!"
        return (False, "")
