# -*- coding: UTF-8 -*-
import os
import traceback

from java.lang import Exception as JException

from run_collect import get_local_dir
from util import clean_dir


def execute(dev_obj):
    try:
        local_dir = dev_obj.get("collectRetDir")
        zip_file = local_dir + os.path.sep + dev_obj.get("collectRetFileName")
        collect_dir = get_local_dir(dev_obj)
        tar_class = dev_obj.get("PYENGINE.PY_ZIP")
        res = tar_class.compressFile(zip_file, collect_dir)
        if res == 1:
            clean_dir(collect_dir)
        return True, ""
    except (Exception, JException):
        dev_obj.get("logger").error(dev_obj, str(traceback.format_exc()))
        return False, ""
