# -*- coding: UTF-8 -*-
import os
import stat
import traceback
import time

from java.lang import Exception as JException

from util import Util
from config import COLLECT_CMD


MORE_END_STRING = "\n  ---- More ----"
OS_OPEN_FLAGS = os.O_WRONLY | os.O_CREAT | os.O_TRUNC  # 写 | 创建并打开 | 截断
OS_OPEN_MODES = stat.S_IWUSR | stat.S_IRUSR  # 拥有者具有读写权限


def execute(dev_obj):
    """
    交换机信息收集
    :param dev_obj: 设备对象
    :return: 是否成功，提示信息
    """
    return DeviceCollect(dev_obj).run_collect()


def get_local_dir(dev_obj):
    local_dir = os.path.join(dev_obj.get("collectRetDir"), "collect_info")
    if not os.path.exists(local_dir):
        os.mkdir(local_dir)
    return local_dir


class DeviceCollect(object):
    """设备信息收集"""

    def __init__(self, dev_obj):
        self.dev_obj = dev_obj
        self.logger = dev_obj.get("logger")
        self.ssh = dev_obj.get("SSH")

    def exec_cmd(self, cmd):
        return self.ssh.execCmdWithTimout(cmd, 10)

    def exec_display_switch_info(self, cmd):
        res = self.exec_cmd(cmd)
        cli_ret = res

        start_time = time.time()
        added_progress = 0
        while res.endswith(MORE_END_STRING):
            used_minute = (time.time() - start_time) // 60
            if used_minute > added_progress:
                # 每分钟进度条加1
                Util.refresh_progress_by_add(
                    self.dev_obj, used_minute - added_progress)
                added_progress = used_minute
            if used_minute > 5:   # 设置5分钟超时时间
                self.exec_cmd("#")
                self.exec_cmd("#")
                res += "\n[ERROR]: TIME OUT!\n\n"
                break
            res = self.exec_cmd(" ")
            cli_ret += res

        return cli_ret.replace(
            MORE_END_STRING, "\n"
        ).replace(
            "[16D                [16D", ""
        )       # 有more情况的特殊字符串清理

    def _run_collect(self):
        file_path = get_local_dir(self.dev_obj) + os.path.sep + "data.txt"
        i_process = 80.0 / len(COLLECT_CMD)
        with os.fdopen(os.open(file_path, OS_OPEN_FLAGS, OS_OPEN_MODES), 'w') as f:
            for cmd in COLLECT_CMD:
                cli_ret = self.exec_display_switch_info(cmd)
                f.write(cli_ret)
                Util.refresh_progress_by_add(self.dev_obj, i_process)

        Util.refresh_progress(self.dev_obj, 95)
        return True, ""

    def run_collect(self):
        try:
            return self._run_collect()
        except (Exception, JException):
            self.logger.error(self.dev_obj, str(traceback.format_exc()))
            return False, ""
        finally:
            Util.refresh_progress(self.dev_obj, 100)
