# -*- coding: UTF-8 -*-
import os
import stat
import shutil
import traceback

from com.huawei.ism.tool.obase.exception import ToolException
from cbb.frame.util.common import wrapAllExceptionLogged


class Util(object):

    @classmethod
    def get_current_progress(cls, dev_obj):
        """
        @summary: 获取信息收集当前进度
        """
        observer = dev_obj.get("progressObserver")
        try:
            if observer is not None:
                return observer.getCurrentProgress()
        except (Exception, ToolException):
            dev_obj.get("logger").error(str(traceback.format_exc()))
        return 0

    @classmethod
    def refresh_progress_by_add(cls, dev_obj, percent_number, max_number=99):
        """
        @summary: 叠加刷新当前进度
        """
        cur = cls.get_current_progress(dev_obj)
        total = cur + max(1, int(percent_number))
        if 0 < total <= max_number:
            cls.refresh_progress(
                dev_obj,
                total
            )

    @classmethod
    def refresh_progress(cls, dev_obj, percentNumber):
        """
        @summary: 设置信息收集当前进度
        """
        observer = dev_obj.get("progressObserver")
        try:
            cur = cls.get_current_progress(dev_obj)
            set_num = int(percentNumber)
            if set_num < cur:
                return
            if observer is not None:
                observer.updateProgress(set_num, None)
        except (Exception, ToolException):
            dev_obj.get("logger").error(str(traceback.format_exc()))


def clean_dir(dir_path):
    """
    @summary: 根据路径，删除路径
    @param dir_path: devObj=上下文对象，dir=路径
    @return: True or False
    """
    # 增加可删除权限。产品安全整改，降低了压缩包权限为440，工具无法删除
    add_permission(dir_path)

    if not os.path.exists(dir_path):
        return True

    if not os.path.isdir(dir_path):
        return False

    shutil.rmtree(dir_path, True)
    return True


@wrapAllExceptionLogged(logger=None)
def add_permission(dir_path):
    """
    递归增加目标目录下所有权限
    :param dir_path:
    :return:
    """
    if os.path.isdir(dir_path):
        file_dir_list = os.listdir(dir_path)
        # 开始解压缩迭代及写入硬盘信息
        for file_dir in file_dir_list:
            file_path = os.path.join(dir_path, file_dir)
            add_permission(file_path)
    else:
        os.chmod(dir_path, stat.S_IWRITE)
