﻿#coding:utf-8

from java.io import File
import time
import traceback
from com.huawei.ism.tool.infocollect.service import DealFileInCopressPackage

'''
获取设备的类型或产品的SN号，如S5600T   SN:210235G7J210E1000006
参数：type
若type = product_model，则获取设备型号
若type = product_sn，则获取产品SN号

返回：根据传入的参数，返回不同的值
若没有找到，则返回默认值：“default”

'''
def get_product_pro(devObj,type):
    try:
        ssh = devObj.get("SSH")
        strCmd = "show system general"
        product_model=""
        product_sn = ""
        cliRet = str(ssh.execCmd(strCmd))
        list = cliRet.splitlines()
        for field in list:
            if type == "product_model":
                field = field.replace(" ", "")
                if field.find("ProductModel") != -1:
                    field = field.replace("ProductModel:", "")
                    product_model = field
                    return product_model
            if type == "product_sn":
                if field.find("SN") != -1:
                    field = field.replace(" ","")
                    field = field.replace("SN:", "")
                    product_sn = field
                    return product_sn
                
        return "default"
    except:
        result = "default"
        return result

'''
获取当前系统时间
'''
def get_product_date():
    try:
        result = str(time.strftime('%Y%m%d%H%M%S',time.localtime(time.time())))
        return result
    except:
        PY_LOGGER.error("catch except when get current time.~~~over!")
        result = "20120512150000"
        return result

'''
填写当前设备的版本信息和型号，写入路径：信息收集目录   + “\\DataCollect\\version”
strCmd ： 传入的设备型号和版本信息的字符串
返回：True or False
表示是否写入成功
'''
def write_version_file(devObj, strCmd):
    try:
        flag = True
        localDir = devObj.get("collectRetDir")+"\\temp\\"
        if True != os.path.exists(localDir):
            os.mkdir(localDir)
        f = open(localDir+"\\DataCollect\\version", "w")
        
        f.write(strCmd)
        f.close()
        return flag
    except:
        flag = False
        PY_LOGGER.error("catch except when write elable info to file.")
        return flag

'''

若没有收集到日志信息，或用户没有收集日志信息

整理每个控制中收集回来的信息：

1、收集信息的根目录： DataCollect 

2、以每个阵列的IP地址作为名称创建文件夹，主控文件夹名称为（IP+“_MAIN”）

3、在 2 中创建的文件夹中的结构是包含：Event、Config、Other三个文件夹，分别存放，事件信息、配置信息、其他

'''

def adjustSingleExportFile(devObj):
    try:
        localDir = devObj.get("collectRetDir")+"\\temp\\"
        curCtrlId = "default"
        masterCtrlId = "default"
        list_file = os.listdir(localDir)
        
        ssh = devObj.get("SSH")
        strCmd = "show controller general"
        cliRet = str(ssh.execCmd(strCmd))
        list_cliRet = cliRet.splitlines()
        
        #根据CLI回显信息获取当前环境中，主控的ID
        for field in list_cliRet:
            if len(field) < 1:
                continue
            if field.find(" ") != -1:
                field = field.replace(" ", "")
            if field.startswith("Controller"):
                list_ctrl = field.split(":")
                PY_LOGGER.info("1 is:"+list_ctrl[0])
                curCtrlId = list_ctrl[1]
            if field.startswith("Role"):
                list_role = field.split(":")
                
                #兼容18000和T系列设备
                if list_role[1] == "Primary" or list_role[1] == "Master":
                    masterCtrlId = curCtrlId
                    PY_LOGGER.info("master id is:"+masterCtrlId)
        
        
        #获取当前环境中所有阵列的IP地址，若为主控，则在主控的IP地址后面添加“_MAIN”
        strCmd = "show upgrade package"
        list_controller = []
        list_cliRetRow = []
        cliRet = str(ssh.execCmd(strCmd))
        list_cliRet = cliRet.splitlines()
        PY_LOGGER.info("show upgrade package cli return~~~"+str(list_cliRet))
        i = 0
        for field in list_cliRet:
            i = i + 1
            if i>5 and i < (len(list_cliRet)+1):
                if str(field).find("HotPatch Version")!=-1:
                    break
                PY_LOGGER.info("show upgrade package every column"+field)  
                if len(field) < 1:
                    continue
                list_cliRetRow = field.split(" ")  
                PY_LOGGER.info("find a controller~~~"+str(list_cliRetRow))          
                curCtrlId = list_cliRetRow[4]
                ctrlIp = list_cliRetRow[8]
                PY_LOGGER.info("find a controller ip and role~~~"+ctrlIp+curCtrlId)
                if curCtrlId == masterCtrlId:
                    ctrlIp = ctrlIp+"_MAIN"
                    PY_LOGGER.info("find a main controller~~~"+ctrlIp)
                list_controller.append(ctrlIp)
                
        
        for field in list_controller:
            if os.path.exists(localDir+"\\DataCollect") == False:
                os.mkdir(localDir+"\\DataCollect")
            if os.path.exists(localDir+"\\DataCollect\\"+field) == False:
                os.mkdir(localDir+"\\DataCollect\\"+field)
            if os.path.exists(localDir+"\\DataCollect\\"+field+"\\Event") == False:
                os.mkdir(localDir+"\\DataCollect\\"+field+"\\Event")
            if os.path.exists(localDir+"\\DataCollect\\"+field+"\\Config") == False:
                os.mkdir(localDir+"\\DataCollect\\"+field+"\\Config")
            if os.path.exists(localDir+"\\DataCollect\\"+field+"\\Other") == False:
                os.mkdir(localDir+"\\DataCollect\\"+field+"\\Other")
            for field_file in list_file:
                if field_file == "event_export.tar":
                    shutil.copy(localDir+field_file, localDir+"\\DataCollect\\"+field+"\\Event\\")
                    continue
                if field_file == "Config.txt":
                    shutil.copy(localDir+field_file, localDir+"\\DataCollect\\"+field+"\\Config\\")
                    continue
                shutil.copy(localDir+field_file, localDir+"\\DataCollect\\"+field+"\\Other\\")

        
        vers = str(devObj.get("devNode").getDeviceType()) + " " + str(devObj.get("devNode").getProductVersion())
        flag = write_version_file(devObj, vers)
        if flag == False:
            PY_LOGGER.info("write version file in single mode failed.")

        for field_file in list_file:
            os.remove(localDir+field_file)
            
        return True
    except Exception, exception:
        PY_LOGGER.info("catch except when adjust single export file. except trace back:{}"
                       .format(traceback.format_exc()))
        devObj["py_detail"] = "catch except when adjust single export file"
        return False

def execute(devObj):
    try:
        localDir = devObj.get("collectRetDir")+"\\temp\\"
        flag_logexist = False
        localFile_final = ""
        tar_class = devObj.get("PYENGINE.PY_ZIP")
        list = os.listdir(localDir)
        for field in list:
            PY_LOGGER.info("file name is:"+field)
            if field.find("Datacollect") != -1:
                PY_LOGGER.info("name is:"+field)
                flag_logexist = True
                if field.find(".tgz") != -1:
                    localFile_final = field.replace(".tgz", ".7z")
                else:
                    localFile_final = field+".7z"
                    os.renames(localDir+field, localDir + "DataCollect")
                PY_LOGGER.info("path is:" + localFile_final)
                break
        if flag_logexist == False:
            adjustSingleExportFile(devObj)
            product_model = get_product_pro(devObj, "product_model")
            product_sn = get_product_pro(devObj, "product_sn")
            product_time = get_product_date()
            localFile_final = "Datacollect_"+product_model+"_"+product_sn+"_"+product_time+".7z"
            PY_LOGGER.info("tar file is:"+localFile_final)
        else:
            list_file_tempDir = os.listdir(localDir)
            list_file_DatacollectDir = os.listdir(localDir+"DataCollect")
            for field in list_file_tempDir:
                if field.find("DataCollect") != -1:
                    continue
                
                #若 收集到有svplog.zip 信息，则需要处理 svplog.zip 
                if (field.find("svplog.zip") != -1):
                    PY_LOGGER.info("copy svplog to DataCollect dir:"+str(field))
                    shutil.move(localDir+field, localDir+"DataCollect")
                    continue
                
                
                for field_temp in list_file_DatacollectDir:
                    
                    #如果发现是交换机得信息，则不收集
                    if (field_temp.find("DSW") != -1):
                        PY_LOGGER.info("Ignore Switch dir:"+str(field_temp))
                        continue
                    
                    if field == "event_export.tar":
                        if os.path.exists(localDir+"\\DataCollect\\"+field_temp+"\\Event\\"+field) == False:
                            shutil.copy(localDir+field, localDir+"\\DataCollect\\"+field_temp+"\\Event\\")
                            continue
                    if field == "Config.txt":
                        if os.path.exists(localDir+"\\DataCollect\\"+field_temp+"\\Config\\"+field) == False:
                            shutil.copy(localDir+field, localDir+"\\DataCollect\\"+field_temp+"\\Config\\")
                            continue
                    if os.path.exists(localDir+"\\DataCollect\\"+field_temp+"\\Other\\"+field) == False:
                        shutil.copy(localDir+field, localDir+"\\DataCollect\\"+field_temp+"\\Other\\")
                os.remove(localDir+field)
            
            
            vers = str(devObj.get("devNode").getDeviceType()) + " " + str(devObj.get("devNode").getProductVersion())
            flag = write_version_file(devObj, vers)
            if flag == False:
                PY_LOGGER.info("write version file in regular mode failed.")
            
        DealFileInCopressPackage.anonymizeTV2(localDir)
        result = tar_class.compressFile(devObj.get("collectRetDir") + "\\" + localFile_final, localDir)
        CleanDir(devObj, localDir)
        devObj["collectRetFileName"] = localFile_final

        return (True, "")
    except Exception, exception:
        PY_LOGGER.info("catch except when compress file.~~~over!")
        PY_LOGGER.info("except arguement:"+str(exception.args)+"~~~over!")
        PY_LOGGER.info("except messages:"+str(exception))
        PY_LOGGER.info("except trace back:"+str(traceback.print_exc()))
        devObj["py_detail"] = "catch except when compress file.~~~over!"
        return (False, "")
