﻿# -*- coding: UTF-8 -*-
from java.io import File
import socket
import os
import shutil
import zipfile
import traceback
import tarfile
import re

G_STRCMD = "export "

G_ITEM_ALM = str("ALM")
G_ITEM_LOG = str("LOG")
G_ITEM_SYS = str("SYSCONFIG")
G_ITEM_DB = str("DB")
G_ITEM_ELABLE = str("ELABLE")
G_ITEM_CLICMD = str("CLICMD")
G_LOG_TIMO = 25 * 60

list_cli_cmd = ["show alarm",
                   "show bbu general",
                   "show bond_port",
                   "show cache_partition general",
                   "show clone general",
                   "show consistency_group general",
                   "show controller general",
                   "show disk general",
                   "show disk_domain general",
                   "show enclosure",
                   "show event",
                   "show event_config",
                   "show event_restore",
                   "show expansion_module",
                   "show fan",
                   "show host general",
                   "show host_group general",
                   "show initiator",
                   "show interface_module",
                   "show iostat policy",
                   "show iscsi initiator_name",
                   "show iscsi target",
                   "show iscsi target_name",
                   "show isns server_ip",
                   "show license",
                   "show license_active",
                   "show lun general",
                   "show lun_copy general",
                   "show lun_group general",
                   "show mapping_view general",
                   "show notification trap",
                   "show notification syslog",
                   "show notification sms",
                   "show port general",
                   "show port_group general",
                   "show power_supply",
                   "show remote_device general",
                   "show remote_replication general",
                   "show schedule",
                   "show security_rule",
                   "show smartqos_policy general",
                   "show smartqos_template",
                   "show snapshot general",
                   "show snmp context_name",
                   "show snmp usm",
                   "show ssd routeswitch",
                   "show storage_engine",
                   "show storage_pool general",
                   "show system general",
                   "show system media_scan",
                   "show system ntp",
                   "show system timezone",
                   "show system manufactory",
                   "show upgrade package",
                   "show user",
                   "show version all"
                   ]

#需要进入developer模式发送的命令
list_developer_cmd = ["show dha judgeproportion", 
                      "show dha policy", 
                      "show dha servicestatus", 
                      "show mp_mode"
                    ]

list_multi_cli_cmd = ["show bbu general",
                      "show disk general",
                      "show enclosure",
                      "show expansion_module",
                   "show fan",
                   "show host general",
                   "show interface_module",
                   "show lun_copy general",
                   "show lun_group general",
                   "show mapping_view general",
                   "show power_supply",
                   "show storage_engine",
                   "show storage_pool general"
                   ]

list_elable_cmd = ["show controller general",
                   "show bbu general",
                   "show fan",
                   "show interface_module",
                   "show expansion_module"]
list_elable_property = ["Devive",
                        "BBU",
                        "FAN",
                        "INTERFACE_MODULE",
                        "EXPANSION_MODULE"]
list_multi_elable_cmd = ["show bbu general",
                  "show fan",
                  "show interface_module",
                  "show expansion_module"]

myname = socket.getfqdn(socket.gethostname())
myaddr = socket.gethostbyname(myname)

MAX_RETRYS = 5

# **************************************************************************** #
# 函数名称: getUserNameCli
# 功能说明: 根据CLI回显获取用户名
# 输入参数: cli
# 输出参数: userName
# **************************************************************************** # 
def getUserNameCli(cli):
    userName = ""

    #执行命令获取当前登录的用户名      
    cliRet = cli.execCmdNoLog("show system general")
    
    #输入CLI回显是否有效
    if None == cliRet or "" == cliRet: 
        return userName
    
    #执行命令获取当前登录的用户名      
    lineList = cliRet.splitlines()
    
    #用户名一定包含在最后一行中
    if lineList[-1].find(CLI_RET_END_FLAG):
        userName = lineList[-1].replace(" ","").replace(CLI_RET_END_FLAG,"")
    return userName

# **************************************************************************** #
# 函数名称: getUserPrivilege
# 功能说明: 获取登录用户名的权限级别
# 输入参数: devObj
# 输出参数: super_admin,guest或admin
# **************************************************************************** # 
def getUserPrivilege(devObj):
    
    userLevel = ""
    ssh = devObj.get("SSH")
    userName = devObj.get("username")
    if None == userName or "" == userName: 
        userName = getUserNameCli(ssh)
    
    PY_LOGGER.info("Get login name is:"+str(userName))
    
    #获取权限级别
    cliRet = ssh.execCmd("show user user_name="+userName)
    lineList = cliRet.splitlines()
    
    #用户名一定包含在最后几行中
    for line in lineList[4:-1]:
        columnList = line.split()
        if len(columnList)>2:
            if userName == columnList[0]:
                userLevel = columnList[1]
                return userLevel
    return userLevel

# **************************************************************************** #
# 函数名称: CheckSystemNormal
# 功能说明: 检验当前设备是否normal
# 输入参数: devObj
# 输出参数: True, False
# **************************************************************************** # 
def CheckSystemNormal(devObj):
    
    flag = False
    ssh = devObj.get("SSH")
    
    cliRet = ssh.execCmd("show system general")
    if re.search("System Name", cliRet, re.IGNORECASE):
        flag = True
        
    return flag
    

# *************************************************************#
# 函数名称: changeDeveloperMode2Cli
# 功能说明: 从developer模式退回到Cli
# 其 他   :  无
# *************************************************************# 
def changeDeveloperMode2Cli(ssh):
    
    index =0
    cliRet = ssh.execCmdNoLog("show system general")
    #密码输入错误时及正常情况从developer模式下退出
    if -1 != cliRet.find("Password") or -1 != cliRet.find("developer:/>"):
        cliRet = ssh.execCmd("exit")
        PY_LOGGER.info("Sequence[5] change to cli model")
        while(-1 == cliRet.find("admin:/>")):
            index+=1
            cliRet = ssh.execCmd("exit")
            if -1!=cliRet.find("Are you sure to exit?(y/n):"):
                cliRet = ssh.execCmd("n")
            if index>MAX_RETRYS:
                break

# *************************************************************#
# 函数名称: changeCli2DeveloperMode
# 功能说明: 从cli进入developer模式的接口
# 其 他   :  无
# *************************************************************#  
def changeCli2DeveloperMode(ssh, developerPwd):

    #判断developer密码是否为空
    if None == developerPwd or "" == developerPwd :
        return False
    
    #发送命令
    cliRet = ssh.execCmd("change user_mode current_mode user_mode=developer")
    if not re.search("Password:", cliRet, re.IGNORECASE):
        return False
    
    cliRet = ssh.execCmdNoLog(developerPwd)
    if not re.search("developer:", cliRet, re.IGNORECASE):
        return False
    
    #模式切换成功
    return True

def func_fail_after_download(devObj, step):
    try:
        tar_class = devObj.get("PYENGINE.PY_ZIP")
        PY_LOGGER.info("handle failed. error code is " + step)
        if step == "step11":
            os.renames(devObj.get("collectRetDir") + "\\temp\\" + devObj["collectRetFileName"].replace(".tgz", ""), devObj.get("collectRetDir") + "\\temp\\DataCollect")
            vers = str(devObj.get("devNode").getDeviceType()) + " " + str(devObj.get("devNode").getProductVersion())
            write_version_file(devObj, vers)
            tar_class.compressFile(devObj.get("collectRetDir") + "\\" + devObj["collectRetFileName"].replace(".tgz", ".7z"), devObj.get("collectRetDir") + "\\temp")
            CleanDir(devObj, devObj.get("collectRetDir") + "\\temp")
        return (False, "")
    except:
        devObj["py_detail"] = "do compress file error. step : " + step
        return (False, "")

def write_version_file(devObj, strCmd):
    try:
        flag = True
        localDir = devObj.get("collectRetDir") + "\\temp\\"
        if True != os.path.exists(localDir):
            os.mkdir(localDir)
        f = open(localDir + "\\DataCollect\\version", "w")
        
        f.write(strCmd)
        f.close()
        return flag
    except:
        flag = False
        PY_LOGGER.info("catch except when write elable info to file.")
        devObj["py_detail"] = "catch except when write elable info to file."
        return flag

def adjust_log_messages(devObj, localDir_fourth_message):
    try:
        if os.path.exists(localDir_fourth_message) == False:
            PY_LOGGER.info("has no " + localDir_fourth_message)
            devObj["py_detail"] = "catch except when write elable info to file."
            return False

        sufix = ""
        tar_class = devObj.get("PYENGINE.PY_ZIP")
        result = False
        newName_log = ""

        list1 = os.listdir(localDir_fourth_message)
        for field in list1:
            if field.find("cur_debug_mem") != -1:
                sufix = ""
            if field.find("his_tar") != -1:
                sufix = "his_tar"
            if field.find("message") != -1:
                sufix = "message"
            if field.find("tgz") == -1 and field.find("tar.gz") == -1 and field.find("tar.bz2") == -1 and field.find("zip") == -1:
                if os.path.isfile(localDir_fourth_message + "\\" + field):
                    continue
                list4 = os.listdir(localDir_fourth_message + "\\" + field)
                for field_file in list4:
                    shutil.copy(localDir_fourth_message + "\\" + field + "\\" + field_file, localDir_fourth_message)
                #删除Messages下的所有子文件夹
                shutil.rmtree(localDir_fourth_message + "\\" + field, True)
                continue

            localDir_fourth_message_temp = localDir_fourth_message + "\\temp\\"
            if os.path.exists(localDir_fourth_message_temp) == False:
                os.mkdir(localDir_fourth_message_temp)
            result = tar_class.decompressTarGzFile(localDir_fourth_message + "\\" + field, localDir_fourth_message_temp)
            if result == False:
                step = "step10"
                func_fail_after_download(devObj, step)
                return False

            list2 = os.listdir(localDir_fourth_message_temp)
            for field_imp in list2:
                if os.path.isfile(localDir_fourth_message_temp + field_imp):
                    shutil.copy(localDir_fourth_message_temp + field_imp, localDir_fourth_message)
                    continue
                path_message = localDir_fourth_message_temp + field_imp
                list3 = os.listdir(localDir_fourth_message_temp + field_imp)
                #调用回归方法
                adjust_log_messages_move_file(list3, path_message, localDir_fourth_message, sufix)
            CleanDir(devObj, localDir_fourth_message_temp)
            os.remove(localDir_fourth_message + "\\" + field)
        return True
    except Exception, exception:
        PY_LOGGER.info("catch except when adjust log file over!")
        PY_LOGGER.info("except arguement:" + str(exception.args) + "~~~over!")
        PY_LOGGER.info("except messages:" + str(exception))
        PY_LOGGER.info("except trace back:" + str(traceback.format_exc()))
        devObj["py_detail"]= "catch except when adjust log file over!"
        return False

'''
收集系统日志专用，当收集到系统日志后，
将系统日志中的Message目录下的压缩文件解压，把解压后的文件夹以及子文件夹中的文件拷贝到Message跟目录中
'''
def adjust_log_messages_move_file(list3, path, localDir_fourth_message, sufix):
    for field_temp in list3:
        if os.path.isfile(path + "\\" + field_temp):
            if field_temp.find(".log") != -1:
                newName_log = field_temp.replace(".log", sufix + ".log")
            elif field_temp.find(".txt") != -1:
                newName_log = field_temp.replace(".txt", sufix + ".txt")
            else:
                newName_log = field_temp + sufix            
            os.renames(path + "\\" + field_temp, path + "\\" + newName_log)
            shutil.copy(path + "\\" + newName_log, localDir_fourth_message)
        else:
            path1 = path + "\\" + field_temp
            listFile = os.listdir(path1)
            adjust_log_messages_move_file(listFile, path1, localDir_fourth_message, sufix)
            
            
def adjust_log_other(devObj, localDir_fourth_other):
    try:
        return True
    except:
        PY_LOGGER.info("catch except when adjust log file over!")
        return False

def adjust_log_file(devObj, localDir_third):
    try:
        passwd = devObj.get("decomp_pwd_new")
        PY_LOGGER.info("start to adjust log file:" + localDir_third)
        if os.path.exists(localDir_third + "\\msg_other.zip") != True:
            PY_LOGGER.info("have no log zip file, exit it.")
            return (True, "")
        localDir_fourth_message = localDir_third + "\\Messages"
        localDir_fourth_other = localDir_third + "\\Other"
        tar_class = devObj.get("PYENGINE.PY_ZIP")

        PY_LOGGER.info("decompress with password start~~")
        result = tar_class.decompressZipFile(localDir_third + "\\msg_other.zip", localDir_third, str(passwd))
        PY_LOGGER.info("decompress with password end~~")
        if result == False:
            step = "step4"
            func_fail_after_download(devObj, step)
            return (False, "")

        if os.path.exists(localDir_third + "msg_other.tar.bz2") != True:
            step = "step5"
            func_fail_after_download(devObj, step)
            return (False, "")
        
        PY_LOGGER.info("decompress with msg other.bz2 start~~")
        result = tar_class.decompressTarBz2File(localDir_third + "\\msg_other.tar.bz2", localDir_third)
        PY_LOGGER.info("decompress with msg other.bz2 end~~")
        if result == False:
            step = "step6"
            func_fail_after_download(devObj, step)
            return (False, "")

        if os.path.exists(localDir_fourth_message) != True:
            step = "step7"
            func_fail_after_download(devObj, step)
            return (False, "")
        if os.path.exists(localDir_fourth_other) != True:
            step = "step8"
            func_fail_after_download(devObj, step)
            return (False, "")
        PY_LOGGER.info("adjust log messages start~~")
        result = adjust_log_messages(devObj, localDir_fourth_message)
        PY_LOGGER.info("adjust log messages end~~")
        if result == False:
            step = "step9"
            func_fail_after_download(devObj, step)
            return (False, "")
        result = adjust_log_other(devObj, localDir_fourth_other)
        if result == False:
            step = "step9"
            func_fail_after_download(devObj, step)
            return (False, "")
        PY_LOGGER.info("del msg_other.zip start~~")
        os.remove(localDir_third + "\\msg_other.tar.bz2")
        os.remove(localDir_third + "\\msg_other.zip")
        PY_LOGGER.info("del msg_other.zip end~~")
        
        return (True, "")
    except Exception, exception:
        PY_LOGGER.info("catch except when adjust log file over! except trace back:{}".format(traceback.format_exc()))
        devObj["py_detail"]= "catch except when adjust log file over!"
        return (False, "")

def CleanDir(devObj, Dir):
    try:
        if os.path.isdir(Dir):
            paths = os.listdir(Dir)
            for path in paths:
                filePath = os.path.join(Dir, path)
                if os.path.isfile(filePath):
                    try:
                        os.remove(filePath)
                    except os.error:
                        PY_LOGGER.info("remove " + filePath + " error.")
                        return (False, "")
                elif os.path.isdir(filePath):
                    if filePath[-4:].lower() == ".svn".lower():
                        continue
                    shutil.rmtree(filePath, True)
            os.rmdir(Dir)
        else:
            return (False, "")
        return (True, "")
    except:
        devObj["py_detail"]= "clean dirs error."
        return (False, "")

#todo 与18000实现方式不一致
def download_File(devObj, type):
    try:
        sftp = devObj.get("SFTP")
        localDir = devObj.get("collectRetDir") + "\\temp\\"
        flag = True
        try:
            #如果本地临时目录不存在，则创建
            if os.path.exists(localDir) != True:
                os.mkdir(localDir)
        except Exception, exception:
            flag = False
            PY_LOGGER.error("catch except when make local dir:" + localDir + " for downloading ~~~over!")
            PY_LOGGER.error("except arguement:" + str(exception.args) + "~~~over!")
            PY_LOGGER.error("except messages:" + str(exception))
            PY_LOGGER.error("except trace back:" + str(traceback.format_exc()))
            lang = devObj.get("lang")
            if lang == "zh":
                devObj["py_detail"] = u"在下载文件过程中创建目录：" + localDir + u"出现异常，请确认该目录可写！"
            else:
                devObj["py_detail"] = "Catch except when make local dir:" + localDir + \
                    " for downloading file, please check the dir writable"
        localPath = localDir + devObj.get("collectRetFileName")
        if True == flag:
            file = File(localPath)
            sftp.getFile(devObj.get("collecRemotePath"), file, None)
        if "SYSCONFIG" == type:
            #将已经下载到本地的系统配置文件重命名
            if os.path.exists(localPath) == True:
                os.renames(localPath, localDir + "Config.txt")
        if False == flag:
            return False
        else:
            return True
    except BaseException, exception:
        PY_LOGGER.info("catch except when download file ")
        PY_LOGGER.info("except arguement:" + str(exception.args) + "~~~over!")
        PY_LOGGER.info("except messages:" + str(exception))
        PY_LOGGER.info("except trace back:" + str(traceback.format_exc()))
        devObj["py_detail"] = "catch except when download file " + devObj.get("collecRemotePath") + "~~~over!"
        return False
    except:
        PY_LOGGER.info("catch except when download file ")
        devObj["py_detail"] = "catch except when download file " + devObj.get("collecRemotePath") + "~~~over!"
        return False
######################################################################
# 函数名称：deleteRemoteFile
# 功能说明：删除远端阵列上的文件
# 传入参数：devObj对象；type信息收集类型
# 返  回  值：True:执行成功；False:执行失败
######################################################################
#todo 删除文件 单独提出
def deleteRemoteFile(devObj, type):
    try:
        ssh = devObj.get("SSH")
        localDir = devObj.get("collectRetDir") + "\\temp\\"
        localPath = localDir + devObj.get("collectRetFileName")
        
        if type == "SYSCONFIG":
            del_type = "running_data"
        elif type == "ALM":
            del_type = "event"
        elif type == "DB":
            del_type = "configuration_data"
        elif type == "LOG":
            del_type = "log"
        #delete export file in memory of device
        strCmd = "delete file " + "filetype=" + del_type
        PY_LOGGER.info("delete command is:" + strCmd)
        cliRet = ssh.execCmd(strCmd)
        if cliRet.find("Command executed successfully") == -1:
            PY_LOGGER.info("delete file in memory of device error. go on executing next step")
        return True
    except Exception, exception:
        PY_LOGGER.info("catch except when delete remote file ")
        PY_LOGGER.info("except arguement:" + str(exception.args) + "~~~over!")
        PY_LOGGER.info("except messages:" + str(exception))
        PY_LOGGER.info("except trace back:" + str(traceback.format_exc()))
        devObj["py_detail"] = "catch except when delete remote file " + devObj.get("collecRemotePath") + "~~~over!"
        return False
    
def func_after_download(devObj, type):
    try:
        if str(type) == str("ALM") or str(type) == str("ELABLE") or str(type) == str("DB") or str(type) == str("CLICMD"):
            PY_LOGGER.info("no need handle log collect.")
            return (True, "")
        flag_logexist = False
        flag_logdir_exist = False
        result = False
        third_dir_name_list = []
        localDir_third_list = []
        step = "default"
        tar_class = devObj.get("PYENGINE.PY_ZIP")
        localPath = "default"
        localFile_final = "default"
        #search tgz file in the temp dir to decompress it
        localDir = devObj.get("collectRetDir") + "\\temp\\"

        PY_LOGGER.info("local path of towar is:" + localDir)
        list = os.listdir(localDir)
        for field in list:
            if field.find(".tgz") != -1:
                flag_logexist = True
                localPath = localDir + field
                localFile_final = devObj.get("collectRetDir") + "\\" + field
                PY_LOGGER.info("path is:" + localFile_final)
                second_dir_name = field.replace(".tgz", "")
                break
            if field.find("Datacollect") != -1:
                if os.path.isdir(localDir + field) == True:
                    flag_logdir_exist = True
                    break

        if flag_logdir_exist == True:
            localDir_third_list_get = devObj.get("localDir_third")
            if len(localDir_third_list_get) != 0:
                for dir_name_get in localDir_third_list_get:
                    if type == "SYSCONFIG":
                        shutil.copy(localDir + "Config.txt", dir_name_get + "Config\\")
            return True
            
        #if exist log dir, need to copy txt or dat file to correspond dir("\temp\second")
        if flag_logexist != True:
            PY_LOGGER.info("log zip file is not exist, may be user do not collect system log.")
            result = True
            return result
        
        localDir_second = localDir + second_dir_name + "\\"
        if os.path.exists(localDir_second) != True:
            os.mkdir(localDir_second)
                
        #decompress tgz file to "\temp\second" dir
        result = tar_class.decompressZipFile(localPath, localDir_second)
        if result == False:
            #decompress fail, then compress temp dir to a new tgz file
            step = "step1"
            func_fail_after_download(devObj, step)
            return False
        os.remove(localPath)
        
        #search  "\temp\second" dir to find bz2 file and decompress it
        list2 = os.listdir(localDir_second)
        for field_second in list2:
            if field_second.find(".bz2") != -1:
                flag_bz2_exist = True
                third_dir_name_list.append(field_second.replace(".tar.bz2", ""))
                PY_LOGGER.info("list in tar is:" + str(field_second.replace(".tar.bz2", "")))
                
        if flag_bz2_exist != True:
            step = "step2"
            func_fail_after_download(devObj, step)

        for third_dir_name in third_dir_name_list:

            #if find bz2 file, start to decompress to "\temp\second\third" dir
            localDir_third = localDir_second + third_dir_name + "\\"
            localDir_third_list.append(localDir_third)
            if os.path.exists(localDir_third) != True:
                os.mkdir(localDir_third)
            result = tar_class.decompressTarBz2File(localDir_second + third_dir_name + ".tar.bz2", localDir_third)

            if result == False:
                step = "step3"
                func_fail_after_download(devObj, step)
                return False
            #delete tar file
            os.remove(localDir_second + third_dir_name + ".tar.bz2")
            if type == "SYSCONFIG":
                shutil.copy(localDir + "Config.txt", localDir_third + "Config\\")
                PY_LOGGER.info("copy " + localDir + "Config.txt to " + localDir_third + "Config\\")
            #adjust log file to messages dictionary
            adjust_log_file(devObj, localDir_third)
        devObj["localDir_third"] = localDir_third_list
        return True
    except Exception, exception:
        PY_LOGGER.info("catch except when handle after download~~~!")
        PY_LOGGER.info("except arguement:" + str(exception.args) + "~~~over!")
        PY_LOGGER.info("except messages:" + str(exception))
        PY_LOGGER.info("except trace back:" + str(traceback.format_exc()))
        devObj["py_detail"] = "catch except when handle after download~~~!"
        return False

def is_multi_cmd(strCmd, type):
    try:
        flag = False
        list_cmd = None
        if type == str("ELABLE"):
            list_cmd = list_multi_elable_cmd
        elif type == str("CLICMD"):
            list_cmd = list_multi_cli_cmd
            
        for field in list_cmd:
            if field == strCmd or field.find(strCmd + "|") != -1:
                flag = True
                PY_LOGGER.info("multi cmd")
                return flag
        PY_LOGGER.info("single cmd")    
        return flag
    except:
        flag = False
        PY_LOGGER.info("catch except when check if multi command~~~over!")
        return flag

def get_multi_cmd(devObj, strCmd, type):
    try:
        list_multi_cmd = []
        list_cmd = None
        ssh = devObj.get("SSH")
        if type == str("ELABLE"):
            list_cmd = list_multi_elable_cmd
        elif type == str("CLICMD"):
            list_cmd = list_multi_cli_cmd

        for element in list_cmd:
            PY_LOGGER.info("element is:" + element + ", " + strCmd)
            if element.find(strCmd) != -1:
                PY_LOGGER.info("comm element is:" + element + ", " + strCmd)
                if element.find("|") != -1:
                    PY_LOGGER.info("right is:" + element + ", " + strCmd)
                    list_tmp = element.split("|")
                    strCmd = list_tmp[1]
                    PY_LOGGER.info("strCmd is:" + strCmd)
                    break
        PY_LOGGER.info("final is:" + strCmd)
        cliRet = ssh.execCmd(strCmd)
        if cliRet == None:
            return strCmd
        if type == str("CLICMD"):
            flag = write_clicmd_file(devObj, cliRet)
        list_cliRet = cliRet.splitlines()
        i = 0
        for field in list_cliRet:
            i = i + 1
            if i < 5:
                continue
            if field.find("admin:/>") != -1 or field.find("developer:/>") != -1:
                continue
            list_field = field.split()
            list_multi_cmd.append(list_field[0])
        return list_multi_cmd
    except:
        PY_LOGGER.info("catch except when get multi command~~~over!")
        return strCmd

def get_product_info(devObj, strCmd, type):
    try:
        result = ""
        list_multi_cmd = []
        if strCmd == None:
            PY_LOGGER.info("get cmd is none")
            return result
        ssh = devObj.get("SSH")
        if False == is_multi_cmd(strCmd, type):
            result = ssh.execCmd(strCmd)
        else:
            list_multi_cmd = get_multi_cmd(devObj, strCmd, type)
        for field_cmd in list_multi_cmd:
            if strCmd.find("bbu") != -1:
                result = result + ssh.execCmd(strCmd + " " + "bbu_id=" + field_cmd)
            if strCmd.find("disk") != -1:
                result = result + ssh.execCmd(strCmd + " " + "disk_id=" + field_cmd)
            if strCmd.find("enclosure") != -1:
                result = result + ssh.execCmd(strCmd + " " + "enclosure_id=" + field_cmd)
            if strCmd.find("fan") != -1:
                result = result + ssh.execCmd(strCmd + " " + "fan_id=" + field_cmd)
            if strCmd.find("host") != -1:
                 result = result + ssh.execCmd(strCmd + " " + "host_id=" + field_cmd)
            if strCmd.find("interface_module") != -1:
                result = result + ssh.execCmd(strCmd + " " + "interface_module_id=" + field_cmd)
            if strCmd.find("expansion_module") != -1:
                result = result + ssh.execCmd(strCmd + " " + "expansion_module_id=" + field_cmd) 
            if strCmd.find("lun_copy") != -1:
                result = result + ssh.execCmd(strCmd + " " + "lun_copy_id=" + field_cmd) 
            if strCmd.find("lun_group") != -1:
                result = result + ssh.execCmd(strCmd + " " + "lun_group_id=" + field_cmd)
            if strCmd.find("mapping_view") != -1:
                result = result + ssh.execCmd(strCmd + " " + "mapping_view_id=" + field_cmd)
            if strCmd.find("power_supply") != -1:
                result = result + ssh.execCmd(strCmd + " " + "power_supply_id=" + field_cmd)
            if strCmd.find("storage_engine") != -1:
                result = result + ssh.execCmd(strCmd + " " + "storage_engine_id=" + field_cmd)
            if strCmd.find("storage_pool") != -1:
                result = result + ssh.execCmd(strCmd + " " + "pool_id=" + field_cmd)                       
        PY_LOGGER.info("execute result is:" + result)
        return result
    except:
        result = "default"
        PY_LOGGER.info("catch except when get product elable " + strCmd)
        return result



def write_elable_file(devObj, strCmd):
    try:
        flag = True
        localDir = devObj.get("collectRetDir") + "\\temp\\"
        if True != os.path.exists(localDir):
            os.mkdir(localDir)
        f = open(localDir + "elable_info.txt", "a")
        
        f.write(strCmd)
        f.close()
        return flag
    except:
        flag = False
        PY_LOGGER.info("catch except when write elable info to file.")
        lang = devObj.get("lang")
        if lang == "zh":
            devObj["py_detail"] = u"写电子标签文件过程中出现异常"
        else:
            devObj["py_detail"] = "Catch except when write elabel to file"
        return flag

def write_clicmd_file(devObj, strCmd):
    try:
        flag = True
        localDir = devObj.get("collectRetDir") + "\\temp\\"
        if True != os.path.exists(localDir):
            os.mkdir(localDir)
        f = open(localDir + "clicmd.txt", "a")
        
        f.write(strCmd)
        f.close()
        return flag
    except:
        flag = False
        PY_LOGGER.info("catch except when write CLI info to file.")
        lang = devObj.get("lang")
        if lang == "zh":
            devObj["py_detail"] = u"写CLI回显文件过程中出现异常"
        else:
            devObj["py_detail"] = "Catch except when write CLI information to file"
        return flag

def find_in_list(list_src, strInfo):
    try:
        i = 0
        for field in list_src:
            if field == strInfo:
                return i
            i = i + 1
        return -1
    except:
        PY_LOGGER.info("catch except when find info in list~~~over!")
        return -1

def get_field_type(atrribute_name):
    try:
        field_type = "string"
        return field_type
    except:
        PY_LOGGER.info("catch except when get field type~~~over!")
        return field_type

def parse_elable_info(strInfo, strProperty):
    try:
        result = "    <TABLE>\n    </TABLE>\n"
        result = "    <TABLE attribute=\"" + strProperty + "\">\n"
        result = result + "        <METADATA>\n"
        result = result + "        <FIELDS>\n"
        flag_start = False
        list_elable_key = []
        list_elable_value = []
        list = strInfo.splitlines()
        list_elable_value_num = 0
        for field in list:
            if field.find("Electronic Label") != -1:
                list_elable_value_num = list_elable_value_num + 1
                flag_start = True
            if flag_start == True:
                if field.find("=") != -1:
                    list_temp = field.split("=")
                    if -1 == find_in_list(list_elable_key, list_temp[0].replace(" ", "")):
                        list_elable_key.append(list_temp[0].replace(" ", ""))
                    list_elable_value.append(list_temp[1])
        if len(list_elable_key) == 0:
            result = result + "        </FIELDS>\n        </METADATA>\n    </TABLE>\n"
            return result
        i = 0
        j = 0
        value_max = 0
        for field in list_elable_key:
            result = result + "            <FIELD attribute = \"" + field
            for j in range(list_elable_value_num):
                if len(list_elable_value[i]) > value_max:
                    value_max = len(list_elable_value[i])
            result = result + "\" fieldtype = \"" + get_field_type(field) + "\" width = \"" + str(value_max) + "\" required=\"true\" />\n"
            i = i + 1
            value_max = 0
        result = result + "        </FIELDS>\n        </METADATA>\n        <ROWDATA>\n"
        i = 0
        for i in range(list_elable_value_num):
            result = result + "            <ROW "
            j = 0
            for field in list_elable_key:
                result = result + field + "=\""
                if list_elable_value[j + i * len(list_elable_key)] == None:
                    result = result + "\""
                    j = j + 1
                    continue
                result = result + list_elable_value[j + i * len(list_elable_key)] + "\" "
                j = j + 1
            result = result + " />\n"
        result = result + "        </ROWDATA>\n    </TABLE>\n"
        return result
    except:
        PY_LOGGER.info("catch except when parse info.~~~~over!")
        return result



def export_elable(devObj, type):
    try: 
        result = "default"
        flag = True
        list_header = ["<?xml version=\"1.0\" encoding=\"iso-8859-1\" standalone=\"yes\" ?> ",
                 "<DATAPACKET Version=\"2.0\">",
                 "<FILELABEL>",
                 "<VERDESC Ver=\"1.4\" />",
                 "</FILELABEL>",
                 "<TABLES>"]
        for field_header in list_header:
            flag = write_elable_file(devObj, field_header + "\n")

        #添加cli回文是否正常判断标识位
        isCliRetNormal = False
        #用于判断是否在正确的模式下，只要有一个命令是在正确的模式下就成功
        isInRightMode = False
        i = 0
        for field in list_elable_cmd:
            result = get_product_info(devObj, field, type)
            if result == "default":
                flag = False
                PY_LOGGER.info("get fail info by " + field)
                continue
            if -1 != result.find(":/>"):
                isInRightMode = True
            i = i + 1
            if len(list_elable_property) >= i:
                result = parse_elable_info(result, list_elable_property[i - 1])
            else:
                result = parse_elable_info(result, "default")
            flag = write_elable_file(devObj, result)
            
            if flag == False:
                PY_LOGGER.info("write to file fail by " + field)
                continue
            else:
                if not re.search("Error:", result, re.IGNORECASE):
                    isCliRetNormal = True
                elif re.search("license", result, re.IGNORECASE):
                    isCliRetNormal = True
              
        flag = write_elable_file(devObj, "</TABLES>\n</DATAPACKET>")
        if not isInRightMode:
            lang = devObj.get("lang")
            if lang == "zh":
                devObj["py_detail"] = u"系统未在正确模式下。"
            else:
                devObj["py_detail"] = "The system is not in right mode."
        flag = isCliRetNormal and flag and isInRightMode
        return flag
    except:
        PY_LOGGER.info("catch except when export elable~~~over!")
        devObj["py_detail"] = "catch except when export elable~~~over!"
        return False

def export_clicmd(devObj, type):
    try:
        result = "admin:/>"
        flag = write_clicmd_file(devObj, result)
        if flag == False:
            PY_LOGGER.info("write cli into to file fail")
            return flag
        
        #用于判断是否在正确的模式下，只要有一个命令是在正确的模式下就成功
        isInRightMode = False
        
        #获取所有Cli模式下命令回文
        for field in list_cli_cmd:
            result = get_product_info(devObj, field, type)
            PY_LOGGER.info("result is:" + result)
            if result == "default":
                flag = False
                PY_LOGGER.info("get fail info by " + field)
                continue
            if -1 != result.find(":/>"):
                isInRightMode = True
            flag = write_clicmd_file(devObj, result)
            if flag == False:
                PY_LOGGER.info("write to file fail by " + field)
                continue

        #系统未在正确模式下
        if not isInRightMode:
            lang = devObj.get("lang")
            if lang == "zh":
                devObj["py_detail"] = u"系统未在正确模式下。\n" + result
            else:
                devObj["py_detail"] = "The system is not in right mode.\n" + result
            return False
        #进入developer模式
        ssh = devObj.get("SSH")
        developerPwd = devObj.get("developer")
        changeFlag = changeCli2DeveloperMode(ssh, developerPwd)
        #切换到developer模式失败
        if not changeFlag:
            lang = devObj.get("lang")
            changeDeveloperMode2Cli(ssh)
            if lang == "zh":
                devObj["py_detail"] = u"【失败原因】：收集Cli命令回显信息成功。但是工具登录developer模式失败，导致不能收集developer命令回文。\n" \
                        + u"【操作建议】：请修改设备，输入正确的developer密码，并且确认当前登录的用户级别或者角色ID是否支持收集操作。"
            else:
                devObj["py_detail"] = "[Failure reason]: Collecting cli command information succeed. But logged in developer model failed and could not collect developer command information.\n" \
                        + "[Process suggestion]: Modify the device information, enter the correct password for logging in to the developer mode, and check whether the login user level or role ID supports information collection."
            return False
        
        #获取所有developer模式下命令回文
        for field in list_developer_cmd:
            result = get_product_info(devObj, field, type)
            PY_LOGGER.info("result is:" + result)
            if result == "default":
                flag = False
                PY_LOGGER.info("get fail info by " + field)
                continue
            if -1 != result.find("developer:/>"):
                isInRightMode = True
            flag = write_clicmd_file(devObj, result)
            if flag == False:
                PY_LOGGER.info("write to file fail by " + field)
                continue
        
        #收集完成，需要退回到Cli模式
        changeDeveloperMode2Cli(ssh)
        #系统未在正确模式下
        if not isInRightMode:
            lang = devObj.get("lang")
            if lang == "zh":
                devObj["py_detail"] = u"系统未在正确模式下。\n" + result
            else:
                devObj["py_detail"] = "The system is not in right mode.\n" + result
        flag = isInRightMode and flag
        return flag
    except:
        PY_LOGGER.info("catch except when export clicmd~~~over!")
        devObj["py_detail"] = "catch except when export clicmd"
        return False

def execute(devObj, type):
    try:
        #为防止前一个收集项失败但错误信息未清空而后一个收集项也失败却没有写错误信息，导致错误信息误报
        devObj["py_detail"] = ""
        ssh = devObj.get("SSH")
        sftp = devObj.get("SFTP")
        flag = False
        lang = devObj.get("lang")
        
        #precheck that whether cli order is available
        if type == "ALM":
            strCmd = "show file export_path file_type=event"
            strCmd_old = G_STRCMD + "event event_type=event " + "ip=" + myaddr + " user=admin password=****** path=/collect_alm.tgz clean_device_file=no"
        if type == "LOG":
            strCmd = "show file export_path file_type=log"
            strCmd_old = G_STRCMD + "event event_type=log " + "ip=" + myaddr + " user=admin password=****** path=/collect_log.tgz clean_device_file=no"
        if type == "SYSCONFIG":
            strCmd = "show file export_path file_type=running_data"
            strCmd_old = G_STRCMD + "running_data " + "ip=" + myaddr + " user=admin password=****** running_data_file=/collect_sysconfig.txt clean_device_file=no"
        if type == "DB":
            strCmd = "show file export_path file_type=configuration_data"
            strCmd_old = G_STRCMD + "configuration_data " + "ip=" + myaddr + " user=admin password=****** db_file=/collect_db.dat clean_device_file=no"
        
        
        if type == "ELABLE":
            strRet = export_elable(devObj, type)
            if strRet == False:
                return (False, "")
            else:
                return (True, "")
        if type == "CLICMD":
            strRet = export_clicmd(devObj, type)
            if strRet == False:
                return (False, "")
            else:
                return (True, "")
            
        PY_LOGGER.info("towar print:" + strCmd)
        if type == "LOG":
            PY_LOGGER.info("collect log")
            strRet = str(ssh.execCmdNoLogTimout(strCmd, G_LOG_TIMO))
        else:
            strRet = str(ssh.execCmdNoLog(strCmd))
        
        #The cli order is not supported by current divice, try old cli order
        isExecNewCmd = True
        if -1 != strRet.find("^"):
            PY_LOGGER.info("The cli order is not supported by current divice, try old cli order")
            if type == "LOG":
                PY_LOGGER.info("collect log")
                strRet = str(ssh.execCmdNoLogTimout(strCmd_old, G_LOG_TIMO))
            else:
                strRet = str(ssh.execCmdNoLog(strCmd_old))
            
            isExecNewCmd = False

        index_1 = strRet.find("Error: Sftp put file failed")
        index_2 = strRet.find("Error: Collection succeeded but the Sftp put file failed")
        index_3 = strRet.find("Command executed successfully.")
        index_4 = strRet.find("Collection succeeded and the command was successfully executed")
        index_5 = strRet.find("Error: Part of information was successfully collected but the Sftp put file failed")
        index_6 = strRet.find("Part of infomration was successfully collected and the command was successfully executed")
        index_7 = strRet.find("Error: Sftp get file failed.")
        index_8 = strRet.find("File Path : /OSM/export_import/")
        #系统未在正确模式下
        if -1 == strRet.find(":/>"):
            if lang == "zh":
                devObj["py_detail"] = u"系统未在正确模式下。\n" + strRet
            else:
                devObj["py_detail"] = "The system is not in right mode.\n"+ strRet
            return (False, "")
        
        if(-1 != strRet.find("The system is busy. Please try again later")):
            PY_LOGGER.info("Collect error, result is:" + strRet)
            devObj["py_detail"] = "The system is busy. Please try again later."
            #收集失败，但可能阵列上已经产生所收集的文件，需要删除
            deleteRemoteFile(devObj, type)
            return (False, "")
        
        if((-1 != strRet.find("-bash: export")) or (-1 != strRet.find("minisystem"))):
            PY_LOGGER.info("Collect error, result is:" + strRet)
            devObj["py_detail"] = "The system is not in right mode."
            #收集失败，但可能阵列上已经产生所收集的文件，需要删除
            deleteRemoteFile(devObj, type)
            return (False, "")
        if False == isExecNewCmd:
            if ((index_1 == -1) and (index_2 == -1) and (index_3 == -1) and (index_4 == -1) and (index_5 == -1) and (index_6 == -1) and (index_7 == -1)):
                PY_LOGGER.info("index_1:" + str(index_1) + "; index_2:" + str(index_2) + "; index_3:" + str(index_3) + "; index_4:" + str(index_4) + "; index_7:" + str(index_7) + "; index_8:" + str(index_8))
                devObj["py_detail"] = strRet             
                #收集失败，但可能阵列上已经产生所收集的文件，需要删除
                deleteRemoteFile(devObj, type)
                return (False, "")
        elif index_8 == -1:
            PY_LOGGER.info("index_8:" + str(index_8))
            devObj["py_detail"] = strRet
            deleteRemoteFile(devObj, type)
            return (False, "")
        
        if type == "ALM":
            devObj["collecRemotePath"] = "/OSM/export_import/event_export.tar"		
            devObj["collectRetFileName"] = "event_export.tar"
        if type == "LOG":
            list = sftp.listFiles("/OSM/export_import")
            for field in list:
                PY_LOGGER.info("file name in export_import is:" + field)
                if field.find("Datacollect") != -1:
                    devObj["collecRemotePath"] = "/OSM/export_import/" + field		
                    devObj["collectRetFileName"] = field
        if type == "SYSCONFIG":
            devObj["collecRemotePath"] = "/OSM/export_import/OSM_sysconfig.txt"		
            devObj["collectRetFileName"] = "OSM_sysconfig.txt"
        if type == "DB":
            devObj["collecRemotePath"] = "/OSM/export_import/db.dat"
            devObj["collectRetFileName"] = "db.dat"
            
        strRet = download_File(devObj, type)
        #下载文件完后从阵列上删除对应文件
        deleteRemoteFile(devObj, type)
        if strRet == False:
            return (False, "")
        strRet = func_after_download(devObj, type)
        if strRet == False:
            return (False, "")

        if type == "LOG":
            if ((index_5 != -1) or (index_6 != -1)):
                step = "step11"
                PY_LOGGER.info("index_5:" + str(index_5) + "; index_6:" + str(index_6))
                func_fail_after_download(devObj, step)
                return (False, "")
        return (True, "")
    except:
        PY_LOGGER.info("catch except when execute module1~~~over~")
        
        PY_LOGGER.info("except trace back:" + str(traceback.format_exc()))
        devObj["py_detail"] = "catch except when execute module1~~~over~"
        return (False, "")
        
def execute_alm(devObj):
    
    lang = devObj.get("lang")
    #检查系统是否Normal
    if not CheckSystemNormal(devObj):
        if lang == "zh":
            devObj["py_detail"] = u"当前系统状态异常，不能执行收集操作"
        else:
            devObj["py_detail"] = "The system is abnormal, can not support to collect"
        return (False, "")              
    
    #guest用户不支持
    if getUserPrivilege(devObj) in ["Super_admin", "Admin"]:
        return execute(devObj, G_ITEM_ALM)
    else:
        if lang == "zh":
            devObj["py_detail"] = u"当前登录的用户级别不支持导出告警文件"
        else:
            devObj["py_detail"] = "The level of current user does not support to export alarm"
        return (False, "")        
    
def execute_log(devObj):
    
    lang = devObj.get("lang")
    #检查系统是否Normal
    if not CheckSystemNormal(devObj):
        if lang == "zh":
            devObj["py_detail"] = u"当前系统状态异常，不能执行收集操作"
        else:
            devObj["py_detail"] = "The system is abnormal, can not support to collect"
        return (False, "")   

    #guest用户不支持
    if getUserPrivilege(devObj) in ["Super_admin", "Admin"]:
        return execute(devObj, G_ITEM_LOG)
    else:
        if lang == "zh":
            devObj["py_detail"] = u"当前登录的用户级别不支持导出系统日志"
        else:
            devObj["py_detail"] = "The level of current user does not support to export system log"
        return (False, "")   

def execute_sysconfig(devObj):
    lang = devObj.get("lang")
    #检查系统是否Normal
    if not CheckSystemNormal(devObj):
        if lang == "zh":
            devObj["py_detail"] = u"当前系统状态异常，不能执行收集操作"
        else:
            devObj["py_detail"] = "The system is abnormal, can not support to collect"
        return (False, "")   

    #guest用户不支持
    if getUserPrivilege(devObj) in ["Super_admin", "Admin"]:
        return execute(devObj, G_ITEM_SYS)
    else:
        if lang == "zh":
            devObj["py_detail"] = u"当前登录的用户级别不支持导出系统配置数据"
        else:
            devObj["py_detail"] = "The level of current user does not support to export system configuration"
        return (False, "")   

def execute_db(devObj):

    lang = devObj.get("lang")
    #检查系统是否Normal
    if not CheckSystemNormal(devObj):
        if lang == "zh":
            devObj["py_detail"] = u"当前系统状态异常，不能执行收集操作"
        else:
            devObj["py_detail"] = "The system is abnormal, can not support to collect"
        return (False, "")   

    #guest用户不支持
    if getUserPrivilege(devObj) in ["Super_admin"]:
        return execute(devObj, G_ITEM_DB)
    else:
        if lang == "zh":
            devObj["py_detail"] = u"当前登录的用户级别不支持导出DB数据"
        else:
            devObj["py_detail"] = "The level of current user does not support to export DB data"
        return (False, "")   

def execute_elable(devObj):
    
    lang = devObj.get("lang")
    #检查系统是否Normal
    if not CheckSystemNormal(devObj):
        if lang == "zh":
            devObj["py_detail"] = u"当前系统状态异常，不能执行收集操作"
        else:
            devObj["py_detail"] = "The system is abnormal, can not support to collect"
        return (False, "")   

    return execute(devObj, G_ITEM_ELABLE)

def execute_clicmd(devObj):
    lang = devObj.get("lang")
    #检查系统是否Normal
    if not CheckSystemNormal(devObj):
        if lang == "zh":
            devObj["py_detail"] = u"当前系统状态异常，不能执行收集操作"
        else:
            devObj["py_detail"] = "The system is abnormal, can not support to collect"
        return (False, "")
    
    #根据设备型号，重新整理CLI目录集合，若为S5000T的设备，则添加相关CLI命令
    productVersion = str(devObj.get("devNode").getProductVersion())
    PY_LOGGER.info("dev sproductVersion : " + str(productVersion))
    if productVersion.startswith("V200R002"):
        for ci in list_S5000T_cmd:
            list_cli_cmd.append(ci)
   
    return execute(devObj, G_ITEM_CLICMD)
