# coding: UTF-8
from java.io import File
import logging

# 打包命令

G_PACKAGE_CMD_STR = "/opt/uds/servicetool/servicetool.sh package"
G_TIMEOUT = 1800


# *************************************************************************#
# Function   :  pack_and_down - 打包和下载收集的信息
# Usage      :  pack_and_down <option list>
# Parameters :
#            $1 -- The obj from tool
# Return     :
#            (True,"")  right
#            (False,"") wrong
# *************************************************************************#
def after_collect(dev_obj):
    try:
        ssh = dev_obj.get("SSH")
        PY_LOGGER.info("begin package now")
        node_lst = dev_obj.get("integrate_selected_node")
        command = G_PACKAGE_CMD_STR + " " + node_lst
        PY_LOGGER.info("package command is " + command)
        str(ssh.execCmdWithTimout("TMOUT=0", G_TIMEOUT))
        str_ret = str(ssh.execCmdWithTimout(command, G_TIMEOUT))
        PY_LOGGER.info("command result  is " + str_ret)
        if str_ret is None or str_ret.find("Failure") != -1:
            return False, ""
        PY_LOGGER.info("command result:\n" + str_ret)
        for line in str_ret.split('\n'):
            values = line.split(':')
            PY_LOGGER.info("line result:\n" + line)
            if values[0] == "Success ":
                collect_path = values[1].strip()
                dev_obj["collecRemotePath"] = collect_path
                PY_LOGGER.info("success")
                return True, ""
        return False, ""
    except BaseException:
        return False, ""
