# coding: UTF-8
import re


# *************************************************************************#
# Function   :  execute - 信息收集获取设备时间的函数
# Usage      :  execute <option list>
# Parameters :
# Return     :
#            (True,"")  right
#            (False,"") wrong
# Date       :  2015-03-02
# *************************************************************************#
def execute(dev_obj):
    try:
        ssh = dev_obj.get("SSH")
        ret_str_cmd = "date '+%Y-%m-%d %H:%M:%S'"
        cli_ret = ssh.execCmd(ret_str_cmd)
        date_str = cli_ret.splitlines()[1]
        regex = r"\s*[0-9]{4}-[0-9]{1,2}-[0-9]{1,2}\s[0-9]{1,2}:[0-9]{1,2}:[0-9]{1,2}\s*"
        if re.match(regex, date_str):
            dev_obj["date_back"] = str(date_str)
            return True, ""
        else:
            return False, ""
    except BaseException:
        return False, ""
