# coding: UTF-8
# 标准块logging是日志管理模块，inspect是搜检模块
import logging
import inspect
import os

from java.io import File


G_UDS_TOPO = "/opt/uds/servicetool/servicetool.sh topo"
G_TIMEOUT = 1800


# devObj是工具侧定义的一个键值对
def execute(dev_obj):
    try:
        ssh = dev_obj.get("SSH")

        # 远程执行命令
        str(ssh.execCmdWithTimout("TMOUT=0", G_TIMEOUT))
        strRet = str(ssh.execCmdWithTimout(G_UDS_TOPO, G_TIMEOUT))

        li = strRet.split("\n")
        xmlRes = ""
        for i in range(len(li)):
            if i != 0 and i != len(li) - 1:
                xmlRes = xmlRes + li[i] + "\n"

        # 把一体化的结果传给devObj
        PY_LOGGER.info("xml is " + xmlRes)
        dev_obj["integrate_back"] = xmlRes

        # 返回的结果必须是元组，不能是True或False，这是工具统一的约定
        return True, ""
    except BaseException:
        return False, ""
