#coding: UTF-8

from java.io import File

G_STRCMD = "/opt/uds/servicetool/servicetool.sh collect"
G_TIMEOUT = 1800
# 信息收集项的编号定义，比如2.1项定义为G_ITEM_21=21
G_ITEM_1000 = "1000"
G_ITEM_20000 = "20000,20005"
G_ITEM_20001 = "20001"
G_ITEM_2500 = "2500"
G_ITEM_20002 = "20002"
G_ITEM_20003 = "20003"
G_ITEM_20004 = "20004"
G_ITEM_20006 = "2000601,2000602,2000603,2000604,2000605,2000606,2000607,2000608,2000609,2000610"
G_ITEM_20007 = "20007"
G_ITEM_3000 = "3000"
# *************************************************************************#
# Function   :  execute - 信息收集调用shell的函数
# Usage      :  execute <option list>
# Parameters :
#            $1 -- The obj from tool
#               $2 -- The number of collect
# Return     :
#            (True,"")  right
#            (False,"") wrong
# *************************************************************************#


def execute(dev_obj, num):
    try:
        ssh = dev_obj.get("SSH")
        start_time = dev_obj.get("startTime")
        end_time = dev_obj.get("endTime")
        node_lst = dev_obj.get("integrate_selected_node")
        ret_str_cmd = G_STRCMD + " " + node_lst + " " + \
            num + " " + start_time + " " + end_time
        PY_LOGGER.info("InfoCollect tool excute command is :" + ret_str_cmd)
        str(ssh.execCmdWithTimout("TMOUT=0", G_TIMEOUT))
        str_ret = str(ssh.execCmdWithTimout(ret_str_cmd, G_TIMEOUT))

        if not str_ret:
            dev_obj["py_detail"] = 'Information collected returns the result as an unrecognized'
            return False, ""
        if str_ret.find("Failure") != -1:
            PY_LOGGER.info("servicetool.sh collect excute failed")
            msg = ""
            PY_LOGGER.info("strRet:" + str_ret)
            tag = "F"
            for line in str_ret.split('\n'):
                if line.find("Failure") >= 0 or tag == "T":
                    if line.find("#") >= 0:
                        break
                    msg = msg + line + '\r\n'
                    tag = "T"
            PY_LOGGER.info(msg)
            dev_obj["py_detail"] = msg
            return False, ""
        PY_LOGGER.info("servicetool.sh collect excute sucess")
        return True, ""
    except BaseException:
        PY_LOGGER.error("collect data fail.")
        dev_obj["py_detail"] = 'collect data fail.'
        return False, ""

#*************************************************************************#
# Function   :  execute_10 - 信息收集第10项
# Usage      :  execute_10 <option list>
# Parameters :
#            $1 -- The obj from tool
# Return     :
#            (True,"")  right
#            (False,"") wrong
#*************************************************************************#


def execute_1000(dev_obj):
    return execute(dev_obj, G_ITEM_1000)


def execute_20000(dev_obj):
    return execute(dev_obj, G_ITEM_20000)


def execute_20001(dev_obj):
    return execute(dev_obj, G_ITEM_20001)


def execute_2500(dev_obj):
    return execute(dev_obj, G_ITEM_2500)


def execute_20002(dev_obj):
    return execute(dev_obj, G_ITEM_20002)


def execute_20003(dev_obj):
    return execute(dev_obj, G_ITEM_20003)


def execute_20004(dev_obj):
    return execute(dev_obj, G_ITEM_20004)


def execute_20006(dev_obj):
    return execute(dev_obj, G_ITEM_20006)


def execute_20007(dev_obj):
    return execute(dev_obj, G_ITEM_20007)


def execute_3000(dev_obj):
    return execute(dev_obj, G_ITEM_3000)
