#coding: UTF-8
from java.io import File
import logging

# 收集预处理命令

G_PRE_CMD_STR = "/opt/uds/servicetool/servicetool.sh collectdecompress"
G_TIMEOUT = 1800


def pre_collect(dev_obj):
    try:
        PY_LOGGER.info("precollect info begin")
        ssh = dev_obj.get("SSH")
        start_time = dev_obj.get("startTime")
        end_time = dev_obj.get("endTime")
        node_lst = dev_obj.get("integrate_selected_node")
        command = G_PRE_CMD_STR + " " + node_lst + " " + start_time + " " + end_time
        PY_LOGGER.info("precollect command is " + command)
        str(ssh.execCmdWithTimout("TMOUT=0", G_TIMEOUT))
        str_ret = str(ssh.execCmdWithTimout(command, G_TIMEOUT))
        PY_LOGGER.info("command result  is " + str_ret)
        if not str_ret or str_ret.find("Failure") != -1:
            msg = ""
            PY_LOGGER.info("strRet:" + str_ret)
            tag = "F"
            for line in str_ret.split('\n'):
                if line.find("Failure") >= 0 or tag == "T":
                    if line.find("#") >= 0:
                        break
                    msg = msg + line + '\r\n'
                    tag = "T"
            PY_LOGGER.info(msg)
            dev_obj["py_detail"] = msg
            return False, ""
        PY_LOGGER.info("precollect execute sucess")
        return True, ""
    except BaseException:
        return False, ""
