# -*- coding: UTF-8 -*-
import os
import codecs
import shutil
import traceback
from common.util import log, util
from common.cliFactory import cli
from common.config import config
from common.parseDisk import converSmartInfo


G_INFORMATION_SPLIT_STR = "\n" + 20 * "*" + "\n"

def dealSmartInfo(devObj):
    """
        处理从阵列侧收集的到得文件，将其转换为日志分析工具需要的格式
    """
    #创建处理后的smart信息的存放路径
    (isSucc, diskSmartInfoFolder) = createDir(devObj)
    if not isSucc:
        errMsgKey = "create.smartDir.failed"
        return (isSucc, errMsgKey)
    
    #创建basic.txt文件
    (isSucc, errMsgKey, diskInfoCliRet) = createBasicInfoFile(devObj, diskSmartInfoFolder)
    if not isSucc:
        return (isSucc, errMsgKey)
    
    #创建smart信息文件，sumary.ini文件
    smartInputDir = util.getLocalInfoPathByType(devObj, config.COLLECT_TYPE_SMART)
    logObj = devObj.get("logger")
    #获取所有disk的ID
    diskIdList, diskDhaInfo = getDiskIdAndDha(diskInfoCliRet)
    diskSNList = getDiskSN(diskInfoCliRet)
    log.info(devObj, "the list of disk id is %s" % str(diskIdList))
    try:
        converSmartInfo(smartInputDir, diskSmartInfoFolder, logObj, diskIdList, diskSNList, diskDhaInfo, devObj)
    except:
        isSucc = False
        errMsgKey = "create.smart.file.failed"
        log.info(devObj, "write smart.txt or sumary.ini failed")
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
         
    return (isSucc, errMsgKey) 
    

def createBasicInfoFile(devObj, fileBaseDir):
    """
        创建smart分析工具所需的basicinfo.txt文件
    """
    #获取CLI回显，并写入basicinfo.txt中
    (isSucc, errMsgKey, diskInfoCliRet) = writeBasicInfo2File(devObj,fileBaseDir)
    #写文件失败，则删除临时信息
    if not isSucc:
        deleteBaseDir(fileBaseDir)
    
    return (isSucc, errMsgKey, diskInfoCliRet)
    

def createDir(devObj):
    """
        创建处理后的smart信息的存放路径
    """
    isSucc = True
    diskSmartInfoFolder = devObj[config.COLLECT_INFO_LOCAL_PATH] + os.path.sep + os.path.sep + "disksmartinfo"
    try:
        if os.path.exists(diskSmartInfoFolder):
            shutil.rmtree(diskSmartInfoFolder)
        
        os.makedirs(diskSmartInfoFolder)
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc())) 
        isSucc = False
    
    return (isSucc, diskSmartInfoFolder)


def writeFile(devObj, fileName, info, isAdd = True):
    '''
          向文件basicinfo.txt中写内容：
    '''    
    isSucc = True
    try:
        #判断是否为追加内容
        if isAdd:
            localFile = codecs.open(fileName, "a", "utf-8")
        else:
            localFile = codecs.open(fileName, "w", "utf-8")
            
        localFile.write(info)
        localFile.flush()
        localFile.close()
    except:
        log.info(devObj, "write file failed because " + str(traceback.format_exc()))
        isSucc = False
    
    return isSucc


def deleteBaseDir(fileBaseDir):  
    """
        处理失败，删除临时文件夹
    """
    try:
        shutil.rmtree(fileBaseDir, True)
    except:
        log.info(devObj, "delete base dir of smart disk infomation failed!")
        log.info(devObj, "excute cli.executeCmd failed because " + str(traceback.format_exc()))
        
def writeBasicInfo2File(devObj,fileBaseDir):
    '''
        回去CLI回显，并写入文件basicinfo.txt中
    '''
    (isSucc, errMsgKey, diskInfoCliRet) = (True, "", "")
    fileName = fileBaseDir + os.sep + "basicinfo.txt"
    
    #将设备IP写入basic.txt文件
    devIp = util.getDevIp(devObj)
    msgInfo = "smart analyzelog device ip : " + devIp + G_INFORMATION_SPLIT_STR
    isSucc = writeFile(devObj, fileName, msgInfo, False)
    if not isSucc:
        log.info(devObj, "write device ip to basic.txt failed!")
        
    #写系统信息
    cmd = "show system general"
    (isSucc, cliRet) = cli.executeCmdNoLogTimeout(devObj, cmd)
    if not isSucc:
        errMsgKey = "dev.conn.failure"
        return (isSucc, errMsgKey, diskInfoCliRet)
    else:
        isSucc = writeFile(devObj, fileName, cliRet + G_INFORMATION_SPLIT_STR)
        if not isSucc:
            errMsgKey = "create.basicinfo.file.failed"
            return (isSucc, errMsgKey, diskInfoCliRet)
    
    #写硬盘信息
    cmd = "show disk general |filterColumn include columnList=ID,Serial\sNumber,Type,Manufacturer,Health\sMark"
    (isSucc, diskInfoCliRet) = cli.executeCmdNoLogTimeout(devObj, cmd)
    if not isSucc:
        errMsgKey = "dev.conn.failure"
        return (isSucc, errMsgKey, diskInfoCliRet)
    else:
        isSucc = writeFile(devObj, fileName, diskInfoCliRet + G_INFORMATION_SPLIT_STR)
        if not isSucc:
            errMsgKey = "create.basicinfo.file.failed"
            return (isSucc, errMsgKey, diskInfoCliRet)
        
    return (isSucc, errMsgKey, diskInfoCliRet)
    
def getDiskIdAndDha(diskInfoCliRet):
    diskIdList = []
    diskDhaInfo = {}
    dictList = cli.getCliTable2DictList(diskInfoCliRet)
    for diskInfo in dictList:
        diskId = diskInfo.get("ID")
        diskSN = diskInfo.get("Serial Number")
        diskIdList.append(diskId)
        
        diskDha = diskInfo.get("Health Mark")
        if diskDha is None or not diskDha.isdigit():
            diskDha = "N/A"
        diskDhaInfo.setdefault(diskId, diskDha)
        #某些版本原始smart信息不一致需要用SN号处理
        diskDhaInfo.setdefault(diskSN, diskDha)
        
    return diskIdList, diskDhaInfo

def getDiskSN(diskInfoCliRet):
    diskSNList = []
    dictList = cli.getCliTable2DictList(diskInfoCliRet)
    for dict in dictList:
        diskSN = dict.get("Serial Number")
        diskSNList.append(diskSN)
    return diskSNList