# -*- coding: UTF-8 -*-
from java.io import File
from com.huawei.ism.tool.framework.pubservice.hardware import DiskLocation
from com.huawei.ism.tool.infocollect.entity import CollectStatus
import com.huawei.ism.tool.infocollect.util.DataCollectConstants as dcc
import traceback
import time
from sshTools import SSHToolUtils
try:
    import defusedxml.cElementTree as ET
except:
    import defusedxml.ElementTree as ET

import re
import os
class NormalDiskLogCollector():
    '''
    @summary: collection running disk logs on high-end device.
    '''

    def __init__(self, devObject, logger, commonUtil, msginfo, disklogConfig, diskLogCollectInterval):
        '''
        @summary:  initial parameters
        '''
        self.devObj = devObject
        self.util = commonUtil
        self.log = logger
        self.msgInfo = msginfo
        self.disklogConf = disklogConfig
        self.util.initPyDetailMsg()
        self.connectedIp = None
        self.sshConnection = None
        self.sftpConnection = None
        self.nosupportDiskLocList = []
        self.failedDiskLocList = []
        self.partlySuccDiskLocList = []
        self.stoppedDiskLocList = []
        self.resultDict = {}
        self.succNum = 0
        self.partSuccNum = 0
        self.interval = diskLogCollectInterval

        self.log.info("normal disk log collection initialized...")

    def getOneControllerSshConnection(self, ipList):
        '''
        @summary: select one controller &build new ssh&sftp connection
        @return: vacant
        @raise exception 
        @status: self.connectedIp will be set
        @status: self.sshConnection will be set
        @status: self.sftpConnection will be set
        '''
        try:
            sshtoolUtils = SSHToolUtils(self.devObj, self.log)
            isConnected = False
            for curIp in ipList:
                isSuccess, ssh = sshtoolUtils.newSshUsingCrntUsrCredential(curIp)
                if isSuccess and ssh is not None:
                    self.sshConnection = ssh
                    self.log.info("successfully built ssh connection to %s" % str(curIp))
                    isSftpSuccess, sftp = sshtoolUtils.deriveSftpTransporter(self.sshConnection)
                    if isSftpSuccess and sftp is not None:
                        self.sftpConnection = sftp
                        self.connectedIp = curIp
                        isConnected = True
                        self.log.info("successfully built sftp connection to %s" % str(self.connectedIp))
                        break
                    else:
                        sshtoolUtils.closeSshConnection(self.sshConnection)
                else:
                    continue
            return  isConnected

        except Exception, excp:
            self.log.error("error occurred while querying ctrlr SSH connection:%s" % str(excp))
            return False

    def doCollect(self):
        '''
        @summary: collection entrance
        @return: boolean,string  
        '''
        isSuccess, errMsg = self.util.checkSystemNormal()
        if not isSuccess:
            self.util.setPyDetailMsg(errMsg)
            return False, ""
        try:
            isSuccess, controllerIpMap = self.util.getEnginCntrIpMap()
            if not isSuccess or not controllerIpMap:
                raise Exception, "failed.query.ctrlr.ip.lists"
            selDiskList = self.devObj.get(dcc.SELECTTED_DISK_KEY_IN_PYENV)
            self.msgInfo.writeMsgLine('selectedDisk=' + unicode(len(selDiskList)))
            self.log.info("selected disk list of which running log to be collected:%s" % str(selDiskList))
            selectedDiskInfoList = self.convertDiskInfoDto2Tuple(selDiskList)
            if not selDiskList:
                raise Exception , "error.no.disk.selected"
            for curEngin in controllerIpMap:
                self.log.info("current engine is %s ." % str(curEngin))
                curEnginDiskList = [i for i in selectedDiskInfoList if len(i[0]) >= 4 and i[0][3] == curEngin]
                if not self.getOneControllerSshConnection(controllerIpMap[curEngin]):

                    self.msgInfo.writeMsgLine("Engine " + curEngin + "'s all controller failed to be connected ",
                             self.disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
                    for diskInfo in curEnginDiskList:
                        self.failedDiskLocList.append(diskInfo[0])
                    continue
                self.util.enterMiniSystemModOnHost(self.sshConnection, self.connectedIp)
                isNewDisktool = self.isNewDisktoolAvailable()
                # i[0] is disk id , which must exists.
                self.log.info("now collecting  disk lists:  %s ." % str(curEnginDiskList))
                if curEnginDiskList:
                    self.doDiskLogCollectionJob(curEnginDiskList, isNewDisktool)

            return self.calculateProcessStatus(selectedDiskInfoList)
        except BaseException, excp:
            excp = str(excp)
            self.log.error("exception occurred while processing NormalDiskLogCollector -> doCollect %s" % excp)
            if re.match("([a-z|A-z]+[.]+)+[a-z|A-Z]+(\|\|)(\S)+", excp):
                errMsg = excp.split("||")[0]
                msgParam = excp.split("||")[1]
                self.util.setPyDetailMsg(errMsg, msgParam)
            elif re.match("([a-z|A-z]+[.]+)+[a-z|A-Z]+", excp):
                self.util.setPyDetailMsg(excp)

            else:
                self.util.setPyDetailMsg("dev.conn.failure")

            return False, ""
        finally:
            self.deleteDisktool()
            self.util.tryExitMiniSystemOnHost(self.sshConnection, self.connectedIp)
            sshtoolUtil = SSHToolUtils(self.devObj, self.log)
            sshtoolUtil.closeSftpConnection(self.sftpConnection)
            sshtoolUtil.closeSshConnection(self.sshConnection)


    def deleteDisktool(self):
        '''
        @summary: delete disktool when finished disk log collection
        '''
        try:
            self.sftpConnection.deleteFile(self.disklogConf.SFPT_HOME_DIR + '/disktool')
            self.log.info("Delete disktool file successfully.")
        except :
            self.log.error("error occurred when deleting disktool, continue...")

    def calculateProcessStatus(self, selectedDiskInfoList):
        '''
        @summary: while collection has finished, calculation will be started 2 count status
        @return status, ""
        '''
        self.failedDiskLocList = list(set(self.failedDiskLocList))

        self.nosupportDiskLocList.sort(key = lambda diskID:getDiskLocSortKey(diskID))
        self.failedDiskLocList.sort(key = lambda diskID:getDiskLocSortKey(diskID))
        self.partlySuccDiskLocList.sort(key = lambda diskID:getDiskLocSortKey(diskID))
        self.stoppedDiskLocList.sort(key = lambda diskID:getDiskLocSortKey(diskID))

        self.msgInfo.writeMsgLine('success=' + unicode(self.succNum))
        self.msgInfo.writeMsgLine('partly success=' + unicode(self.partSuccNum))
        self.msgInfo.writeMsgLine('failed=' + unicode(len(self.failedDiskLocList)))
        self.msgInfo.writeMsgLine('unsupported =' + unicode(len(self.nosupportDiskLocList)))
        self.msgInfo.writeMsgLine('stopped =' + unicode(len(self.stoppedDiskLocList)))

        self.devObj['collectResultDict'] = self.resultDict
        if self.partlySuccDiskLocList:
            self.util.addPyDetailMsg('collect.disk.log.partly.success', ','.join(self.partlySuccDiskLocList))

        if self.nosupportDiskLocList:
            self.util.addPyDetailMsg('collect.disk.log.not.support', ','.join(self.nosupportDiskLocList))

        if self.failedDiskLocList:
            self.util.addPyDetailMsg('collect.disk.log.failed', ','.join(self.failedDiskLocList))

        if self.stoppedDiskLocList:
            self.util.addPyDetailMsg('collect.disk.log.stopped', ','.join(self.stoppedDiskLocList))

        if self.succNum == len(selectedDiskInfoList):
            return True, ''
        elif self.succNum == 0 and 0 == len(self.partlySuccDiskLocList):
            return False, ''
        else:
            #partly success setting.
            self.util.setCollectAllInfo(False)
            return True, ''

    def convertDiskInfoDto2Tuple(self, selDiskList):
        '''
        @summary: convert Disk information Pojo(java) into tuple obj
        @return: selectedDiskInfoList: tuple
        '''
        selectedDiskInfoList = []
        for diskInfoDto in selDiskList:
            diskInfoTuple = (
                             diskInfoDto.getDiskLocation().toString(),
                             diskInfoDto.getDiskSn(),
                             diskInfoDto.getVendor(),
                             diskInfoDto.getDiskName(),
                             diskInfoDto.getDiskType(),
                             diskInfoDto.getModelNum()
                             )
            selectedDiskInfoList.append(diskInfoTuple)
        self.log.info("now selected disk count:%s" % str(len(selectedDiskInfoList)))

        return selectedDiskInfoList

    def isX86Device(self):
        '''
        @summary:  check whether the system is a X86 Device
        @return:  boolean
        '''
        deviceType = str(self.devObj.get("devNode").getDeviceType()).strip()
        self.log.info("current device type is :%s" % str(deviceType))
        return deviceType not in ['2200 V3', '2600 V3', '2600F V3', '2600 V3 for Video']


    def replaceDisktoolOnDevice(self, isX86):
        '''
        @summary: using SFTP to upload disktool to controller
        '''
        curScriptPth = self.devObj.get(dcc.COLLECT_PYTHON_SCRIPT_PATH)
        disktoolPth = os.path.join(curScriptPth ,
                                   '..', '..',
                                   'disktool',
                                   'x86_64' if isX86 else 'arm_64',
                                   'disktool')
        try:
            self.sftpConnection.putFile(File(disktoolPth), self.disklogConf.SFPT_HOME_DIR, None)
            if not self.sftpConnection.chmod(150, self.disklogConf.SFPT_HOME_DIR + '/disktool'):
                self.log.error('Chmod command on disk-tool failed.')
                return False
            self.log.info("Upload and chmod of disk-tool success.")
            return True
        except Exception, e:
            self.log.error("Upload or chmod of disk-tool exception:" + unicode(e))
            return False

    def isNewDisktoolAvailable(self):
        '''
        @summary:  check whether the new uploaded disk tool is executable
        @return:  boolean
        '''
        isX86Device = self.isX86Device()
        self.log.info("is current device a X86 Architecture device?%s" % str(isX86Device))

        isRplsDisk2lSucc = self.replaceDisktoolOnDevice(isX86Device)
        self.log.info("is Replacement of new  Disk tool Succ?:%s" % str(isRplsDisk2lSucc))
        if not isRplsDisk2lSucc:
            return False
        self.log.info("checking whether  the New disk tool is available:")
        try:
            cmdList = ["./disktool -v", "./disktool -h"]
            for cmd in cmdList:
                isCmdSucc, cmdEcho = self.util.execCliTimeoutGivenSsh(self.sshConnection, cmd)
                if not isCmdSucc:
                    self.log.error("cannot execute %s" % str(cmd))
                    return False
                if "version" in cmdEcho.lower():
                    return True
                if "password:" in cmdEcho.lower():
                    self.log.warn("new disk tool execution required password, quit!")
                    self.sshConnection.execCtrlPlusCCmd(3 * 60)
                    return False

        except Exception, excp:
            self.log.error("exception occurred while checking whether new Disktool available%s" % str(excp))
            return False

    def parseXMLDoc(self, confPth):
        '''
        @summary: parse running disk log configure XML document
        '''
        root = None
        try:
            tree = ET.parse(confPth)
            root = tree.getroot()
        except Exception, excp:
            self.log.error("Parse disk log collect configure file exception:" + unicode(excp))
            return {}

        confMap = {}
        for vendorTree in root.findall("vendor"):
            vendor = vendorTree.attrib["diskVendor"]

            typeTree = vendorTree.findall('diskType')
            for typeNode in typeTree:
                key = (vendor.upper(), typeNode.attrib['type'].upper())
                val = []
                for confNode in typeNode.findall("conf"):
                    val.append((confNode.attrib['collectCmd'], confNode.attrib['resultPth']))
                confMap[key] = val

        return confMap

    def isHSSDV2(self, vendor, diskModelNum):
        return vendor.upper() == 'HUAWEI' and diskModelNum.upper().startswith('HSSD-D5')

    def doDiskLogCollectionJob(self, selectedDiskInfoList, isNewDisktool):
        '''
        @summary: here we do collection commands
        '''
        curScriptPth = self.devObj.get(dcc.COLLECT_PYTHON_SCRIPT_PATH)
        confPthName = os.path.join(curScriptPth , self.disklogConf.DISK_LOG_COLLECT_CMD_AND_LOG_CONF)
        self.log.info("running disk log configure file is %s" % str(confPthName))
        collectCmdMap = self.parseXMLDoc(confPthName)

        allSelectedDiskIdList =map(lambda diskPara:diskPara[0], selectedDiskInfoList)
        for (diskID, diskSn, vendor, diskBlkDev, diskType, diskModelNum) in selectedDiskInfoList:
            if vendor in ['HUASY', 'huasy']:
                vendor = 'HUAWEI'

            currntDiskCollctCmds = collectCmdMap.get((vendor.upper(), diskType.upper()), [])[:]
            if not currntDiskCollctCmds:
                self.log.error('Collecting running disk log on ' + diskBlkDev + ' is not supported.')
                self.msgInfo.writeMsgLine('Unsupport Disk['
                             + diskID + ', ' + vendor + ', ' + diskSn + ', ' + diskType + ', ' + diskModelNum + ', ' + diskBlkDev + ']',
                             self.disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
                self.nosupportDiskLocList.append(diskID)
                self.resultDict[DiskLocation(diskID, True)] = CollectStatus.COLLECT_UNSUPPORT
                continue

            thisDiskOkNum = 0

            if self.isHSSDV2(vendor, diskModelNum) and diskType.upper() != 'NVME_SSD':
                currntDiskCollctCmds.append(self.disklogConf.HSSD_EXT_LOG_CMD_RESULT_PATH_TUP)

            isStoped = self.devObj.get('stop').isStopped()
            self.log.warn('disk log collect stop flag: %s.' %isStoped)
            if isStoped:
                stoppedStartIdx = allSelectedDiskIdList.index(diskID)
                self.stoppedDiskLocList = allSelectedDiskIdList[stoppedStartIdx:]
                self.log.warn('disk log collect is stopped.')
                break

            for collectCmd, resultPthName in currntDiskCollctCmds:
                if isNewDisktool:
                    collectCmd = './' + collectCmd

                collectCmd = collectCmd % ("/dev/" + diskBlkDev)
                isSucc, cliRet = self.util.execCliTimeoutGivenSsh(self.sshConnection, collectCmd, self.disklogConf.COLLECT_RUNNING_DISKLOG_CMD_TIMEOUT)
                if not isSucc:
                    self.msgInfo.writeMsgLine('Failed Disk['
                             + diskID + ', ' + vendor + ', ' + diskSn + ', ' + diskType + ', ' + diskModelNum + ', ' + diskBlkDev + ']',
                             self.disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)

                    #Write executed command when command timeout.Otherwise, the CLI echo message contains the command.
                    if "TOOLKIT_SEND_CMD_TIME_OUT" in cliRet:
                        self.msgInfo.writeMsgLine(unicode(collectCmd), self.disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
                    self.msgInfo.writeMsgLine(unicode(cliRet), self.disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
                    self.log.error('Execute collecting disk log command failed:' + unicode(diskID))
                    self.resultDict[DiskLocation(diskID, True)] = CollectStatus.COLLECT_FAILED
                    continue

                if self.isNormalDisklogCollectOk(cliRet):
                    try:
                        localSaveDir = os.path.join(self.util.getLocalInfoPathByType("Disklog"),
                                                    self.disklogConf.RUNNING_DISKLOG_DIR_NAME)
                        if not os.path.exists(localSaveDir):
                            os.makedirs(localSaveDir)

                        #download to local-host
                        localSaveFile = File(localSaveDir, diskID + '_' + diskSn + '_' + resultPthName.split('/')[-1])
                        self.sftpConnection.getFile(resultPthName, localSaveFile, None)
                    except:
                        self.log.error("Download disk log file %s failed." % unicode(resultPthName))
                        self.log.error("Except trace back:" + unicode(traceback.format_exc()))
                    else:
                        thisDiskOkNum += 1
                        self.log.info("Download disk log file to %s successfully." % unicode(localSaveFile))
                else:
                    #Write executed command when command timeout.Other wise, the CLI echo message contains the command.
                    if "TOOLKIT_SEND_CMD_TIME_OUT" in cliRet:
                        self.msgInfo.writeMsgLine(unicode(collectCmd), self.disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
                    self.msgInfo.writeMsgLine(unicode(cliRet), self.disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
                    self.log.error('Collect disk log failed, disk is: %s, collect echo message is: %s' % (unicode(diskID), cliRet))

                try:
                    self.sftpConnection.deleteFile(resultPthName)
                    self.log.info("Delete disk log file %s successfully." % unicode(resultPthName))
                except:
                    self.log.error("Delete disk log exception, except trace back:" + unicode(traceback.format_exc()))

            if thisDiskOkNum == len(currntDiskCollctCmds):
                self.succNum += 1
                self.resultDict[DiskLocation(diskID, True)] = CollectStatus.COLLECT_FINISHED
            elif thisDiskOkNum > 0:
                self.partSuccNum += 1
                self.msgInfo.writeMsgLine('Partly success Disk['
                             + diskID + ', ' + vendor + ', ' + diskSn + ', ' + diskType + ', ' + diskModelNum + ', ' + diskBlkDev + ']',
                             self.disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
                self.resultDict[DiskLocation(diskID, True)] = CollectStatus.COLLECT_FINISHED_NOTALL
                self.partlySuccDiskLocList.append(diskID)
            else:
                self.failedDiskLocList.append(diskID)
                self.resultDict[DiskLocation(diskID, True)] = CollectStatus.COLLECT_FAILED
            time.sleep(self.interval)


    def isNormalDisklogCollectOk(self, returnMsg):
        if len(returnMsg.splitlines()) == 2:
            return True

        collectRetMsgLower = returnMsg.lower()
        for okWord in self.disklogConf.NORMAL_DISKLOG_COLLECT_SUCC_KEYWORDS:
            if okWord in collectRetMsgLower:
                return True

        return False


def getDiskEncAndSlotNum(loc):
    return loc.split(',')[0].strip('('), loc.split(',')[1].strip(')')

def getDiskLocSortKey(loc):
    if "." in loc:
        head = loc.split(".")[0].strip()
        diskNo = loc.split(".")[1].strip()
        return head, int(diskNo)

    elif "," in loc:
        encStr, slotStr = getDiskEncAndSlotNum(loc)
        return int(encStr), int(slotStr)
    else:
        return loc

