﻿#coding:utf-8
import time
import traceback
from cbb.common.util.system import clean_permission_on
from common.util import *
import os
from frameone.common import copy_file_to_smart_and_rename
from frameone.util import collect_util


def execute(devObj):
    try:
        util.refreshProcess(devObj, 1)
        collect_path = util.getLocalDir(devObj) + os.path.sep + devObj["collectRetFileName"]
        add_smart_file(devObj)
        #压缩前，增加eServer描述文件
        creatPkginfo(collect_path, devObj)
        util.refreshProcess(devObj, 10)
        #压缩文件
        localFileFinal = devObj["collectRetFileName"] + ".7z"
        compressFilePath = util.getLocalDir(devObj) + os.path.sep + localFileFinal
        collect_util.copy_log_and_ini_to_collect_ret_dir(devObj, collect_path)
        tar_class = devObj.get("PYENGINE.PY_ZIP")
        tar_class.compressFile(compressFilePath, collect_path)
        devObj["collectRetFileName"] = localFileFinal
        util.refreshProcess(devObj, 50)
        util.cleanDir(collect_path)
        util.refreshProcess(devObj, 80)
        clean_permission_on(compressFilePath, devObj.get("logger"))
        util.refreshProcess(devObj, 100)
        return (True, "")
    except Exception, exception:
        log.error(devObj, "except trace back:" + str(traceback.format_exc()))
        devObj["py_detail"] = "catch except when compress file.~~~over!"
        return (False, "")


def creatPkginfo(rootPath, devObj):
    '''
    @summary: 创建与datacollect同级的目录pkginfo，用于表示该包是信息收集的包。
        pkginfo下有两个空文件
            type_collect: 信息收集的包
            domain_storage: 存储设备
    '''
    pkginfoPath = rootPath + os.sep + "pkginfo"
    typeFile = pkginfoPath + os.sep + "type_collect"
    domainFile = pkginfoPath + os.sep + "domain_storage"
    descFile = pkginfoPath + os.sep + "desc"
    snFmt = "deviceSN=${%s}\n"
    timeFmt = "fileCreateTime=%s"
    try:
        #如果pkginfo已存在，则需要先删除
        if os.path.exists(pkginfoPath):
            shutil.rmtree(pkginfoPath, True)
            
        os.mkdir(pkginfoPath)
        #先创建type文件，然后拷贝type并重命名为domain文件
        fileObj = open(typeFile, "w")  
        fileObj.close()
        shutil.copy(typeFile, domainFile)
        #创建Desc文件并写入SN号和时间（UTC）
        #获取SN号和时间毫秒数
        snInfo = snFmt % str(device.getDeviceSn(devObj))
        timeInfo = timeFmt % str(long(time.time()*1000))
        from com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil import getAllToolVersion
        tool_version = "\ntool-version={{{}}}".format(",\n".join(getAllToolVersion()))
        desc_file = open(descFile, "w")
        seq = [snInfo, timeInfo, tool_version]
        desc_file.writelines(seq)
        desc_file.close()
        log.info(devObj, "[creatPkginfo] Creat the pkginfo succeed!")
    
    except:
        if os.path.exists(pkginfoPath):
            shutil.rmtree(pkginfoPath, True)  
        log.error(devObj, "[creatPkginfo] Creat the pkginfo failed! except trace back: " + str(traceback.format_exc()))


def add_smart_file(devObj):
    path = devObj.get("collect_info_local_path")
    config_path = os.path.join(path, copy_file_to_smart_and_rename.RUNNING_DATA, copy_file_to_smart_and_rename.CONFIG)
    pool_path = os.path.join(path, copy_file_to_smart_and_rename.DATACOLLECT,
                             copy_file_to_smart_and_rename.DISKSMARTINFO, copy_file_to_smart_and_rename.CONFIG)
    smart_path = os.path.join(path, copy_file_to_smart_and_rename.DATACOLLECT,
                              copy_file_to_smart_and_rename.DISKSMARTINFO)
    running_data_path = os.path.join(path, copy_file_to_smart_and_rename.RUNNING_DATA)

    try:
        if os.path.isfile(config_path) and os.path.exists(smart_path):
            shutil.copyfile(config_path, pool_path)
            log.info(devObj, "Smart information collection copying the config file and "
                             "renaming the file to the pool file successfully")
    except Exception:
        log.error(devObj, "Failed to copy the config file and rename the file to the pool file. {}"
                  .format(str(traceback.format_exc())))
    finally:
        if devObj.get("runningDataClean") and os.path.exists(running_data_path):
            shutil.rmtree(running_data_path)
            log.info(devObj, "Delete the config file and Running_Data folder.")
