﻿# -*- coding: UTF-8 -*-
import traceback
from common.util import *
from common.exportCmd import *
from common.exportInfo import *
from common.exportSmart import * 




def collectLog(devObj):
    
    util.initPyDetailMsg(devObj)
    isSucc = exportInfo.exportSysInfo(devObj, config.EXPORT_TYPE_LOG)
    isExistMsg = util.isExistDetailMsg(devObj)
    if False == isSucc and False == isExistMsg:
        util.setPyDetailMsg(devObj, "failed.collect.information")
    return (isSucc, "")
    
    
def collectAllLog(devObj):
    
    util.initPyDetailMsg(devObj)
    isSucc = exportInfo.exportSysInfo(devObj, config.EXPORT_TYPE_ALLLOG)
    isExistMsg = util.isExistDetailMsg(devObj)
    if False == isSucc and False == isExistMsg:
        util.setPyDetailMsg(devObj, "failed.collect.information")
    return (isSucc, "")
    
    
def collectEvent(devObj):
    
    util.initPyDetailMsg(devObj)
    isSucc = exportInfo.exportSysInfo(devObj, config.EXPORT_TYPE_EVENT)
    isExistMsg = util.isExistDetailMsg(devObj)
    if False == isSucc and False == isExistMsg:
        util.setPyDetailMsg(devObj, "failed.collect.information")
    return (isSucc, "")
    
def collectRunningData(devObj):
    
    util.initPyDetailMsg(devObj)
    isSucc = exportInfo.exportSysInfo(devObj, config.EXPORT_TYPE_RUNNING_DATA)
    isExistMsg = util.isExistDetailMsg(devObj)
    if False == isSucc and False == isExistMsg:
        util.setPyDetailMsg(devObj, "failed.collect.information")
    return (isSucc, "")
    
def collectCliCmd(devObj):
    try:
        
        util.initPyDetailMsg(devObj)
        #检查系统是否正常
        isSysNormal = util.checkSystemNormal(devObj, None)
        if False == isSysNormal:
            return(False, "")
        
        #获取收集CLI回显的命令列表
        cliList = exportCmd.getCliList(devObj)
        
        isSucc = exportCmd.exportCliCmd(devObj, cliList, config.COLLECT_TYPE_CLI)
        isExistMsg = util.isExistDetailMsg(devObj)
        if False == isSucc and False == isExistMsg:
            util.setPyDetailMsg(devObj, "failed.collect.information")
        return (isSucc, "")
    
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        util.setPyDetailMsg(devObj, "failed.collect.information")
        return (False, "")
    
def collectElableCmd(devObj):
    try:
        
        util.initPyDetailMsg(devObj)
        #检查系统是否正常
        isSysNormal = util.checkSystemNormal(devObj, None)
        if False == isSysNormal:
            return(False, "")
       
        isSucc = exportCmd.exportElableCmd(devObj, config.COLLECT_TYPE_ELABLE)
        isExistMsg = util.isExistDetailMsg(devObj)
        if False == isSucc and False == isExistMsg:
            util.setPyDetailMsg(devObj, "failed.collect.information")
        return (isSucc, "")
    
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        util.setPyDetailMsg(devObj, "failed.collect.information")
        return (False, "")
    
def collectSmart(devObj):
    try:
        
        util.initPyDetailMsg(devObj)
        isSucc = exportSmart.collectSmart(devObj, config.COLLECT_TYPE_SMART)
        isExistMsg = util.isExistDetailMsg(devObj)
        if False == isSucc and False == isExistMsg:
            util.setPyDetailMsg(devObj, "failed.collect.information")
        return (isSucc, "")
    
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        util.setPyDetailMsg(devObj, "failed.collect.information")
        return (False, "")
    
    