# -*- coding: UTF-8 -*-

import re
from toolutilities import sshutils

class cli():
    
    CLI_RET_END_FLAG = ":/>"
    CLI_NOT_EXIST_FLAG = "^"
    CLI_SYSTEM_BUSY_FLAG = "The system is busy. Please try again later"
    CLI_BASH_EXPORT_FLAG = "-bash: export"
    CLI_MINISYSTEM_FLAG = "minisystem>"
    CLI_DEVELOPER_MODEL_FLAG = "developer:/>"
    CLI_ENTER_DEVELOPER_MODEL_MAX_RETRYS = 5
    CLI_EXECUTED_SUCCESSFULLY = "Command executed successfully"
    PORT_NUM = 22
    
    
    @staticmethod
    def executeCmd(devObj, cmd):
        '''
                        执行CLI命令
        '''
        ssh = devObj.get("SSH")
        cliRet = cli.executeCmdBySsh(ssh, cmd)
        return cliRet
    
    @staticmethod
    def executeCmdBySsh(ssh, cmd):
        '''
                        执行CLI命令
        '''
        cliRet = ssh.execCmd(cmd)
        return cliRet
    
    
    @staticmethod
    def executeCmdNoLog(devObj, cmd):
        '''
                        执行CLI命令,不打印日志信息
        '''
        ssh = devObj.get("SSH")
        cliRet = cli.executeCmdNoLogBySsh(ssh, cmd)
        return cliRet
    
    @staticmethod
    def executeCmdNoLogBySsh(ssh, cmd):
        '''
                        执行CLI命令,不打印日志信息
        '''
        cliRet = ssh.execCmdNoLog(cmd)
        return cliRet
        
    @staticmethod
    def executeCmdNoLogTimeout(devObj, cmd, timeOut):
        '''
                        执行CLI命令，不打印日志信息并且设置相应的超时时间
        '''
        ssh = devObj.get("SSH")
        cliRet = ssh.execCmdNoLogTimout(cmd, timeOut)
        return cliRet
        
    @staticmethod
    def isExistCmdForRec(rec):
        '''
                    根据命令回显信息，判断当前命令是否在系统中存在
                    判断标准：若在回显中出现 '^'符号，则当前命令不存在
        '''
        if None == rec:
            return False
        
        if cli.CLI_NOT_EXIST_FLAG in rec:
            return False
        
        return True
    
    
    @staticmethod
    def getSshByIp(devObj, ip):
        cliCon = None
        username = devObj.get("username")
        password = devObj.get("password")
        context = devObj.get("context")
         
        try:
            cliCon = sshutils.createSSHConnection(ip, username, password, cli.PORT_NUM, context)
            cliCon.connect()
        except:
            return None
    
        return cliCon
    
    @staticmethod
    def getCliTable2DictList(cliRet):
        '''
        @summary: 对表格形式cli回显统一处理
        @param cliRet: cli回显
        @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合
        '''
        try:
            headline = ""
            i = 0
            cliRetList = cliRet.splitlines()
            for line in cliRetList:
                reg_headline = re.compile("^\s*-+(\s+-+)*\s*$") 
                match_headline = reg_headline.search(line)
                if match_headline:
                    headline = match_headline.group()
                    break
                i += 1
            if headline == "" or i == 0 or i >= len(cliRetList) - 1:
                return []
            
            #获取标题
            title = cliRetList[i - 1]
            
            #获取字段值
            field_words = cliRetList[(i + 1):]
            
            reg_split = re.compile("\s*-+\s*")
            tuple_idxs = []
            start_pos = 0
            end_pos = 0
            while (start_pos <= len(headline)):
                match = reg_split.search(headline, start_pos)
                if match:
                    end_pos = match.end()
                    tuple_idxs.append((start_pos, end_pos))
                    start_pos = end_pos
                else:
                    break
                
            keys = []
            for item in tuple_idxs:
                key = title[item[0]:item[1]].strip()
                #字段名重复时,自动添加后缀：_{自增长标记}
                if keys.count(key):
                    key += "_" + str(str(keys).count(key + "_") + 1)
                keys.append(key)
            
            dictList = []
            for line in field_words:
                if len(line) != len(headline):
                    break
                vals = []
                for item in tuple_idxs:
                    vals.append(line[item[0]:item[1]].strip())
                dictList.append(dict(zip(keys, vals)))
                
            return dictList
        except:
            return []

    
