# -*- coding: UTF-8 -*-

class config():
    
    #********************环境型号判断********************
    #设备型号，判断标准
    DEVICE_TYPE_S5000T_STANDARD = "V200R002"
    DEVICE_TYPE_OCEANSTOR_18000_STANDARD = "V100R001"
    DEVICE_TYPE_V3_STANDARD = "V300R002"
    #设备型号
    DEVICE_TYPE_S5000T = "S5000T"
    DEVICE_TYPE_OCEANSTOR_18000 = "18000"
    DEVICE_TYPE_V3 = "V3"
    #********************环境型号判断********************
    
    #********************信息收集类型********************
    EXPORT_TYPE_LOG = "log"
    EXPORT_TYPE_ALLLOG = "all_log"
    EXPORT_TYPE_EVENT = "event"
    EXPORT_TYPE_RUNNING_DATA = "running_data"
    COLLECT_TYPE_CLI = "cli"
    COLLECT_TYPE_ELABLE = "elable"
    COLLECT_TYPE_SMART = "smart"
    #********************信息收集类型********************
    
    #导出系统日志，超时时间
    EXPORT_LOG_TIMEOUT = 185*60
    
    #系统日志收集，主控IP名称后加 "_MAIN"
    COLLECT_CONTOLLER_IP_NAME_END = "_MAIN"
    
    #判断系统日志是否收集完全
    COLLECT_LOG_FILE_INFO = "info_log.txt"
    
    #smart信息单个文件存储的个数
    COLLECT_SMART_NUM_FILE = 20
    #smart收集，每个收集项的收信息
    COLLECT_SMART_INFORMATION_SPLIT_STR = "\n********************\n"
    
    #老版本使用的收集信息的命令
    EXPORT_SYSINFO_CMD_OLD = {
                           EXPORT_TYPE_LOG : "export event event_type=log ip=%s user=admin password=****** path=/collect_alm.tgz clean_device_file=no",
                           EXPORT_TYPE_ALLLOG : "export event event_type=all_log ip=%s user=admin password=******** path=/collect_all_log.tgz clean_device_file=no",
                           EXPORT_TYPE_EVENT : "export event event_type=event ip=%s user=admin password=****** path=/collect_alm.tgz clean_device_file=no",
                           EXPORT_TYPE_RUNNING_DATA : "export running_data ip=%s user=admin password=****** running_data_file=/collect_sysconfig.txt clean_device_file=no"
                           }
    
    #收集系统信息时，需要特殊处理的信息（日志信息，日志大包信息）
    EXPORT_SYSINFO_PROCESS_ITEM = [
                                   EXPORT_TYPE_LOG,
                                   EXPORT_TYPE_ALLLOG
                                   ]
    
    #判断老命令执行成功的列表
    ISEXEC_OLD_CMD_SUCCESS_FLAG = [
                               "Error: Sftp put file failed",
                               "Error: Collection succeeded but the Sftp put file failed",
                               "Command executed successfully.",
                               "Collection succeeded and the command was successfully executed",
                               "Error: Part of information was successfully collected but the Sftp put file failed",
                               "Part of infomration was successfully collected and the command was successfully executed",
                               "Error: Sftp get file failed."
                                ]
    
    #判断老命令执行失败的列表
    ISEXEC_OLD_CMD_NOT_SUCCESS_FLAG = [
                               "Error: Part of information was successfully collected but the Sftp put file failed",
                               "Part of infomration was successfully collected and the command was successfully executed",
                                ]
    
    #判断新命令执行成功的列表
    ISEXEC_NEW_CMD_SUCCESS_FLAG = [
                               "File Path : /OSM/export_import/"
                                ]
    
    #新版本收集信息的命令
    EXPORT_SYSINFO_CMD_NEW = {
                           EXPORT_TYPE_LOG : "show file export_path file_type=log",
                           EXPORT_TYPE_ALLLOG : "show file export_path file_type=all_log",
                           EXPORT_TYPE_EVENT : "show file export_path file_type=event",
                           EXPORT_TYPE_RUNNING_DATA : "show file export_path file_type=running_data"
                           }
    
    
    #CLI回显、电子标签、smart信息收集，对应的文件名称
    CLI_FILE_NAMES_FOR_TYPE = {
                               COLLECT_TYPE_CLI : "clicmd.txt",
                               COLLECT_TYPE_ELABLE : "elabel_info.txt",
                               COLLECT_TYPE_SMART : "basicinfo.txt"
                               }
    
    #CLI回显收集的命令列表
    LIST_CLI_CMD = [
                    "show alarm",
                    "show bbu general",
                    "show bond_port",
                    "show cache_partition general",
                    "show clone general",
                    "show consistency_group general",
                    "show controller general",
                    "show disk general",
                    "show disk_domain general",
                    "show enclosure",
                    "show event",
                    "show event_restore",
                    "show expansion_module",
                    "show fan",
                    "show host general",
                    "show host_group general",
                    "show initiator",
                    "show interface_module",
                    "show iostat policy",
                    "show iscsi initiator_name",
                    "show iscsi target",
                    "show iscsi target_name",
                    "show isns server_ip",
                    "show license",
                    "show license_active",
                    "show lun general",
                    "show lun_copy general",
                    "show lun_group general",
                    "show mapping_view general",
                    "show notification trap",
                    "show port general",
                    "show port_group general",
                    "show power_supply",
                    "show remote_device general",
                    "show remote_replication general",
                    "show schedule",
                    "show security_rule",
                    "show smartqos_policy general",
                    "show smartqos_template",
                    "show snapshot general",
                    "show snmp context_name",
                    "show snmp usm",
                    "show ssd routeswitch",
                    "show storage_engine",
                    "show storage_pool general",
                    "show system general",
                    "show system media_scan",
                    "show system ntp",
                    "show system timezone",
                    "show system manufactory",
                    "show upgrade package",
                    "show user",
                    "show version all",
                    "show lun_migration general",
                    "show lun_destroy_data upgrade_status",
                    "show mirror_lun general",
                    "show mirror_copy general",
                    "show remote_lun general array_type=current_manufacturer_device",
                    "show remote_lun general array_type=other_manufacturer_device",
                    "show smart_cache_pool general",
                    "show smart_cache_partition general",
                    "show lun dedup_compress",
                    "show logical_port general",
                    "show vlan count",
                    "show vlan general",
                    "show failover_group general",
                    "show vstore",
                    "show fs_snapshot general",
                    "show quota general",
                    "show file_system general",
                    "show service cifs",
                    "show common_config nfs",
                    "show service nfs"
                   ]
    
    #需要进入developer模式发送的命令
    LIST_DEVELOPER_CMD = ["show dha judgeproportion", 
                          "show dha policy", 
                          "show dha servicestatus", 
                          "show mp_mode"
                        ]
    
    #需要收集详细信息的CLI列表
    LIST_MULTI_CLI_CMD = {
                          "show bbu general" : ["ID", "bbu_id="],
                          "show disk general" : ["ID", "disk_id="],
                          "show enclosure" : ["ID", "enclosure_id="],
                          "show expansion_module" : ["ID", "expansion_module_id="],
                          "show fan" : ["ID", "fan_id="],
                          "show host general" : ["ID", "host_id="],
                          "show interface_module" : ["ID", "interface_module_id="],
                          "show lun_copy general" : ["ID", "lun_copy_id="],
                          "show lun_group general" : ["ID", "lun_group_id="],
                          "show mapping_view general" : ["Mapping View ID", "mapping_view_id="],
                          "show power_supply" : ["ID", "power_supply_id="],
                          "show storage_engine" : ["ID", "storage_engine_id="],
                          "show storage_pool general" : ["ID", "pool_id="],
                          "show lun dedup_compress" : ["ID", "lun_id="],
                          "show fs_snapshot general" : ["ID", "file_system_id=", "show file_system general"],
                          "show quota general" : ["ID", "file_system_id=", "show file_system general"],
                          "show mirror_copy general" : ["ID", "mirror_lun_id=", "show mirror_lun general"],
                          "show remote_lun general array_type=current_manufacturer_device" : ["ID", "remote_device_id=", "show remote_device general array_type=current_manufacturer_device"],
                          "show remote_lun general array_type=other_manufacturer_device" : ["ID", "remote_device_id=", "show remote_device general array_type=other_manufacturer_device"]
                        }
    
    #收集电子标签的CLI列表
    LIST_ELABLE_CMD = [
                       "show controller general",
                       "show bbu general",
                       "show fan",
                       "show interface_module",
                       "show expansion_module"
                       ]
    
    #收集电子标签详细信息的CLI列表
    LIST_MULTI_ELABLE_CMD = {
                             "show bbu general" : ["ID", "bbu_id="],
                             "show fan" : ["ID", "fan_id="],
                             "show interface_module" : ["ID", "interface_module_id="],
                             "show expansion_module" : ["ID", "expansion_module_id="]
                             }
    
    #smart基本信息收集
    LIST_SMART_BAISC_CMD = [
                            "show system general",
                            "show storage_pool general",
                            "show disk general |filterColumn include columnList=ID,Health\sStatus,Running\sStatus,Type,Capacity,Role,Disk\sDomain\sID,Speed(RPM),Health\sMark,Manufacturer,Serial\sNumber"
                            ]
    
    #smart基本信息收集
    LIST_MULTI_SMART_BAISC_CMD = {
                                  "show disk general" : ["ID", "disk_id="]
                                  }
    
    
    #是否包含，收集CLI的详细信息
    MULTI_CLI_COLLECT = {
                         COLLECT_TYPE_CLI : LIST_MULTI_CLI_CMD,
                         COLLECT_TYPE_ELABLE : LIST_MULTI_ELABLE_CMD,
                         COLLECT_TYPE_SMART : LIST_MULTI_SMART_BAISC_CMD
                         }
    
    
    #TV2R2环境，在收集CLI回显中，需要特殊收集的CLI命令
    LIST_S5000T_V3_CLI_CMD = [
                              "show event_config",
                              "show notification syslog",
                              "show notification sms",
                              ]
    
    #电子标签文件的头信息
    ELABLE_LIST_HEADER = [
                            "<?xml version=\"1.0\" encoding=\"iso-8859-1\" standalone=\"yes\" ?> ",
                            "<DATAPACKET Version=\"2.0\">",
                            "<FILELABEL>",
                            "<VERDESC Ver=\"1.4\" />",
                            "</FILELABEL>",
                            "<TABLES>"
                          ]
    
    #电子标签文件的内容，XML格式的标签名称
    LIST_ELABLE_PROPERTY = {
                            "show controller general" : "Devive",
                            "show bbu general" : "BBU",
                            "show fan" : "FAN",
                            "show interface_module" : "INTERFACE_MODULE",
                            "show expansion_module" : "EXPANSION_MODULE"
                            }
    