# -*- coding: UTF-8 -*-
import os
import traceback
import codecs
from common.util import *
from common.config import *
from com.huawei.oss.cn.common.anonymize import FileAnonymizeUtil
from com.huawei.oss.cn.common.anonymize import AnonymizeType

class exportCmd():
    
    @staticmethod
    def getExecuteCliCmd(strCmd, type):
        '''
        #CLI回显收集，判断当前收集的命令，是否收集详细信息，及详细信息参数的来源
        '''
        result = strCmd
        #判断是否收集详细信息，不收集则直接返回当前命令
        flag = exportCmd.isMultiCmd(strCmd, type)
        if not flag:
            return result
        
        #获取查询详细信息CLI的构造列表
        tempList = config.LIST_MULTI_CLI_CMD[strCmd]
        if len(tempList) <= 2:
            return result
        
        #列表大于2，则需要根据配置的CLI命令，获取参数值
        tempCmd = tempList[2]
        if tempCmd:
            result = tempCmd
    
        return result
       
    @staticmethod
    def getCliList(devObj):
        #判断设备型号，若为S500T或V3，则新增收集的CLI信息
        devType = device.getDeviceType(devObj)
        cliList = []
        cliList.extend(config.LIST_CLI_CMD)
        if devType == config.DEVICE_TYPE_S5000T or devType == config.DEVICE_TYPE_V3:
            cliList.extend(config.LIST_S5000T_V3_CLI_CMD)
        
        return cliList
    
    @staticmethod
    def writeCliCmdFile(devObj, strCmd, type):
        '''
        @summary: CLI回显信息收集，将回显信息写入文件中
        @param cliRet:  devObj=上下文对象
                        type=收集的类型
                        strCmd=回显信息
        @return:
        '''
        #需要写入的目录
        path = util.getLocalTempDir(devObj)
        strCmd = FileAnonymizeUtil.anonymizeMultiLine(strCmd, AnonymizeType.LOG)
        result = exportCmd.writeCliCmdFileByPath(devObj, path, strCmd, type)
        return result
    
    @staticmethod
    def writeCliCmdFileByPath(devObj, path, strCmd, type):
        '''
        @summary: 将回显信息写入文件中
        @param cliRet:  devObj=上下文对象
                        type=收集的类型
                        strCmd=回显信息
                        path=写入的目录
        @return:
        '''
        try:
            f = None
            if True != os.path.exists(path):
                os.mkdir(path)
                
            fileName = config.CLI_FILE_NAMES_FOR_TYPE[type]
            
            f = codecs.open(path + fileName, "a", "utf-8")
            f.write(strCmd)
            return True
        except:
            log.info(devObj, "write except:" + strCmd)
            log.info(devObj, "except trace back:" + str(traceback.format_exc()))
            return False
        finally:
            if None != f:
                f.close()
    
    @staticmethod
    def getMultiCmdList(type):
        '''
                    根据收集的类型，获取需要收集详细信息的命令列表
        '''
        list_cmd = None
        
        if type in config.MULTI_CLI_COLLECT.keys():
            list_cmd = config.MULTI_CLI_COLLECT[type]
            
        return list_cmd
    
    
    @staticmethod
    def isMultiCmd(strCmd, type):
        '''
                    判断是否需要获取CLI命令的详细信息
        '''
        flag = False
        list_cmd = exportCmd.getMultiCmdList(type)
        
        if None == list_cmd:
            return flag
            
        if strCmd in list_cmd.keys():
            flag = True
        
        return flag
        
    @staticmethod
    def getMultiCmdIds(devObj, cliRet, type, strCmd):
        '''
                    获取CLI回显中ID列的信息，返回ID列表
        '''
        list_multi_cmd = []
        
        list_cliRet =cli.getCliTable2DictList(cliRet)
        list_multi = exportCmd.getMultiCmdList(type)
        
        fieldName = list_multi[strCmd][0]
        
        for field in list_cliRet:
            if fieldName in field.keys():
                id = field[fieldName]
                list_multi_cmd.append(id)
            
        return list_multi_cmd
    
    
    @staticmethod
    def getCliResultInfo(devObj, strCmd, type):
        '''
                    获取CLI回显信息，若需要获取详细信息，则获取详细信息
        '''
        result = ""
        list_multi_cmd_ids = []
        if strCmd == None:
            log.info(devObj, "get cmd is none")
            return result
        
        execCmd = exportCmd.getExecuteCliCmd(strCmd, type)
        rec = cli.executeCmd(devObj, execCmd)
        cmdIsExist = cli.isExistCmdForRec(rec)
        if not cmdIsExist:
            return ""
        
        if False == exportCmd.isMultiCmd(strCmd, type):
            result = rec
        else:
            list_multi_cmd_ids = exportCmd.getMultiCmdIds(devObj, rec, type, strCmd)
            list_multi_cmd = exportCmd.getMultiCmdList(type)
            
            for field_cmd in list_multi_cmd_ids:
                cmd = strCmd + " " + list_multi_cmd[strCmd][1] + field_cmd
                recs = cli.executeCmd(devObj, cmd)
                if type == config.COLLECT_TYPE_SMART and "" != result:
                    result = result + config.COLLECT_SMART_INFORMATION_SPLIT_STR + recs
                else:
                    result = result + recs
            
        if type == config.COLLECT_TYPE_SMART:
            result = result + config.COLLECT_SMART_INFORMATION_SPLIT_STR
            if len(list_multi_cmd_ids) > 0:
                result = rec + config.COLLECT_SMART_INFORMATION_SPLIT_STR + result
            
        return result
    
    @staticmethod
    def exportCliCmd(devObj, cliList, type):
        '''
        @summary: 收集CLI回显信息的入口
        @param cliRet:  devObj=上下文对象
                        type=收集的类型
        @return:
        '''
        result = util.getUsername(devObj) + ":/>"
        flag = exportCmd.writeCliCmdFile(devObj, result, type)
        if flag == False:
            log.info(devObj, "write cli into to file fail")
            return flag
        
        #用于判断是否在正确的模式下，只要有一个命令是在正确的模式下就成功
        isInRightMode = False
        
        #获取所有Cli模式下命令回文
        for field in cliList:
            result = exportCmd.getCliResultInfo(devObj, field, type)
            if result == "":
                flag = False
                continue
            if cli.CLI_RET_END_FLAG in result:
                isInRightMode = True
                
            exportCmd.writeCliCmdFile(devObj, result, type)
        
        #系统未在正确模式下
        if False == isInRightMode:
            util.setPyDetailMsg(devObj, "system.not.in.right.mode.noparam")
            return False
        
        #进入developer模式
        changeFlag = systemMode.enterDeveloperMode(devObj)
        #切换到developer模式失败
        if False == changeFlag:
            #设置部分收集成功
            util.setCollectAllInfo(devObj, False)
            #设置界面显示信息
            key = "cli.collect.debug.login.fail"
            util.setPyDetailMsg(devObj, key)
            if True == systemMode.isInDeveloperMode(devObj):
                systemMode.developerMode2CliMode(devObj)
            
            return False
        #获取所有developer模式下命令回文
        for field in config.LIST_DEVELOPER_CMD:
            
            result = exportCmd.getCliResultInfo(devObj, field, type)
            
            if True == systemMode.isInDeveloperMode(devObj):
                isInRightMode = True
                
            exportCmd.writeCliCmdFile(devObj, result, type)
        
        #收集完成，需要退回到Cli模式
        systemMode.developerMode2CliMode(devObj)
        #系统未在正确模式下
        if False == isInRightMode:
            util.setPyDetailMsg(devObj, "system.not.in.right.mode.noparam")
            
        return isInRightMode
    
    @staticmethod
    def isElableEnd(line):
        '''
                    判断电子标签是否结束，根据结束标记和-----判断
        '''
        reg = "^\s*-+\s*$"
        reg_headline = re.compile(reg)
        match_headline = reg_headline.search(line)
        if (cli.CLI_RET_END_FLAG in line) or (None != match_headline):
            return True
        else:
            return False
        
    @staticmethod
    def getElableKeyAndValue(strInfo):
        '''
                        获取电子标签的Key和Value值,如：
        '''
        list = strInfo.splitlines()
        flag_start = False
        list_elable_key = []
        list_elable_value = []
        keyValue = {}
        for field in list:
            if "Electronic Label" in field:
                flag_start = True
            
            if True == exportCmd.isElableEnd(field):
                
                flag_start = False
                if 0 < len(keyValue):
                    list_elable_value.append(keyValue)
                keyValue = {}
            
            if True == flag_start and ("=" in field):
                
                list_temp = field.split("=")
                key = list_temp[0].strip()
                value = list_temp[1].strip()
                
                if key not in list_elable_key:
                    list_elable_key.append(key)
                
                keyValue[key] = value
                    
        return (list_elable_key, list_elable_value)
        
    @staticmethod
    def getFieldType(atrribute_name):
        '''
                    获取标签的类型，当前默认为string，此方法方便后续扩展
        '''
        type = "string"
        return type
    
    
    @staticmethod
    def parseElableInfo(strInfo, strProperty):
        
        '''
                        根据当前回显返回，对应格式的XML标签    如：
        <TABLE attribute="***">
            <METADATA>
            <FIELDS>
                <FIELD attribute = "***" />
            </FIELDS>
            </METADATA>
            <ROWDATA>
                <ROW ***="***" />
            </ROWDATA>
        </TABLE>
        '''
        
        result = "    <TABLE attribute=\"" + strProperty + "\">\n"
        result = result + "        <METADATA>\n" + "        <FIELDS>\n"
        
        keyValue = exportCmd.getElableKeyAndValue(strInfo)
        
        list_elable_key = keyValue[0]
        list_elable_value = keyValue[1]
        
        if len(list_elable_key) == 0:
            result = result + "        </FIELDS>\n        </METADATA>\n    </TABLE>\n"
            return result
        
        value0 = list_elable_value[0]
        for field in list_elable_key:
            result = result + '            <FIELD attribute = "' + field +'" '
            field_type = exportCmd.getFieldType(field)
            valueLen = 0
            if field in value0.keys():
                valueLen = len(value0[field])
            result = result + 'fieldtype = "' + field_type + '" width = "' + str(valueLen) + '" required="true" />\n'
            
        result = result + "        </FIELDS>\n        </METADATA>\n        <ROWDATA>\n"
        
        for elable_value in list_elable_value:
            result = result + '            <ROW'
            
            for elable_key in list_elable_key:
                va = ""
                if elable_key in elable_value.keys():
                    va = elable_value[elable_key]
                result = result + " " + elable_key + '=' + '"' + va + '"'
            
            result = result + " />\n"    
                
         
        result = result + "        </ROWDATA>\n    </TABLE>\n"
        return result
            
    @staticmethod
    def exportElableCmd(devObj, type):
        '''
        @summary: 收集电子标签的入口
        @param cliRet:  devObj=上下文对象
                        type=收集的类型
        @return:
        '''
        result = "default"
        flag = True
        list_header = config.ELABLE_LIST_HEADER
        
        for field_header in list_header:
            exportCmd.writeCliCmdFile(devObj, field_header + "\n", type)

        #添加cli回文是否正常判断标识位
        isCliRetNormal = False
        #用于判断是否在正确的模式下，只要有一个命令是在正确的模式下就成功
        isInRightMode = False
        for field in config.LIST_ELABLE_CMD:
            result = exportCmd.getCliResultInfo(devObj, field, type)
            if result == "":
                continue
            
            if ("Error:" not in result) or ("license" in result):
                isCliRetNormal = True
                
            if cli.CLI_RET_END_FLAG in result:
                isInRightMode = True
                
            if field in config.LIST_ELABLE_PROPERTY.keys():
                result = exportCmd.parseElableInfo(result, config.LIST_ELABLE_PROPERTY[field])
            else:
                result = exportCmd.parseElableInfo(result, "default")
                
            exportCmd.writeCliCmdFile(devObj, result, type)
            
              
        flag = exportCmd.writeCliCmdFile(devObj, "</TABLES>\n</DATAPACKET>", type)
        
        #系统未在正确模式下
        if False == isInRightMode:
            util.setPyDetailMsg(devObj, "system.not.in.right.mode.noparam")
        
        #三种情况同时满足，则收集电子标签成功
        flag = isCliRetNormal and flag and isInRightMode
        
        return flag