# -*- coding: UTF-8 -*-
import traceback
from common.util import *

from cbb.frame.cli.cli_con_check_4_info_collect import CliUtil as CliCheckUtil
from com.huawei.oss.cn.common.anonymize import FileAnonymizeUtil
from com.huawei.ism.tool.infocollect.service import DealFileInCopressPackage

'''
导出系统信息（系统日志，配置信息，告警信息），公共方法
'''
class exportInfo():
    
    @staticmethod
    def isNormalForRec(devObj, rec):
        '''
        @summary: 判断回显信息是否正常
        @param cliRet:  devObj=上下文对象,
                        rec=导出系统信息的回显
        @return: True or False
        '''
        if None == rec or "" == rec:
            return False
        
        #判断系统是否在正确模式下
        if cli.CLI_RET_END_FLAG not in rec:
            util.setPyDetailMsg(devObj, "system.not.in.right.mode", rec)
            return False
        
        #判断系统是否繁忙
        if cli.CLI_SYSTEM_BUSY_FLAG in rec:
            log.info(devObj, "Collect error, result is:" + rec)
            util.setPyDetailMsg(devObj, "system.busy")
            return False
        
        if cli.CLI_BASH_EXPORT_FLAG in rec or cli.CLI_MINISYSTEM_FLAG in rec:
            log.info(devObj, "Collect error, result is:" + rec)
            util.setPyDetailMsg(devObj, "The system is not in right mode.")
            return False
        
        return True
    
    @staticmethod
    def isExecCmdSuccForRec(devObj, rec, list):
        '''
        @summary: 根据回显判断命令是否执行成功
        @param cliRet:  devObj=上下文对象,
                        rec=导出系统信息的回显
                        list=判断命令回显成功的回显列表
        @return: True or False
        '''
        
        #首先判断命令执行是否正常
        isNormal = exportInfo.isNormalForRec(devObj, rec)
        if False == isNormal:
            return False
        
        isSucc = False
        for re in list:
            if re in rec:
                isSucc = True
                break
        
        return isSucc
    
    
    @staticmethod
    def isExecNewCmdSuccForRec(devObj, rec):
        '''
                    根据回显信息判断新的导出阵列信息的命令，是否执行成功
        '''
        isSucc = exportInfo.isExecCmdSuccForRec(devObj, rec, config.ISEXEC_NEW_CMD_SUCCESS_FLAG)
        return isSucc
    
    
    @staticmethod
    def isExecOldCmdSuccForRec(devObj, rec):
        '''
                    根据回显信息判断旧的导出阵列信息的命令，是否执行成功
        '''
        isSucc = exportInfo.isExecCmdSuccForRec(devObj, rec, config.ISEXEC_OLD_CMD_SUCCESS_FLAG)
        return isSucc
        
    @staticmethod
    def executeExportCmd(devObj, type, cmd):
        '''
                    执行导出系统信息的命令，导出系统日志，需要传入超时时间
        '''
        rec = None
        if type in config.EXPORT_SYSINFO_PROCESS_ITEM:
            rec = cli.executeCmdNoLogTimeout(devObj, cmd, config.EXPORT_LOG_TIMEOUT)
        else:
            rec = cli.executeCmdNoLog(devObj, cmd)
            
        return rec
        
    @staticmethod
    def executeNewCmd(devObj, type):
        '''
                    执行新的导出系统信息的命令
        '''
        cmd = config.EXPORT_SYSINFO_CMD_NEW[type]
        rec = exportInfo.executeExportCmd(devObj, type, cmd)
        
        isExistCmd = cli.isExistCmdForRec(rec)
        
        if None == rec or False == isExistCmd:
            return (False, rec)
        else:
            return (True, rec)
        
    @staticmethod
    def executeOldCmd(devObj, type):
        '''
                    执行旧的导出系统信息的命令
        '''
        cmd = config.EXPORT_SYSINFO_CMD_OLD[type]
        devIp = util.getDevIp(devObj)
        cmd = cmd % devIp
        rec = exportInfo.executeExportCmd(devObj, type, cmd)
        
        isExistCmd = cli.isExistCmdForRec(rec)
        
        if None == rec or False == isExistCmd:
            return (False, rec)
        else:
            return (True, rec)
        
        
    @staticmethod
    def getRemotePathAndNameFromContext(devObj):
        '''
        @summary: 获取收集到得阵列端的文件名称和目录
        @param cliRet:  devObj=上下文对象
        @return: name:阵列端产生的文件名称
                 path:阵列端产生的文件的路径
        '''
        path = devObj.get("collecRemotePath")
        name = devObj.get("collectRetFileName")
        return (path, name)
        
        
    @staticmethod
    def setRemotePathToContext(devObj, rec, type):
        '''
                    将信息在阵列端的存放路径，放入上下文中
        '''
        path = ""
        name = ""
        if config.EXPORT_TYPE_EVENT == type:
            path = "/OSM/export_import/event_export.tar"
            name = "event_export.tar"
        elif config.EXPORT_TYPE_RUNNING_DATA == type:
            path = "/OSM/export_import/OSM_sysconfig.txt"
            name = "OSM_sysconfig.txt"
        elif type in config.EXPORT_SYSINFO_PROCESS_ITEM:
            
            #判断是否新老命令
            if True == exportInfo.isExecNewCmdSuccForRec(devObj, rec):
                listInfo = rec.splitlines()
                for field in listInfo:
                    if (field.find("Datacollect") != -1):
                        controlLogPath = field.split("/")
                        logName = controlLogPath[3]
                        path = "/OSM/export_import/" + logName        
                        name = logName 
                        break
            
            else:
                sftp = util.getSftp(devObj)
                list = sftp.listFiles("/OSM/export_import")
                for field in list:
                    log.info(devObj, "file name in export_import is:" + field)
                    if "Datacollect" in field:
                        path = "/OSM/export_import/" + field        
                        name = field
                        break
                
        devObj["collecRemotePath"] = path
        devObj["collectRetFileName"] = name
    
    @staticmethod
    def downloadFile(devObj, type):
        '''
        @summary: 下载收集到得文件信息到本地
        @param cliRet:  devObj=上下文对象
                        type=收集的类型
        @return: True or False
        '''
        sftp = util.getSftp(devObj)
        localDir = util.getLocalTempDir(devObj)
        
        try:
            #如果本地临时目录不存在，则创建
            if False == os.path.exists(localDir):
                os.mkdir(localDir)
                
        except :
            log.info(devObj, "except trace back:" + str(traceback.format_exc()))
            util.setPyDetailMsg(devObj, "create.dir.fail", localDir)
            return False
        
        #下载信息到本地
        #获取阵列端存放信息的路径和文件名称
        (filePath, fileName) = exportInfo.getRemotePathAndNameFromContext(devObj)
        
        localPath = localDir + fileName
        file = File(localPath)
        sftp.getFile(filePath, file, None)
        
        #判断若为18000的设备，且当前收集的日系统日志，则收集SVP信息
        deviceType = device.getDeviceType(devObj)
        if type in config.EXPORT_SYSINFO_PROCESS_ITEM and deviceType == config.DEVICE_TYPE_OCEANSTOR_18000:
            #判断是否包含SVP包
            flag = False
            svpName = "svplog.zip"
            tempList = sftp.listFiles("/OSM/export_import")
            for fileName in tempList:
                if svpName in fileName:
                    flag = True
                    break
            if True == flag:
                file = File(localDir + svpName)
                sftp.getFile("/OSM/export_import/svplog.zip", file, None)
        
        #若收集的信息为配置信息，并已经收集到信息，则将收集到得配置信息重命名为：Config.txt
        if config.EXPORT_TYPE_RUNNING_DATA == type and os.path.exists(localPath) == True:
            rePath = localDir + "Config.txt"
            #若发现本地已经存在，则删除，保证当前为收集到的最新数据
            if True == os.path.isfile(rePath):
                os.remove(rePath)
                
            os.renames(localPath, rePath)
            #对配置信息文件进行脱敏
            FileAnonymizeUtil.anonymizeWithEncoding(localDir, "utf-8")
        elif config.EXPORT_TYPE_ALLLOG == type or config.EXPORT_TYPE_LOG == type:
            DealFileInCopressPackage.anonymizeCompressFile(localPath)
        CliCheckUtil.check_cli_connect(devObj)
        return True

    @staticmethod
    def deleteRemoteFile(devObj, type):
        '''
        @summary: 删除阵列端生成的文件
        @param cliRet:  devObj=上下文对象
                        type=收集的类型
        @return:
        '''
        strCmd = "delete file filetype=" + type
        log.info(devObj, "delete command is:" + strCmd)
        cli.executeCmd(devObj, strCmd)
    
    @staticmethod
    def exportSysInfo(devObj, type):
        '''
        @summary: 丛阵列端导出信息，日志收集、事件信息、配置信息收集的主入口
        @param cliRet:  devObj=上下文对象
                        type=收集的类型
        @return:True or False
        '''
        try:
            #收集前检查
            #检查系统是否正常
            isSysNormal = util.checkSystemNormal(devObj, None)
            if False == isSysNormal:
                return False
            
            #检查用户级别是否满足收集信息
            isPrivilege = util.checkUserPrivilege(devObj)
            if False == isPrivilege:
                return False
            
            #判断新命令，同时判断新命令是否存在，若新命令不存在，则执行老命令
            result = exportInfo.executeNewCmd(devObj, type)
            isExistNewCmd = result[0]
            rec = result[1]
            if False == isExistNewCmd:
                res = exportInfo.executeOldCmd(devObj, type)
                isExistOldCmd = res[0]
                rec = res[1]
                if False == isExistOldCmd:
                    util.setPyDetailMsg(devObj, rec)
                    return False
            
            #判断命令是否执行成功
            if True == isExistNewCmd:
                isExecSucc = exportInfo.isExecNewCmdSuccForRec(devObj, rec)
                if False == isExecSucc:
                    util.setPyDetailMsg(devObj, rec)
                    exportInfo.deleteRemoteFile(devObj, type)
                    return False
            else:
                isExecSucc = exportInfo.isExecOldCmdSuccForRec(devObj, rec)
                if False == isExecSucc:
                    util.setPyDetailMsg(devObj, rec)
                    exportInfo.deleteRemoteFile(devObj, type)
                    return False
            
            #将收集到的信息，在阵列断的路径，存放到上下文对象中
            exportInfo.setRemotePathToContext(devObj, rec, type)
            #下载阵列端收集的信息
            log.info(devObj, "execute command success, start down load file")
            isSucc = exportInfo.downloadFile(devObj, type)
            if False == isSucc:
                return False
            
            #从阵列上删除对应文件
            exportInfo.deleteRemoteFile(devObj, type)
            log.info(devObj, "delete controller file success")
            #单独处理收集的日志信息和日志打包信息
            log.info(devObj, "start process log file, after down load log")
            if type in config.EXPORT_SYSINFO_PROCESS_ITEM:
                strRet = logInfoImpl.afterDownloadLog(devObj, type)
                if strRet == False:
                    return False
                
                #export 命令，单独判断回显是否成功
                for errorInfo in config.ISEXEC_OLD_CMD_NOT_SUCCESS_FLAG:
                    if errorInfo in rec:
                        step = "step11"
                        logInfoImpl.failAfterDownload(devObj, step)
                        return False
                
            return True
        except:
            log.info(devObj, "except trace back:" + str(traceback.format_exc()))
            util.setPyDetailMsg(devObj, "failed.collect.information")
            exportInfo.deleteRemoteFile(devObj, type)
            return False
    
'''
单独处理，收集系统日志的方法
'''
class logInfoImpl():
    
    @staticmethod
    def checkIsFullLog(devObj, pathList, path_log):
        '''
        @summary: 检查收集到的日志信息，是否完全
        @param cliRet:  devObj=上下文对象,
                        pathList=收集的系统日志的文件夹列表，
                        path_log=收集的系统日志的路径
        @return: (msgInfo=错误信息, item=错误信息序号)
        '''
        if len(pathList) == 0:
            return None
        
        msgInfo = ""
        ip = None
        item = 0
        for dirName in pathList:
            ip = dirName
            if config.COLLECT_CONTOLLER_IP_NAME_END in dirName:
                ip = dirName.replace(config.COLLECT_CONTOLLER_IP_NAME_END, "")
            
            #判断info_log.txt是否存在
            info_log = path_log + dirName + "\\" + config.COLLECT_LOG_FILE_INFO
            if True == os.path.isfile(info_log):
                
                rec = util.readFile(info_log)
                if None == rec:
                    return None
                
                lines = rec.splitlines()
                collectFailList = ""
                for line in lines:
                    if line.strip().startswith("Slot ID is"):
                        break
                    #如果某项收集结果不是ok，则表示该项收集失败
                    if not line.strip().lower().endswith(" ok"):
                        collectFailList += line.split()[0] + ', ' 
                        
                if "" != collectFailList:
                    item +=1
                    msg = util.getMsg(devObj, "controller.failed.items", (item, ip, collectFailList[:-2]))
                    
                    msgInfo = msgInfo + msg
            else:
                item +=1
                msg = util.getMsg(devObj, "controller.failed.information", (item, ip))
                msgInfo = msgInfo + msg
                
        #检查控制器是否存在离线
        rec = logInfoImpl.checkLogInfoIsFull(devObj, pathList, item, msgInfo)
        
        return rec
    
    @staticmethod
    def checkLogInfoIsFull(devObj, pathList, item, msgInfo):
        '''
        @summary: 下载系统config.txt文件，从文件中获取系统标配控制器个数
        @param cliRet:  devObj=上下文对象,
                        pathList=收集的系统日志的文件夹列表，
                        item=错误信息序号
                        msgInfo=错误信息
        @return: (msgInfo=错误信息, item=错误信息序号)
        '''
        isSucc = exportInfo.exportSysInfo(devObj, config.EXPORT_TYPE_RUNNING_DATA)
        if False == isSucc:
            item +=1 
            msg = "network.communication.abnormal"
            msgInfo = msgInfo + util.getMsg(devObj, msg, (item))
            return (msgInfo, item)
        
        ctrlCount = 0
        path = util.getLocalTempDir(devObj) + "Config.txt"
        collectConfig = util.readFile(path)
        if None == collectConfig:
            collectConfig = ""
        lines = collectConfig.splitlines()
        for line in lines:
            if line.find("Number of total controllers") != -1:
                ctrlCount = line.split(':')[1].strip()
                break
            
        size = len(pathList)
        if int(ctrlCount) != size:
            item +=1
            msg = "controllers.some.failed"
            msgInfo = msgInfo + util.getMsg(devObj, msg, (item))
            log.info(devObj, "ctrlCount=" + str(ctrlCount) + ";pathList is len = " + str(size))
        
        #若是18000环境，则需要检查SVP
        deviceType = device.getDeviceType(devObj)
        localDir = util.getLocalTempDir(devObj)
        if deviceType == config.DEVICE_TYPE_OCEANSTOR_18000:
            if not os.path.exists(localDir + 'svplog.zip'):
                item = item + 1
                msg = util.getMsg(devObj, 'failed.collect.svp', item)
                msgInfo = msgInfo + msg
        return (msgInfo, item)
    
    @staticmethod
    def afterDownloadLog(devObj, type):
        '''
        @summary: 下载完系统日志后，对系统日志做相应的处理
                    处理流程：
                    1、将收集到的系统日志解压
                    2、将 1 中 解压后的列表在解压
                    3、将 2 中得到的文件 msg_other.zip 在解压
                    4、(1)将3 中得到的 diagnoselog.tgz解压，将解压后的文件拷贝到 Message 目录中。
                       (2)将类似于 omm 的文件夹即于omm同级的文件夹中的文件，拷贝到  Message 目录中 。
                    5、判断收集的系统日志，是否收集完全
        @param cliRet:  devObj=上下文对象
                        type=收集类型：log
        @return: True or False
        '''
        flag_logexist = False
        third_dir_name_list = []
        localDir_third_list = []
        step = "default"
        tar_class = devObj.get("PYENGINE.PY_ZIP")
        localPath = "default"
        
        localDir = util.getLocalTempDir(devObj)
        log.info(devObj, "local path of towar is:" + localDir)
        
        list = os.listdir(localDir)
        for field in list:
            if ".tgz" in field and "Datacollect" in field:
                flag_logexist = True
                localPath = localDir + field
                second_dir_name = field.replace(".tgz", "")
                break

        #容错，若未找到日志信息，则直接返回收集成功
        if False == flag_logexist:
            return True
        
        localDir_second = localDir + second_dir_name + "\\"
        if os.path.exists(localDir_second) != True:
            os.mkdir(localDir_second)
                
        result = tar_class.decompressZipFile(localPath, localDir_second)
        if result == False:
            step = "step1"
            logInfoImpl.failAfterDownload(devObj, step)
            return False
        
        os.remove(localPath)
        
        list2 = os.listdir(localDir_second)
        flag_bz2_exist = False
        for field_second in list2:
            if ".bz2" in field_second:
                flag_bz2_exist = True
                third_dir_name_list.append(field_second.replace(".tar.bz2", ""))
                log.info(devObj, "list in tar is:" + str(field_second.replace(".tar.bz2", "")))
                
        if flag_bz2_exist != True:
            step = "step2"
            logInfoImpl.failAfterDownload(devObj, step)
            shutil.rmtree(localDir_second)
            util.setPyDetailMsg(devObj, "system.log.not.exist")
            return False

        for third_dir_name in third_dir_name_list:
            localDir_third = localDir_second + third_dir_name + "\\"
            localDir_third_list.append(localDir_third)
            if os.path.exists(localDir_third) != True:
                os.mkdir(localDir_third)
            result = tar_class.decompressTarBz2File(localDir_second + third_dir_name + ".tar.bz2", localDir_third)

            if result == False:
                step = "step3"
                logInfoImpl.failAfterDownload(devObj, step)
                return False
            
            os.remove(localDir_second + third_dir_name + ".tar.bz2")
            
            logInfoImpl.adjustLogFile(devObj, localDir_third)
        
        #系统日志部分收集
        result = logInfoImpl.checkIsFullLog(devObj, third_dir_name_list, localDir_second)
        errorInfo = result[0]
        if errorInfo != "":
            #设置部分收集成功
            util.setCollectAllInfo(devObj, False)
            util.setPyDetailMsg(devObj, errorInfo)
        
        #整理交换机目录
        logInfoImpl.adjustLogDsw(devObj, localDir_second)
        
        devObj["dataCollect_RunningData_Path"] = localDir_third_list
        return True

    @staticmethod
    def failAfterDownload(devObj, step):
        '''
        @summary: 系统日志处理失败
        @param cliRet:  devObj=上下文对象
                        type=收集类型：log
        @return: True or False
        '''
        tar_class = devObj.get("PYENGINE.PY_ZIP")
        log.info(devObj, "handle failed. error code is " + step)
        if step == "step11":
            #删除本地收集的系统日志
            localTempDir = util.getLocalTempDir(devObj)
            localDir = util.getLocalDir(devObj)
            log_FileName = exportInfo.getRemotePathAndNameFromContext(devObj)[1]
            log_FileName1 = log_FileName.replace(".tgz", "")
            log_FileName2 = log_FileName.replace(".tgz", ".7z")
            
            os.renames(localDir + log_FileName1, localDir + "DataCollect")
            
            tar_class.compressFile(localDir + "\\" + log_FileName2, localTempDir)
            util.cleanDir(localTempDir)
            
        return (False, "")
    
    
    @staticmethod
    def adjustLogDsw(devObj, localDir_second):
        '''
                    整理交换机信息，当前只有18000设备需要整理交换机信息
        '''
        tar_class = devObj.get("PYENGINE.PY_ZIP")
        deviceType = device.getDeviceType(devObj)
        if deviceType != config.DEVICE_TYPE_OCEANSTOR_18000:
            return True
        
        list = os.listdir(localDir_second)
        for field_second in list:
            if "DSW" not in field_second:
                continue
            
            third_dir_name = field_second.replace(".tgz", "")
            localDir_third = localDir_second + third_dir_name + "\\"
            
            if False == os.path.exists(localDir_third):
                os.mkdir(localDir_third)
                
            localDir_DSW_messages =localDir_third + "messages\\"
            if False == os.path.exists(localDir_DSW_messages):
                os.mkdir(localDir_DSW_messages)
                
            result = tar_class.decompressTarGzFile(localDir_second + field_second, localDir_DSW_messages)
            
            if result == False:
                step = "step3"
                logInfoImpl.failAfterDownload(devObj, step)
                return False
            os.remove(localDir_second + field_second)
            
        return True
    
    
    @staticmethod
    def adjustLogOther(devObj, localDir_fourth_other):
        '''
        @summary:单独处理日志文件中的other目录，目前暂无处理
        @param cliRet:  devObj = 上下文对象
                        localDir_fourth_other = other 文件目录
        @return: 
        '''
        return True
    
    @staticmethod
    def adjustLogMessages(devObj, pathOfMessages):
        '''
        @summary:单独处理日志文件中的message目录，将messages目录中的文件夹中的文件和以“message_”开头的压缩包中的文件，都拷贝到messages目录中
        @param cliRet:  devObj = 上下文对象
                        localDir_fourth_message = message 文件目录
        @return: True or False
        '''
        
        #参数校验
        if not os.path.exists(pathOfMessages):
            log.info(devObj, "There is no path named:" + pathOfMessages)
            util.setPyDetailMsg(devObj, "path.message.not.exist", pathOfMessages)
            return False

        #将Messages目录下的子目录下的内容拷贝到Messages目录，以及将message压缩包解压并将包内的文件放到Messages目录
        listOfMessages = os.listdir(pathOfMessages)
        for elem in listOfMessages:
            elemInMessages = os.path.join(pathOfMessages, elem)
            #如果当前元素是目录，则将里面的内容拷贝到Messages目录下，然后删除该目录
            if os.path.isdir(elemInMessages):
                listInElem = os.listdir(elemInMessages)
                #当前目录中若存在子目录，则不删除当前目录
                isRmDir = True
                for fieldFile in listInElem:
                    tempPath = os.path.join(elemInMessages, fieldFile)
                    if not os.path.isdir(tempPath):
                        shutil.copy(tempPath, pathOfMessages)
                    else:
                        isRmDir = False
                if isRmDir:
                    shutil.rmtree(elemInMessages, True)
                continue

            #过滤掉文件，只剩下压缩包
            if not elem.endswith(("tgz", "tar.gz")):
                continue
            
            #不是message压缩包不予解压
            if not elem.startswith("message"):
                continue
            
            tar_class = devObj.get("PYENGINE.PY_ZIP")
            result = tar_class.decompressTarGzFile(elemInMessages, pathOfMessages)
            
            if not result:
                util.setPyDetailMsg(devObj, "failed.decompress.package", elemInMessages)
                return False
            
            os.remove(elemInMessages)
        return True

    @staticmethod
    def adjustLogFile(devObj, localDir_third):
        '''
        @summary:单独处理日志文件，将各个阵列的日志压缩文件解压
        @param cliRet:  devObj = 上下文对象
                        localDir_third = 日志信息目录
        @return: True or False
        '''
        passwd = util.getDecompPwdNew(devObj)
        
        log.info(devObj, "start to adjust log file:" + localDir_third)
        msg_other_file = localDir_third + "\\msg_other.zip"
        if False == os.path.exists(msg_other_file):
            log.info(devObj, "have no log zip file, exit it.")
            return
        
        localDir_fourth_message = localDir_third + "\\Messages"
        localDir_fourth_other = localDir_third + "\\Other"
        tar_class = devObj.get("PYENGINE.PY_ZIP")

        result = tar_class.decompressZipFile(localDir_third + "\\msg_other.zip", localDir_third, str(passwd))
        
        if result == False:
            return
                
        msg_other_tar_file = localDir_third + "msg_other.tar.bz2"
        if False == os.path.exists(msg_other_tar_file):
            step = "step5"
            logInfoImpl.failAfterDownload(devObj, step)
            return
        
        result = tar_class.decompressTarBz2File(msg_other_tar_file, localDir_third)
        
        if result == False:
            return

        if False == os.path.exists(localDir_fourth_message):
            return
        
        if False == os.path.exists(localDir_fourth_other):
            return
        
        result = logInfoImpl.adjustLogMessages(devObj, localDir_fourth_message)
        if result == False:
            return
        
        result = logInfoImpl.adjustLogOther(devObj, localDir_fourth_other)
        if result == False:
            return
        
        os.remove(msg_other_tar_file)
        os.remove(msg_other_file)
