# -*- coding: UTF-8 -*-
import os
import time
from common.util import *
from common.exportCmd import *

class exportSmart():
    
    #所有硬盘信息
    diskSerialNumberInfo = []
    
    #序列号于硬盘ID的对应关系
    diskSerialNumberDiskIdInfo = {}
    
    #smart信息收集的目录
    disksMartInfoDir = ""
    #成功的smart信息文件数
    smartFileNum = 0
    
    #当前收集的硬盘数量
    currentCount = 0
    
    #成功列表
    collectFailList = []
    #失败列表
    collectSuccList = []
    #收集成功信息
    collectSuccSmartINfoStr = ""
    
    @staticmethod
    def collectBasicSmartInfo(devObj, type):
        '''
        smart信息写入基本信息，系统状态信息、硬盘信息、硬盘详细信息
        '''
        #获取写入的文件路径
        basicDir = util.getLocalTempDir(devObj)
        if False == os.path.exists(basicDir):
            os.mkdir(basicDir)
            
        exportSmart.disksMartInfoDir = util.getLocalTempDir(devObj) + "disksmartinfo" + "\\"
        path = exportSmart.disksMartInfoDir
        #由于部分版本该命令的过滤关键字columnList拼写有问题，需要使用备用命令得到信息
        cmd = "show disk general |filterColumn include columnList=ID,Health\sStatus,Running\sStatus,Type,Capacity,Role,Disk\sDomain\sID,Speed(RPM),Health\sMark,Manufacturer,Serial\sNumber"
        spareCmd="show disk general |filterColumn include colunmList=ID,Health\sStatus,Running\sStatus,Type,Capacity,Role,Disk\sDomain\sID,Speed(RPM),Health\sMark,Manufacturer,Serial\sNumber"
        for field in config.LIST_SMART_BAISC_CMD:
            result = exportCmd.getCliResultInfo(devObj, field, type)
            if field == cmd:
                if not hasCliExecPrivilege(result):
                    result = exportCmd.getCliResultInfo(devObj, spareCmd, type)
                
                exportSmart.getDiskInfo(result)
            
            isSucc = exportCmd.writeCliCmdFileByPath(devObj, path, result, type)
            
            if False == isSucc:
                util.setPyDetailMsg(devObj, "write.basicinfo.failed")
                return False
        
        return True
    
    @staticmethod
    def getDiskInfo(rec):
        '''
                    收集硬盘信息，包括硬盘数量，硬盘信息
        '''
        tempList = rec.splitlines()
        cmd = "show disk general disk_id="
        diskId = ""
        for line in tempList:
            if cmd in line:
                temp = line.split("=")
                diskId = temp[1].strip()
            if "Serial Number" in line:
                temp = line.split(":")
                serialNumber = temp[1].strip()
                exportSmart.diskSerialNumberInfo.append(serialNumber)
                exportSmart.diskSerialNumberDiskIdInfo[serialNumber] = diskId
                
    
    @staticmethod
    def getEngineIpList(devObj):
        '''
                    获取引擎对应的设备列表          
        1、当环境为6U4控，单个引擎存4个控制器2个IP，0A,0B和0C,0D对应的不同的硬盘，
                      所以需要对6U4控单引擎中的所有IP进行收集
                    判断标准：
                    若CLI回显中，IP列包含”--“ 则表示以上情况，其他则正常            
        '''
        
        strCmd = "show upgrade package"
        cliRet = cli.executeCmd(devObj, strCmd)
        
        indexStart = cliRet.find("HotPatch Version")
        rec = cliRet[int(indexStart) : ]
        
        list_cliRet = cli.getCliTable2DictList(rec)
        
        resultInfo = {}
        for line in list_cliRet:
            engId = line['Name'][0]
            
            tmpInfo = {"collectAllIp" : False, "ipList" : []}
            if engId in resultInfo.keys():
                tmpInfo = resultInfo[engId] 
            
            ip = line['IP']
            if ip == '--':
                tmpInfo["collectAllIp"] = True
            else:
                tmpInfo["ipList"].append(ip)
            resultInfo[engId] = tmpInfo
        
        return resultInfo
    
    
    @staticmethod
    def getCollectDiskListDebug(devObj, ssh):
        '''
                        函数名称: getCollectDiskList_Debug
                        功能说明: 获取需要获取Smart信息的硬盘列表（调用者保证：调用此接口前，ssh在minisystem模式下）
                        输入参数: devObj，ssh
                        输出参数: 无
        '''
        needCollectDiskList = []
        
        allDiskSerialNumberInfoList = exportSmart.diskSerialNumberInfo
        #查询所有硬盘信息，获取所有SAS和SATA盘的盘符列表
        temp = cli.executeCmdBySsh(ssh, "sddebug show disk")
        
        lines = temp.splitlines()
        #mark 补全合法判断
        if len(lines) < 4:
            return needCollectDiskList
        
        for line in lines[3:]:
            lineData = line.split()
            if len(lineData) > 6:
                serialNumber = lineData[2]
                diskName = lineData[-1] 
                #过滤掉不在物理硬盘信息里面
                if serialNumber not in allDiskSerialNumberInfoList:
                    serialNumber = ""
            
                if serialNumber != "" and diskName != "":
                    diskInfoDict = {}
                    diskInfoDict["serialNumber"] = serialNumber
                    diskInfoDict["name"] = diskName
                    #记录硬盘信息，初始化变量
                    needCollectDiskList.append(diskInfoDict)
        
        return needCollectDiskList
    
    @staticmethod
    def minisystemModelCollect(devObj, ssh):
        '''
                        函数名称: minisystemModelCollect(devObj, ssh, nodeName)
                        功能说明: 查询当前控制器下的硬盘Smart信息（minisystem模式下）
                        入参数: devObj, ssh, nodeName
                        输出参数: 无
        '''
        
        #获取全局信息
        logger = devObj.get("logger")
        smartInfoSaveDir = exportSmart.disksMartInfoDir
        
        #收集失败的Smart信息
        collectFailSmartINfoStr = ""
        needCollectDiskList = exportSmart.getCollectDiskListDebug(devObj, ssh)
        if 0 == len(needCollectDiskList):
            return False
        
        #切换回developer模式
        systemMode.changeDebug2Developer(ssh)
        systemMode.changeDeveloper2Minisystem(ssh)
        
        #分割信息
        splitStr = config.COLLECT_SMART_INFORMATION_SPLIT_STR
        
        for diskInfoTmp in needCollectDiskList:
            #获取硬盘信息
            diskName = diskInfoTmp["name"]
            serialNumber = diskInfoTmp["serialNumber"]
            diskLocation = exportSmart.diskSerialNumberDiskIdInfo[serialNumber]
    
            #盘符为空，则直接将此硬盘设定为收集失败
            if not diskName:
                #收集失败，需要将location写入失败列表
                exportSmart.collectFailList.append(diskLocation)
                diskInfoStrTmp = "Disk " + diskLocation + " has no name, collecting smart information failed!"
                collectFailSmartINfoStr += diskInfoStrTmp + splitStr
                continue
    
            #盘符不为空，继续收集
            diskInfoStrTmp = cli.executeCmdNoLogBySsh(ssh, "disktool -f a /dev/" + diskName)
            
            #判断收集是否成功。因硬盘健康分析需使用Device Model做分隔，所以必须判断此字段存在，否则可能导致分析数据错位。
            if re.search("Serial Number", diskInfoStrTmp, re.IGNORECASE) and "Device Model" in diskInfoStrTmp:
                exportSmart.currentCount += 1
                #收集成功
                exportSmart.collectSuccList.append(diskLocation)
                exportSmart.collectSuccSmartINfoStr += diskInfoStrTmp + splitStr
            else:
                #收集失败，需要将location写入失败列表
                exportSmart.collectFailList.append(diskLocation)
                
                collectFailSmartINfoStr += diskInfoStrTmp + splitStr
    
            #每收集20块盘，保存一份文件
            if exportSmart.currentCount >= config.COLLECT_SMART_NUM_FILE:
                
                #新建文件，保存smart信息
                tempFileName = "smart" + str(exportSmart.smartFileNum)
                fileName = smartInfoSaveDir + tempFileName + ".txt"
                flag = util.writeFile(fileName, exportSmart.collectSuccSmartINfoStr, False)
                #重置信息
                exportSmart.collectSuccSmartINfoStr = ""
                if not flag:
                    return False
                
                logger.info("[Smart Info] Collect 20 disks and write the result to the new file:" + str(fileName))
                
                #计数加一，变量清空
                exportSmart.smartFileNum += 1
                exportSmart.currentCount = 0
        
        #如果存在收集失败的盘，写入failsmart.txt文件
        if collectFailSmartINfoStr != "":
            fileName = smartInfoSaveDir + "failsmart.txt"
            flag = util.writeFile(fileName, collectFailSmartINfoStr, True)
            if not flag:
                return False
    
        #正确返回
        return True
    
    @staticmethod
    def collectSmartBySsh(devObj, ssh):
        
        #切换到developer模式下
        log.info(devObj, "[Smart Info] Begin to changing to developer model!")
        flag = systemMode.enterDeveloperMode(devObj, ssh)
        
        #切换到developer模式失败，直接返回
        if False == flag:
            log.error(devObj, "[Smart Info] Collecting failed, the reason is: Login to developer model failed!")
                    
            key = "smart.debug.login.fail"
            util.setPyDetailMsg(devObj, key)
            return False
        
        #通过showdiskinfo命令获取硬盘盘符列表
        log.info(devObj, "[Smart Info] Begin to getting disk info in debug mode!")
        #进debug查询信息
        ret = systemMode.changeDeveloper2DebugBySsh(ssh)
        
        if False == ret:
            return False
        
        #Minisystem下开始收集
        log.info(devObj, "[Smart Info] Begin to collecting smart info!")
        result = exportSmart.minisystemModelCollect(devObj, ssh)
        log.info(devObj, "[Smart Info] Collecting smart info (storage) finished, back to cli model!")
        systemMode.changeAnyModel2Cli(ssh)
        return result
    
    
    @staticmethod
    def collectSmartByIp(devObj, ip):
        '''
                        收集单个IP下的smart信息
        '''
        loginIp = util.getDevIp(devObj)
        ssh = None
        if ip == loginIp:
            ssh = device.getDeviceSsh(devObj)
        else:
            ssh = cli.getSshByIp(devObj, ip)
        
        if None == ssh:
            return False
        
        #判断当前连接是否正常
        isNormal = util.checkSystemNormal(devObj, ssh)
        if False == isNormal:
            return False
        
        result = exportSmart.collectSmartBySsh(devObj, ssh)
        return result
    
    @staticmethod
    def writeSummaryFile():
        '''
                        功能说明: 写summeray.ini文件
                        输入参数: 
                        输出参数: 无
        '''
        path = exportSmart.disksMartInfoDir + "summary.ini"
        info = "total=" + str(len(exportSmart.diskSerialNumberInfo)) + "\n"
        info = info + "success=" + str(len(exportSmart.collectSuccList)) + "\n"
        curTime = time.strftime('%Y-%m-%d %H:%M:%S',time.localtime(time.time()))
        info = info + "date=" + curTime + "\n"
        for index in range(exportSmart.smartFileNum):
            #获取开始index和结束index
            startIndex = index * config.COLLECT_SMART_NUM_FILE
            if index + 1 == exportSmart.smartFileNum:
                endIndex = startIndex + exportSmart.currentCount - 1  
            else:
                endIndex = startIndex + config.COLLECT_SMART_NUM_FILE - 1
            #设置index描述信息
            info = info + "smart" + str(index) + "=" + str(startIndex) + "-" + str(endIndex) + "\n"
        
        isSucc = util.writeFile(path, info, False)
        return isSucc
    
    @staticmethod
    def writeTailSmartInfo(devObj):
        '''
                        函数名称: writeTailSmartInfo
                        功能说明: 将遗留未写入文件的最终写入smart文件中
                        输入参数: devObj
                        输出参数: 无
        '''
        smartInfoSaveDir = exportSmart.disksMartInfoDir
        
        #不满20块盘，则最终收集写入文件
        if "" != exportSmart.collectSuccSmartINfoStr:
            #新建文件，保存smart信息
            fileName = smartInfoSaveDir + "smart" + str(exportSmart.smartFileNum) + ".txt"
            flag = util.writeFile(fileName, exportSmart.collectSuccSmartINfoStr, False)
            if not flag:
                return False
            exportSmart.smartFileNum += 1
            
        return True

    
    @staticmethod
    def setUiDisplayMsg(devObj):
        '''
                        函数名称: setUiDisplayMsg
                        功能说明: 设置部分收集成功的相关状态
                        输入参数: devObj，collectFailDiskStr
                        输出参数: 无
        ''' 
        allDiskLocationInfo = exportSmart.diskSerialNumberDiskIdInfo.values()
        smartInfoSaveDir = exportSmart.disksMartInfoDir
        
        #没有收集成功的显示错误信息
        collectFailDiskStr = ""
        #没有执行过收集的硬盘错误信息
        noCollectDiskInfoStr = "" 
        for location in allDiskLocationInfo:
            #没有收集成功的硬盘
            if location not in exportSmart.collectSuccList:
                collectFailDiskStr += location + "," 
                #没有执行过收集的硬盘
                if location not in exportSmart.collectFailList:
                    noCollectDiskInfoStr = noCollectDiskInfoStr + "Disk " + location + \
                        " has not been collected, collecting smart information failed!" + config.COLLECT_SMART_INFORMATION_SPLIT_STR
    
        #部分收集成功
        if collectFailDiskStr != "":
            #去除字符串最后的分隔符
            collectFailDiskStr = collectFailDiskStr[0:-1]
            
            log.error(devObj, "[Smart Info] Collecting partly successful, end!")
            #设置返回信息
            errMsg = "smart.failed.disk"
            util.setPyDetailMsg(devObj, errMsg, collectFailDiskStr)
            #设置部分收集成功
            devObj["collectAllInfo"] = False
        else:
            log.info(devObj, "[Smart Info] Collecting successful, end!")
            devObj["collectAllInfo"] = True
            
        #如果存在收集失败的盘，写入failsmart.txt文件
        if noCollectDiskInfoStr:
            fileName = smartInfoSaveDir + "failsmart.txt"
            flag = util.writeFile(fileName, noCollectDiskInfoStr, True)
            if not flag:
                return False
        
        return True

    
    @staticmethod
    def collectAllSmartByIp(devObj):
        '''
                        收集各个引擎对应的smart信息
        '''
        #获取各引擎对应的IP列表
        engIpList = exportSmart.getEngineIpList(devObj)
        
        if 0 == len(engIpList):
            util.setPyDetailMsg(devObj, "failed.get.controller.ip")
            return False
        
        loginIp = util.getDevIp(devObj)
        #对每个引擎进行收集
        for engIp in engIpList.values():
            ipList = engIp['ipList']
            isCollectAllIp = engIp['collectAllIp']
            
            #若需要收集所有IP
            if True == isCollectAllIp:
                for ip in ipList:
                    exportSmart.collectSmartByIp(devObj, ip)
                    
            #若不需要收集所有IP，则首先判断当前登录的IP，是否在IP列表中，若在当前列表中，则使用当前的SSH连接，否则自己建立连接       
            elif loginIp in ipList:
                exportSmart.collectSmartByIp(devObj, loginIp)
            else:
                for ip in ipList:
                    result = exportSmart.collectSmartByIp(devObj, ip)
                    if True == result:
                        break
        
        if 0 == len(exportSmart.collectSuccList):
            return False
        
        #处理收集后的结果
        isSucc = exportSmart.writeTailSmartInfo(devObj)
        if False == isSucc:
            return False
        
        isSucc = exportSmart.writeSummaryFile()
        if False == isSucc:
            return False
        
        isSucc = exportSmart.setUiDisplayMsg(devObj)
        if False == isSucc:
            return False
        
        return True
    
    @staticmethod
    def collectSmart(devObj, type):
        '''
                        功能说明: 收集smart信息的入口
                        输入参数: devObj
                        输出参数: 无
        '''
        #检查系统是否正常
        isSysNormal = util.checkSystemNormal(devObj, None)
        if False == isSysNormal:
            return False
        
        #检查用户级别是否满足收集信息
        isPrivilege = util.checkUserPrivilege(devObj, type)
        if False == isPrivilege:
            return False
        
        util.setPyDetailMsg(devObj, "")
        
        #收集基本信息
        isSucc = exportSmart.collectBasicSmartInfo(devObj, type)
        if False == isSucc:
            return False
        
        #收集各个引擎的硬盘smart信息
        
        isSucc = exportSmart.collectAllSmartByIp(devObj)
        
        return isSucc