# -*- coding: UTF-8 -*-
from java.io import File
import sys
import resource
import os
import shutil
import codecs
from common.cliFactory import *
from common.config import *

class systemMode():
    
    @staticmethod
    def enterDeveloperMode(devObj, ssh=None):
        '''
        @summary: 进入developer模式
        @param cliRet: devObj=上下文对象
        @return: True=成功，False=失败
        '''
        #发送命令
        cmd = "change user_mode current_mode user_mode=developer"
        cliRet = ""
        if None == ssh:
            cliRet = cli.executeCmd(devObj, cmd)
        else:
            cliRet = cli.executeCmdBySsh(ssh, cmd)
        
        if re.search("developer:", cliRet, re.IGNORECASE):
            return True
        
        if None == re.search("Password:", cliRet, re.IGNORECASE):
            log.info(devObj, "enterDeveloperMode fail")
            return False
        
        developerPwd = util.getDevDeveloperPwd(devObj)
        #判断developer密码是否为空
        if None == developerPwd or "" == developerPwd :
            del developerPwd
            return False
        
        cliRet = ""
        if None == ssh:
            cliRet = cli.executeCmdNoLog(devObj, developerPwd)
        else:
            cliRet = cli.executeCmdNoLogBySsh(ssh, developerPwd)
        del developerPwd
        if None == re.search("developer:", cliRet, re.IGNORECASE):
            log.info(devObj, "enterDeveloperMode fail")
            return False
        
        return True
    
    @staticmethod
    def developerMode2CliMode(devObj):
        '''
        @summary: developer模式下退回到cli模式
        @param cliRet: devObj=上下文对象
        '''
        cliRet = cli.executeCmdNoLog(devObj, "show system general")
        
        #密码输入错误时及正常情况从developer模式下退出
        if ("Password" in cliRet) or ("developer:/>" in cliRet):
            
            cliRet = cli.executeCmd(devObj, "exit")
            log.info(devObj, "Sequence[5] change to cli model")
            index = 0
            while ("admin:/>" not in cliRet):
                index = index + 1
                cliRet = cli.executeCmd(devObj, "exit")
                if "Are you sure to exit?(y/n):" in cliRet:
                    cliRet = cli.executeCmd(devObj, "n")
                if index > cli.CLI_ENTER_DEVELOPER_MODEL_MAX_RETRYS:
                    break
    
    @staticmethod
    def isInDeveloperMode(devObj):
        '''
        @summary: 判断当前是否在developer模式下
        @param cliRet: cli回显
        @return: 
            True: 当前在developer模式下
            False: 当前不在developer模式下
        '''
        cliRet = cli.executeCmdNoLog(devObj, "show system general")
        
        if re.search(cli.CLI_DEVELOPER_MODEL_FLAG, cliRet, re.IGNORECASE):
            return True
        return False
    
    @staticmethod
    def changeDeveloper2DebugBySsh(ssh):
        
        temp = ssh.execCmd("debug")
    
        #判断是否进入到了debug模式
        if re.search(":/diagnose>", temp, re.IGNORECASE):
            return True
        
        #切换失败重新回到CLI模式
        systemMode.changeAnyModel2Cli(ssh)
        return False
    
    @staticmethod
    def changeDebug2Developer(ssh):
    
        temp = ssh.execCmd("exit")
        #判断是否进入到了debug模式
        if re.search("developer:", temp, re.IGNORECASE):
            return True
    
        return False
    
    @staticmethod
    def changeAnyModel2Cli(ssh):
        '''
                        函数名称: changeAnyModel2Cli(ssh)
                        功能说明: 从任意模式退出到cli命令模式（不适用于心跳连接到对端的情况）
                        输入参数: ssh
                        输出参数: 无
                        返 回 值: True or False
        '''
        counter = 0
        while True:
            temp = ssh.execCmdWithTimout("show system general", 180)
            
            #最小系统下要用login admin命令，exit会直接退出连接
            if re.search("minisystem>", temp, re.IGNORECASE):
                temp1 = ssh.execCmd("exit")
                if re.search("Are you sure", temp1, re.IGNORECASE):
                    ssh.execCmd("y")
                    
            elif re.search("developer", temp, re.IGNORECASE):
                temp1 = ssh.execCmd("exit")
                if re.search("Are you sure", temp1, re.IGNORECASE):
                    ssh.execCmd("n")
                
            elif re.search("-bash", temp, re.IGNORECASE):
                ssh.execCmdWithTimout("sh /ISM/cli/start.sh", 60)
                
            #其他情况下，直接exit
            else:
                temp1 = ssh.execCmd("exit")
                if re.search("Are you sure", temp1, re.IGNORECASE):
                    ssh.execCmd("n")
                    break
            
            #单控的命令模式最多4层
            counter += 1
            if counter >= 5:
                break
    
    @staticmethod
    def changeDeveloper2Minisystem(ssh):
        '''
                        函数名称: changeDeveloper2Minisystem(ssh)
                        功能说明: 从developer模式进入minisystem模式（需要确定使用之前为developer模式）
                        输入参数: devObj
                        输出参数: 无
                        返 回 值: True or False
        '''
        #进入minisystem
        temp = ssh.execCmdWithTimout("minisystem", 5)
    
        if re.search("minisystem>", temp, re.IGNORECASE):
            return True
        
        if re.search("Are you sure", temp, re.IGNORECASE):
            temp1 = ssh.execCmd("y")
    
            if re.search("minisystem>", temp1, re.IGNORECASE):
                return True
        return False
    
    
class device():
    
    @staticmethod
    def getDeviceSn(devObj):
        '''
                    获取设备SN号
        '''
        devNode = devObj.get("devNode")
        
        if None == devNode:
            return ""
        
        sn = devNode.getDeviceSerialNumber()
        
        return sn
    
    @staticmethod
    def getDeviceDetailType(devObj):
        '''
                    获取设备具体型号,如S5600T
        '''
        devNode = devObj.get("devNode")
        
        if None == devNode:
            return ""
        
        type = devNode.getDeviceType()
        
        return type
    
    
    @staticmethod
    def getDeviceVersion(devObj):
        '''
                    获取设备版本号,如：V200R002C11
        '''
        
        devNode = devObj.get("devNode")
        
        if None == devNode:
            return ""
        
        version = devNode.getProductVersion()
        
        return version
        
    @staticmethod
    def getDeviceType(devObj):
        '''
                    获取设备类型,目前设备主要分为，S500T,18000,V3
        '''
        type = None
        version = device.getDeviceVersion(devObj)
        
        if True == version.startswith(config.DEVICE_TYPE_OCEANSTOR_18000_STANDARD):
            type = config.DEVICE_TYPE_OCEANSTOR_18000
        
        elif True == version.startswith(config.DEVICE_TYPE_S5000T_STANDARD):
            type = config.DEVICE_TYPE_S5000T
        
        elif True == version.startswith(config.DEVICE_TYPE_V3_STANDARD):
            type = config.DEVICE_TYPE_V3
            
        return type
    
    @staticmethod
    def getDeviceSsh(devObj):
        '''
                    获取设备版本号,如：V200R002C11
        '''
        ssh = devObj.get("SSH")
        
        return ssh

'''
信息收集，基本的工具方法
'''
class util():
    
    @staticmethod
    def checkSystemNormal(devObj, ssh):
        '''
                    函数名称: checkSystemNormal
                    功能说明: 检验当前设备是否normal
                    输入参数: devObj
                    输出参数: True, False
        '''
        flag = False
        cliRet = ""
        cmd = "show system general"
        if None == ssh:
            cliRet = cli.executeCmd(devObj, cmd)
        else:
            cliRet = cli.executeCmdBySsh(ssh, cmd)
        
        if re.search("System Name", cliRet, re.IGNORECASE):
            flag = True
        else:
            util.setPyDetailMsg(devObj, 'system.abnormal')
            
        return flag
    
    @staticmethod
    def getUserNameCli(devObj):
        '''
        @summary: 用CLI的方式，获取当前的用户名（当上下文对象中不存在用户名时，用到）
        @param cliRet: devObj=上下文对象
        @return: userName
        '''
        userName = ""
        cliRet = cli.executeCmdNoLog("show system general")
        #输入CLI回显是否有效
        if None == cliRet or "" == cliRet: 
            return userName
        
        #执行命令获取当前登录的用户名      
        lineList = cliRet.splitlines()
        #用户名一定包含在最后一行中
        if lineList[-1].find(cli.CLI_RET_END_FLAG):
            userName = lineList[-1].replace(" ","").replace(cli.CLI_RET_END_FLAG,"")
        return userName
    
    @staticmethod
    def getUsername(devObj):
        '''
        @summary: 获取上下文中的用户名
        @param cliRet: devObj=上下文对象
        @return: name
        '''
        name = devObj.get("username")
        
        if None == name or "" == name: 
            name = util.getUserNameCli(devObj)
            
        return name
        
    @staticmethod
    def getUserPrivilege(devObj):
        '''
        @summary: 获取用户权限级别
        @param cliRet: devObj=上下文对象
        @return: userLevel
        '''
        userLevel = ""
        #首先获取用户名
        userName = util.getUsername(devObj)
        
        if None == userName or "" == userName:
            return userLevel
        
        log.info(devObj, "Get login name is:"+str(userName))
        
        #根据用户名，查询用户权限
        cliRet = cli.executeCmd(devObj, "show user user_name=" + userName)
        rec = cli.getCliTable2DictList(cliRet)
        if len(rec) == 0:
            return userLevel
        
        #获取用户权限的行信息
        level = rec[0]
        if "Level" in level:
            userLevel = level["Level"]
        
        return userLevel
    
    
    @staticmethod
    def checkUserPrivilege(devObj, type=None):
        '''
        @summary: 检查用户权限，用户权限为["Super_admin" 或  "Admin"],则返回True，否则返回False
        @param cliRet: devObj=上下文对象
        @return: userLevel
        '''
        result = False
        userLevel = util.getUserPrivilege(devObj)
        
        privileges = ["Super_admin", "Admin"]
        if None != type and type == config.COLLECT_TYPE_SMART:
            privileges = ["Super_admin"]
            
        if userLevel in privileges:
            result = True
        else:
            util.setPyDetailMsg(devObj, "user.level.low")
        
        return result
    
    
    @staticmethod
    def isChinese(devObj):
        '''
        @summary: 判断当前语言类型
        @param lang: 语言lang
        @return: 
            True: 中文
            False: 非中文
        '''
        lang = devObj.get("lang")
        if "zh" == lang:
            return True
        return False
    
    @staticmethod
    def getMsg(devObj, msg, args = ""):
        '''
        @summary: 获取资源信息
        @param cliRet: devObj=上下文对象, msg=资源脚本（resource.py）中对应的Key，args=占位符对应的值
        @return: msg
        '''
        if  None == msg or "" == msg:
            return ""
        
        lang = devObj.get("lang")
        if resource.MESSAGES_DICT.has_key(msg):
            msgDict = resource.MESSAGES_DICT.get(msg)
            msg = msgDict[lang]
        
        #若占位符的值不为”“，则天冲高占位符
        if "" != args:
            msg = msg % args
            
        return msg
    
    @staticmethod
    def setCollectAllInfo(devObj, flag):
        '''
        @summary: 设置是否部分收集成功
        @param flag: flag = True 该项收集成功，flag=False 该项部分收集成功
        '''
        devObj["collectAllInfo"] = flag
    
    @staticmethod
    def isExistDetailMsg(devObj):
        '''
        @summary: 判断错误信息是否已经设置
        @param devObj: 上下文对象
        @return: True or False
        '''
        msg = devObj["py_detail"]
        if None == msg or "" == msg:
            return False
        
        return True
    
    @staticmethod
    def initPyDetailMsg(devObj):
        '''
        @summary: 清除之前设置的错误信息
        @return: 无
        '''
        devObj["py_detail"] = ""
    
    @staticmethod
    def setPyDetailMsg(devObj, msg, args = ""):
        '''
        @summary: 消息国际化
        @param lang: 语言lang
        @param msg: 消息
        @param args: 消息参数
        @return: 经过国际化处理后的消息
        '''
        msg = util.getMsg(devObj, msg, args)
        
        devObj["py_detail"] = msg
        
    @staticmethod
    def getDevIp(devObj):
        '''
        @summary: 根据上下文，获取当前连接的IP
        @param cliRet: devObj=上下文对象
        @return: ip
        '''
        ip = devObj.get("devIp")
        return ip
    
    @staticmethod
    def getSftp(devObj):
        '''
        @summary: 根据上下文，获取sftp对象
        @param cliRet: devObj=上下文对象
        @return: sftp
        '''
        sftp = devObj.get("SFTP")
        return sftp
    
    @staticmethod
    def getDevVersion(devObj):
        '''
        @summary: 拼凑设备版本信息
        @param cliRet: devObj=上下文对象
        @return: ver，如S5600T V200R002C10
        '''
        ver = str(device.getDeviceDetailType(devObj)) + " " + device.getDeviceVersion(devObj)
        return ver
    
    @staticmethod
    def readFile(filePath):
        try:
            f = None
            f = open(filePath)
            info = f.read()
            return info
        except:
            return None
        finally:
            if None != f:
                f.close()
    
    
    @staticmethod
    def writeFile(filePath, info, isAddFlag):
        try:
            file = None
            openType = "w"
            if True == isAddFlag:
                openType = "a"
            
            file = codecs.open(filePath, openType, "utf-8")
            file.write(info)
            return True
        except:
            return False
        finally:
            if None != file:
                file.close()
    
    @staticmethod
    def writeVersionToFile(devObj):
        '''
        @summary: 将设备版本信息，写入到文件 version 中
        @param cliRet: devObj=上下文对象
        @return: ver，如：将 S5600T V200R002C10 写入文件
        '''
        localDir = util.getLocalTempDir(devObj)
        if False == os.path.exists(localDir):
            os.mkdir(localDir)
            
        path = localDir + "\\DataCollect\\version"
        ver = util.getDevVersion(devObj)
        util.writeFile(path, ver, False)
        
    #todo devObj 不可用
    @staticmethod
    def cleanDir(dir):
        '''
        @summary: 根据路径，删除路径
        @param cliRet: devObj=上下文对象，dir=路径
        @return: True or False
        '''
        if False == os.path.exists(dir):
            return True
        
        if False == os.path.isdir(dir):
            return False
        
        shutil.rmtree(dir, True)
        return True
    
    @staticmethod
    def getDecompPwdNew(devObj):
        '''
        @summary: 获取压缩文件解压密码
        @param cliRet: devObj=上下文对象
        @return: passw
        '''
        passw = devObj.get("decomp_pwd_new")
        return passw
    
    @staticmethod
    def getLocalDir(devObj):
        '''
        @summary: 获取用户选择的路径
        @param cliRet:  devObj=上下文对象
        @return: localDir:用户选择的路径
        '''
        localDir = devObj.get("collectRetDir")
        return localDir
    
    @staticmethod
    def getLocalTempDir(devObj):
        '''
        @summary: 获取本地临时路径
        @param cliRet: devObj=上下文对象
        @return: localDir
        '''
        localDir = util.getLocalDir(devObj) + "\\temp\\"
        return localDir
    
    @staticmethod
    def getDevDeveloperPwd(devObj):
        '''
        @summary: 获取设备developer密码
        @param cliRet: devObj=上下文对象
        @return: pwd
        '''
        pwd = devObj.get("developer")
        return pwd
    
    @staticmethod
    def getMasterCtrlId(devObj):
        '''
        @summary: 获取主控的设备命令
        @param cliRet: devObj=上下文对象
        @return: masterCtrlId，如：0A
        '''
        masterCtrlId = None
        strCmd = "show controller general"
        cliRet = cli.executeCmd(devObj, strCmd)
        list_cliRet = cliRet.splitlines()
        #根据CLI回显信息获取当前环境中，主控的ID
        for field in list_cliRet:
            
            field = field.replace(" ", "")
            if field.startswith("Controller"):
                list_ctrl = field.split(":")
                log.info(devObj, "1 is:"+list_ctrl[0])
                masterCtrlId = list_ctrl[1]
                
            if field.startswith("Role"):
                list_role = field.split(":")
                #兼容18000和T系列设备
                if list_role[1] == "Primary" or list_role[1] == "Master":
                    break
                
        return masterCtrlId
    
    @staticmethod
    def getControllerIpList(devObj):
        '''
        @summary: 获取环境的IP列表，主控的名称改为：*_MAIN
        @param cliRet: devObj=上下文对象
        @return: list_controller，如：[100.0.0.1_MAIN,100.0.0.2]
        6U4控特殊情况：
                    方案：若发现回显的IP为‘--’，则返回[最小IP_0_MAIN,最小IP_1,...]
        '''
        #获取当前环境中所有阵列的IP地址，若为主控，则在主控的IP地址后面添加“_MAIN”
        list_controller = []
        
        masterCtrlId = util.getMasterCtrlId(devObj)[0]
        
        strCmd = "show upgrade package"
        cliRet = cli.executeCmd(devObj, strCmd)
        
        indexStart = cliRet.find("HotPatch Version")
        rec = cliRet[int(indexStart) : ]
        
        list_cliRet = cli.getCliTable2DictList(rec)
        
        isIpNotExcite = False
        for cliRet in list_cliRet:
            ip = cliRet["IP"].strip()
            if "--" == ip:
                isIpNotExcite = True
                continue
            
            if masterCtrlId == cliRet["Name"]:
                ip = ip + config.COLLECT_CONTOLLER_IP_NAME_END
            
            list_controller.append(ip)
        
        size = len(list_cliRet)
        if True == isIpNotExcite and size > 0:
            list_controller.sort()
            masterIp = list_controller[0]
            list_controller = []
            tempIp = masterIp + "_0" + config.COLLECT_CONTOLLER_IP_NAME_END
            list_controller.append(tempIp)
            
            for index in range(1, size):
                tempIp = masterIp + "_" + str(index)
                list_controller.append(tempIp)
            
        return list_controller
    
class log():
    
    """
            功能：日志记录函数的子函数，用于获取调用函数和调用行号
            参数： MAX_CALLER_LEVEL：最大调用关系层数
            返回值：调用函数信息
    """
    @staticmethod
    def getCallerInfo(MAX_CALLER_LEVEL=5, skipLastLevel=True):
        #从堆栈中获取调用函数和行号
        
        #初始化参数
        funcBack = sys._getframe().f_back
        if True == skipLastLevel: #忽略最近的调用关系
            funcBack = funcBack.f_back
            MAX_CALLER_LEVEL -= 1
        
        #生成函数调用关系
        callerInfo = ""    
        for index in range(0, MAX_CALLER_LEVEL):
        
            #获取该级调用函数和行号
            if hasattr(funcBack, "f_code") and hasattr(funcBack, "f_lineno"):
                funcName = funcBack.f_code.co_name
                lineNumber = funcBack.f_lineno
                callerInfo = " [" + str(funcName) + ":" +  str(lineNumber) + "]" + callerInfo
            else:
                break
            
            #刷新Back函数
            if hasattr(funcBack, "f_back"):
                funcBack = funcBack.f_back
            else:
                break
        
        #返回函数调用关系
        return callerInfo
    
    @staticmethod
    def debug(devObj, info):
        """
                    功能：记录调试信息info到工具日志中
                    参数：devObj=工具上下文；info=要记录的信息
                    返回值：True=成功；False=失败
        """
        logInfo = info + log.getCallerInfo()
        if "logger" in devObj:
            devObj.get("logger").debug('[ToolLog]:' + logInfo)
            return True
        else:
            raise Exception("[failed]: logger is inexisted. info=" + logInfo)
    
    @staticmethod
    def error(devObj, info):
        """
                    功能：记录错误信息info到工具日志中
                    参数：devObj=工具上下文；info=要记录的信息
                    返回值：True=成功；False=失败
        """
        logInfo = info + log.getCallerInfo()
        if "logger" in devObj:
            devObj.get("logger").error('[ToolLog]:' + logInfo)
            return True
        else:
            raise Exception("[failed]: logger is inexisted. info=" + logInfo)
        
    @staticmethod
    def info(devObj, info):
        logInfo = info + log.getCallerInfo()
        if "logger" in devObj:
            devObj.get("logger").info('[ToolLog]:' + logInfo)
            return True
        else:
            raise Exception("[failed]: logger is inexisted. info=" + logInfo)
        
    @staticmethod
    def warn(devObj, info):
        logInfo = info + log.getCallerInfo()
        if "logger" in devObj:
            devObj.get("logger").warn('[ToolLog]:' + logInfo)
            return True
        else:
            raise Exception("[failed]: logger is inexisted. info=" + logInfo)


def hasCliExecPrivilege(cliRet):
    '''
    @summary: 判断是否具有执行cli命令的权限
    @param cliRet: cli回显
    @return: 
    True: 具有执行cli命令的权限
    False: 不具有执行cli命令的权限
    '''
    for line in cliRet.splitlines():
        if line.strip() == "^":
            return False
    if "does not have the permission" in line:
        return False
    return True