﻿#coding:utf-8
from java.io import File
import time
import traceback
from common.util import *
import os
import subprocess

def getCurrentDate(devObj):
    '''
            获取当前系统时间
    '''
    result = str(time.strftime('%Y%m%d%H%M%S',time.localtime(time.time())))
    return result

def adjustSingleExportFile(devObj):
    localDir = util.getLocalTempDir(devObj)
    list_file = os.listdir(localDir)
    
    list_controller = util.getControllerIpList(devObj)
    for field in list_controller:
        
        path0 = localDir + "\\DataCollect"
        if False == os.path.exists(path0):
            os.mkdir(path0)
        
        path1 = path0 + "\\" + field
        if False == os.path.exists(path1):
            os.mkdir(path1)
            
        path2 = path1 + "\\Event"
        if False == os.path.exists(path2):
            os.mkdir(path2)
            
        path3 = path1 + "\\Config"
        if False == os.path.exists(path3):
            os.mkdir(path3)
            
        path4 = path1 + "\\Other"
        if False == os.path.exists(path4):
            os.mkdir(path4)
            
        for field_file in list_file:
            tempPath = localDir + field_file
            if field_file == "event_export.tar":
                shutil.copy(tempPath, path2)
                continue
            if field_file == "Config.txt":
                shutil.copy(tempPath, path3)
                continue
            
            if "disksmartinfo" == field_file:
                tempSmartPath = path0 + "\\" + field_file
                if False == os.path.exists(tempSmartPath):
                    shutil.move(tempPath, tempSmartPath)
                continue
            
            shutil.copy(tempPath, path4)
    
    #删除临时文件夹中的数据
    for field_file in list_file:
        temp = localDir + field_file
        if True == os.path.exists(temp):
            os.remove(temp)
        
    return True

def execute(devObj):
    try:
        localDir = util.getLocalTempDir(devObj)
        tar_class = devObj.get("PYENGINE.PY_ZIP")
        flag_logexist = False
        #最终打包的文件名称
        localFile_final = ""
        
        #临时文件夹中的文件列表，判断是否存在收集的系统日志
        list = os.listdir(localDir)
        for field in list:
            log.info(devObj, "file name is:"+field)
            if "Datacollect" in field:
                flag_logexist = True
                log.info(devObj, "name is:"+field)
                
                if ".tgz" in field:
                    localFile_final = field.replace(".tgz", ".7z")
                else:
                    localFile_final = field + ".7z"
                    os.renames(localDir + field, localDir + "DataCollect")
                    
                log.info(devObj, "path is:" + localFile_final)
                break
        
        #不存在收集的系统日志
        if False == flag_logexist:
            adjustSingleExportFile(devObj)
            
            product_model = device.getDeviceDetailType(devObj)
            #兼容OEM后的设备型号
            if devObj.get("isOEMTool"):
                product_model = devObj.get("devNode").getOemModel()
                
            product_sn = device.getDeviceSn(devObj)
            product_time = getCurrentDate(devObj)
            localFile_final = "Datacollect_" + str(product_model) + "_" + str(product_sn) + "_" + str(product_time) + ".7z"
            
            log.info(devObj, "tar file is:" + localFile_final)
        else:
            list_file_tempDir = os.listdir(localDir)
            datacollectPath = localDir + "DataCollect"
            list_file_DatacollectDir = os.listdir(datacollectPath)
            
            for field in list_file_tempDir:
                if field.find("DataCollect") != -1:
                    continue
                
                #若 收集到有svplog.zip 信息，则需要处理 svplog.zip 
                if ("svplog.zip" in field):
                    log.info(devObj, "copy svplog to DataCollect dir:"+str(field))
                    shutil.move(localDir + field, datacollectPath)
                    continue
                
                
                if field == "disksmartinfo":
                    shutil.move(localDir + field, datacollectPath + "\\" + field)
                    continue
                
                for field_temp in list_file_DatacollectDir:
                    
                    #如果发现是交换机和svp的信息，则不处理
                    if ("DSW" in field_temp) or ("svplog" in field_temp):
                        continue
                    
                    
                    if field == "event_export.tar":
                        eventPath = localDir + "\\DataCollect\\" + field_temp + "\\Event\\"
                        if os.path.exists(eventPath + field) == False:
                            shutil.copy(localDir + field, eventPath)
                            continue
                        
                    if field == "Config.txt":
                        configPath = localDir + "\\DataCollect\\" + field_temp + "\\Config\\"
                        if os.path.exists(configPath + field) == False:
                            if False == os.path.isdir(configPath):
                                os.mkdir(configPath)
                            shutil.copy(localDir + field, configPath)
                            continue
                        
                    otherPath = localDir+"\\DataCollect\\"+field_temp+"\\Other\\"
                    if os.path.exists(otherPath + field) == False:
                        shutil.copy(localDir + field, otherPath)
                        
                os.remove(localDir + field)
            
        util.writeVersionToFile(devObj)
        tar_class.compressFile(devObj.get("collectRetDir") + "\\" + localFile_final, localDir)
        devObj["collectRetFileName"] = localFile_final
        util.cleanDir(localDir)
        #去掉权限
        finalPath = devObj.get("collectRetDir") + "\\" + localFile_final
        subprocess.Popen(['cmd.exe', '/C', 'icacls', finalPath, '/inheritance:d'], shell=False)
        subprocess.Popen(['cmd.exe', '/C', 'icacls', finalPath, '/remove:g Users'], shell=False)

        return (True, "")
    except Exception, exception:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        devObj["py_detail"] = "catch except when compress file.~~~over!"
        return (False, "")
