# -*- coding: UTF-8 -*-
import os
import traceback
from common.util import *

'''
收集前准备
删除用户选择的路径中的temp目录
'''
def preCollect(devObj):
    try:
        #检查用户名称是否非法（部分关键字作为用户名将影响CLI执行结果判断）
        loginUserName = devObj.get("username")
        log.info(devObj, "loginUserName is %s" % str(loginUserName))
        isPass = checkLoginUserName(loginUserName)
        if not isPass:
            errMsg = util.setPyDetailMsg(devObj, "loginUser.name.check.failure")
            return (False, "")

        flag = False
        localDir = util.getLocalTempDir(devObj)
        log.info(devObj, "clean temp dictory." + localDir)
        flag = util.cleanDir(localDir)
        return (flag, "")
    except Exception:
        log.error(devObj, "tool: pre_collect except trace back:" + str(traceback.format_exc()))
        return (False, "")

USER_NAME_BLACK_LIST = ["developer", "diagnose", "error", "password", "upgrade", "minisystem", "storage"]
def checkLoginUserName(loginUserName):
    '''
    @summary: 检查工具登录用户名称是否为特殊用户名
    '''
    
    loginUserName = loginUserName.lower()
    
    for keyWords in USER_NAME_BLACK_LIST:
        if loginUserName.endswith(keyWords):
            return False
    
    return True 