﻿# -*- coding: UTF-8 -*-
import traceback
import time
import os
from common.util import *
from common.util import log
from common.config import config
from common.exportCmd import *
from common.exportInfo import *
from common.exportInfo import exportInfo
from common.dealSmartInfo import dealSmartInfo
from common.dealLogInfo import dealLogInfo
from common.DhaInfoCollector import DhaInfoCollector
from check_item_service_work_controller_luncopy import check_lun_copy


def collectLog(devObj):
    try:
        log.info(devObj, "start check lun copy...")
        flag, cli_ret, err_msg, return_hot_patch = check_lun_copy(devObj)
        if flag != True:
            log.error(devObj, "check lun copy failed, all_cli_ret:%s, err_msg:%s" % (cli_ret, err_msg))
            if return_hot_patch:
                util.setPyDetailMsg(devObj, "exist.lun.copy.risk.patch", return_hot_patch)
            else:
                util.setPyDetailMsg(devObj, "exist.lun.copy.risk.no.patch")
            return False, ""
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        isSucc = exportInfo.exportSysInfo(devObj, config.EXPORT_TYPE_LOG)
        #处理从阵列侧收集到的日志文件
        if isSucc:
            isSucc = dealLogInfo(devObj)
            if not isSucc:
                errMsgKey = "create.log.config.failed"
                util.setPyDetailMsg(devObj, errMsgKey)
        util.refreshProcess(devObj, 100)
        return (isSucc, "")
    except:
        log.error(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")
    
    
def collectAllLog(devObj):
    try:
        log.info(devObj, "start check lun copy...")
        flag, cli_ret, err_msg, return_hot_patch = check_lun_copy(devObj)
        if flag != True:
            log.error(devObj, "check lun copy failed, all_cli_ret:%s, err_msg:%s" % (cli_ret, err_msg))
            if return_hot_patch:
                util.setPyDetailMsg(devObj, "exist.lun.copy.risk.patch", return_hot_patch)
            else:
                util.setPyDetailMsg(devObj, "exist.lun.copy.risk.no.patch")
            return False, ""
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        isSucc = exportInfo.exportSysInfo(devObj, config.EXPORT_TYPE_ALLLOG)
        #处理从阵列侧收集到的日志文件
        if isSucc:
            isSucc = dealLogInfo(devObj)
            if not isSucc:
                errMsgKey = "create.log.config.failed"
                util.setPyDetailMsg(devObj, errMsgKey)
        util.refreshProcess(devObj, 100)
        return (isSucc, "")
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")

   
def collectEvent(devObj):
    try:
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        isUpgrading = util.isSystemUpgrading(devObj)
        if isUpgrading:
            return (False,"")
        isSucc = exportInfo.exportSysInfo(devObj, config.EXPORT_TYPE_EVENT)
        util.refreshProcess(devObj, 100)
        return (isSucc, "")
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")
 
   
def collectRunningData(devObj):
    # 收集完config限制CLI命令收集时间，已和LMT/eservice对齐，
    # 时间2019.12.27
    collect_limit_time = 600
    try:
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        isUpgrading = util.isSystemUpgrading(devObj)
        if isUpgrading:
            return (False,"")
        isSucc = exportInfo.exportSysInfo(devObj, config.EXPORT_TYPE_RUNNING_DATA)
        util.refreshProcess(devObj, 80)
        current_time = time.time()
        # 为eService收集cli命令的回显，存放到与config文件相同的路径下
        localDir = util.getLocalInfoPathByType(devObj, config.EXPORT_TYPE_RUNNING_DATA)
        time_out = exportCmd.collectCliCmd4eService(devObj, localDir,
                                                    current_time,
                                                    collect_limit_time)
        if time_out:
            log.info(devObj, "collect cli cmd time out!")

        util.refreshProcess(devObj, 100)
        return (isSucc, "")
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")
 
    
def collectCliCmd(devObj):
    try:
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        isUpgrading = util.isSystemUpgrading(devObj)
        if isUpgrading:
            return(False, "")
        #检查系统是否正常
        isSysNormal = util.checkSystemNormal(devObj)
        if False == isSysNormal:
            return(False, "")
        isSucc = exportCmd.exportCliCmd(devObj, config.LIST_CLI_CMD, config.COLLECT_TYPE_CLI)
        util.refreshProcess(devObj, 100)
        return (isSucc, "")
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")
   
    
def collectElableCmd(devObj):
    try:
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        isUpgrading = util.isSystemUpgrading(devObj)
        if isUpgrading:
            return(False, "")
        #检查系统是否正常
        isSysNormal = util.checkSystemNormal(devObj)
        if False == isSysNormal:
            return(False, "")
        isSucc = exportCmd.exportElableCmd(devObj, config.COLLECT_TYPE_ELABLE)
        util.refreshProcess(devObj, 100)
        return (isSucc, "")
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")
  
def collectDHA(devObj):
    try:
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        
        #保留此检查过程，以便后续维护更改
        isUpgrading = util.isSystemUpgrading(devObj)
        if isUpgrading:
            return(True, "")
        
        dhaInfoCollector = DhaInfoCollector()
        
        #DHA信息收集结果仅用于机器学习，因此总是返回成功。若发生任何错误仅记录日志
        status, msg = dhaInfoCollector.exportDhaInfo(devObj)
        msg = util.getMsg(devObj, msg)
        log.info(devObj, "error message from DHA collection:%s" % msg)
        
        util.refreshProcess(devObj, 100)
        return (True, "")
    except :
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        return (True, "" )    
 
def collectSmart(devObj):
    try:
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        isUpgrading = util.isSystemUpgrading(devObj)
        if isUpgrading:
            return (False,"")
        isSucc = exportInfo.exportSysInfo(devObj, config.COLLECT_TYPE_SMART)
        if not os.path.exists(os.path.join(devObj.get("collect_info_local_path"), "Running_Data")):
            devObj.setdefault("runningDataClean", True)
            log.info(devObj, "To collect Smart information, download the config file and delete it.")
            if not exportInfo.exportSysInfo(devObj, config.EXPORT_TYPE_RUNNING_DATA):
                log.error(devObj, "Failed to download the config file during Smart Information Collection.")
        #处理收集到得smart信息，将其转换为日志分析工具需要的格式
        if isSucc:
            (isSucc, errMsgKey) = dealSmartInfo(devObj)
            if not isSucc:
                util.setPyDetailMsg(devObj, errMsgKey)
        util.refreshProcess(devObj, 100)
        return (isSucc, "")
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")
    
    