# -*- coding: UTF-8 -*-
from java.io import File
from com.huawei.ism.tool.framework.pubservice.hardware import DiskLocation
from com.huawei.ism.tool.infocollect.entity import CollectStatus
import com.huawei.ism.tool.infocollect.util.DataCollectConstants as dcc
from common.config import config
from common.cliFactory import cli
from common.util import systemMode
from common.util import util
from common.util import device
from common.util import log
from common.disklogConf import disklogConf
from disklogConfParse import parseConf
from writeDiskLogResult import writeMsgLine
from replaceDisktool import replaceDisktool
from datetime import datetime
import traceback
import os
import re
import time
import ConfigParser
from common import cliModeManager

ODYSSEY_RESULT_PATH = "/OSM/coffer_data/dha/SanDisk_SAS_Log.zip"
SETTING_FILE_NAME = 'collect.conf'

def collect(devObj):
    util.refreshProcess(devObj, 1)
    startTime = datetime.now()
    try:
        diskLogCollectInterval = getDisklogCollectInvterVal(devObj)
        return doCollect(devObj, diskLogCollectInterval)
    except Exception, e:
        log.error(devObj, 'Collect running disk log exception:' + unicode(e))
        log.error(devObj, 'Collect running disk log exception:' + unicode(traceback.format_exc()))
        return False, ''
    finally:
        #无论执行成功失败与否都去执行一次删除动作，避免残留文件。
        timeLapse = str(datetime.now()-startTime).split(".")[0]
        writeMsgLine(devObj, 'Time lapse(hh:mi:SS)=' + timeLapse)
        #无论执行成功失败与否都去执行一次删除动作，避免残留文件。
        try:
            sftp = util.getSftp(devObj)
            sftp.deleteFile(disklogConf.SFPT_HOME_DIR + '/disktool')
        except:
            log.error(devObj, "Delete disktool exception, except trace back:" + unicode(traceback.format_exc()))
        else:
            log.info(devObj, "Delete disktool file successfully.")        
        util.refreshProcess(devObj, 100)        
        
def doCollect(devObj, diskLogCollectInterval):
    '''
    @devObj: Java传递给Python脚本的上下文。
    @summary:执行disktool进行“正常硬盘”日志
    @return: boolean,string  (收集成功, _)
    @note: 并非是设备对象，而是包含设备对象的一个map。
    '''    
    util.initPyDetailMsg(devObj)
    if util.isSystemUpgrading(devObj):
        writeMsgLine(devObj, 'System is upgrading.')
        return (False, "")
    
    isSuccess, dskIdList = util.getDiskIds(devObj)
    if not isSuccess:
        log.error(devObj, 'Query disk number by all disk IDS failed.')
        return False, ''

    isSuccess, diskFwModelInfoDict = util.getDiskFwVersionInCliModel(devObj)
    if not isSuccess:
        log.error(devObj, 'Query disk number by all disk IDS failed.')
        return False, ''

    sysAllDiskNum = len(dskIdList)
    writeMsgLine(devObj, 'allDiskNum=' + unicode(sysAllDiskNum))
       
    selDiskList = devObj.get(dcc.SELECTTED_DISK_KEY_IN_PYENV)
    log.info(devObj, 'Get selected disk location list from java is:' + unicode(selDiskList))
    
    writeMsgLine(devObj, 'selectedDisk=' + unicode(len(selDiskList)))
    if not selDiskList:
        log.error(devObj, 'Selected no disk, error.')    
        return False, ''
        
    diskParaList = []
    for diskObj in selDiskList:
        diskParaList.append((diskObj.getDiskLocation().toString(),
                             diskObj.getDiskSn(),
                             diskObj.getVendor(),
                             diskObj.getDiskName(),
                             diskObj.getDiskType(),
                             diskObj.getModelNum(),
                             ))
    
    if 0 < len(diskParaList) <= 100:
        log.info(devObj, 'All selected disk para list:' + unicode(diskParaList))
    else:
        log.info(devObj, 'All selected disk number is:' + unicode(len(diskParaList)))
        log.info(devObj, 'The foremost 100 disk selected disk para list are:' + unicode(diskParaList[:100]))
            

    if not systemMode.enterMinisystemMode(devObj):
        util.addPyDetailMsg(devObj, 'enter.minisystem.mode.failed')
        return False, ''
    
    isNewDisktool = False
    isX86Arc = device.isX86Architecture(devObj)
    if replaceDisktool(devObj, isX86Arc):
        if isSupportUploadDisktoolExecute(devObj):
            isNewDisktool = True
            log.info(devObj, 'Current version support upload disktool executed.')
        else:
            log.warn(devObj, 'Current version does not support upload disktool executed.')
    else:
        log.warn(devObj, 'Replace disk tool failed, use disktol in storage.')
             
    nosupportDiskLocList = []
    failedDiskLocList = []
    partlySuccDiskLocList = []
    stoppedDiskIdList = []
    resultDict = {}
    curScriptPth = devObj.get(dcc.COLLECT_PYTHON_SCRIPT_PATH)
    confPthName = os.path.join(curScriptPth , disklogConf.DISK_LOG_COLLECT_CMD_AND_LOG_CONF)
    collectCmdMap = parseConf(devObj, confPthName) 
    succNum = 0
    partSuccNum = 0

    currentProcess = 5
    percentNumber = 80.0
    if len(diskParaList) > 0:
        percentNumber = 80.0 / len(diskParaList)
    
    for (diskId, diskSn, vendor, diskBlkDev, diskType, diskModelNum) in diskParaList:
        #为减小配置文件规模，HUAWEI/HUASY厂商的硬盘统一配置为HUAWEI
        if vendor in ['HUASY', 'huasy']:
            vendor = 'HUAWEI'
            
        collectCmdPathTups = collectCmdMap.get((vendor.upper(), diskType.upper()), [])[:]
        if not collectCmdPathTups:
            log.error(devObj, 'Collecting running disk log:' + diskBlkDev + ' is not supported.')
            writeMsgLine(devObj, 'Unsupport Disk[' 
                         + diskId + ', '+ vendor + ', ' + diskSn + ', ' + diskType + ', ' + diskModelNum + ', ' + diskBlkDev +']',  
                         disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
            nosupportDiskLocList.append(diskId)
            resultDict[DiskLocation(diskId, True)] = CollectStatus.COLLECT_UNSUPPORT
            continue
            
        thisDiskOkNum = 0
        
        #HSDD V2 SAS盘需要新增extlog的收集.
        if isHSSDV2(vendor, diskModelNum) and diskType.upper() != 'NVME_SSD':
            collectCmdPathTups.append(disklogConf.HSSD_EXT_LOG_CMD_RESULT_PATH_TUP)

        isStoped = devObj.get('stop').isStopped()
        log.warn(devObj, 'disk log collect stop flag: %s.' % isStoped)
        if isStoped:
            allDiskIdList = map(lambda diskPara:diskPara[0], diskParaList)
            stopStartIdx = allDiskIdList.index(diskId)
            stoppedDiskIdList = allDiskIdList[stopStartIdx:]
            log.warn(devObj, 'disk log collect is stopped.')
            break
        singelcmdProcess = percentNumber / len(collectCmdPathTups)
        for collectCmd, resultPthName in collectCmdPathTups:
            if isNewDisktool:
                collectCmd = './' + collectCmd
            
            collectCmd = collectCmd % ("/dev/" + diskBlkDev) 
            isSucc = False
            cliRet = ""
            
            #判断是否为Odyssey的硬盘
            if isOdyssey(diskModelNum):
                #Odyssey的硬盘的日志包名称有变，SanDisk_SAS_Log.zip
                resultPthName = ODYSSEY_RESULT_PATH
                log.info(devObj, "Odyssey disk ID is %s " % str(diskId))
                if not isNewDisktool:
                    #上传disktool失败，采用老方式收集Odyssey的硬盘日志
                    collectCmd = "disktool -D  /OSM/coffer_data/dha -A D %s" % ("/dev/" + diskBlkDev)

            # Model 为AL14XXX 且FW版本为0803/0808/0807的硬盘只收集0x01部分日志：disktool -D /OSM/coffer_data/dha -A F %s。
            # 其他场景收集全量硬盘日志（SAS/NL_SAS命令增加-z参数）：disktool -D /OSM/coffer_data/dha -A F -z AllLogTB %s。
            # 数据中未保存FW版本信息所以只能再查询一遍，评估了一下，如果在原有数据中增加一个字段，风险太高，因查询时保存的信息和当前使用的信息不匹配。
            diskInfo = diskFwModelInfoDict.get(diskId, {})
            fw = diskInfo.get("fw", '')
            diskModel = diskInfo.get("diskModel", '')
            if fw and vendor and vendor.lower() == "toshiba" and fw in disklogConf.TOSHIBA_EXCLUDE_DISK_MODEL_BATCH_MAP.get(
                    diskModel, ""):
                collectCmd = collectCmd.replace("-z AllLogTB ", '')

            if cli.getNetworkEvaluation(devObj) >= 1:  
                    isSucc, cliRet = cli.executeCmdWithTimoutAndRetry(devObj, collectCmd, 
                                                              disklogConf.COLLECT_RUNNING_DISKLOG_CMD_TIMEOUT, 
                                                              cliMode=cliModeManager.CLI_MODE_MINISYSTEM)

            if not isSucc:
                writeMsgLine(devObj, 'Failed Disk[' 
                         + diskId + ', '+ vendor + ', ' + diskSn + ', ' + diskType + ', ' + diskModelNum + ', ' + diskBlkDev +']',  
                         disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
                    
                #Write executed command when command timeout.Other wise, the CLI echo message contains the command.
                if cli.TOOLKIT_SEND_CMD_TIME_OUT in cliRet:
                    writeMsgLine(devObj, unicode(collectCmd), disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
                writeMsgLine(devObj, unicode(cliRet), disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
                log.error(devObj, 'Execute collecting disk log command failed:' + unicode(diskId))
                resultDict[DiskLocation(diskId, True)] = CollectStatus.COLLECT_FAILED
            else:
                sftp = util.getSftp(devObj)
                if isNormalDisklogCollectOk(cliRet):
                    try:
                        localSaveDir = os.path.join(util.getLocalInfoPathByType(devObj, config.COLLECT_TYPE_DISKLOG),
                                                    disklogConf.RUNNING_DISKLOG_DIR_NAME)
                        if not os.path.exists(localSaveDir):
                            os.makedirs(localSaveDir)
                        #下载信息到本地
                        localSaveFile = File(localSaveDir, diskId + '_' + diskSn + '_' + resultPthName.split('/')[-1])
                        sftp.getFile(resultPthName, localSaveFile, None)
                    except:
                        log.error(devObj, "Down load disk log file %s failed." % unicode(resultPthName))
                        log.error(devObj, "Except trace back:" + unicode(traceback.format_exc()))
                    else:
                        thisDiskOkNum += 1
                        log.info(devObj, "Down load disk log file %s successfully." % unicode(localSaveFile))
                else:
                    #Write executed command when command timeout.Other wise, the CLI echo message contains the command.
                    if cli.TOOLKIT_SEND_CMD_TIME_OUT in cliRet:
                        writeMsgLine(devObj, unicode(collectCmd), disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
                    writeMsgLine(devObj, unicode(cliRet), disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
                    log.error(devObj, 'Collect disk log failed, disk is: %s, collect echo message is: %s' % (unicode(diskId), cliRet))
                
                #无论执行成功失败与否都去执行一次删除动作，避免残留文件。
                try:
                    sftp.deleteFile(resultPthName)
                except:
                    log.error(devObj, "Delete disk log exception, except trace back:" + unicode(traceback.format_exc()))
                else:
                    log.info(devObj, "Delete disk log file %s successfully." % unicode(resultPthName))
            currentProcess = util.refreshProcessByStep(devObj, currentProcess, singelcmdProcess)
        
        #硬盘日志收集状态.
        if thisDiskOkNum == len(collectCmdPathTups):
            succNum += 1
            resultDict[DiskLocation(diskId, True)] = CollectStatus.COLLECT_FINISHED
        elif thisDiskOkNum > 0:
            partSuccNum += 1
            writeMsgLine(devObj, 'Partly success Disk[' 
                         + diskId + ', '+ vendor + ', ' + diskSn + ', ' + diskType + ', ' + diskModelNum + ', ' + diskBlkDev +']',  
                         disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
            resultDict[DiskLocation(diskId, True)] = CollectStatus.COLLECT_FINISHED_NOTALL
            partlySuccDiskLocList.append(diskId)
        else:
            failedDiskLocList.append(diskId)
            resultDict[DiskLocation(diskId, True)] = CollectStatus.COLLECT_FAILED
        time.sleep(diskLogCollectInterval)

    if cli.getNetworkEvaluation(devObj) >= 1:
        systemMode.exitDiagnoseOrMinisystem(devObj)
    failedDiskLocList = list(set(failedDiskLocList))
    
    nosupportDiskLocList.sort(key=lambda diskId:getDiskLocSortKey(diskId))
    failedDiskLocList.sort(key=lambda diskId:getDiskLocSortKey(diskId))
    partlySuccDiskLocList.sort(key=lambda diskId:getDiskLocSortKey(diskId))
    stoppedDiskIdList.sort(key=lambda diskId: getDiskLocSortKey(diskId))
    
    writeMsgLine(devObj, 'success=' + unicode(succNum))
    writeMsgLine(devObj, 'partly success=' + unicode(partSuccNum))
    writeMsgLine(devObj, 'failed=' + unicode(len(failedDiskLocList)))
    writeMsgLine(devObj, 'unsupported =' + unicode(len(nosupportDiskLocList)))
    writeMsgLine(devObj, 'stopped =' + unicode(len(stoppedDiskIdList)))

    devObj['collectResultDict'] = resultDict
    if cli.getNetworkEvaluation(devObj) < 1:
        util.addPyDetailMsg(devObj, 'failed.to.reconnect.after.several.times')
        
    if partlySuccDiskLocList:
        util.addPyDetailMsg(devObj, 'collect.disk.log.partly.success', ','.join(partlySuccDiskLocList))

    if nosupportDiskLocList:
        util.addPyDetailMsg(devObj, 'collect.disk.log.not.support', ','.join(nosupportDiskLocList))

    if failedDiskLocList:
        util.addPyDetailMsg(devObj, 'collect.disk.log.failed', ','.join(failedDiskLocList))

    if stoppedDiskIdList:
        util.addPyDetailMsg(devObj, 'collect.disk.log.stopped', ','.join(stoppedDiskIdList))

    if succNum == len(selDiskList):
        return True, ''
    elif succNum == 0 and 0 == len(partlySuccDiskLocList):
        return False, ''
    else:
        #partly success setting.
        util.setCollectAllInfo(devObj, False)
        return True, ''

def isNormalDisklogCollectOk(collectRetMsg): 
    '''
    @summary: 根据执行disktool进行“正常硬盘”日志收集时的回显信息判断日志是否收集成功.
    @return: boolean, 判断单块硬盘的日志是否收集成功
    @note: 判断是否成功依赖与disktool的回显信息。
    '''
    #No news is good news for HSSD
    if len(collectRetMsg.splitlines()) == 2:
        return True
    
    collectRetMsgLower = collectRetMsg.lower()
    for okWord in disklogConf.NORMAL_DISKLOG_COLLECT_SUCC_KEYWORDS:
        if okWord in collectRetMsgLower:
            return True
    
    return False

def getDiskEncAndSlotNum(loc):
    return loc.split(',')[0].strip('('), loc.split(',')[1].strip(')')

def getDiskLocSortKey(loc):
    if "." in loc:
        head = loc.split(".")[0].strip()
        diskNo = loc.split(".")[1].strip()
        return head, int(diskNo)
        
    elif "," in loc:
        encStr, slotStr = getDiskEncAndSlotNum(loc)
        return int(encStr), int(slotStr)
    else:
        return loc
    

def isSupportUploadDisktoolExecute(devObj):
    isSucc, cliRet = cli.executeCmdWithTimout(devObj, './disktool -v', disklogConf.DISKLOG_NORMAL_QRY_CMD_TIMEOUT)
    if not isSucc:
        log.error(devObj, 'Executed ./disktool -v failed.')
        return False
    elif re.search('Version', cliRet, re.I):
        return True
    elif re.search('password:', cliRet, re.I):
        #Compatiable for some versions such as V3R5C00SPC300 2600 V3 requires password to execute uploaded disktool
        ret = cli.executeCtrlPlusCCmd(devObj, 3 * 60)
        if ret and ret.strip().endswith(cli.CLI_MINISYSTEM_FLAG):
            log.info(devObj, 'Send CTRL + C command success:' + unicode(ret))
        else:
            log.error(devObj, 'Send CTRL + C command failed:' + unicode(ret))
                
        log.error(devObj, 'Executed ./disktool -v failed because need password.')
        return False
    else:
        isSucc, cliRet = cli.executeCmdWithTimout(devObj, './disktool -h', disklogConf.DISKLOG_NORMAL_QRY_CMD_TIMEOUT)
        if not isSucc:
            log.error(devObj, 'Executed ./disktool -h failed.')
            return False
        elif re.search('Version', cliRet, re.I):
            return True
        elif re.search('password:', cliRet, re.I):
            #Compatiable for some versions such as V3R5C00SPC300 2600 V3 requires password to execute uploaded disktool
            ret = cli.executeCtrlPlusCCmd(devObj, 3 * 60)
            if ret and ret.strip().endswith(cli.CLI_MINISYSTEM_FLAG):
                log.info(devObj, 'Send CTRL + C command success:' + unicode(ret))
            else:
                log.error(devObj, 'Send CTRL + C command failed:' + unicode(ret))
                    
            log.error(devObj, 'Executed ./disktool -h failed because need password.')
            return False
        else:
            log.error(devObj, 'Executed ./disktool -h failed because other error:' + unicode(cliRet))
            return False
        
def isHSSDV2(vendor, diskModelNum):
    return vendor.upper() =='HUAWEI' and diskModelNum.upper().startswith('HSSD-D5')

def getDisklogCollectInvterVal(devObj):
    try:
        collectCfgFilePth = os.path.join(devObj.get('currentScriptPath'), '..', '..', '..', '..', '..', 'configuration')
        collectCfgFile = os.path.join(collectCfgFilePth, SETTING_FILE_NAME)

        cf = ConfigParser.ConfigParser()
        cf.read(collectCfgFile)
        interval = cf.getint('diskLog', 'DiskLogCollectionInterval')
        log.info(devObj, 'Disk log interval configured value is: %s' % interval)
        return interval if interval >=0 else 60
    except:
        log.warn(devObj, "Parse collect interval value exception: %s" % traceback.format_exc())
        return 60


def isOdyssey(diskModelNum):
    '''
    @summary: 判断是否为Odyssey的硬盘
    @return: True:是Odyssey硬盘
             False:不是是Odyssey硬盘
    '''
    try:
        if diskModelNum[:5] == "SDLL1" and diskModelNum[6] == "L":
            return True
        
        return False
    except:
        return False