# -*- coding: UTF-8 -*-
import os
import shutil
import traceback
from common.config import config
from common.util import log, util
import codecs
import zipfile

def dealLogInfo(devObj):
    """
        处理从阵列侧收集到的日志文件
    """
    try:
        #若原始日志包中包含productInfo.txt文件则不创建
        if isHasProductInfoFile(devObj):
            log.info(devObj, "the log information file already has productInfo.txt.")
            return True
        isSucc = creatProductInfoFile(devObj)
        return isSucc
    except:
        log.error(devObj, "except trace back:" + str(traceback.format_exc()))
        return False
    
def creatProductInfoFile(devObj):
    """
        创建config文件，并将其放入日志压缩包
    """
    tar_class = devObj.get("PYENGINE.PY_ZIP")
    
    #获取设备信息
    deviceInfo = getProductInfo(devObj)
    #本地日志文件存放路径
    logInfoDir = util.getLocalInfoPathByType(devObj, config.EXPORT_TYPE_LOG)
    #在每个控制器的日之包中创建日志分析工具需要的设备信息文件productInfo.txt
    isSucc = True
    logFileList = os.listdir(logInfoDir)
    for logFile in logFileList:
        tempDirPath = os.path.join(logInfoDir, "temp")
        isSucc = createDir(devObj, tempDirPath)
        log.info(devObj, "%s : create temp dir!" % str(isSucc))
        logFileName = os.path.join(logInfoDir, logFile)
        isSucc = tar_class.decompressZipFile(logFileName, tempDirPath)
        log.info(devObj, "%s : decompress file %s to temp dir!" % (str(isSucc), logFileName))
        productInfoFileName = os.path.join(tempDirPath, "productInfo.txt")
        isSucc = writeFile(devObj, productInfoFileName, deviceInfo)
        log.info(devObj, "%s : write file %s!" % (str(isSucc), productInfoFileName))
        isSucc = tar_class.compressFile(logFileName, tempDirPath)
        log.info(devObj, "%s : compress file!" % str(isSucc))
        #删除临时文件夹
        shutil.rmtree(tempDirPath)
        
    return isSucc

def getProductInfo(devObj):
    """
        获取设备信息，先从devObj获取，无则从阵列上获取
    """
    deviceInfo = ""
    
    devNode = devObj.get("devNode")
    productModel = devNode.getDeviceType()
    productVesion = devNode.getProductVersion()
    systemName = devNode.getDeviceName()
    productSerialNumber = devNode.getDeviceSerialNumber()
    productModelAndVersion = str(productModel) + " " + str(productVesion)[0:11]
    
    deviceInfo = "productModel: %s\nproductModelAndVersion: %s\nsystemName: %s\nproductSerialNumber: %s" % \
    (productModel, productModelAndVersion, systemName, productSerialNumber)
    
    return deviceInfo
        
def writeFile(devObj, fileName, info, isAdd = True):
    '''
          向文件中写内容：
    '''    
    isSucc = True
    try:
        #判断是否为追加内容 
        if isAdd:
            file = codecs.open(fileName, "a", "utf-8")
        else:
            file = codecs.open(fileName, "w", "utf-8")
        
        file.write(info)
        file.flush()
        file.close()
    except:
        log.info(devObj, "write file failed because " + str(traceback.format_exc()))
        isSucc = False
    
    return isSucc            
        
def createDir(devObj, dirPath):
    """
          创建文件夹，若存在则清空该文件夹再创建
    """
    try:
        if os.path.exists(dirPath):
            shutil.rmtree(dirPath)
        os.makedirs(dirPath)
    except:
        log.info(devObj, "create directory failed!")
        log.info(devObj, "except trace back:" + str(traceback.format_exc())) 
        return False
    
    return True

def isHasProductInfoFile(devObj):
    """
          检查阵列上下载的原始日志包中是否已经包含了product.txt文件
    """
    logInfoDir = util.getLocalInfoPathByType(devObj, config.EXPORT_TYPE_LOG)
    
    logFileList = os.listdir(logInfoDir)
    for logFile in logFileList:
        if "log_controller" in logFile and logFile.endswith(".tgz"):
            logFileName = os.path.join(logInfoDir, logFile)
            logZipFile = zipfile.ZipFile(logFileName)
            fileList = logZipFile.namelist()
            if "productInfo.txt" in fileList:
                return True
            else:
                return False
            
    return True
    
