# -*- coding: UTF-8 -*-
import traceback
from common.util import *

from cbb.frame.cli.cli_con_check_4_info_collect import CliUtil as CliCheckUtil
from common.cliFactory import cli
from common.config import config
from com.huawei.oss.cn.common.anonymize import FileAnonymizeUtil
from com.huawei.ism.tool.infocollect.service import DealFileInCopressPackage

'''
导出系统信息（系统日志，配置信息，告警信息），公共方法
'''
class exportInfo():
    
    @staticmethod
    def isNormalForRec(devObj, rec):
        '''
        @summary: 判断回显信息是否正常
        @param cliRet:  devObj=上下文对象,
                        rec=导出系统信息的回显
        @return: True or False
        '''
        if None == rec or "" == rec:
            return False
        
        #判断系统是否在正确模式下
        if cli.CLI_RET_END_FLAG not in rec:
            util.setPyDetailMsg(devObj, "system.not.in.right.mode", rec)
            return False
        
        #判断系统是否繁忙
        if cli.CLI_SYSTEM_BUSY_FLAG in rec:
            log.info(devObj, "Collect error, result is:" + rec)
            util.setPyDetailMsg(devObj, "system.busy")
            return False
        
        if cli.CLI_BASH_EXPORT_FLAG in rec or cli.CLI_MINISYSTEM_FLAG in rec:
            log.info(devObj, "Collect error, result is:" + rec)
            util.setPyDetailMsg(devObj, "system.not.in.right.mode")
            return False
        
        return True
    
    @staticmethod
    def isExecCmdSuccForRec(devObj, rec):
        '''
        @summary: 根据回显判断命令是否执行成功
        @param cliRet:  devObj=上下文对象,
                        rec=导出系统信息的回显
                        list=判断命令回显成功的回显列表
        @return 1: True or False,命令执行成功
        @return 2: True or False,收集的文件是否完整
        '''
        execSucc = False
        isAllSucc = False
        #首先判断命令执行是否正常
        isNormal = exportInfo.isNormalForRec(devObj, rec)
        if False == isNormal:
            return (execSucc, isAllSucc)
        
        for re in config.ISEXEC_CMD_SUCCESS_FLAG:
            if re in rec:
                execSucc = True
                break
        
        if execSucc:
            #收集成功的文件数量
            succCollectNum = 0
            cliRetList = rec.splitlines()
            cliRet4Log = ""
            for line in cliRetList:
                if config.COLLECT_INFO_RECROD_STANDARD in line:
                    succCollectNum += 1
                    cliRet4Log += "File Path : XXXX"
                else:
                    cliRet4Log += line 
            #应该收集的文件数量
            allCollectNum = len(cliRetList) - 2
            if succCollectNum > 0 and succCollectNum < allCollectNum:
                log.info(devObj, "collect partfail because: %s" % cliRet4Log)
            else:
                isAllSucc = True
                
        return (execSucc, isAllSucc)
    
    @staticmethod
    def getRemotePathAndName(devObj, rec):
        '''
        @summary: 获取阵列端的文件名称和路径
        @param cliRet:  devObj=上下文对象
        @return: name:阵列端产生的文件名称
                 path:阵列端产生的文件的路径
        '''
        resultList = []
        cliRetList = rec.splitlines()
        for line in cliRetList:
            #判断回显是否正常
            if config.COLLECT_INFO_RECROD_STANDARD in line:
                tempDict = {}
                tempList = line.split(" : ")
                path = tempList[1]
                tempList1 = path.split("/")
                name = tempList1[-1]
                tempDict["path"] = path
                tempDict["name"] = name
                resultList.append(tempDict)
        
        return resultList
        
    @staticmethod
    def downloadFile(devObj, type, rec):
        '''
        @summary: 下载收集到得文件信息到本地
        @param cliRet:  devObj=上下文对象
                        type=收集的类型
                        rec=命令执行成功的回显
        @return: True or False
        '''
        try:
            sftp = util.getSftp(devObj)
            localDir = util.getLocalInfoPathByType(devObj, type)
            #下载信息到本地
            #获取阵列端存放信息的路径和文件名称
            listRemotePaths = exportInfo.getRemotePathAndName(devObj, rec)
            
            #下载到本地的目录信息
            loadLocalDirInfo = []
            localPath = ""
            for temp in listRemotePaths:
                localPath = localDir + temp["name"]
                file = File(localPath)
                sftp.getFile(temp["path"], file, None)
                tempDict = {"path":localDir, "name":temp["name"]}
                loadLocalDirInfo.append(tempDict)
                
            #对配置信息文件、全部日志和近期日志进行脱敏
            if config.EXPORT_TYPE_RUNNING_DATA == type:
                FileAnonymizeUtil.anonymizeWithEncoding(localDir, "utf-8")
            elif config.EXPORT_TYPE_ALLLOG == type or config.EXPORT_TYPE_LOG == type:
                DealFileInCopressPackage.anonymizeCompressFile(localPath)
            CliCheckUtil.check_cli_connect(devObj)
            return (True, loadLocalDirInfo)
        except:
            log.error(devObj, "down load %s fail" % str(type))
            log.info(devObj, "except trace back:" + str(traceback.format_exc()))
            return (False, None)
    
    @staticmethod
    def deleteRemoteFile(devObj, type, rec):
        '''
        @summary: 删除阵列端生成的文件
        @param cliRet:  devObj=上下文对象
                        type=收集的类型
                        rec=CLI回显信息
        @return:Bool(True or False)
        '''
        #根据CLI回显信息判断当前环境下，是否允许删除
        tempList = config.DELETE_REMOTE_DATA_STANDARD
        deleteFlag = True
        for standard in tempList:
            if standard in rec:
                deleteFlag = False
                break
            
        if deleteFlag:
            strCmd = "delete file filetype=" + type
            log.info(devObj, "delete command is:" + strCmd)
            cli.executeCmdNoLogTimeout(devObj, strCmd)
    
    
    
    @staticmethod
    def decompressTgzFile(devObj, filePath, fileName):
        '''
        @summary: 解压文件(只支持解压系统日志包（.tgz）)
        @param cliRet:  devObj=上下文对象,
                        filePath=需要检查的节点的路径，
                        fileName=检查的文件名称
        @return: (msgInfo=错误信息, item=错误信息序号)
        '''
        
        tar_class = devObj.get("PYENGINE.PY_ZIP")
        dirName = fileName[0: fileName.find(".tgz")]
        
        tempFilePath = filePath + os.path.sep + fileName
        tempDirPath = filePath + os.path.sep + dirName
        
        tar_class.decompressZipFile(tempFilePath, tempDirPath)
        
        return tempDirPath
    
    
    @staticmethod
    def decompressTarBz2File(devObj, filePath, fileName):
        '''
        @summary: 解压文件(只支持解压系统日志包（.tar.bz2）)
        @param cliRet:  devObj=上下文对象,
                        filePath=需要检查的节点的路径，
                        fileName=检查的文件名称
        @return: (解压路径)
        '''
        tar_class = devObj.get("PYENGINE.PY_ZIP")
        dirName = fileName[0: fileName.find(".tar.bz2")]
        tempFilePath = filePath + os.path.sep + fileName
        tempDirPath = filePath + os.path.sep + dirName
        tar_class.decompressTarBz2File(tempFilePath, tempDirPath)
        return tempDirPath
        
    
    @staticmethod
    def getNodeCollectInfo(devObj, filePath, fileName):
        '''
        @summary: 解压文件(只支持解压系统日志包（.tar.bz2）)
        @param cliRet:  devObj=上下文对象,
                        filePath=需要检查的节点的路径，
                        fileName=检查的文件名称
        @return: (msgInfo=错误信息, item=错误信息序号)
        '''
        
        tempDirPath = exportInfo.decompressTarBz2File(devObj, filePath, fileName)
        
        #筛选日志信息结果文件
        listFile = os.listdir(tempDirPath)
        result = None
        for fileName in listFile:
            if fileName == config.COLLECT_LOG_FILE_INFO:
                logPath = tempDirPath + os.path.sep + fileName
                result = util.readFile(logPath)
        
        return result
    
    
    @staticmethod
    def checkSystemLogByFile(devObj, info, item, nodeName):
        '''
        @summary: 解析节点,系统日志信息中收集结果的文件
        @param cliRet:  devObj=上下文对象,
                        info=文件内容，
                        item=错误信息编号
                        nodeName=控制器节点名称
        @return: (msg=当前节点错误信息, item=错误信息序号)
        '''
        msg = None
        if None == info:
            item +=1
            msg = util.getMsg(devObj, "controller.failed.information", (item, nodeName))
            return msg
            
        lines = info.splitlines()
        collectFailList = ""
        #如果收集结果文件（info_log.txt）中含有乱码则剔除含有乱码的项
        newLines = []
        for line in lines:
            try:
                line.decode("utf-8").encode("utf-8")
                newLines.append(line)
            except Exception:
                pass
        
        lines = newLines   
        for line in lines:
            if line.strip().startswith("Slot ID is"):
                break
            #如果某项收集结果不是ok，则表示该项收集失败
            if not line.strip().lower().endswith(" ok"):
                collectFailList += line.split()[0] + ', ' 
                
        if "" != collectFailList:
            item +=1
            msg = util.getMsg(devObj, "controller.failed.items", (item, nodeName, collectFailList[:-2]))
            
        return (msg, item)
    
    @staticmethod
    def checkNodeSystemLogIsFull(devObj, filePath, fileName, item, nodeId=None):
        '''
        @summary: 获取当前收集节点，收集失败的项
        @param cliRet:  devObj=上下文对象,
                        filePath=需要检查的节点的路径，
                        fileName=检查的文件名称
        @return: (msgInfo=错误信息, item=错误信息序号)
        '''
        #解压tgz压缩包，返回解压后的路径
        keepAliveThread = AsynProgressExecuteCmd(devObj, log)
        keepAliveThread.start()
        log.info(devObj, "AsynProgressExecuteCmd keepAliveThread is start.")
        decompressDir = exportInfo.decompressTgzFile(devObj, filePath, fileName)
        #获取解压后的tar.bz2的文件列表，一个tar.bz2代表一个节点信息
        nodeList = os.listdir(decompressDir)
        messsage = ""
        controllerCount = len(nodeList)
        for nodeInfo in nodeList:
            nodePath = decompressDir
            nodeName = nodeInfo
            
            #判断，若不是tar.bz2的压缩包，则不做处理
            if ".tar.bz2" not in nodeName or ".sha256sum" in nodeName:
                continue
            #解压各个节点，获取节点中导出日志信息的结果信息
            nodeResultInfo = exportInfo.getNodeCollectInfo(devObj, nodePath, nodeName)
            #分析结果信息
            if nodeId != None:
                nodeName = nodeId
            (msg, item) = exportInfo.checkSystemLogByFile(devObj, nodeResultInfo, item, nodeName)
            if None != msg:
                messsage += msg
        
        #清除解压后的临时目录
        util.cleanDir(decompressDir)
        keepAliveThread.setStopFlag(True)
        return (messsage, item, controllerCount)
    
    
    @staticmethod
    def checkLogIsCollectFull(devObj, successCount, item):
        '''
        @summary: 下载系统config.txt文件，从文件中获取系统标配控制器个数
        @param cliRet:  devObj=上下文对象,
                        pathList=收集的系统日志的文件夹列表，
                        msgInfo=错误信息
        @return: (msgInfo=错误信息, item=错误信息序号)
        '''
        #配置信息存放目录，若目录存在，则表示之前已经收集了配置信息
        runningDataType = config.EXPORT_TYPE_RUNNING_DATA
        runningDataDir = devObj[config.COLLECT_INFO_LOCAL_PATH] + os.path.sep
        runningDataDir = runningDataDir + config.COLLECT_INFO_DIR_NAME[runningDataType]
        deleteRunningDataDir = True
        
        #若存在则不删除本地配置信息
        if os.path.exists(runningDataDir):
            deleteRunningDataDir = False
        
        exportDataFalg = True
        tempCmd = "show file export_path file_type=%s" % runningDataType

        (isSuccess, rec) = cli.executeCmdNoLogTimeout(devObj, tempCmd)
        if not isSuccess:
            item += 1
            msg = util.getMsg(devObj, "dev.conn.failure")
            return (msg, item)
        
        (execSucc, isAllSucc) = exportInfo.isExecCmdSuccForRec(devObj, rec)
        if not execSucc:
            exportDataFalg = False
        
        (loadSucc, loadDirInfo) = exportInfo.downloadFile(devObj, runningDataType, rec)
        if not loadSucc:
            exportDataFalg = False
        
        exportInfo.deleteRemoteFile(devObj, runningDataType, rec)
        if not exportDataFalg:
            item += 1
            msg = util.getMsg(devObj, "network.communication.abnormal", (item))
            return (msg, item)
        
        tempList = exportInfo.getRemotePathAndName(devObj, rec)
        fileName = tempList[0]["name"]
        ctrlCount = 0
        path = runningDataDir + os.path.sep + fileName
        collectConfig = util.readFile(path)
        if None == collectConfig:
            collectConfig = ""
        lines = collectConfig.splitlines()
        for line in lines:
            if "Number of total controllers" in line:
                ctrlCount = line.split(':')[-1].strip()
                break
            
        #删除收集到得文件
        if deleteRunningDataDir:
            util.cleanDir(runningDataDir)
            
        msg = ""
        if int(ctrlCount) != successCount:
            item +=1
            msg = util.getMsg(devObj, "controllers.some.failed", (item))
            log.info(devObj, "ctrlCount=" + str(ctrlCount) + ";collect success controller = " + str(successCount))
        
        return (msg, item)
    
    @staticmethod
    def exportLog(devObj, type):
        '''
        #执行命令，导出系统日志信息
        '''
        #版本兼容，需要首先判断新命令是否存在，若不存在则执行老命令进行信息收集
        timeOut = config.EXPORT_INFO_TIMEOUT[type]
        existCmd = False
        successCount = 0
        #错误信息相关
        messages = ""
        item = 0
        if type in config.IS_CONTROLLER_INFO_FULL:
            #对支持异步方式收集信息的设备采用如下方式收集，适用于新方案的log,alllog,smart收集
            (isSuccess, existCmd) = exportInfo.canParallelExportInfoByCtrlId(devObj, type)
            if not isSuccess:
                return False
            if existCmd:
                return exportInfo.parallelExportInfoByCtrlId(devObj, type)
        
        if not existCmd:
            #使用旧的导出方式导出数据
            tempCmd = "show file export_path file_type=%s" % (type)
            log.info(devObj, "execute collect : %s" % str(tempCmd))            
            (isSuccess, rec) = cli.executeCmdNoLogTimeout(devObj, tempCmd, timeOut)
            if not isSuccess:
                util.setPyDetailMsg(devObj, "dev.conn.failure")
                return False
            util.refreshProcess(devObj, 50)
            #判断命令是否存在
            existCmd = cli.isExistCmdForRec(rec)
            if not existCmd:
                #命令不存在，表示环境版本过低，直接收集成功
                log.info(devObj, "commend not exist %s" % str(rec))
                return True
            util.refreshProcess(devObj, 52)
            (execSucc, isAllSucc) = exportInfo.isExecCmdSuccForRec(devObj, rec)
            if not execSucc:
                util.setPyDetailMsg(devObj, rec)
                log.info(devObj, "show file... execute failed, and delete file")
                exportInfo.deleteRemoteFile(devObj, type, rec)
                return False
            util.refreshProcess(devObj, 54)
            (loadSucc, loadDirInfo) = exportInfo.downloadFile(devObj, type, rec)
            if not loadSucc:
                util.setPyDetailMsg(devObj, "downLoad.file.failure")
                log.info(devObj, "download file failed, and delete file")
                exportInfo.deleteRemoteFile(devObj, type, rec)
                return False
            util.refreshProcess(devObj, 70)
            #删除阵列段临时文件
            log.info(devObj, "get file success, and delete file")         
            exportInfo.deleteRemoteFile(devObj, type, rec)
            
            util.refreshProcess(devObj, 75)
            
            #若收集的是系统日志信息
            count = 0
            if type in config.IS_SYSTEM_INFO_FULL:
                #判断信息是否收集完全
                for tempDir in loadDirInfo:
                    fileName = tempDir["name"]
                    if ".tgz" in fileName:
                        (msg, item, count) = exportInfo.checkNodeSystemLogIsFull(devObj, tempDir["path"], fileName, item)
                        messages += msg
            util.refreshProcess(devObj, 78)
            #单独获取收集Smart信息的节点数量
            if type == config.COLLECT_TYPE_SMART:
                tempDir = loadDirInfo[0]
                tempDirPath = exportInfo.decompressTarBz2File(devObj, tempDir["path"], tempDir["name"])
                listFile = os.listdir(tempDirPath)
                count = len(listFile)
            
            successCount = count
            
        if type in config.IS_CONTROLLER_INFO_FULL:
            if successCount == 0:
                log.info(devObj, "collect fail successCount=0")
                return False
            (msg, item) = exportInfo.checkLogIsCollectFull(devObj, successCount, item)
            messages += msg
        util.refreshProcess(devObj, 86)
        if "" != messages:
            util.setCollectAllInfo(devObj, False)
            util.setPyDetailMsg(devObj, messages)
        
        return True
    
    @staticmethod
    def exportSysInfo(devObj, type):
        '''
        @summary: 丛阵列端导出信息，日志收集、事件信息、配置信息收集的主入口
        @param cliRet:  devObj=上下文对象
                        type=收集的类型
        @return:True or False
        '''
        try:
            #收集前检查
            #检查系统是否正常
            isSysNormal = util.checkSystemNormal(devObj)
            if not isSysNormal:
                return False
            
            #检查用户级别是否满足收集信息
            isPrivilege = util.checkUserPrivilege(devObj)
            if not isPrivilege:
                return False
            
            exportSucc = exportInfo.exportLog(devObj, type)
            
            return exportSucc
        
        except Exception, ex:
            log.info(devObj, "except trace back:" + str(traceback.format_exc()))
            return False
        
    @staticmethod
    def canParallelExportInfoByCtrlId(devObj, type):
        '''
        #判断设备是否支持并行方式收集-->设备支持此命令show file package_result file_type=%s
        @return 1:True or False,命令执行成功
        @return 2:True or False,是否支持此命令
        '''
        (isSuccess, exist_cmd) = (False, False)
        cmd = "show file package_result file_type=%s" % (type)
        count = 0
        while count < 4:
            (isSuccess, rec) = cli.executeCmdNoLogTimeout(devObj, cmd)
            if "timed out" not in rec:
                exist_cmd = cli.isExistCmdForRec(rec)
                break
            exist_cmd = cli.isExistCmdForRec(rec)
            time.sleep(30)
            count += 1
        if not isSuccess:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
        return (isSuccess, exist_cmd)
    
    @staticmethod
    def prepareCollect(devObj, type):
        '''
        #下发CLI,通知OM开始收集，OM通知各节点做收集的前期准备
        '''
        cmd4collect = "show file export_path file_type=%s" % (type)
        (isSuccess, rec) = cli.executeCmdNoLogTimeout(devObj, cmd4collect)
        log.info(devObj, "prepareCollect and the cliRet is " + str(rec))
        if not isSuccess:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return False
        
        if config.CLI_EXECUTE_CMD_SUCCESS not in rec: 
            util.setPyDetailMsg(devObj, "cli.excute.failure", rec)
            return False
        
        return True
    
    @staticmethod
    def queryCollectStatus(devObj, type):
        '''
        #轮询收集进度
        @return 1:True or False,命令执行成功
        @return 2:收集进度{"总的进度" : "" , "单个节点的进度" : {"节点" : "进度"}..}
        @return 3:cli回显
        '''
        (isSuccess, collectStatus, cliRet) = (False, {"totalResult" : "" , "singleResultDict" : {}}, "")
        
        cmd4status = "show file package_result file_type=%s" % (type)
        (isSuccess, cliRet) = cli.executeCmdNoLogTimeout(devObj, cmd4status)
        log.info(devObj, "queryCollectStatus and the cliRet is " + str(cliRet))
        if not isSuccess:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return (isSuccess, collectStatus, cliRet)
        if "Total Result" not in cliRet:
            util.setPyDetailMsg(devObj, "cli.excute.failure", cliRet)
            return (isSuccess, collectStatus, cliRet)
        
        totalResult = ""
        NodeID = ""
        singleResult = ""
        
        dictList = cli.getCliTable2DictList(cliRet)
        for dict in dictList:
            totalResult = dict["Total Result"]
            if totalResult != "" and totalResult != "--":
                collectStatus["totalResult"] = totalResult
            
            singleResultDict = collectStatus["singleResultDict"]
            NodeID = dict["Controller ID"]
            singleResult = dict["Single Result"]
            singleResultDict.update({NodeID : singleResult})
            collectStatus["singleResultDict"] = singleResultDict
        
        return (True, collectStatus, cliRet)
    
    @staticmethod
    def notificationDownload(devObj, type, NodeID):
        '''
        #通知OM取文件
        @return 1:True or False,命令执行成功
        @return 2:CLI回显
        '''
        (isSuccess, cliRet) = (False, "")
        cmd4load = "show file notification file_type=%s controller_id=%s" % (type, NodeID)   
        (isSuccess, cliRet) = cli.executeCmdNoLogTimeout(devObj, cmd4load)
        log.info(devObj, "notificationDownload and the cliRet is " + str(cliRet))
        if not isSuccess:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return (isSuccess, cliRet)
        
        isSuccess = True
        return (isSuccess, cliRet)
        
    @staticmethod
    def deleteFile(devObj, type, NodeID):
        '''
        #删除阵列端数据
        '''
        cmd4delete = "delete file filetype=%s controller_id=%s" % (type, NodeID)
        (isSuccess, cliRet) = cli.executeCmdNoLogTimeout(devObj, cmd4delete)
        log.info(devObj, "deleteFile and the cliRet is " + str(cliRet))
        if not isSuccess:
            log.info(devObj, "deleteFile failed because cli execute failed")
            
        return
       
    @staticmethod
    def collectAndDownload(devObj, type):
        '''
        #1，轮询收集进度；2，下载收集到的文件到本地；3，删除阵列端的文件
        @return 1:True or False,收集项成功or失败
        @return 2:本项收集项的所有失败记录
        '''
        (isSuccess, failMesage) = (False, "")
        
        cmd4statusRet = ""
        item = 0 #
        totalResult = "" #总的收集进度
        limitTime = config.PARALLEL_EXPORT_INFO_TIMEOUT[type] #收集的超时时间，单位：分
        repeatTimes = limitTime * 2 #轮训次数
        
        shouldCollectNodeList = [] #应该收集的节点数量
        finishedNodes = [] #已经完成的节点，包括成功和失败
        successNoedList = [] #收集成功的节点
        hasErrMsgNodeList = [] #收集失败且已经设置错误信息的节点列表
        ftpGetFailedNodes = []
        #1，轮询收集进度
        currentProcess = 2
        percentNumber = 80.0 / 8
        while repeatTimes != 0:
            repeatTimes -= 1

            (isSuccess, collectStatus, cmd4statusRet) =exportInfo.queryCollectStatus(devObj, type)
            if not isSuccess:
                return (isSuccess, failMesage)
            
            totalResult = collectStatus["totalResult"]
            singleResultDict = collectStatus["singleResultDict"]
            
            for key in singleResultDict.keys():
                NodeID = key
                singleResult = singleResultDict[key]
                if shouldCollectNodeList.count(NodeID) == 0 and NodeID not in ["", "--"]:
                    shouldCollectNodeList.append(NodeID)
                if "Successful"  in singleResult and finishedNodes.count(NodeID) == 0:
                    finishedNodes.append(NodeID)
                    #通知OM取文件
                    (isSuccess, cliRet) = exportInfo.notificationDownload(devObj, type, NodeID)
                    if not isSuccess:
                        return (isSuccess, failMesage)
                    
                    if "File Path" not in cliRet:
                        item += 1
                        errMsg = util.getMsg(devObj, "cli.excute.failure.on.someContr", (item, NodeID, cliRet))
                        failMesage += errMsg
                        hasErrMsgNodeList.append(NodeID)
                        #未获取到相应的文件路径，向用户提示可能的原因和处理意见
                        ftpGetFailedNodes.append(NodeID)        
                    else:
                        #将阵列端的数据下载到本地
                        (loadSucc, loadDirInfo) = exportInfo.downloadFile(devObj, type, cliRet)
                        #删除阵列端数据
                        exportInfo.deleteFile(devObj, type, NodeID)
                        
                        if not loadSucc:
                            item += 1
                            errMsg = util.getMsg(devObj, "downLoad.file.failure.on.someContr", (item, NodeID))
                            failMesage += errMsg
                            hasErrMsgNodeList.append(NodeID)
                        else:
                            successNoedList.append(NodeID)
                            if type in config.IS_SYSTEM_INFO_FULL:
                                #判断信息是否收集完全
                                for tempDir in loadDirInfo:
                                    fileName = tempDir["name"]
                                    if ".tgz" in fileName:
                                        (errMsg, item, count) = exportInfo.checkNodeSystemLogIsFull(devObj, tempDir["path"], fileName, item, NodeID)
                                        failMesage += errMsg
                                        hasErrMsgNodeList.append(NodeID)
                        
            if "Packaging" not in totalResult:
                break  
            #已30秒为间隔时间进行轮询
            time.sleep(30)
            currentProcess = util.refreshProcessByStep(devObj, currentProcess, percentNumber)
            
        successNoedNum = len(successNoedList)
        shouldCollectNodeNum = len(shouldCollectNodeList)
        #收集失败 
        if successNoedNum == 0:
            isSuccess = False         
        #成功或部分成功 
        else:
            isSuccess = True
        
        #每个节点收集失败的原因
        if successNoedNum != shouldCollectNodeNum:
            for NodeID in shouldCollectNodeList:
                #如果是超时则设置轮询结果的CLI命令的回显为失败原因
                if successNoedList.count(NodeID) == 0 and hasErrMsgNodeList.count(NodeID) == 0:
                    item += 1
                    errMsg = util.getMsg(devObj, "cli.excute.failure.on.someContr", (item, NodeID, cmd4statusRet))
                    failMesage += errMsg
                    
        if "Partly Exported" in totalResult:
            item += 1
            errMsg = util.getMsg(devObj, "collect.controllers.some.failed", item)
            failMesage += errMsg
            
        if len(ftpGetFailedNodes) != 0:
            errMsg = util.getMsg(devObj, "sftp.get.file.faild", ",".join(ftpGetFailedNodes))
            failMesage += errMsg
        util.refreshProcess(devObj, 86)    
        return (isSuccess, failMesage)
    
    @staticmethod
    def parallelExportInfoByCtrlId(devObj, type):
        '''
        #控制器之间以并行方式来收集信息，涉及log,alllog,smart
        '''
        #1, 下发CLI,通知OM开始收集;
        isSuccess = exportInfo.prepareCollect(devObj, type)
        if not isSuccess:
            return False
        
        #2, 轮询收集进度，一旦发现有收集成功的节点则下载收集到得文件到本地并删除阵列端的文件。
        (isSuccess, failMesage) = exportInfo.collectAndDownload(devObj, type)
            
        #设置错误消息，并将部分收集成功标志置为True
        if failMesage != "":
            util.setCollectAllInfo(devObj, False)
            util.setPyDetailMsg(devObj, failMesage)
        
        return isSuccess
